<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/gkebackup/v1/restore_channel.proto

namespace Google\Cloud\GkeBackup\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A RestoreChannel imposes constraints on where backups can be restored.
 * The RestoreChannel should be in the same project and region
 * as the backups. The backups can only be restored in the
 * `destination_project`.
 *
 * Generated from protobuf message <code>google.cloud.gkebackup.v1.RestoreChannel</code>
 */
class RestoreChannel extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The fully qualified name of the RestoreChannel.
     * `projects/&#42;&#47;locations/&#42;&#47;restoreChannels/&#42;`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. Immutable. The project into which the backups will be restored.
     * The format is `projects/{projectId}` or `projects/{projectNumber}`.
     *
     * Generated from protobuf field <code>string destination_project = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $destination_project = '';
    /**
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     */
    protected $uid = '';
    /**
     * Output only. The timestamp when this RestoreChannel was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp when this RestoreChannel was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. A set of custom labels supplied by user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. User specified descriptive string for this RestoreChannel.
     *
     * Generated from protobuf field <code>string description = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a RestoreChannel from overwriting each
     * other. It is strongly suggested that systems make use of the 'etag' in the
     * read-modify-write cycle to perform RestoreChannel updates in order to
     * avoid race conditions: An `etag` is returned in the response to
     * `GetRestoreChannel`, and systems are expected to put that etag in the
     * request to `UpdateRestoreChannel` or `DeleteRestoreChannel` to
     * ensure that their change will be applied to the same version of the
     * resource.
     *
     * Generated from protobuf field <code>string etag = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $etag = '';
    /**
     * Output only. The project_id where backups will be restored.
     * Example Project ID: "my-project-id".
     * This will be an OUTPUT_ONLY field to return the project_id of the
     * destination project.
     *
     * Generated from protobuf field <code>string destination_project_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $destination_project_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The fully qualified name of the RestoreChannel.
     *           `projects/&#42;&#47;locations/&#42;&#47;restoreChannels/&#42;`
     *     @type string $destination_project
     *           Required. Immutable. The project into which the backups will be restored.
     *           The format is `projects/{projectId}` or `projects/{projectNumber}`.
     *     @type string $uid
     *           Output only. Server generated global unique identifier of
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when this RestoreChannel was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when this RestoreChannel was last updated.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. A set of custom labels supplied by user.
     *     @type string $description
     *           Optional. User specified descriptive string for this RestoreChannel.
     *     @type string $etag
     *           Output only. `etag` is used for optimistic concurrency control as a way to
     *           help prevent simultaneous updates of a RestoreChannel from overwriting each
     *           other. It is strongly suggested that systems make use of the 'etag' in the
     *           read-modify-write cycle to perform RestoreChannel updates in order to
     *           avoid race conditions: An `etag` is returned in the response to
     *           `GetRestoreChannel`, and systems are expected to put that etag in the
     *           request to `UpdateRestoreChannel` or `DeleteRestoreChannel` to
     *           ensure that their change will be applied to the same version of the
     *           resource.
     *     @type string $destination_project_id
     *           Output only. The project_id where backups will be restored.
     *           Example Project ID: "my-project-id".
     *           This will be an OUTPUT_ONLY field to return the project_id of the
     *           destination project.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Gkebackup\V1\RestoreChannel::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The fully qualified name of the RestoreChannel.
     * `projects/&#42;&#47;locations/&#42;&#47;restoreChannels/&#42;`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The fully qualified name of the RestoreChannel.
     * `projects/&#42;&#47;locations/&#42;&#47;restoreChannels/&#42;`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Immutable. The project into which the backups will be restored.
     * The format is `projects/{projectId}` or `projects/{projectNumber}`.
     *
     * Generated from protobuf field <code>string destination_project = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDestinationProject()
    {
        return $this->destination_project;
    }

    /**
     * Required. Immutable. The project into which the backups will be restored.
     * The format is `projects/{projectId}` or `projects/{projectNumber}`.
     *
     * Generated from protobuf field <code>string destination_project = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDestinationProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->destination_project = $var;

        return $this;
    }

    /**
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. Server generated global unique identifier of
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when this RestoreChannel was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when this RestoreChannel was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when this RestoreChannel was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when this RestoreChannel was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. A set of custom labels supplied by user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. A set of custom labels supplied by user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. User specified descriptive string for this RestoreChannel.
     *
     * Generated from protobuf field <code>string description = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. User specified descriptive string for this RestoreChannel.
     *
     * Generated from protobuf field <code>string description = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a RestoreChannel from overwriting each
     * other. It is strongly suggested that systems make use of the 'etag' in the
     * read-modify-write cycle to perform RestoreChannel updates in order to
     * avoid race conditions: An `etag` is returned in the response to
     * `GetRestoreChannel`, and systems are expected to put that etag in the
     * request to `UpdateRestoreChannel` or `DeleteRestoreChannel` to
     * ensure that their change will be applied to the same version of the
     * resource.
     *
     * Generated from protobuf field <code>string etag = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Output only. `etag` is used for optimistic concurrency control as a way to
     * help prevent simultaneous updates of a RestoreChannel from overwriting each
     * other. It is strongly suggested that systems make use of the 'etag' in the
     * read-modify-write cycle to perform RestoreChannel updates in order to
     * avoid race conditions: An `etag` is returned in the response to
     * `GetRestoreChannel`, and systems are expected to put that etag in the
     * request to `UpdateRestoreChannel` or `DeleteRestoreChannel` to
     * ensure that their change will be applied to the same version of the
     * resource.
     *
     * Generated from protobuf field <code>string etag = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Output only. The project_id where backups will be restored.
     * Example Project ID: "my-project-id".
     * This will be an OUTPUT_ONLY field to return the project_id of the
     * destination project.
     *
     * Generated from protobuf field <code>string destination_project_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDestinationProjectId()
    {
        return $this->destination_project_id;
    }

    /**
     * Output only. The project_id where backups will be restored.
     * Example Project ID: "my-project-id".
     * This will be an OUTPUT_ONLY field to return the project_id of the
     * destination project.
     *
     * Generated from protobuf field <code>string destination_project_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDestinationProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->destination_project_id = $var;

        return $this;
    }

}

