<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/firestore/admin/v1/snapshot.proto

namespace Google\Cloud\Firestore\Admin\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A consistent snapshot of a database at a specific point in time.
 * A PITR (Point-in-time recovery) snapshot with previous versions of a
 * database's data is available for every minute up to the associated database's
 * data retention period. If the PITR feature is enabled, the retention period
 * is 7 days; otherwise, it is one hour.
 *
 * Generated from protobuf message <code>google.firestore.admin.v1.PitrSnapshot</code>
 */
class PitrSnapshot extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the database that this was a snapshot of. Format:
     * `projects/{project}/databases/{database}`.
     *
     * Generated from protobuf field <code>string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $database = '';
    /**
     * Output only. Public UUID of the database the snapshot was associated with.
     *
     * Generated from protobuf field <code>bytes database_uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $database_uid = '';
    /**
     * Required. Snapshot time of the database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $snapshot_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $database
     *           Required. The name of the database that this was a snapshot of. Format:
     *           `projects/{project}/databases/{database}`.
     *     @type string $database_uid
     *           Output only. Public UUID of the database the snapshot was associated with.
     *     @type \Google\Protobuf\Timestamp $snapshot_time
     *           Required. Snapshot time of the database.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Firestore\Admin\V1\Snapshot::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the database that this was a snapshot of. Format:
     * `projects/{project}/databases/{database}`.
     *
     * Generated from protobuf field <code>string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getDatabase()
    {
        return $this->database;
    }

    /**
     * Required. The name of the database that this was a snapshot of. Format:
     * `projects/{project}/databases/{database}`.
     *
     * Generated from protobuf field <code>string database = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkString($var, True);
        $this->database = $var;

        return $this;
    }

    /**
     * Output only. Public UUID of the database the snapshot was associated with.
     *
     * Generated from protobuf field <code>bytes database_uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDatabaseUid()
    {
        return $this->database_uid;
    }

    /**
     * Output only. Public UUID of the database the snapshot was associated with.
     *
     * Generated from protobuf field <code>bytes database_uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDatabaseUid($var)
    {
        GPBUtil::checkString($var, False);
        $this->database_uid = $var;

        return $this;
    }

    /**
     * Required. Snapshot time of the database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getSnapshotTime()
    {
        return $this->snapshot_time;
    }

    public function hasSnapshotTime()
    {
        return isset($this->snapshot_time);
    }

    public function clearSnapshotTime()
    {
        unset($this->snapshot_time);
    }

    /**
     * Required. Snapshot time of the database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setSnapshotTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->snapshot_time = $var;

        return $this;
    }

}

