<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/identity_mapping_store.proto

namespace Google\Cloud\DiscoveryEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Identity Mapping Entry that maps an external identity to an internal
 * identity.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.IdentityMappingEntry</code>
 */
class IdentityMappingEntry extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Identity outside the customer identity provider.
     * The length limit of external identity will be of 100 characters.
     *
     * Generated from protobuf field <code>string external_identity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $external_identity = '';
    protected $identity_provider_id;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $user_id
     *           User identifier.
     *           For Google Workspace user account, user_id should be the google workspace
     *           user email.
     *           For non-google identity provider, user_id is the mapped user identifier
     *           configured during the workforcepool config.
     *     @type string $group_id
     *           Group identifier.
     *           For Google Workspace user account, group_id should be the google
     *           workspace group email.
     *           For non-google identity provider, group_id is the mapped group identifier
     *           configured during the workforcepool config.
     *     @type string $external_identity
     *           Required. Identity outside the customer identity provider.
     *           The length limit of external identity will be of 100 characters.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\IdentityMappingStore::initOnce();
        parent::__construct($data);
    }

    /**
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider, user_id is the mapped user identifier
     * configured during the workforcepool config.
     *
     * Generated from protobuf field <code>string user_id = 2;</code>
     * @return string
     */
    public function getUserId()
    {
        return $this->readOneof(2);
    }

    public function hasUserId()
    {
        return $this->hasOneof(2);
    }

    /**
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider, user_id is the mapped user identifier
     * configured during the workforcepool config.
     *
     * Generated from protobuf field <code>string user_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setUserId($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider, group_id is the mapped group identifier
     * configured during the workforcepool config.
     *
     * Generated from protobuf field <code>string group_id = 3;</code>
     * @return string
     */
    public function getGroupId()
    {
        return $this->readOneof(3);
    }

    public function hasGroupId()
    {
        return $this->hasOneof(3);
    }

    /**
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider, group_id is the mapped group identifier
     * configured during the workforcepool config.
     *
     * Generated from protobuf field <code>string group_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setGroupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Required. Identity outside the customer identity provider.
     * The length limit of external identity will be of 100 characters.
     *
     * Generated from protobuf field <code>string external_identity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getExternalIdentity()
    {
        return $this->external_identity;
    }

    /**
     * Required. Identity outside the customer identity provider.
     * The length limit of external identity will be of 100 characters.
     *
     * Generated from protobuf field <code>string external_identity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setExternalIdentity($var)
    {
        GPBUtil::checkString($var, True);
        $this->external_identity = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getIdentityProviderId()
    {
        return $this->whichOneof("identity_provider_id");
    }

}

