<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/cmek_config_service.proto

namespace Google\Cloud\DiscoveryEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configurations used to enable CMEK data encryption with Cloud KMS keys.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.CmekConfig</code>
 */
class CmekConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the CmekConfig of the form
     * `projects/{project}/locations/{location}/cmekConfig` or
     * `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * KMS key resource name which will be used to encrypt resources
     * `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
     *
     * Generated from protobuf field <code>string kms_key = 2 [(.google.api.resource_reference) = {</code>
     */
    protected $kms_key = '';
    /**
     * KMS key version resource name which will be used to encrypt resources
     * `<kms_key>/cryptoKeyVersions/{keyVersion}`.
     *
     * Generated from protobuf field <code>string kms_key_version = 6 [(.google.api.resource_reference) = {</code>
     */
    protected $kms_key_version = '';
    /**
     * Output only. The states of the CmekConfig.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CmekConfig.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The default CmekConfig for the Customer.
     *
     * Generated from protobuf field <code>bool is_default = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $is_default = false;
    /**
     * Output only. The timestamp of the last key rotation.
     *
     * Generated from protobuf field <code>int64 last_rotation_timestamp_micros = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_rotation_timestamp_micros = 0;
    /**
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $single_region_keys;
    /**
     * Output only. Whether the NotebookLM Corpus is ready to be used.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState notebooklm_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $notebooklm_state = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The name of the CmekConfig of the form
     *           `projects/{project}/locations/{location}/cmekConfig` or
     *           `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
     *     @type string $kms_key
     *           KMS key resource name which will be used to encrypt resources
     *           `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
     *     @type string $kms_key_version
     *           KMS key version resource name which will be used to encrypt resources
     *           `<kms_key>/cryptoKeyVersions/{keyVersion}`.
     *     @type int $state
     *           Output only. The states of the CmekConfig.
     *     @type bool $is_default
     *           Output only. The default CmekConfig for the Customer.
     *     @type int|string $last_rotation_timestamp_micros
     *           Output only. The timestamp of the last key rotation.
     *     @type array<\Google\Cloud\DiscoveryEngine\V1\SingleRegionKey>|\Google\Protobuf\Internal\RepeatedField $single_region_keys
     *           Optional. Single-regional CMEKs that are required for some VAIS features.
     *     @type int $notebooklm_state
     *           Output only. Whether the NotebookLM Corpus is ready to be used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\CmekConfigService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the CmekConfig of the form
     * `projects/{project}/locations/{location}/cmekConfig` or
     * `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The name of the CmekConfig of the form
     * `projects/{project}/locations/{location}/cmekConfig` or
     * `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * KMS key resource name which will be used to encrypt resources
     * `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
     *
     * Generated from protobuf field <code>string kms_key = 2 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getKmsKey()
    {
        return $this->kms_key;
    }

    /**
     * KMS key resource name which will be used to encrypt resources
     * `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
     *
     * Generated from protobuf field <code>string kms_key = 2 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key = $var;

        return $this;
    }

    /**
     * KMS key version resource name which will be used to encrypt resources
     * `<kms_key>/cryptoKeyVersions/{keyVersion}`.
     *
     * Generated from protobuf field <code>string kms_key_version = 6 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getKmsKeyVersion()
    {
        return $this->kms_key_version;
    }

    /**
     * KMS key version resource name which will be used to encrypt resources
     * `<kms_key>/cryptoKeyVersions/{keyVersion}`.
     *
     * Generated from protobuf field <code>string kms_key_version = 6 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_version = $var;

        return $this;
    }

    /**
     * Output only. The states of the CmekConfig.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CmekConfig.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The states of the CmekConfig.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CmekConfig.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DiscoveryEngine\V1\CmekConfig\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The default CmekConfig for the Customer.
     *
     * Generated from protobuf field <code>bool is_default = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->is_default;
    }

    /**
     * Output only. The default CmekConfig for the Customer.
     *
     * Generated from protobuf field <code>bool is_default = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsDefault($var)
    {
        GPBUtil::checkBool($var);
        $this->is_default = $var;

        return $this;
    }

    /**
     * Output only. The timestamp of the last key rotation.
     *
     * Generated from protobuf field <code>int64 last_rotation_timestamp_micros = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getLastRotationTimestampMicros()
    {
        return $this->last_rotation_timestamp_micros;
    }

    /**
     * Output only. The timestamp of the last key rotation.
     *
     * Generated from protobuf field <code>int64 last_rotation_timestamp_micros = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setLastRotationTimestampMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->last_rotation_timestamp_micros = $var;

        return $this;
    }

    /**
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSingleRegionKeys()
    {
        return $this->single_region_keys;
    }

    /**
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     *
     * Generated from protobuf field <code>repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\DiscoveryEngine\V1\SingleRegionKey>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSingleRegionKeys($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DiscoveryEngine\V1\SingleRegionKey::class);
        $this->single_region_keys = $arr;

        return $this;
    }

    /**
     * Output only. Whether the NotebookLM Corpus is ready to be used.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState notebooklm_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getNotebooklmState()
    {
        return $this->notebooklm_state;
    }

    /**
     * Output only. Whether the NotebookLM Corpus is ready to be used.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState notebooklm_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setNotebooklmState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DiscoveryEngine\V1\CmekConfig\NotebookLMState::class);
        $this->notebooklm_state = $var;

        return $this;
    }

}

