<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/response_message.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a response message that can be returned by a conversational agent.
 * Response messages are also used for output audio synthesis. The approach is
 * as follows:
 * * If at least one OutputAudioText response is present, then all
 *   OutputAudioText responses are linearly concatenated, and the result is used
 *   for output audio synthesis.
 * * If the OutputAudioText responses are a mixture of text and SSML, then the
 *   concatenated result is treated as SSML; otherwise, the result is treated as
 *   either text or SSML as appropriate. The agent designer should ideally use
 *   either text or SSML consistently throughout the bot design.
 * * Otherwise, all Text responses are linearly concatenated, and the result is
 *   used for output audio synthesis.
 * This approach allows for more sophisticated user experience scenarios, where
 * the text displayed to the user may differ from what is heard.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.ResponseMessage</code>
 */
class ResponseMessage extends \Google\Protobuf\Internal\Message
{
    /**
     * Response type.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.ResponseType response_type = 4;</code>
     */
    protected $response_type = 0;
    /**
     * The channel which the response is associated with. Clients can specify the
     * channel via
     * [QueryParameters.channel][google.cloud.dialogflow.cx.v3.QueryParameters.channel],
     * and only associated channel response will be returned.
     *
     * Generated from protobuf field <code>string channel = 19;</code>
     */
    protected $channel = '';
    protected $message;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\Text $text
     *           Returns a text response.
     *     @type \Google\Protobuf\Struct $payload
     *           Returns a response containing a custom, platform-specific payload.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\ConversationSuccess $conversation_success
     *           Indicates that the conversation succeeded.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\OutputAudioText $output_audio_text
     *           A text or ssml response that is preferentially used for TTS output audio
     *           synthesis, as described in the comment on the ResponseMessage message.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\LiveAgentHandoff $live_agent_handoff
     *           Hands off conversation to a human agent.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\EndInteraction $end_interaction
     *           Output only. A signal that indicates the interaction with the Dialogflow
     *           agent has ended. This message is generated by Dialogflow only when the
     *           conversation reaches `END_SESSION` page. It is not supposed to be defined
     *           by the user.
     *           It's guaranteed that there is at most one such message in each response.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\PlayAudio $play_audio
     *           Signal that the client should play an audio clip hosted at a
     *           client-specific URI. Dialogflow uses this to construct
     *           [mixed_audio][google.cloud.dialogflow.cx.v3.ResponseMessage.mixed_audio].
     *           However, Dialogflow itself does not try to read or process the URI in any
     *           way.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\MixedAudio $mixed_audio
     *           Output only. An audio response message composed of both the synthesized
     *           Dialogflow agent responses and responses defined via
     *           [play_audio][google.cloud.dialogflow.cx.v3.ResponseMessage.play_audio].
     *           This message is generated by Dialogflow only and not supposed to be
     *           defined by the user.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\TelephonyTransferCall $telephony_transfer_call
     *           A signal that the client should transfer the phone call connected to
     *           this agent to a third-party endpoint.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\KnowledgeInfoCard $knowledge_info_card
     *           Represents info card for knowledge answers, to be better rendered in
     *           Dialogflow Messenger.
     *     @type int $response_type
     *           Response type.
     *     @type string $channel
     *           The channel which the response is associated with. Clients can specify the
     *           channel via
     *           [QueryParameters.channel][google.cloud.dialogflow.cx.v3.QueryParameters.channel],
     *           and only associated channel response will be returned.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\ResponseMessage::initOnce();
        parent::__construct($data);
    }

    /**
     * Returns a text response.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.Text text = 1;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\Text|null
     */
    public function getText()
    {
        return $this->readOneof(1);
    }

    public function hasText()
    {
        return $this->hasOneof(1);
    }

    /**
     * Returns a text response.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.Text text = 1;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\Text $var
     * @return $this
     */
    public function setText($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\Text::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Returns a response containing a custom, platform-specific payload.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct payload = 2;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getPayload()
    {
        return $this->readOneof(2);
    }

    public function hasPayload()
    {
        return $this->hasOneof(2);
    }

    /**
     * Returns a response containing a custom, platform-specific payload.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct payload = 2;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setPayload($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Indicates that the conversation succeeded.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.ConversationSuccess conversation_success = 9;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\ConversationSuccess|null
     */
    public function getConversationSuccess()
    {
        return $this->readOneof(9);
    }

    public function hasConversationSuccess()
    {
        return $this->hasOneof(9);
    }

    /**
     * Indicates that the conversation succeeded.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.ConversationSuccess conversation_success = 9;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\ConversationSuccess $var
     * @return $this
     */
    public function setConversationSuccess($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\ConversationSuccess::class);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.OutputAudioText output_audio_text = 8;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\OutputAudioText|null
     */
    public function getOutputAudioText()
    {
        return $this->readOneof(8);
    }

    public function hasOutputAudioText()
    {
        return $this->hasOneof(8);
    }

    /**
     * A text or ssml response that is preferentially used for TTS output audio
     * synthesis, as described in the comment on the ResponseMessage message.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.OutputAudioText output_audio_text = 8;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\OutputAudioText $var
     * @return $this
     */
    public function setOutputAudioText($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\OutputAudioText::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Hands off conversation to a human agent.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\LiveAgentHandoff|null
     */
    public function getLiveAgentHandoff()
    {
        return $this->readOneof(10);
    }

    public function hasLiveAgentHandoff()
    {
        return $this->hasOneof(10);
    }

    /**
     * Hands off conversation to a human agent.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.LiveAgentHandoff live_agent_handoff = 10;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\LiveAgentHandoff $var
     * @return $this
     */
    public function setLiveAgentHandoff($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\LiveAgentHandoff::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * Output only. A signal that indicates the interaction with the Dialogflow
     * agent has ended. This message is generated by Dialogflow only when the
     * conversation reaches `END_SESSION` page. It is not supposed to be defined
     * by the user.
     * It's guaranteed that there is at most one such message in each response.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\EndInteraction|null
     */
    public function getEndInteraction()
    {
        return $this->readOneof(11);
    }

    public function hasEndInteraction()
    {
        return $this->hasOneof(11);
    }

    /**
     * Output only. A signal that indicates the interaction with the Dialogflow
     * agent has ended. This message is generated by Dialogflow only when the
     * conversation reaches `END_SESSION` page. It is not supposed to be defined
     * by the user.
     * It's guaranteed that there is at most one such message in each response.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.EndInteraction end_interaction = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\EndInteraction $var
     * @return $this
     */
    public function setEndInteraction($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\EndInteraction::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * Signal that the client should play an audio clip hosted at a
     * client-specific URI. Dialogflow uses this to construct
     * [mixed_audio][google.cloud.dialogflow.cx.v3.ResponseMessage.mixed_audio].
     * However, Dialogflow itself does not try to read or process the URI in any
     * way.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.PlayAudio play_audio = 12;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\PlayAudio|null
     */
    public function getPlayAudio()
    {
        return $this->readOneof(12);
    }

    public function hasPlayAudio()
    {
        return $this->hasOneof(12);
    }

    /**
     * Signal that the client should play an audio clip hosted at a
     * client-specific URI. Dialogflow uses this to construct
     * [mixed_audio][google.cloud.dialogflow.cx.v3.ResponseMessage.mixed_audio].
     * However, Dialogflow itself does not try to read or process the URI in any
     * way.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.PlayAudio play_audio = 12;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\PlayAudio $var
     * @return $this
     */
    public function setPlayAudio($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\PlayAudio::class);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * Output only. An audio response message composed of both the synthesized
     * Dialogflow agent responses and responses defined via
     * [play_audio][google.cloud.dialogflow.cx.v3.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\MixedAudio|null
     */
    public function getMixedAudio()
    {
        return $this->readOneof(13);
    }

    public function hasMixedAudio()
    {
        return $this->hasOneof(13);
    }

    /**
     * Output only. An audio response message composed of both the synthesized
     * Dialogflow agent responses and responses defined via
     * [play_audio][google.cloud.dialogflow.cx.v3.ResponseMessage.play_audio].
     * This message is generated by Dialogflow only and not supposed to be
     * defined by the user.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.MixedAudio mixed_audio = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\MixedAudio $var
     * @return $this
     */
    public function setMixedAudio($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\MixedAudio::class);
        $this->writeOneof(13, $var);

        return $this;
    }

    /**
     * A signal that the client should transfer the phone call connected to
     * this agent to a third-party endpoint.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\TelephonyTransferCall|null
     */
    public function getTelephonyTransferCall()
    {
        return $this->readOneof(18);
    }

    public function hasTelephonyTransferCall()
    {
        return $this->hasOneof(18);
    }

    /**
     * A signal that the client should transfer the phone call connected to
     * this agent to a third-party endpoint.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.TelephonyTransferCall telephony_transfer_call = 18;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\TelephonyTransferCall $var
     * @return $this
     */
    public function setTelephonyTransferCall($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\TelephonyTransferCall::class);
        $this->writeOneof(18, $var);

        return $this;
    }

    /**
     * Represents info card for knowledge answers, to be better rendered in
     * Dialogflow Messenger.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\KnowledgeInfoCard|null
     */
    public function getKnowledgeInfoCard()
    {
        return $this->readOneof(20);
    }

    public function hasKnowledgeInfoCard()
    {
        return $this->hasOneof(20);
    }

    /**
     * Represents info card for knowledge answers, to be better rendered in
     * Dialogflow Messenger.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.KnowledgeInfoCard knowledge_info_card = 20;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\KnowledgeInfoCard $var
     * @return $this
     */
    public function setKnowledgeInfoCard($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\KnowledgeInfoCard::class);
        $this->writeOneof(20, $var);

        return $this;
    }

    /**
     * Response type.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.ResponseType response_type = 4;</code>
     * @return int
     */
    public function getResponseType()
    {
        return $this->response_type;
    }

    /**
     * Response type.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.ResponseMessage.ResponseType response_type = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setResponseType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage\ResponseType::class);
        $this->response_type = $var;

        return $this;
    }

    /**
     * The channel which the response is associated with. Clients can specify the
     * channel via
     * [QueryParameters.channel][google.cloud.dialogflow.cx.v3.QueryParameters.channel],
     * and only associated channel response will be returned.
     *
     * Generated from protobuf field <code>string channel = 19;</code>
     * @return string
     */
    public function getChannel()
    {
        return $this->channel;
    }

    /**
     * The channel which the response is associated with. Clients can specify the
     * channel via
     * [QueryParameters.channel][google.cloud.dialogflow.cx.v3.QueryParameters.channel],
     * and only associated channel response will be returned.
     *
     * Generated from protobuf field <code>string channel = 19;</code>
     * @param string $var
     * @return $this
     */
    public function setChannel($var)
    {
        GPBUtil::checkString($var, True);
        $this->channel = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->whichOneof("message");
    }

}

