<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dialogflow/cx/v3/session_entity_type.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\Cx\V3\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\Cx\V3\CreateSessionEntityTypeRequest;
use Google\Cloud\Dialogflow\Cx\V3\DeleteSessionEntityTypeRequest;
use Google\Cloud\Dialogflow\Cx\V3\GetSessionEntityTypeRequest;
use Google\Cloud\Dialogflow\Cx\V3\ListSessionEntityTypesRequest;
use Google\Cloud\Dialogflow\Cx\V3\SessionEntityType;
use Google\Cloud\Dialogflow\Cx\V3\UpdateSessionEntityTypeRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Service for managing
 * [SessionEntityTypes][google.cloud.dialogflow.cx.v3.SessionEntityType].
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<SessionEntityType> createSessionEntityTypeAsync(CreateSessionEntityTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteSessionEntityTypeAsync(DeleteSessionEntityTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SessionEntityType> getSessionEntityTypeAsync(GetSessionEntityTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSessionEntityTypesAsync(ListSessionEntityTypesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SessionEntityType> updateSessionEntityTypeAsync(UpdateSessionEntityTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class SessionEntityTypesClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.dialogflow.cx.v3.SessionEntityTypes';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dialogflow.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/session_entity_types_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/session_entity_types_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/session_entity_types_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/session_entity_types_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent_environment_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $environment
     * @param string $session
     *
     * @return string The formatted project_location_agent_environment_session resource.
     */
    public static function projectLocationAgentEnvironmentSessionName(
        string $project,
        string $location,
        string $agent,
        string $environment,
        string $session
    ): string {
        return self::getPathTemplate('projectLocationAgentEnvironmentSession')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'environment' => $environment,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent_environment_session_entity_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $environment
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_location_agent_environment_session_entity_type resource.
     */
    public static function projectLocationAgentEnvironmentSessionEntityTypeName(
        string $project,
        string $location,
        string $agent,
        string $environment,
        string $session,
        string $entityType
    ): string {
        return self::getPathTemplate('projectLocationAgentEnvironmentSessionEntityType')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'environment' => $environment,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $session
     *
     * @return string The formatted project_location_agent_session resource.
     */
    public static function projectLocationAgentSessionName(
        string $project,
        string $location,
        string $agent,
        string $session
    ): string {
        return self::getPathTemplate('projectLocationAgentSession')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent_session_entity_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_location_agent_session_entity_type resource.
     */
    public static function projectLocationAgentSessionEntityTypeName(
        string $project,
        string $location,
        string $agent,
        string $session,
        string $entityType
    ): string {
        return self::getPathTemplate('projectLocationAgentSessionEntityType')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a session
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $session
     *
     * @return string The formatted session resource.
     */
    public static function sessionName(string $project, string $location, string $agent, string $session): string
    {
        return self::getPathTemplate('session')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * session_entity_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted session_entity_type resource.
     */
    public static function sessionEntityTypeName(
        string $project,
        string $location,
        string $agent,
        string $session,
        string $entityType
    ): string {
        return self::getPathTemplate('sessionEntityType')->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - projectLocationAgentEnvironmentSession: projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/sessions/{session}
     * - projectLocationAgentEnvironmentSessionEntityType: projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/sessions/{session}/entityTypes/{entity_type}
     * - projectLocationAgentSession: projects/{project}/locations/{location}/agents/{agent}/sessions/{session}
     * - projectLocationAgentSessionEntityType: projects/{project}/locations/{location}/agents/{agent}/sessions/{session}/entityTypes/{entity_type}
     * - session: projects/{project}/locations/{location}/agents/{agent}/sessions/{session}
     * - sessionEntityType: projects/{project}/locations/{location}/agents/{agent}/sessions/{session}/entityTypes/{entity_type}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a session entity type.
     *
     * The async variant is
     * {@see SessionEntityTypesClient::createSessionEntityTypeAsync()} .
     *
     * @example samples/V3/SessionEntityTypesClient/create_session_entity_type.php
     *
     * @param CreateSessionEntityTypeRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SessionEntityType
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSessionEntityType(
        CreateSessionEntityTypeRequest $request,
        array $callOptions = []
    ): SessionEntityType {
        return $this->startApiCall('CreateSessionEntityType', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified session entity type.
     *
     * The async variant is
     * {@see SessionEntityTypesClient::deleteSessionEntityTypeAsync()} .
     *
     * @example samples/V3/SessionEntityTypesClient/delete_session_entity_type.php
     *
     * @param DeleteSessionEntityTypeRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSessionEntityType(DeleteSessionEntityTypeRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSessionEntityType', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the specified session entity type.
     *
     * The async variant is
     * {@see SessionEntityTypesClient::getSessionEntityTypeAsync()} .
     *
     * @example samples/V3/SessionEntityTypesClient/get_session_entity_type.php
     *
     * @param GetSessionEntityTypeRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SessionEntityType
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSessionEntityType(
        GetSessionEntityTypeRequest $request,
        array $callOptions = []
    ): SessionEntityType {
        return $this->startApiCall('GetSessionEntityType', $request, $callOptions)->wait();
    }

    /**
     * Returns the list of all session entity types in the specified session.
     *
     * The async variant is
     * {@see SessionEntityTypesClient::listSessionEntityTypesAsync()} .
     *
     * @example samples/V3/SessionEntityTypesClient/list_session_entity_types.php
     *
     * @param ListSessionEntityTypesRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSessionEntityTypes(
        ListSessionEntityTypesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListSessionEntityTypes', $request, $callOptions);
    }

    /**
     * Updates the specified session entity type.
     *
     * The async variant is
     * {@see SessionEntityTypesClient::updateSessionEntityTypeAsync()} .
     *
     * @example samples/V3/SessionEntityTypesClient/update_session_entity_type.php
     *
     * @param UpdateSessionEntityTypeRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SessionEntityType
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSessionEntityType(
        UpdateSessionEntityTypeRequest $request,
        array $callOptions = []
    ): SessionEntityType {
        return $this->startApiCall('UpdateSessionEntityType', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see SessionEntityTypesClient::getLocationAsync()} .
     *
     * @example samples/V3/SessionEntityTypesClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see SessionEntityTypesClient::listLocationsAsync()} .
     *
     * @example samples/V3/SessionEntityTypesClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
