<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/developerconnect/v1/developer_connect.proto

namespace Google\Cloud\DeveloperConnect\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for connections to an instance of GitLab Enterprise.
 *
 * Generated from protobuf message <code>google.cloud.developerconnect.v1.GitLabEnterpriseConfig</code>
 */
class GitLabEnterpriseConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The URI of the GitLab Enterprise host this connection is for.
     *
     * Generated from protobuf field <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $host_uri = '';
    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * of a GitLab project, formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. This
     * is used to validate webhooks.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    protected $webhook_secret_secret_version = '';
    /**
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access and a minimum role of `reporter`. The GitLab Projects visible to
     * this Personal Access Token will control which Projects Developer Connect
     * has access to.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $read_authorizer_credential = null;
    /**
     * Required. A GitLab personal access token with the minimum `api` scope
     * access and a minimum role of `maintainer`. The GitLab Projects visible to
     * this Personal Access Token will control which Projects Developer Connect
     * has access to.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $authorizer_credential = null;
    /**
     * Optional. Configuration for using Service Directory to privately connect to
     * a GitLab Enterprise instance. This should only be set if the GitLab
     * Enterprise server is hosted on-premises and not reachable by public
     * internet. If this field is left empty, calls to the GitLab Enterprise
     * server will be made over the public internet.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.ServiceDirectoryConfig service_directory_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_directory_config = null;
    /**
     * Optional. SSL Certificate Authority certificate to use for requests to
     * GitLab Enterprise instance.
     *
     * Generated from protobuf field <code>string ssl_ca_certificate = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ssl_ca_certificate = '';
    /**
     * Output only. Version of the GitLab Enterprise server running on the
     * `host_uri`.
     *
     * Generated from protobuf field <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $server_version = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $host_uri
     *           Required. The URI of the GitLab Enterprise host this connection is for.
     *     @type string $webhook_secret_secret_version
     *           Required. Immutable. SecretManager resource containing the webhook secret
     *           of a GitLab project, formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. This
     *           is used to validate webhooks.
     *     @type \Google\Cloud\DeveloperConnect\V1\UserCredential $read_authorizer_credential
     *           Required. A GitLab personal access token with the minimum `read_api` scope
     *           access and a minimum role of `reporter`. The GitLab Projects visible to
     *           this Personal Access Token will control which Projects Developer Connect
     *           has access to.
     *     @type \Google\Cloud\DeveloperConnect\V1\UserCredential $authorizer_credential
     *           Required. A GitLab personal access token with the minimum `api` scope
     *           access and a minimum role of `maintainer`. The GitLab Projects visible to
     *           this Personal Access Token will control which Projects Developer Connect
     *           has access to.
     *     @type \Google\Cloud\DeveloperConnect\V1\ServiceDirectoryConfig $service_directory_config
     *           Optional. Configuration for using Service Directory to privately connect to
     *           a GitLab Enterprise instance. This should only be set if the GitLab
     *           Enterprise server is hosted on-premises and not reachable by public
     *           internet. If this field is left empty, calls to the GitLab Enterprise
     *           server will be made over the public internet.
     *     @type string $ssl_ca_certificate
     *           Optional. SSL Certificate Authority certificate to use for requests to
     *           GitLab Enterprise instance.
     *     @type string $server_version
     *           Output only. Version of the GitLab Enterprise server running on the
     *           `host_uri`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Developerconnect\V1\DeveloperConnect::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The URI of the GitLab Enterprise host this connection is for.
     *
     * Generated from protobuf field <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getHostUri()
    {
        return $this->host_uri;
    }

    /**
     * Required. The URI of the GitLab Enterprise host this connection is for.
     *
     * Generated from protobuf field <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setHostUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->host_uri = $var;

        return $this;
    }

    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * of a GitLab project, formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. This
     * is used to validate webhooks.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getWebhookSecretSecretVersion()
    {
        return $this->webhook_secret_secret_version;
    }

    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * of a GitLab project, formatted as `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. This
     * is used to validate webhooks.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setWebhookSecretSecretVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->webhook_secret_secret_version = $var;

        return $this;
    }

    /**
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access and a minimum role of `reporter`. The GitLab Projects visible to
     * this Personal Access Token will control which Projects Developer Connect
     * has access to.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\DeveloperConnect\V1\UserCredential|null
     */
    public function getReadAuthorizerCredential()
    {
        return $this->read_authorizer_credential;
    }

    public function hasReadAuthorizerCredential()
    {
        return isset($this->read_authorizer_credential);
    }

    public function clearReadAuthorizerCredential()
    {
        unset($this->read_authorizer_credential);
    }

    /**
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access and a minimum role of `reporter`. The GitLab Projects visible to
     * this Personal Access Token will control which Projects Developer Connect
     * has access to.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\DeveloperConnect\V1\UserCredential $var
     * @return $this
     */
    public function setReadAuthorizerCredential($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\UserCredential::class);
        $this->read_authorizer_credential = $var;

        return $this;
    }

    /**
     * Required. A GitLab personal access token with the minimum `api` scope
     * access and a minimum role of `maintainer`. The GitLab Projects visible to
     * this Personal Access Token will control which Projects Developer Connect
     * has access to.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\DeveloperConnect\V1\UserCredential|null
     */
    public function getAuthorizerCredential()
    {
        return $this->authorizer_credential;
    }

    public function hasAuthorizerCredential()
    {
        return isset($this->authorizer_credential);
    }

    public function clearAuthorizerCredential()
    {
        unset($this->authorizer_credential);
    }

    /**
     * Required. A GitLab personal access token with the minimum `api` scope
     * access and a minimum role of `maintainer`. The GitLab Projects visible to
     * this Personal Access Token will control which Projects Developer Connect
     * has access to.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\DeveloperConnect\V1\UserCredential $var
     * @return $this
     */
    public function setAuthorizerCredential($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\UserCredential::class);
        $this->authorizer_credential = $var;

        return $this;
    }

    /**
     * Optional. Configuration for using Service Directory to privately connect to
     * a GitLab Enterprise instance. This should only be set if the GitLab
     * Enterprise server is hosted on-premises and not reachable by public
     * internet. If this field is left empty, calls to the GitLab Enterprise
     * server will be made over the public internet.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.ServiceDirectoryConfig service_directory_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DeveloperConnect\V1\ServiceDirectoryConfig|null
     */
    public function getServiceDirectoryConfig()
    {
        return $this->service_directory_config;
    }

    public function hasServiceDirectoryConfig()
    {
        return isset($this->service_directory_config);
    }

    public function clearServiceDirectoryConfig()
    {
        unset($this->service_directory_config);
    }

    /**
     * Optional. Configuration for using Service Directory to privately connect to
     * a GitLab Enterprise instance. This should only be set if the GitLab
     * Enterprise server is hosted on-premises and not reachable by public
     * internet. If this field is left empty, calls to the GitLab Enterprise
     * server will be made over the public internet.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.ServiceDirectoryConfig service_directory_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DeveloperConnect\V1\ServiceDirectoryConfig $var
     * @return $this
     */
    public function setServiceDirectoryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\ServiceDirectoryConfig::class);
        $this->service_directory_config = $var;

        return $this;
    }

    /**
     * Optional. SSL Certificate Authority certificate to use for requests to
     * GitLab Enterprise instance.
     *
     * Generated from protobuf field <code>string ssl_ca_certificate = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getSslCaCertificate()
    {
        return $this->ssl_ca_certificate;
    }

    /**
     * Optional. SSL Certificate Authority certificate to use for requests to
     * GitLab Enterprise instance.
     *
     * Generated from protobuf field <code>string ssl_ca_certificate = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setSslCaCertificate($var)
    {
        GPBUtil::checkString($var, True);
        $this->ssl_ca_certificate = $var;

        return $this;
    }

    /**
     * Output only. Version of the GitLab Enterprise server running on the
     * `host_uri`.
     *
     * Generated from protobuf field <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getServerVersion()
    {
        return $this->server_version;
    }

    /**
     * Output only. Version of the GitLab Enterprise server running on the
     * `host_uri`.
     *
     * Generated from protobuf field <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setServerVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->server_version = $var;

        return $this;
    }

}

