<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/deploy/v1/cloud_deploy.proto

namespace Google\Cloud\Deploy\V1\KubernetesConfig\GatewayServiceMesh;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Information about route destinations for the Gateway API service mesh.
 *
 * Generated from protobuf message <code>google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.RouteDestinations</code>
 */
class RouteDestinations extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The clusters where the Gateway API HTTPRoute resource will be
     * deployed to. Valid entries include the associated entities IDs
     * configured in the Target resource and "&#64;self" to include the Target
     * cluster.
     *
     * Generated from protobuf field <code>repeated string destination_ids = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $destination_ids;
    /**
     * Optional. Whether to propagate the Kubernetes Service to the route
     * destination clusters. The Service will always be deployed to the Target
     * cluster even if the HTTPRoute is not. This option may be used to
     * facilitate successful DNS lookup in the route destination clusters. Can
     * only be set to true if destinations are specified.
     *
     * Generated from protobuf field <code>bool propagate_service = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $propagate_service = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $destination_ids
     *           Required. The clusters where the Gateway API HTTPRoute resource will be
     *           deployed to. Valid entries include the associated entities IDs
     *           configured in the Target resource and "&#64;self" to include the Target
     *           cluster.
     *     @type bool $propagate_service
     *           Optional. Whether to propagate the Kubernetes Service to the route
     *           destination clusters. The Service will always be deployed to the Target
     *           cluster even if the HTTPRoute is not. This option may be used to
     *           facilitate successful DNS lookup in the route destination clusters. Can
     *           only be set to true if destinations are specified.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Deploy\V1\CloudDeploy::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The clusters where the Gateway API HTTPRoute resource will be
     * deployed to. Valid entries include the associated entities IDs
     * configured in the Target resource and "&#64;self" to include the Target
     * cluster.
     *
     * Generated from protobuf field <code>repeated string destination_ids = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDestinationIds()
    {
        return $this->destination_ids;
    }

    /**
     * Required. The clusters where the Gateway API HTTPRoute resource will be
     * deployed to. Valid entries include the associated entities IDs
     * configured in the Target resource and "&#64;self" to include the Target
     * cluster.
     *
     * Generated from protobuf field <code>repeated string destination_ids = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDestinationIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->destination_ids = $arr;

        return $this;
    }

    /**
     * Optional. Whether to propagate the Kubernetes Service to the route
     * destination clusters. The Service will always be deployed to the Target
     * cluster even if the HTTPRoute is not. This option may be used to
     * facilitate successful DNS lookup in the route destination clusters. Can
     * only be set to true if destinations are specified.
     *
     * Generated from protobuf field <code>bool propagate_service = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getPropagateService()
    {
        return $this->propagate_service;
    }

    /**
     * Optional. Whether to propagate the Kubernetes Service to the route
     * destination clusters. The Service will always be deployed to the Target
     * cluster even if the HTTPRoute is not. This option may be used to
     * facilitate successful DNS lookup in the route destination clusters. Can
     * only be set to true if destinations are specified.
     *
     * Generated from protobuf field <code>bool propagate_service = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setPropagateService($var)
    {
        GPBUtil::checkBool($var);
        $this->propagate_service = $var;

        return $this;
    }

}


