<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/audit/audit_log.proto

namespace Google\Cloud\Audit;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Common audit log format for Google Cloud Platform API operations.
 *
 * Generated from protobuf message <code>google.cloud.audit.AuditLog</code>
 */
class AuditLog extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the API service performing the operation. For example,
     * `"compute.googleapis.com"`.
     *
     * Generated from protobuf field <code>string service_name = 7;</code>
     */
    protected $service_name = '';
    /**
     * The name of the service method or operation.
     * For API calls, this should be the name of the API method.
     * For example,
     *     "google.cloud.bigquery.v2.TableService.InsertTable"
     *     "google.logging.v2.ConfigServiceV2.CreateSink"
     *
     * Generated from protobuf field <code>string method_name = 8;</code>
     */
    protected $method_name = '';
    /**
     * The resource or collection that is the target of the operation.
     * The name is a scheme-less URI, not including the API service name.
     * For example:
     *     "projects/PROJECT_ID/zones/us-central1-a/instances"
     *     "projects/PROJECT_ID/datasets/DATASET_ID"
     *
     * Generated from protobuf field <code>string resource_name = 11;</code>
     */
    protected $resource_name = '';
    /**
     * The resource location information.
     *
     * Generated from protobuf field <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     */
    protected $resource_location = null;
    /**
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct resource_original_state = 19;</code>
     */
    protected $resource_original_state = null;
    /**
     * The number of items returned from a List or Query API method,
     * if applicable.
     *
     * Generated from protobuf field <code>int64 num_response_items = 12;</code>
     */
    protected $num_response_items = 0;
    /**
     * The status of the overall operation.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 2;</code>
     */
    protected $status = null;
    /**
     * Authentication information.
     *
     * Generated from protobuf field <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     */
    protected $authentication_info = null;
    /**
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     *
     * Generated from protobuf field <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    private $authorization_info;
    /**
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     *
     * Generated from protobuf field <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     */
    protected $policy_violation_info = null;
    /**
     * Metadata about the operation.
     *
     * Generated from protobuf field <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     */
    protected $request_metadata = null;
    /**
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct request = 16;</code>
     */
    protected $request = null;
    /**
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct response = 17;</code>
     */
    protected $response = null;
    /**
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct metadata = 18;</code>
     */
    protected $metadata = null;
    /**
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     *
     * Generated from protobuf field <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     * @deprecated
     */
    protected $service_data = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $service_name
     *           The name of the API service performing the operation. For example,
     *           `"compute.googleapis.com"`.
     *     @type string $method_name
     *           The name of the service method or operation.
     *           For API calls, this should be the name of the API method.
     *           For example,
     *               "google.cloud.bigquery.v2.TableService.InsertTable"
     *               "google.logging.v2.ConfigServiceV2.CreateSink"
     *     @type string $resource_name
     *           The resource or collection that is the target of the operation.
     *           The name is a scheme-less URI, not including the API service name.
     *           For example:
     *               "projects/PROJECT_ID/zones/us-central1-a/instances"
     *               "projects/PROJECT_ID/datasets/DATASET_ID"
     *     @type \Google\Cloud\Audit\ResourceLocation $resource_location
     *           The resource location information.
     *     @type \Google\Protobuf\Struct $resource_original_state
     *           The resource's original state before mutation. Present only for
     *           operations which have successfully modified the targeted resource(s).
     *           In general, this field should contain all changed fields, except those
     *           that are already been included in `request`, `response`, `metadata` or
     *           `service_data` fields.
     *           When the JSON object represented here has a proto equivalent,
     *           the proto name will be indicated in the `&#64;type` property.
     *     @type int|string $num_response_items
     *           The number of items returned from a List or Query API method,
     *           if applicable.
     *     @type \Google\Rpc\Status $status
     *           The status of the overall operation.
     *     @type \Google\Cloud\Audit\AuthenticationInfo $authentication_info
     *           Authentication information.
     *     @type array<\Google\Cloud\Audit\AuthorizationInfo>|\Google\Protobuf\Internal\RepeatedField $authorization_info
     *           Authorization information. If there are multiple
     *           resources or permissions involved, then there is
     *           one AuthorizationInfo element for each {resource, permission} tuple.
     *     @type \Google\Cloud\Audit\PolicyViolationInfo $policy_violation_info
     *           Indicates the policy violations for this request. If the request
     *           is denied by the policy, violation information will be logged
     *           here.
     *     @type \Google\Cloud\Audit\RequestMetadata $request_metadata
     *           Metadata about the operation.
     *     @type \Google\Protobuf\Struct $request
     *           The operation request. This may not include all request parameters,
     *           such as those that are too large, privacy-sensitive, or duplicated
     *           elsewhere in the log record.
     *           It should never include user-generated data, such as file contents.
     *           When the JSON object represented here has a proto equivalent, the proto
     *           name will be indicated in the `&#64;type` property.
     *     @type \Google\Protobuf\Struct $response
     *           The operation response. This may not include all response elements,
     *           such as those that are too large, privacy-sensitive, or duplicated
     *           elsewhere in the log record.
     *           It should never include user-generated data, such as file contents.
     *           When the JSON object represented here has a proto equivalent, the proto
     *           name will be indicated in the `&#64;type` property.
     *     @type \Google\Protobuf\Struct $metadata
     *           Other service-specific data about the request, response, and other
     *           information associated with the current audited event.
     *     @type \Google\Protobuf\Any $service_data
     *           Deprecated. Use the `metadata` field instead.
     *           Other service-specific data about the request, response, and other
     *           activities.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Audit\AuditLog::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the API service performing the operation. For example,
     * `"compute.googleapis.com"`.
     *
     * Generated from protobuf field <code>string service_name = 7;</code>
     * @return string
     */
    public function getServiceName()
    {
        return $this->service_name;
    }

    /**
     * The name of the API service performing the operation. For example,
     * `"compute.googleapis.com"`.
     *
     * Generated from protobuf field <code>string service_name = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_name = $var;

        return $this;
    }

    /**
     * The name of the service method or operation.
     * For API calls, this should be the name of the API method.
     * For example,
     *     "google.cloud.bigquery.v2.TableService.InsertTable"
     *     "google.logging.v2.ConfigServiceV2.CreateSink"
     *
     * Generated from protobuf field <code>string method_name = 8;</code>
     * @return string
     */
    public function getMethodName()
    {
        return $this->method_name;
    }

    /**
     * The name of the service method or operation.
     * For API calls, this should be the name of the API method.
     * For example,
     *     "google.cloud.bigquery.v2.TableService.InsertTable"
     *     "google.logging.v2.ConfigServiceV2.CreateSink"
     *
     * Generated from protobuf field <code>string method_name = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setMethodName($var)
    {
        GPBUtil::checkString($var, True);
        $this->method_name = $var;

        return $this;
    }

    /**
     * The resource or collection that is the target of the operation.
     * The name is a scheme-less URI, not including the API service name.
     * For example:
     *     "projects/PROJECT_ID/zones/us-central1-a/instances"
     *     "projects/PROJECT_ID/datasets/DATASET_ID"
     *
     * Generated from protobuf field <code>string resource_name = 11;</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * The resource or collection that is the target of the operation.
     * The name is a scheme-less URI, not including the API service name.
     * For example:
     *     "projects/PROJECT_ID/zones/us-central1-a/instances"
     *     "projects/PROJECT_ID/datasets/DATASET_ID"
     *
     * Generated from protobuf field <code>string resource_name = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * The resource location information.
     *
     * Generated from protobuf field <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     * @return \Google\Cloud\Audit\ResourceLocation|null
     */
    public function getResourceLocation()
    {
        return $this->resource_location;
    }

    public function hasResourceLocation()
    {
        return isset($this->resource_location);
    }

    public function clearResourceLocation()
    {
        unset($this->resource_location);
    }

    /**
     * The resource location information.
     *
     * Generated from protobuf field <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     * @param \Google\Cloud\Audit\ResourceLocation $var
     * @return $this
     */
    public function setResourceLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Audit\ResourceLocation::class);
        $this->resource_location = $var;

        return $this;
    }

    /**
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct resource_original_state = 19;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getResourceOriginalState()
    {
        return $this->resource_original_state;
    }

    public function hasResourceOriginalState()
    {
        return isset($this->resource_original_state);
    }

    public function clearResourceOriginalState()
    {
        unset($this->resource_original_state);
    }

    /**
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct resource_original_state = 19;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setResourceOriginalState($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->resource_original_state = $var;

        return $this;
    }

    /**
     * The number of items returned from a List or Query API method,
     * if applicable.
     *
     * Generated from protobuf field <code>int64 num_response_items = 12;</code>
     * @return int|string
     */
    public function getNumResponseItems()
    {
        return $this->num_response_items;
    }

    /**
     * The number of items returned from a List or Query API method,
     * if applicable.
     *
     * Generated from protobuf field <code>int64 num_response_items = 12;</code>
     * @param int|string $var
     * @return $this
     */
    public function setNumResponseItems($var)
    {
        GPBUtil::checkInt64($var);
        $this->num_response_items = $var;

        return $this;
    }

    /**
     * The status of the overall operation.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 2;</code>
     * @return \Google\Rpc\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }

    public function hasStatus()
    {
        return isset($this->status);
    }

    public function clearStatus()
    {
        unset($this->status);
    }

    /**
     * The status of the overall operation.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 2;</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * Authentication information.
     *
     * Generated from protobuf field <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     * @return \Google\Cloud\Audit\AuthenticationInfo|null
     */
    public function getAuthenticationInfo()
    {
        return $this->authentication_info;
    }

    public function hasAuthenticationInfo()
    {
        return isset($this->authentication_info);
    }

    public function clearAuthenticationInfo()
    {
        unset($this->authentication_info);
    }

    /**
     * Authentication information.
     *
     * Generated from protobuf field <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     * @param \Google\Cloud\Audit\AuthenticationInfo $var
     * @return $this
     */
    public function setAuthenticationInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Audit\AuthenticationInfo::class);
        $this->authentication_info = $var;

        return $this;
    }

    /**
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     *
     * Generated from protobuf field <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAuthorizationInfo()
    {
        return $this->authorization_info;
    }

    /**
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     *
     * Generated from protobuf field <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     * @param array<\Google\Cloud\Audit\AuthorizationInfo>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAuthorizationInfo($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Audit\AuthorizationInfo::class);
        $this->authorization_info = $arr;

        return $this;
    }

    /**
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     *
     * Generated from protobuf field <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     * @return \Google\Cloud\Audit\PolicyViolationInfo|null
     */
    public function getPolicyViolationInfo()
    {
        return $this->policy_violation_info;
    }

    public function hasPolicyViolationInfo()
    {
        return isset($this->policy_violation_info);
    }

    public function clearPolicyViolationInfo()
    {
        unset($this->policy_violation_info);
    }

    /**
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     *
     * Generated from protobuf field <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     * @param \Google\Cloud\Audit\PolicyViolationInfo $var
     * @return $this
     */
    public function setPolicyViolationInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Audit\PolicyViolationInfo::class);
        $this->policy_violation_info = $var;

        return $this;
    }

    /**
     * Metadata about the operation.
     *
     * Generated from protobuf field <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     * @return \Google\Cloud\Audit\RequestMetadata|null
     */
    public function getRequestMetadata()
    {
        return $this->request_metadata;
    }

    public function hasRequestMetadata()
    {
        return isset($this->request_metadata);
    }

    public function clearRequestMetadata()
    {
        unset($this->request_metadata);
    }

    /**
     * Metadata about the operation.
     *
     * Generated from protobuf field <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     * @param \Google\Cloud\Audit\RequestMetadata $var
     * @return $this
     */
    public function setRequestMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Audit\RequestMetadata::class);
        $this->request_metadata = $var;

        return $this;
    }

    /**
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct request = 16;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getRequest()
    {
        return $this->request;
    }

    public function hasRequest()
    {
        return isset($this->request);
    }

    public function clearRequest()
    {
        unset($this->request);
    }

    /**
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct request = 16;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->request = $var;

        return $this;
    }

    /**
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct response = 17;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getResponse()
    {
        return $this->response;
    }

    public function hasResponse()
    {
        return isset($this->response);
    }

    public function clearResponse()
    {
        unset($this->response);
    }

    /**
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct response = 17;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setResponse($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->response = $var;

        return $this;
    }

    /**
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct metadata = 18;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    public function hasMetadata()
    {
        return isset($this->metadata);
    }

    public function clearMetadata()
    {
        unset($this->metadata);
    }

    /**
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct metadata = 18;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->metadata = $var;

        return $this;
    }

    /**
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     *
     * Generated from protobuf field <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     * @return \Google\Protobuf\Any|null
     * @deprecated
     */
    public function getServiceData()
    {
        if (isset($this->service_data)) {
            @trigger_error('service_data is deprecated.', E_USER_DEPRECATED);
        }
        return $this->service_data;
    }

    public function hasServiceData()
    {
        if (isset($this->service_data)) {
            @trigger_error('service_data is deprecated.', E_USER_DEPRECATED);
        }
        return isset($this->service_data);
    }

    public function clearServiceData()
    {
        @trigger_error('service_data is deprecated.', E_USER_DEPRECATED);
        unset($this->service_data);
    }

    /**
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     *
     * Generated from protobuf field <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     * @param \Google\Protobuf\Any $var
     * @return $this
     * @deprecated
     */
    public function setServiceData($var)
    {
        @trigger_error('service_data is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\Any::class);
        $this->service_data = $var;

        return $this;
    }

}

