<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/chronicle/v1/reference_list.proto

namespace Google\Cloud\Chronicle\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request for a list of reference lists.
 *
 * Generated from protobuf message <code>google.cloud.chronicle.v1.ListReferenceListsRequest</code>
 */
class ListReferenceListsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent, which owns this collection of reference lists.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * The maximum number of reference lists to return.
     * The service may return fewer than this value.
     * If unspecified, at most 100 reference lists will be returned.
     * The maximum value is 1000; values above 1000 will be coerced to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     */
    protected $page_size = 0;
    /**
     * A page token, received from a previous `ListReferenceLists` call.
     * Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to `ListReferenceLists` must
     * match the call that provided the page token.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     */
    protected $page_token = '';
    /**
     * How much of each ReferenceList to view. Defaults to
     * REFERENCE_LIST_VIEW_BASIC.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ReferenceListView view = 4;</code>
     */
    protected $view = 0;

    /**
     * @param string $parent Required. The parent, which owns this collection of reference lists.
     *                       Format:
     *                       `projects/{project}/locations/{location}/instances/{instance}`
     *                       Please see {@see ReferenceListServiceClient::instanceName()} for help formatting this field.
     *
     * @return \Google\Cloud\Chronicle\V1\ListReferenceListsRequest
     *
     * @experimental
     */
    public static function build(string $parent): self
    {
        return (new self())
            ->setParent($parent);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent, which owns this collection of reference lists.
     *           Format:
     *           `projects/{project}/locations/{location}/instances/{instance}`
     *     @type int $page_size
     *           The maximum number of reference lists to return.
     *           The service may return fewer than this value.
     *           If unspecified, at most 100 reference lists will be returned.
     *           The maximum value is 1000; values above 1000 will be coerced to 1000.
     *     @type string $page_token
     *           A page token, received from a previous `ListReferenceLists` call.
     *           Provide this to retrieve the subsequent page.
     *           When paginating, all other parameters provided to `ListReferenceLists` must
     *           match the call that provided the page token.
     *     @type int $view
     *           How much of each ReferenceList to view. Defaults to
     *           REFERENCE_LIST_VIEW_BASIC.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Chronicle\V1\ReferenceList::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent, which owns this collection of reference lists.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent, which owns this collection of reference lists.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * The maximum number of reference lists to return.
     * The service may return fewer than this value.
     * If unspecified, at most 100 reference lists will be returned.
     * The maximum value is 1000; values above 1000 will be coerced to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * The maximum number of reference lists to return.
     * The service may return fewer than this value.
     * If unspecified, at most 100 reference lists will be returned.
     * The maximum value is 1000; values above 1000 will be coerced to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * A page token, received from a previous `ListReferenceLists` call.
     * Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to `ListReferenceLists` must
     * match the call that provided the page token.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * A page token, received from a previous `ListReferenceLists` call.
     * Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to `ListReferenceLists` must
     * match the call that provided the page token.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * How much of each ReferenceList to view. Defaults to
     * REFERENCE_LIST_VIEW_BASIC.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ReferenceListView view = 4;</code>
     * @return int
     */
    public function getView()
    {
        return $this->view;
    }

    /**
     * How much of each ReferenceList to view. Defaults to
     * REFERENCE_LIST_VIEW_BASIC.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ReferenceListView view = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setView($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Chronicle\V1\ReferenceListView::class);
        $this->view = $var;

        return $this;
    }

}

