<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/v2/bigtable.proto

namespace Google\Cloud\Bigtable\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for Bigtable.PrepareQuery
 *
 * Generated from protobuf message <code>google.bigtable.v2.PrepareQueryRequest</code>
 */
class PrepareQueryRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The unique name of the instance against which the query should be
     * executed.
     * Values are of the form `projects/<project>/instances/<instance>`
     *
     * Generated from protobuf field <code>string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $instance_name = '';
    /**
     * Optional. This value specifies routing for preparing the query. Note that
     * this `app_profile_id` is only used for preparing the query. The actual
     * query execution will use the app profile specified in the
     * `ExecuteQueryRequest`. If not specified, the `default` application profile
     * will be used.
     *
     * Generated from protobuf field <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $app_profile_id = '';
    /**
     * Required. The query string.
     *
     * Generated from protobuf field <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $query = '';
    /**
     * Required. `param_types` is a map of parameter identifier strings to their
     * `Type`s.
     * In query string, a parameter placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     * query parameter of type Bytes. The specific `Value` to be used for the
     * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     *
     * Generated from protobuf field <code>map<string, .google.bigtable.v2.Type> param_types = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $param_types;
    protected $data_format;

    /**
     * @param string $instanceName Required. The unique name of the instance against which the query should be
     *                             executed.
     *                             Values are of the form `projects/<project>/instances/<instance>`
     *                             Please see {@see BigtableClient::instanceName()} for help formatting this field.
     * @param string $query        Required. The query string.
     *
     * @return \Google\Cloud\Bigtable\V2\PrepareQueryRequest
     *
     * @experimental
     */
    public static function build(string $instanceName, string $query): self
    {
        return (new self())
            ->setInstanceName($instanceName)
            ->setQuery($query);
    }

    /**
     * @param string $instanceName Required. The unique name of the instance against which the query should be
     *                             executed.
     *                             Values are of the form `projects/<project>/instances/<instance>`
     *                             Please see {@see BigtableClient::instanceName()} for help formatting this field.
     * @param string $query        Required. The query string.
     * @param string $appProfileId Optional. This value specifies routing for preparing the query. Note that
     *                             this `app_profile_id` is only used for preparing the query. The actual
     *                             query execution will use the app profile specified in the
     *                             `ExecuteQueryRequest`. If not specified, the `default` application profile
     *                             will be used.
     *
     * @return \Google\Cloud\Bigtable\V2\PrepareQueryRequest
     *
     * @experimental
     */
    public static function buildFromInstanceNameQueryAppProfileId(string $instanceName, string $query, string $appProfileId): self
    {
        return (new self())
            ->setInstanceName($instanceName)
            ->setQuery($query)
            ->setAppProfileId($appProfileId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $instance_name
     *           Required. The unique name of the instance against which the query should be
     *           executed.
     *           Values are of the form `projects/<project>/instances/<instance>`
     *     @type string $app_profile_id
     *           Optional. This value specifies routing for preparing the query. Note that
     *           this `app_profile_id` is only used for preparing the query. The actual
     *           query execution will use the app profile specified in the
     *           `ExecuteQueryRequest`. If not specified, the `default` application profile
     *           will be used.
     *     @type string $query
     *           Required. The query string.
     *     @type \Google\Cloud\Bigtable\V2\ProtoFormat $proto_format
     *           Protocol buffer format as described by ProtoSchema and ProtoRows
     *           messages.
     *     @type array|\Google\Protobuf\Internal\MapField $param_types
     *           Required. `param_types` is a map of parameter identifier strings to their
     *           `Type`s.
     *           In query string, a parameter placeholder consists of the
     *           `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     *           the query string.
     *           For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     *           query parameter of type Bytes. The specific `Value` to be used for the
     *           query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\V2\Bigtable::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The unique name of the instance against which the query should be
     * executed.
     * Values are of the form `projects/<project>/instances/<instance>`
     *
     * Generated from protobuf field <code>string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getInstanceName()
    {
        return $this->instance_name;
    }

    /**
     * Required. The unique name of the instance against which the query should be
     * executed.
     * Values are of the form `projects/<project>/instances/<instance>`
     *
     * Generated from protobuf field <code>string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setInstanceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance_name = $var;

        return $this;
    }

    /**
     * Optional. This value specifies routing for preparing the query. Note that
     * this `app_profile_id` is only used for preparing the query. The actual
     * query execution will use the app profile specified in the
     * `ExecuteQueryRequest`. If not specified, the `default` application profile
     * will be used.
     *
     * Generated from protobuf field <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAppProfileId()
    {
        return $this->app_profile_id;
    }

    /**
     * Optional. This value specifies routing for preparing the query. Note that
     * this `app_profile_id` is only used for preparing the query. The actual
     * query execution will use the app profile specified in the
     * `ExecuteQueryRequest`. If not specified, the `default` application profile
     * will be used.
     *
     * Generated from protobuf field <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAppProfileId($var)
    {
        GPBUtil::checkString($var, True);
        $this->app_profile_id = $var;

        return $this;
    }

    /**
     * Required. The query string.
     *
     * Generated from protobuf field <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Required. The query string.
     *
     * Generated from protobuf field <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     * @return \Google\Cloud\Bigtable\V2\ProtoFormat|null
     */
    public function getProtoFormat()
    {
        return $this->readOneof(4);
    }

    public function hasProtoFormat()
    {
        return $this->hasOneof(4);
    }

    /**
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     * @param \Google\Cloud\Bigtable\V2\ProtoFormat $var
     * @return $this
     */
    public function setProtoFormat($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Bigtable\V2\ProtoFormat::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Required. `param_types` is a map of parameter identifier strings to their
     * `Type`s.
     * In query string, a parameter placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     * query parameter of type Bytes. The specific `Value` to be used for the
     * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     *
     * Generated from protobuf field <code>map<string, .google.bigtable.v2.Type> param_types = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getParamTypes()
    {
        return $this->param_types;
    }

    /**
     * Required. `param_types` is a map of parameter identifier strings to their
     * `Type`s.
     * In query string, a parameter placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     * For example, if param_types["firstName"] = Bytes then &#64;firstName will be a
     * query parameter of type Bytes. The specific `Value` to be used for the
     * query execution must be sent in `ExecuteQueryRequest` in the `params` map.
     *
     * Generated from protobuf field <code>map<string, .google.bigtable.v2.Type> param_types = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setParamTypes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Bigtable\V2\Type::class);
        $this->param_types = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getDataFormat()
    {
        return $this->whichOneof("data_format");
    }

}

