<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/space.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A space in Google Chat. Spaces are conversations between two or more users
 * or 1:1 messages between a user and a Chat app.
 *
 * Generated from protobuf message <code>google.chat.v1.Space</code>
 */
class Space extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. Resource name of the space.
     * Format: `spaces/{space}`
     * Where `{space}` represents the system-assigned ID for the space. You can
     * obtain the space ID by calling the
     * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
     * method or from the space URL. For example, if the space URL
     * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
     * is `AAAAAAAAA`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @deprecated
     */
    protected $type = 0;
    /**
     * Optional. The type of space. Required when creating a space or updating the
     * space type of a space. Output only for other usage.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $space_type = 0;
    /**
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     *
     * Generated from protobuf field <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $single_user_bot_dm = false;
    /**
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     *
     * Generated from protobuf field <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @deprecated
     */
    protected $threaded = false;
    /**
     * Optional. The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
     * with a `spaceType` of `SPACE`. If you receive the error message
     * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
     * different `displayName`. An existing space within the Google Workspace
     * organization might already use this display name.
     * For direct messages, this field might be empty.
     * Supports up to 128 characters.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_name = '';
    /**
     * Optional. Immutable. Whether this space permits any Google Chat user as a
     * member. Input when creating a space in a Google Workspace organization.
     * Omit this field when creating spaces in the following conditions:
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     * For existing spaces, this field is output only.
     *
     * Generated from protobuf field <code>bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $external_user_allowed = false;
    /**
     * Output only. The threading state in the Chat space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $space_threading_state = 0;
    /**
     * Optional. Details about the space including description and rules.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $space_details = null;
    /**
     * Optional. The message history state for messages and threads in this space.
     *
     * Generated from protobuf field <code>.google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $space_history_state = 0;
    /**
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     * Creating a space in `Import Mode`requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     *
     * Generated from protobuf field <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $import_mode = false;
    /**
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Timestamp of the last message in the space.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_active_time = null;
    /**
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     * To support admin install, your Chat app must feature direct messaging.
     *
     * Generated from protobuf field <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $admin_installed = false;
    /**
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $membership_count = null;
    /**
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $access_settings = null;
    /**
     * Optional. Immutable. The customer id of the domain of the space.
     * Required only when creating a space with [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and `SpaceType` is `SPACE`, otherwise should not be set.
     * In the format `customers/{customer}`, where `customer` is the `id` from the
     * [Admin SDK customer resource](
     * https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers).
     * Private apps can also use the `customers/my_customer` alias to create
     * the space in the same Google Workspace organization as the app.
     * For DMs, this field isn't populated.
     *
     * Generated from protobuf field <code>optional string customer = 24 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $customer = null;
    /**
     * Output only. The URI for a user to access the space.
     *
     * Generated from protobuf field <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $space_uri = '';
    /**
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     * This field is only populated for spaces that were created with import mode.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $import_mode_expire_time = null;
    protected $space_permission_settings;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. Resource name of the space.
     *           Format: `spaces/{space}`
     *           Where `{space}` represents the system-assigned ID for the space. You can
     *           obtain the space ID by calling the
     *           [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
     *           method or from the space URL. For example, if the space URL
     *           is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
     *           is `AAAAAAAAA`.
     *     @type int $type
     *           Output only. Deprecated: Use `space_type` instead.
     *           The type of a space.
     *     @type int $space_type
     *           Optional. The type of space. Required when creating a space or updating the
     *           space type of a space. Output only for other usage.
     *     @type bool $single_user_bot_dm
     *           Optional. Whether the space is a DM between a Chat app and a single
     *           human.
     *     @type bool $threaded
     *           Output only. Deprecated: Use `spaceThreadingState` instead.
     *           Whether messages are threaded in this space.
     *     @type string $display_name
     *           Optional. The space's display name. Required when [creating a
     *           space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
     *           with a `spaceType` of `SPACE`. If you receive the error message
     *           `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
     *           different `displayName`. An existing space within the Google Workspace
     *           organization might already use this display name.
     *           For direct messages, this field might be empty.
     *           Supports up to 128 characters.
     *     @type bool $external_user_allowed
     *           Optional. Immutable. Whether this space permits any Google Chat user as a
     *           member. Input when creating a space in a Google Workspace organization.
     *           Omit this field when creating spaces in the following conditions:
     *             * The authenticated user uses a consumer account (unmanaged user
     *               account). By default, a space created by a consumer account permits any
     *               Google Chat user.
     *           For existing spaces, this field is output only.
     *     @type int $space_threading_state
     *           Output only. The threading state in the Chat space.
     *     @type \Google\Apps\Chat\V1\Space\SpaceDetails $space_details
     *           Optional. Details about the space including description and rules.
     *     @type int $space_history_state
     *           Optional. The message history state for messages and threads in this space.
     *     @type bool $import_mode
     *           Optional. Whether this space is created in `Import Mode` as part of a data
     *           migration into Google Workspace. While spaces are being imported, they
     *           aren't visible to users until the import is complete.
     *           Creating a space in `Import Mode`requires [user
     *           authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Optional. Immutable. For spaces created in Chat, the time the space was
     *           created. This field is output only, except when used in import mode spaces.
     *           For import mode spaces, set this field to the historical timestamp at which
     *           the space was created in the source in order to preserve the original
     *           creation time.
     *           Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     *     @type \Google\Protobuf\Timestamp $last_active_time
     *           Output only. Timestamp of the last message in the space.
     *     @type bool $admin_installed
     *           Output only. For direct message (DM) spaces with a Chat app, whether the
     *           space was created by a Google Workspace administrator. Administrators can
     *           install and set up a direct message with a Chat app on behalf of users in
     *           their organization.
     *           To support admin install, your Chat app must feature direct messaging.
     *     @type \Google\Apps\Chat\V1\Space\MembershipCount $membership_count
     *           Output only. The count of joined memberships grouped by member type.
     *           Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     *           `GROUP_CHAT`.
     *     @type \Google\Apps\Chat\V1\Space\AccessSettings $access_settings
     *           Optional. Specifies the [access
     *           setting](https://support.google.com/chat/answer/11971020) of the space.
     *           Only populated when the `space_type` is `SPACE`.
     *     @type string $customer
     *           Optional. Immutable. The customer id of the domain of the space.
     *           Required only when creating a space with [app
     *           authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     *           and `SpaceType` is `SPACE`, otherwise should not be set.
     *           In the format `customers/{customer}`, where `customer` is the `id` from the
     *           [Admin SDK customer resource](
     *           https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers).
     *           Private apps can also use the `customers/my_customer` alias to create
     *           the space in the same Google Workspace organization as the app.
     *           For DMs, this field isn't populated.
     *     @type string $space_uri
     *           Output only. The URI for a user to access the space.
     *     @type int $predefined_permission_settings
     *           Optional. Input only. Predefined space permission settings, input only
     *           when creating a space. If the field is not set, a collaboration space is
     *           created. After you create the space, settings are populated in the
     *           `PermissionSettings` field.
     *           Setting predefined permission settings supports:
     *           - [App
     *           authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     *           with [administrator
     *           approval](https://support.google.com/a?p=chat-app-auth) with the
     *           `chat.app.spaces` or `chat.app.spaces.create` scopes.
     *           - [User
     *           authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     *     @type \Google\Apps\Chat\V1\Space\PermissionSettings $permission_settings
     *           Optional. Space permission settings for existing spaces. Input for
     *           updating exact space permission settings, where existing permission
     *           settings are replaced. Output lists current permission settings.
     *           Reading and updating permission settings supports:
     *           - [App
     *           authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     *           with [administrator
     *           approval](https://support.google.com/a?p=chat-app-auth) with the
     *           `chat.app.spaces` scope. Only populated and settable when the Chat app
     *           created the space.
     *           - [User
     *           authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     *     @type \Google\Protobuf\Timestamp $import_mode_expire_time
     *           Output only. The time when the space will be automatically deleted by the
     *           system if it remains in import mode.
     *           Each space created in import mode must exit this mode before this expire
     *           time using `spaces.completeImport`.
     *           This field is only populated for spaces that were created with import mode.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\Space::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. Resource name of the space.
     * Format: `spaces/{space}`
     * Where `{space}` represents the system-assigned ID for the space. You can
     * obtain the space ID by calling the
     * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
     * method or from the space URL. For example, if the space URL
     * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
     * is `AAAAAAAAA`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. Resource name of the space.
     * Format: `spaces/{space}`
     * Where `{space}` represents the system-assigned ID for the space. You can
     * obtain the space ID by calling the
     * [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
     * method or from the space URL. For example, if the space URL
     * is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
     * is `AAAAAAAAA`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     * @deprecated
     */
    public function getType()
    {
        if ($this->type !== 0) {
            @trigger_error('type is deprecated.', E_USER_DEPRECATED);
        }
        return $this->type;
    }

    /**
     * Output only. Deprecated: Use `space_type` instead.
     * The type of a space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.Type type = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     * @deprecated
     */
    public function setType($var)
    {
        @trigger_error('type is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\Space\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Optional. The type of space. Required when creating a space or updating the
     * space type of a space. Output only for other usage.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getSpaceType()
    {
        return $this->space_type;
    }

    /**
     * Optional. The type of space. Required when creating a space or updating the
     * space type of a space. Output only for other usage.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceType space_type = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setSpaceType($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\Space\SpaceType::class);
        $this->space_type = $var;

        return $this;
    }

    /**
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     *
     * Generated from protobuf field <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getSingleUserBotDm()
    {
        return $this->single_user_bot_dm;
    }

    /**
     * Optional. Whether the space is a DM between a Chat app and a single
     * human.
     *
     * Generated from protobuf field <code>bool single_user_bot_dm = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setSingleUserBotDm($var)
    {
        GPBUtil::checkBool($var);
        $this->single_user_bot_dm = $var;

        return $this;
    }

    /**
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     *
     * Generated from protobuf field <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     * @deprecated
     */
    public function getThreaded()
    {
        if ($this->threaded !== false) {
            @trigger_error('threaded is deprecated.', E_USER_DEPRECATED);
        }
        return $this->threaded;
    }

    /**
     * Output only. Deprecated: Use `spaceThreadingState` instead.
     * Whether messages are threaded in this space.
     *
     * Generated from protobuf field <code>bool threaded = 5 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setThreaded($var)
    {
        @trigger_error('threaded is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->threaded = $var;

        return $this;
    }

    /**
     * Optional. The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
     * with a `spaceType` of `SPACE`. If you receive the error message
     * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
     * different `displayName`. An existing space within the Google Workspace
     * organization might already use this display name.
     * For direct messages, this field might be empty.
     * Supports up to 128 characters.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Optional. The space's display name. Required when [creating a
     * space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
     * with a `spaceType` of `SPACE`. If you receive the error message
     * `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
     * different `displayName`. An existing space within the Google Workspace
     * organization might already use this display name.
     * For direct messages, this field might be empty.
     * Supports up to 128 characters.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. Immutable. Whether this space permits any Google Chat user as a
     * member. Input when creating a space in a Google Workspace organization.
     * Omit this field when creating spaces in the following conditions:
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     * For existing spaces, this field is output only.
     *
     * Generated from protobuf field <code>bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getExternalUserAllowed()
    {
        return $this->external_user_allowed;
    }

    /**
     * Optional. Immutable. Whether this space permits any Google Chat user as a
     * member. Input when creating a space in a Google Workspace organization.
     * Omit this field when creating spaces in the following conditions:
     *   * The authenticated user uses a consumer account (unmanaged user
     *     account). By default, a space created by a consumer account permits any
     *     Google Chat user.
     * For existing spaces, this field is output only.
     *
     * Generated from protobuf field <code>bool external_user_allowed = 8 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setExternalUserAllowed($var)
    {
        GPBUtil::checkBool($var);
        $this->external_user_allowed = $var;

        return $this;
    }

    /**
     * Output only. The threading state in the Chat space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getSpaceThreadingState()
    {
        return $this->space_threading_state;
    }

    /**
     * Output only. The threading state in the Chat space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceThreadingState space_threading_state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setSpaceThreadingState($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\Space\SpaceThreadingState::class);
        $this->space_threading_state = $var;

        return $this;
    }

    /**
     * Optional. Details about the space including description and rules.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Apps\Chat\V1\Space\SpaceDetails|null
     */
    public function getSpaceDetails()
    {
        return $this->space_details;
    }

    public function hasSpaceDetails()
    {
        return isset($this->space_details);
    }

    public function clearSpaceDetails()
    {
        unset($this->space_details);
    }

    /**
     * Optional. Details about the space including description and rules.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.SpaceDetails space_details = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Apps\Chat\V1\Space\SpaceDetails $var
     * @return $this
     */
    public function setSpaceDetails($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Space\SpaceDetails::class);
        $this->space_details = $var;

        return $this;
    }

    /**
     * Optional. The message history state for messages and threads in this space.
     *
     * Generated from protobuf field <code>.google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getSpaceHistoryState()
    {
        return $this->space_history_state;
    }

    /**
     * Optional. The message history state for messages and threads in this space.
     *
     * Generated from protobuf field <code>.google.chat.v1.HistoryState space_history_state = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setSpaceHistoryState($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\HistoryState::class);
        $this->space_history_state = $var;

        return $this;
    }

    /**
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     * Creating a space in `Import Mode`requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     *
     * Generated from protobuf field <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getImportMode()
    {
        return $this->import_mode;
    }

    /**
     * Optional. Whether this space is created in `Import Mode` as part of a data
     * migration into Google Workspace. While spaces are being imported, they
     * aren't visible to users until the import is complete.
     * Creating a space in `Import Mode`requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
     *
     * Generated from protobuf field <code>bool import_mode = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setImportMode($var)
    {
        GPBUtil::checkBool($var);
        $this->import_mode = $var;

        return $this;
    }

    /**
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Optional. Immutable. For spaces created in Chat, the time the space was
     * created. This field is output only, except when used in import mode spaces.
     * For import mode spaces, set this field to the historical timestamp at which
     * the space was created in the source in order to preserve the original
     * creation time.
     * Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 17 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp of the last message in the space.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastActiveTime()
    {
        return $this->last_active_time;
    }

    public function hasLastActiveTime()
    {
        return isset($this->last_active_time);
    }

    public function clearLastActiveTime()
    {
        unset($this->last_active_time);
    }

    /**
     * Output only. Timestamp of the last message in the space.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_active_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastActiveTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_active_time = $var;

        return $this;
    }

    /**
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     * To support admin install, your Chat app must feature direct messaging.
     *
     * Generated from protobuf field <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getAdminInstalled()
    {
        return $this->admin_installed;
    }

    /**
     * Output only. For direct message (DM) spaces with a Chat app, whether the
     * space was created by a Google Workspace administrator. Administrators can
     * install and set up a direct message with a Chat app on behalf of users in
     * their organization.
     * To support admin install, your Chat app must feature direct messaging.
     *
     * Generated from protobuf field <code>bool admin_installed = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setAdminInstalled($var)
    {
        GPBUtil::checkBool($var);
        $this->admin_installed = $var;

        return $this;
    }

    /**
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Apps\Chat\V1\Space\MembershipCount|null
     */
    public function getMembershipCount()
    {
        return $this->membership_count;
    }

    public function hasMembershipCount()
    {
        return isset($this->membership_count);
    }

    public function clearMembershipCount()
    {
        unset($this->membership_count);
    }

    /**
     * Output only. The count of joined memberships grouped by member type.
     * Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
     * `GROUP_CHAT`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.MembershipCount membership_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Apps\Chat\V1\Space\MembershipCount $var
     * @return $this
     */
    public function setMembershipCount($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Space\MembershipCount::class);
        $this->membership_count = $var;

        return $this;
    }

    /**
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Apps\Chat\V1\Space\AccessSettings|null
     */
    public function getAccessSettings()
    {
        return $this->access_settings;
    }

    public function hasAccessSettings()
    {
        return isset($this->access_settings);
    }

    public function clearAccessSettings()
    {
        unset($this->access_settings);
    }

    /**
     * Optional. Specifies the [access
     * setting](https://support.google.com/chat/answer/11971020) of the space.
     * Only populated when the `space_type` is `SPACE`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.AccessSettings access_settings = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Apps\Chat\V1\Space\AccessSettings $var
     * @return $this
     */
    public function setAccessSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Space\AccessSettings::class);
        $this->access_settings = $var;

        return $this;
    }

    /**
     * Optional. Immutable. The customer id of the domain of the space.
     * Required only when creating a space with [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and `SpaceType` is `SPACE`, otherwise should not be set.
     * In the format `customers/{customer}`, where `customer` is the `id` from the
     * [Admin SDK customer resource](
     * https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers).
     * Private apps can also use the `customers/my_customer` alias to create
     * the space in the same Google Workspace organization as the app.
     * For DMs, this field isn't populated.
     *
     * Generated from protobuf field <code>optional string customer = 24 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getCustomer()
    {
        return isset($this->customer) ? $this->customer : '';
    }

    public function hasCustomer()
    {
        return isset($this->customer);
    }

    public function clearCustomer()
    {
        unset($this->customer);
    }

    /**
     * Optional. Immutable. The customer id of the domain of the space.
     * Required only when creating a space with [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * and `SpaceType` is `SPACE`, otherwise should not be set.
     * In the format `customers/{customer}`, where `customer` is the `id` from the
     * [Admin SDK customer resource](
     * https://developers.google.com/admin-sdk/directory/reference/rest/v1/customers).
     * Private apps can also use the `customers/my_customer` alias to create
     * the space in the same Google Workspace organization as the app.
     * For DMs, this field isn't populated.
     *
     * Generated from protobuf field <code>optional string customer = 24 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setCustomer($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer = $var;

        return $this;
    }

    /**
     * Output only. The URI for a user to access the space.
     *
     * Generated from protobuf field <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSpaceUri()
    {
        return $this->space_uri;
    }

    /**
     * Output only. The URI for a user to access the space.
     *
     * Generated from protobuf field <code>string space_uri = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSpaceUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->space_uri = $var;

        return $this;
    }

    /**
     * Optional. Input only. Predefined space permission settings, input only
     * when creating a space. If the field is not set, a collaboration space is
     * created. After you create the space, settings are populated in the
     * `PermissionSettings` field.
     * Setting predefined permission settings supports:
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator
     * approval](https://support.google.com/a?p=chat-app-auth) with the
     * `chat.app.spaces` or `chat.app.spaces.create` scopes.
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPredefinedPermissionSettings()
    {
        return $this->readOneof(26);
    }

    public function hasPredefinedPermissionSettings()
    {
        return $this->hasOneof(26);
    }

    /**
     * Optional. Input only. Predefined space permission settings, input only
     * when creating a space. If the field is not set, a collaboration space is
     * created. After you create the space, settings are populated in the
     * `PermissionSettings` field.
     * Setting predefined permission settings supports:
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator
     * approval](https://support.google.com/a?p=chat-app-auth) with the
     * `chat.app.spaces` or `chat.app.spaces.create` scopes.
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.PredefinedPermissionSettings predefined_permission_settings = 26 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPredefinedPermissionSettings($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\Space\PredefinedPermissionSettings::class);
        $this->writeOneof(26, $var);

        return $this;
    }

    /**
     * Optional. Space permission settings for existing spaces. Input for
     * updating exact space permission settings, where existing permission
     * settings are replaced. Output lists current permission settings.
     * Reading and updating permission settings supports:
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator
     * approval](https://support.google.com/a?p=chat-app-auth) with the
     * `chat.app.spaces` scope. Only populated and settable when the Chat app
     * created the space.
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Apps\Chat\V1\Space\PermissionSettings|null
     */
    public function getPermissionSettings()
    {
        return $this->readOneof(27);
    }

    public function hasPermissionSettings()
    {
        return $this->hasOneof(27);
    }

    /**
     * Optional. Space permission settings for existing spaces. Input for
     * updating exact space permission settings, where existing permission
     * settings are replaced. Output lists current permission settings.
     * Reading and updating permission settings supports:
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator
     * approval](https://support.google.com/a?p=chat-app-auth) with the
     * `chat.app.spaces` scope. Only populated and settable when the Chat app
     * created the space.
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     *
     * Generated from protobuf field <code>.google.chat.v1.Space.PermissionSettings permission_settings = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Apps\Chat\V1\Space\PermissionSettings $var
     * @return $this
     */
    public function setPermissionSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Space\PermissionSettings::class);
        $this->writeOneof(27, $var);

        return $this;
    }

    /**
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     * This field is only populated for spaces that were created with import mode.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getImportModeExpireTime()
    {
        return $this->import_mode_expire_time;
    }

    public function hasImportModeExpireTime()
    {
        return isset($this->import_mode_expire_time);
    }

    public function clearImportModeExpireTime()
    {
        unset($this->import_mode_expire_time);
    }

    /**
     * Output only. The time when the space will be automatically deleted by the
     * system if it remains in import mode.
     * Each space created in import mode must exit this mode before this expire
     * time using `spaces.completeImport`.
     * This field is only populated for spaces that were created with import mode.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp import_mode_expire_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setImportModeExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->import_mode_expire_time = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSpacePermissionSettings()
    {
        return $this->whichOneof("space_permission_settings");
    }

}

