<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/space.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request to search for a list of spaces based on a query.
 *
 * Generated from protobuf message <code>google.chat.v1.SearchSpacesRequest</code>
 */
class SearchSpacesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     * Requires either the `chat.admin.spaces.readonly` or `chat.admin.spaces`
     * [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     * This method currently only supports admin access, thus only `true` is
     * accepted for this field.
     *
     * Generated from protobuf field <code>bool use_admin_access = 1;</code>
     */
    protected $use_admin_access = false;
    /**
     * The maximum number of spaces to return. The service may return fewer than
     * this value.
     * If unspecified, at most 100 spaces are returned.
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     */
    protected $page_size = 0;
    /**
     * A token, received from the previous search spaces call. Provide this
     * parameter to retrieve the subsequent page.
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     */
    protected $page_token = '';
    /**
     * Required. A search query.
     * You can search by using the following parameters:
     * - `create_time`
     * - `customer`
     * - `display_name`
     * - `external_user_allowed`
     * - `last_active_time`
     * - `space_history_state`
     * - `space_type`
     * `create_time` and `last_active_time` accept a timestamp in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
     * comparison operators are: `=`, `<`, `>`, `<=`, `>=`.
     * `customer` is required and is used to indicate which customer
     * to fetch spaces from. `customers/my_customer` is the only supported value.
     * `display_name` only accepts the `HAS` (`:`) operator. The text to
     * match is first tokenized into tokens and each token is prefix-matched
     * case-insensitively and independently as a substring anywhere in the space's
     * `display_name`. For example, `Fun Eve` matches `Fun event` or `The
     * evening was fun`, but not `notFun event` or `even`.
     * `external_user_allowed` accepts either `true` or `false`.
     * `space_history_state` only accepts values from the [`historyState`]
     * (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
     * field of a `space` resource.
     * `space_type` is required and the only valid value is `SPACE`.
     * Across different fields, only `AND` operators are supported. A valid
     * example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
     * example is `space_type = "SPACE" OR display_name:"Hello"`.
     * Among the same field,
     * `space_type` doesn't support `AND` or `OR` operators.
     * `display_name`, 'space_history_state', and 'external_user_allowed' only
     * support `OR` operators.
     * `last_active_time` and `create_time` support both `AND` and `OR` operators.
     * `AND` can only be used to represent an interval, such as `last_active_time
     * < "2022-01-01T00:00:00+00:00" AND last_active_time >
     * "2023-01-01T00:00:00+00:00"`.
     * The following example queries are valid:
     * ```
     * customer = "customers/my_customer" AND space_type = "SPACE"
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * display_name:"Hello World"
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (last_active_time < "2020-01-01T00:00:00+00:00" OR last_active_time >
     * "2022-01-01T00:00:00+00:00")
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (display_name:"Hello World" OR display_name:"Fun event") AND
     * (last_active_time > "2020-01-01T00:00:00+00:00" AND last_active_time <
     * "2022-01-01T00:00:00+00:00")
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (create_time > "2019-01-01T00:00:00+00:00" AND create_time <
     * "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
     * (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
     * ```
     *
     * Generated from protobuf field <code>string query = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $query = '';
    /**
     * Optional. How the list of spaces is ordered.
     * Supported attributes to order by are:
     * - `membership_count.joined_direct_human_user_count` — Denotes the count of
     * human users that have directly joined a space.
     * - `last_active_time` — Denotes the time when last eligible item is added to
     * any topic of this space.
     * - `create_time` — Denotes the time of the space creation.
     * Valid ordering operation values are:
     * - `ASC` for ascending. Default value.
     * - `DESC` for descending.
     * The supported syntax are:
     * - `membership_count.joined_direct_human_user_count DESC`
     * - `membership_count.joined_direct_human_user_count ASC`
     * - `last_active_time DESC`
     * - `last_active_time ASC`
     * - `create_time DESC`
     * - `create_time ASC`
     *
     * Generated from protobuf field <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $order_by = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $use_admin_access
     *           When `true`, the method runs using the user's Google Workspace
     *           administrator privileges.
     *           The calling user must be a Google Workspace administrator with the
     *           [manage chat and spaces conversations
     *           privilege](https://support.google.com/a/answer/13369245).
     *           Requires either the `chat.admin.spaces.readonly` or `chat.admin.spaces`
     *           [OAuth 2.0
     *           scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     *           This method currently only supports admin access, thus only `true` is
     *           accepted for this field.
     *     @type int $page_size
     *           The maximum number of spaces to return. The service may return fewer than
     *           this value.
     *           If unspecified, at most 100 spaces are returned.
     *           The maximum value is 1000. If you use a value more than 1000, it's
     *           automatically changed to 1000.
     *     @type string $page_token
     *           A token, received from the previous search spaces call. Provide this
     *           parameter to retrieve the subsequent page.
     *           When paginating, all other parameters provided should match the call that
     *           provided the page token. Passing different values to the other parameters
     *           might lead to unexpected results.
     *     @type string $query
     *           Required. A search query.
     *           You can search by using the following parameters:
     *           - `create_time`
     *           - `customer`
     *           - `display_name`
     *           - `external_user_allowed`
     *           - `last_active_time`
     *           - `space_history_state`
     *           - `space_type`
     *           `create_time` and `last_active_time` accept a timestamp in
     *           [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
     *           comparison operators are: `=`, `<`, `>`, `<=`, `>=`.
     *           `customer` is required and is used to indicate which customer
     *           to fetch spaces from. `customers/my_customer` is the only supported value.
     *           `display_name` only accepts the `HAS` (`:`) operator. The text to
     *           match is first tokenized into tokens and each token is prefix-matched
     *           case-insensitively and independently as a substring anywhere in the space's
     *           `display_name`. For example, `Fun Eve` matches `Fun event` or `The
     *           evening was fun`, but not `notFun event` or `even`.
     *           `external_user_allowed` accepts either `true` or `false`.
     *           `space_history_state` only accepts values from the [`historyState`]
     *           (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
     *           field of a `space` resource.
     *           `space_type` is required and the only valid value is `SPACE`.
     *           Across different fields, only `AND` operators are supported. A valid
     *           example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
     *           example is `space_type = "SPACE" OR display_name:"Hello"`.
     *           Among the same field,
     *           `space_type` doesn't support `AND` or `OR` operators.
     *           `display_name`, 'space_history_state', and 'external_user_allowed' only
     *           support `OR` operators.
     *           `last_active_time` and `create_time` support both `AND` and `OR` operators.
     *           `AND` can only be used to represent an interval, such as `last_active_time
     *           < "2022-01-01T00:00:00+00:00" AND last_active_time >
     *           "2023-01-01T00:00:00+00:00"`.
     *           The following example queries are valid:
     *           ```
     *           customer = "customers/my_customer" AND space_type = "SPACE"
     *           customer = "customers/my_customer" AND space_type = "SPACE" AND
     *           display_name:"Hello World"
     *           customer = "customers/my_customer" AND space_type = "SPACE" AND
     *           (last_active_time < "2020-01-01T00:00:00+00:00" OR last_active_time >
     *           "2022-01-01T00:00:00+00:00")
     *           customer = "customers/my_customer" AND space_type = "SPACE" AND
     *           (display_name:"Hello World" OR display_name:"Fun event") AND
     *           (last_active_time > "2020-01-01T00:00:00+00:00" AND last_active_time <
     *           "2022-01-01T00:00:00+00:00")
     *           customer = "customers/my_customer" AND space_type = "SPACE" AND
     *           (create_time > "2019-01-01T00:00:00+00:00" AND create_time <
     *           "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
     *           (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
     *           ```
     *     @type string $order_by
     *           Optional. How the list of spaces is ordered.
     *           Supported attributes to order by are:
     *           - `membership_count.joined_direct_human_user_count` — Denotes the count of
     *           human users that have directly joined a space.
     *           - `last_active_time` — Denotes the time when last eligible item is added to
     *           any topic of this space.
     *           - `create_time` — Denotes the time of the space creation.
     *           Valid ordering operation values are:
     *           - `ASC` for ascending. Default value.
     *           - `DESC` for descending.
     *           The supported syntax are:
     *           - `membership_count.joined_direct_human_user_count DESC`
     *           - `membership_count.joined_direct_human_user_count ASC`
     *           - `last_active_time DESC`
     *           - `last_active_time ASC`
     *           - `create_time DESC`
     *           - `create_time ASC`
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\Space::initOnce();
        parent::__construct($data);
    }

    /**
     * When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     * Requires either the `chat.admin.spaces.readonly` or `chat.admin.spaces`
     * [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     * This method currently only supports admin access, thus only `true` is
     * accepted for this field.
     *
     * Generated from protobuf field <code>bool use_admin_access = 1;</code>
     * @return bool
     */
    public function getUseAdminAccess()
    {
        return $this->use_admin_access;
    }

    /**
     * When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     * Requires either the `chat.admin.spaces.readonly` or `chat.admin.spaces`
     * [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     * This method currently only supports admin access, thus only `true` is
     * accepted for this field.
     *
     * Generated from protobuf field <code>bool use_admin_access = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseAdminAccess($var)
    {
        GPBUtil::checkBool($var);
        $this->use_admin_access = $var;

        return $this;
    }

    /**
     * The maximum number of spaces to return. The service may return fewer than
     * this value.
     * If unspecified, at most 100 spaces are returned.
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * The maximum number of spaces to return. The service may return fewer than
     * this value.
     * If unspecified, at most 100 spaces are returned.
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * A token, received from the previous search spaces call. Provide this
     * parameter to retrieve the subsequent page.
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * A token, received from the previous search spaces call. Provide this
     * parameter to retrieve the subsequent page.
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Required. A search query.
     * You can search by using the following parameters:
     * - `create_time`
     * - `customer`
     * - `display_name`
     * - `external_user_allowed`
     * - `last_active_time`
     * - `space_history_state`
     * - `space_type`
     * `create_time` and `last_active_time` accept a timestamp in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
     * comparison operators are: `=`, `<`, `>`, `<=`, `>=`.
     * `customer` is required and is used to indicate which customer
     * to fetch spaces from. `customers/my_customer` is the only supported value.
     * `display_name` only accepts the `HAS` (`:`) operator. The text to
     * match is first tokenized into tokens and each token is prefix-matched
     * case-insensitively and independently as a substring anywhere in the space's
     * `display_name`. For example, `Fun Eve` matches `Fun event` or `The
     * evening was fun`, but not `notFun event` or `even`.
     * `external_user_allowed` accepts either `true` or `false`.
     * `space_history_state` only accepts values from the [`historyState`]
     * (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
     * field of a `space` resource.
     * `space_type` is required and the only valid value is `SPACE`.
     * Across different fields, only `AND` operators are supported. A valid
     * example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
     * example is `space_type = "SPACE" OR display_name:"Hello"`.
     * Among the same field,
     * `space_type` doesn't support `AND` or `OR` operators.
     * `display_name`, 'space_history_state', and 'external_user_allowed' only
     * support `OR` operators.
     * `last_active_time` and `create_time` support both `AND` and `OR` operators.
     * `AND` can only be used to represent an interval, such as `last_active_time
     * < "2022-01-01T00:00:00+00:00" AND last_active_time >
     * "2023-01-01T00:00:00+00:00"`.
     * The following example queries are valid:
     * ```
     * customer = "customers/my_customer" AND space_type = "SPACE"
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * display_name:"Hello World"
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (last_active_time < "2020-01-01T00:00:00+00:00" OR last_active_time >
     * "2022-01-01T00:00:00+00:00")
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (display_name:"Hello World" OR display_name:"Fun event") AND
     * (last_active_time > "2020-01-01T00:00:00+00:00" AND last_active_time <
     * "2022-01-01T00:00:00+00:00")
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (create_time > "2019-01-01T00:00:00+00:00" AND create_time <
     * "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
     * (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
     * ```
     *
     * Generated from protobuf field <code>string query = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Required. A search query.
     * You can search by using the following parameters:
     * - `create_time`
     * - `customer`
     * - `display_name`
     * - `external_user_allowed`
     * - `last_active_time`
     * - `space_history_state`
     * - `space_type`
     * `create_time` and `last_active_time` accept a timestamp in
     * [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
     * comparison operators are: `=`, `<`, `>`, `<=`, `>=`.
     * `customer` is required and is used to indicate which customer
     * to fetch spaces from. `customers/my_customer` is the only supported value.
     * `display_name` only accepts the `HAS` (`:`) operator. The text to
     * match is first tokenized into tokens and each token is prefix-matched
     * case-insensitively and independently as a substring anywhere in the space's
     * `display_name`. For example, `Fun Eve` matches `Fun event` or `The
     * evening was fun`, but not `notFun event` or `even`.
     * `external_user_allowed` accepts either `true` or `false`.
     * `space_history_state` only accepts values from the [`historyState`]
     * (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
     * field of a `space` resource.
     * `space_type` is required and the only valid value is `SPACE`.
     * Across different fields, only `AND` operators are supported. A valid
     * example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
     * example is `space_type = "SPACE" OR display_name:"Hello"`.
     * Among the same field,
     * `space_type` doesn't support `AND` or `OR` operators.
     * `display_name`, 'space_history_state', and 'external_user_allowed' only
     * support `OR` operators.
     * `last_active_time` and `create_time` support both `AND` and `OR` operators.
     * `AND` can only be used to represent an interval, such as `last_active_time
     * < "2022-01-01T00:00:00+00:00" AND last_active_time >
     * "2023-01-01T00:00:00+00:00"`.
     * The following example queries are valid:
     * ```
     * customer = "customers/my_customer" AND space_type = "SPACE"
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * display_name:"Hello World"
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (last_active_time < "2020-01-01T00:00:00+00:00" OR last_active_time >
     * "2022-01-01T00:00:00+00:00")
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (display_name:"Hello World" OR display_name:"Fun event") AND
     * (last_active_time > "2020-01-01T00:00:00+00:00" AND last_active_time <
     * "2022-01-01T00:00:00+00:00")
     * customer = "customers/my_customer" AND space_type = "SPACE" AND
     * (create_time > "2019-01-01T00:00:00+00:00" AND create_time <
     * "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
     * (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
     * ```
     *
     * Generated from protobuf field <code>string query = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * Optional. How the list of spaces is ordered.
     * Supported attributes to order by are:
     * - `membership_count.joined_direct_human_user_count` — Denotes the count of
     * human users that have directly joined a space.
     * - `last_active_time` — Denotes the time when last eligible item is added to
     * any topic of this space.
     * - `create_time` — Denotes the time of the space creation.
     * Valid ordering operation values are:
     * - `ASC` for ascending. Default value.
     * - `DESC` for descending.
     * The supported syntax are:
     * - `membership_count.joined_direct_human_user_count DESC`
     * - `membership_count.joined_direct_human_user_count ASC`
     * - `last_active_time DESC`
     * - `last_active_time ASC`
     * - `create_time DESC`
     * - `create_time ASC`
     *
     * Generated from protobuf field <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }

    /**
     * Optional. How the list of spaces is ordered.
     * Supported attributes to order by are:
     * - `membership_count.joined_direct_human_user_count` — Denotes the count of
     * human users that have directly joined a space.
     * - `last_active_time` — Denotes the time when last eligible item is added to
     * any topic of this space.
     * - `create_time` — Denotes the time of the space creation.
     * Valid ordering operation values are:
     * - `ASC` for ascending. Default value.
     * - `DESC` for descending.
     * The supported syntax are:
     * - `membership_count.joined_direct_human_user_count DESC`
     * - `membership_count.joined_direct_human_user_count ASC`
     * - `last_active_time DESC`
     * - `last_active_time ASC`
     * - `create_time DESC`
     * - `create_time ASC`
     *
     * Generated from protobuf field <code>string order_by = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setOrderBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->order_by = $var;

        return $this;
    }

}

