<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/chat/v1/chat_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Apps\Chat\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Apps\Chat\V1\Attachment;
use Google\Apps\Chat\V1\CompleteImportSpaceRequest;
use Google\Apps\Chat\V1\CompleteImportSpaceResponse;
use Google\Apps\Chat\V1\CreateCustomEmojiRequest;
use Google\Apps\Chat\V1\CreateMembershipRequest;
use Google\Apps\Chat\V1\CreateMessageRequest;
use Google\Apps\Chat\V1\CreateReactionRequest;
use Google\Apps\Chat\V1\CreateSpaceRequest;
use Google\Apps\Chat\V1\CustomEmoji;
use Google\Apps\Chat\V1\DeleteCustomEmojiRequest;
use Google\Apps\Chat\V1\DeleteMembershipRequest;
use Google\Apps\Chat\V1\DeleteMessageRequest;
use Google\Apps\Chat\V1\DeleteReactionRequest;
use Google\Apps\Chat\V1\DeleteSpaceRequest;
use Google\Apps\Chat\V1\FindDirectMessageRequest;
use Google\Apps\Chat\V1\GetAttachmentRequest;
use Google\Apps\Chat\V1\GetCustomEmojiRequest;
use Google\Apps\Chat\V1\GetMembershipRequest;
use Google\Apps\Chat\V1\GetMessageRequest;
use Google\Apps\Chat\V1\GetSpaceEventRequest;
use Google\Apps\Chat\V1\GetSpaceNotificationSettingRequest;
use Google\Apps\Chat\V1\GetSpaceReadStateRequest;
use Google\Apps\Chat\V1\GetSpaceRequest;
use Google\Apps\Chat\V1\GetThreadReadStateRequest;
use Google\Apps\Chat\V1\ListCustomEmojisRequest;
use Google\Apps\Chat\V1\ListMembershipsRequest;
use Google\Apps\Chat\V1\ListMessagesRequest;
use Google\Apps\Chat\V1\ListReactionsRequest;
use Google\Apps\Chat\V1\ListSpaceEventsRequest;
use Google\Apps\Chat\V1\ListSpacesRequest;
use Google\Apps\Chat\V1\Membership;
use Google\Apps\Chat\V1\Message;
use Google\Apps\Chat\V1\Reaction;
use Google\Apps\Chat\V1\SearchSpacesRequest;
use Google\Apps\Chat\V1\SetUpSpaceRequest;
use Google\Apps\Chat\V1\Space;
use Google\Apps\Chat\V1\SpaceEvent;
use Google\Apps\Chat\V1\SpaceNotificationSetting;
use Google\Apps\Chat\V1\SpaceReadState;
use Google\Apps\Chat\V1\ThreadReadState;
use Google\Apps\Chat\V1\UpdateMembershipRequest;
use Google\Apps\Chat\V1\UpdateMessageRequest;
use Google\Apps\Chat\V1\UpdateSpaceNotificationSettingRequest;
use Google\Apps\Chat\V1\UpdateSpaceReadStateRequest;
use Google\Apps\Chat\V1\UpdateSpaceRequest;
use Google\Apps\Chat\V1\UploadAttachmentRequest;
use Google\Apps\Chat\V1\UploadAttachmentResponse;
use Google\Auth\FetchAuthTokenInterface;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Enables developers to build Chat apps and
 * integrations on Google Chat Platform.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<CompleteImportSpaceResponse> completeImportSpaceAsync(CompleteImportSpaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomEmoji> createCustomEmojiAsync(CreateCustomEmojiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Membership> createMembershipAsync(CreateMembershipRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Message> createMessageAsync(CreateMessageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Reaction> createReactionAsync(CreateReactionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Space> createSpaceAsync(CreateSpaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteCustomEmojiAsync(DeleteCustomEmojiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Membership> deleteMembershipAsync(DeleteMembershipRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteMessageAsync(DeleteMessageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteReactionAsync(DeleteReactionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteSpaceAsync(DeleteSpaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Space> findDirectMessageAsync(FindDirectMessageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Attachment> getAttachmentAsync(GetAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CustomEmoji> getCustomEmojiAsync(GetCustomEmojiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Membership> getMembershipAsync(GetMembershipRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Message> getMessageAsync(GetMessageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Space> getSpaceAsync(GetSpaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SpaceEvent> getSpaceEventAsync(GetSpaceEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SpaceNotificationSetting> getSpaceNotificationSettingAsync(GetSpaceNotificationSettingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SpaceReadState> getSpaceReadStateAsync(GetSpaceReadStateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ThreadReadState> getThreadReadStateAsync(GetThreadReadStateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCustomEmojisAsync(ListCustomEmojisRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMembershipsAsync(ListMembershipsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMessagesAsync(ListMessagesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listReactionsAsync(ListReactionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSpaceEventsAsync(ListSpaceEventsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSpacesAsync(ListSpacesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchSpacesAsync(SearchSpacesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Space> setUpSpaceAsync(SetUpSpaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Membership> updateMembershipAsync(UpdateMembershipRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Message> updateMessageAsync(UpdateMessageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Space> updateSpaceAsync(UpdateSpaceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SpaceNotificationSetting> updateSpaceNotificationSettingAsync(UpdateSpaceNotificationSettingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SpaceReadState> updateSpaceReadStateAsync(UpdateSpaceReadStateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<UploadAttachmentResponse> uploadAttachmentAsync(UploadAttachmentRequest $request, array $optionalArgs = [])
 */
final class ChatServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.chat.v1.ChatService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'chat.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'chat.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/chat.admin.delete',
        'https://www.googleapis.com/auth/chat.admin.memberships',
        'https://www.googleapis.com/auth/chat.admin.memberships.readonly',
        'https://www.googleapis.com/auth/chat.admin.spaces',
        'https://www.googleapis.com/auth/chat.admin.spaces.readonly',
        'https://www.googleapis.com/auth/chat.app.delete',
        'https://www.googleapis.com/auth/chat.app.memberships',
        'https://www.googleapis.com/auth/chat.app.spaces',
        'https://www.googleapis.com/auth/chat.app.spaces.create',
        'https://www.googleapis.com/auth/chat.bot',
        'https://www.googleapis.com/auth/chat.customemojis',
        'https://www.googleapis.com/auth/chat.customemojis.readonly',
        'https://www.googleapis.com/auth/chat.delete',
        'https://www.googleapis.com/auth/chat.import',
        'https://www.googleapis.com/auth/chat.memberships',
        'https://www.googleapis.com/auth/chat.memberships.app',
        'https://www.googleapis.com/auth/chat.memberships.readonly',
        'https://www.googleapis.com/auth/chat.messages',
        'https://www.googleapis.com/auth/chat.messages.create',
        'https://www.googleapis.com/auth/chat.messages.reactions',
        'https://www.googleapis.com/auth/chat.messages.reactions.create',
        'https://www.googleapis.com/auth/chat.messages.reactions.readonly',
        'https://www.googleapis.com/auth/chat.messages.readonly',
        'https://www.googleapis.com/auth/chat.spaces',
        'https://www.googleapis.com/auth/chat.spaces.create',
        'https://www.googleapis.com/auth/chat.spaces.readonly',
        'https://www.googleapis.com/auth/chat.users.readstate',
        'https://www.googleapis.com/auth/chat.users.readstate.readonly',
        'https://www.googleapis.com/auth/chat.users.spacesettings',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/chat_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/chat_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/chat_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/chat_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a attachment
     * resource.
     *
     * @param string $space
     * @param string $message
     * @param string $attachment
     *
     * @return string The formatted attachment resource.
     */
    public static function attachmentName(string $space, string $message, string $attachment): string
    {
        return self::getPathTemplate('attachment')->render([
            'space' => $space,
            'message' => $message,
            'attachment' => $attachment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a custom_emoji
     * resource.
     *
     * @param string $customEmoji
     *
     * @return string The formatted custom_emoji resource.
     */
    public static function customEmojiName(string $customEmoji): string
    {
        return self::getPathTemplate('customEmoji')->render([
            'custom_emoji' => $customEmoji,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a membership
     * resource.
     *
     * @param string $space
     * @param string $member
     *
     * @return string The formatted membership resource.
     */
    public static function membershipName(string $space, string $member): string
    {
        return self::getPathTemplate('membership')->render([
            'space' => $space,
            'member' => $member,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a message
     * resource.
     *
     * @param string $space
     * @param string $message
     *
     * @return string The formatted message resource.
     */
    public static function messageName(string $space, string $message): string
    {
        return self::getPathTemplate('message')->render([
            'space' => $space,
            'message' => $message,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * quoted_message_metadata resource.
     *
     * @param string $space
     * @param string $message
     * @param string $quotedMessageMetadata
     *
     * @return string The formatted quoted_message_metadata resource.
     */
    public static function quotedMessageMetadataName(
        string $space,
        string $message,
        string $quotedMessageMetadata
    ): string {
        return self::getPathTemplate('quotedMessageMetadata')->render([
            'space' => $space,
            'message' => $message,
            'quoted_message_metadata' => $quotedMessageMetadata,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a reaction
     * resource.
     *
     * @param string $space
     * @param string $message
     * @param string $reaction
     *
     * @return string The formatted reaction resource.
     */
    public static function reactionName(string $space, string $message, string $reaction): string
    {
        return self::getPathTemplate('reaction')->render([
            'space' => $space,
            'message' => $message,
            'reaction' => $reaction,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a space
     * resource.
     *
     * @param string $space
     *
     * @return string The formatted space resource.
     */
    public static function spaceName(string $space): string
    {
        return self::getPathTemplate('space')->render([
            'space' => $space,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a space_event
     * resource.
     *
     * @param string $space
     * @param string $spaceEvent
     *
     * @return string The formatted space_event resource.
     */
    public static function spaceEventName(string $space, string $spaceEvent): string
    {
        return self::getPathTemplate('spaceEvent')->render([
            'space' => $space,
            'space_event' => $spaceEvent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * space_notification_setting resource.
     *
     * @param string $user
     * @param string $space
     *
     * @return string The formatted space_notification_setting resource.
     */
    public static function spaceNotificationSettingName(string $user, string $space): string
    {
        return self::getPathTemplate('spaceNotificationSetting')->render([
            'user' => $user,
            'space' => $space,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * space_read_state resource.
     *
     * @param string $user
     * @param string $space
     *
     * @return string The formatted space_read_state resource.
     */
    public static function spaceReadStateName(string $user, string $space): string
    {
        return self::getPathTemplate('spaceReadState')->render([
            'user' => $user,
            'space' => $space,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a thread
     * resource.
     *
     * @param string $space
     * @param string $thread
     *
     * @return string The formatted thread resource.
     */
    public static function threadName(string $space, string $thread): string
    {
        return self::getPathTemplate('thread')->render([
            'space' => $space,
            'thread' => $thread,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * thread_read_state resource.
     *
     * @param string $user
     * @param string $space
     * @param string $thread
     *
     * @return string The formatted thread_read_state resource.
     */
    public static function threadReadStateName(string $user, string $space, string $thread): string
    {
        return self::getPathTemplate('threadReadState')->render([
            'user' => $user,
            'space' => $space,
            'thread' => $thread,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - attachment: spaces/{space}/messages/{message}/attachments/{attachment}
     * - customEmoji: customEmojis/{custom_emoji}
     * - membership: spaces/{space}/members/{member}
     * - message: spaces/{space}/messages/{message}
     * - quotedMessageMetadata: spaces/{space}/messages/{message}/quotedMessageMetadata/{quoted_message_metadata}
     * - reaction: spaces/{space}/messages/{message}/reactions/{reaction}
     * - space: spaces/{space}
     * - spaceEvent: spaces/{space}/spaceEvents/{space_event}
     * - spaceNotificationSetting: users/{user}/spaces/{space}/spaceNotificationSetting
     * - spaceReadState: users/{user}/spaces/{space}/spaceReadState
     * - thread: spaces/{space}/threads/{thread}
     * - threadReadState: users/{user}/spaces/{space}/threads/{thread}/threadReadState
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'chat.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Completes the
     * [import process](https://developers.google.com/workspace/chat/import-data)
     * for the specified space and makes it visible to users.
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * and domain-wide delegation with the [authorization
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.import`
     *
     * For more information, see [Authorize Google
     * Chat apps to import
     * data](https://developers.google.com/workspace/chat/authorize-import).
     *
     * The async variant is {@see ChatServiceClient::completeImportSpaceAsync()} .
     *
     * @example samples/V1/ChatServiceClient/complete_import_space.php
     *
     * @param CompleteImportSpaceRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CompleteImportSpaceResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function completeImportSpace(
        CompleteImportSpaceRequest $request,
        array $callOptions = []
    ): CompleteImportSpaceResponse {
        return $this->startApiCall('CompleteImportSpace', $request, $callOptions)->wait();
    }

    /**
     * Creates a custom emoji.
     *
     * Custom emojis are only available for Google Workspace accounts, and the
     * administrator must turn custom emojis on for the organization. For more
     * information, see [Learn about custom emojis in Google
     * Chat](https://support.google.com/chat/answer/12800149) and
     * [Manage custom emoji
     * permissions](https://support.google.com/a/answer/12850085).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with the [authorization
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.customemojis`
     *
     * The async variant is {@see ChatServiceClient::createCustomEmojiAsync()} .
     *
     * @example samples/V1/ChatServiceClient/create_custom_emoji.php
     *
     * @param CreateCustomEmojiRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomEmoji
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCustomEmoji(CreateCustomEmojiRequest $request, array $callOptions = []): CustomEmoji
    {
        return $this->startApiCall('CreateCustomEmoji', $request, $callOptions)->wait();
    }

    /**
     * Creates a membership for the calling Chat app, a user, or a Google Group.
     * Creating memberships for other Chat apps isn't supported.
     * When creating a membership, if the specified member has their auto-accept
     * policy turned off, then they're invited, and must accept the space
     * invitation before joining. Otherwise, creating a membership adds the member
     * directly to the specified space.
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator approval](https://support.google.com/a?p=chat-app-auth)
     * and the authorization scope:
     * - `https://www.googleapis.com/auth/chat.app.memberships`
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.memberships`
     * - `https://www.googleapis.com/auth/chat.memberships.app` (to add the
     * calling app to the space)
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces
     * only)
     * - User authentication grants administrator privileges when an
     * administrator account authenticates, `use_admin_access` is `true`, and
     * the following authorization scope is used:
     * - `https://www.googleapis.com/auth/chat.admin.memberships`
     *
     * App authentication is not supported for the following use cases:
     *
     * - Inviting users external to the Workspace organization that owns the
     * space.
     * - Adding a Google Group to a space.
     * - Adding a Chat app to a space.
     *
     * For example usage, see:
     *
     * - [Invite or add a user to a
     * space](https://developers.google.com/workspace/chat/create-members#create-user-membership).
     * - [Invite or add a Google Group to a
     * space](https://developers.google.com/workspace/chat/create-members#create-group-membership).
     * - [Add the Chat app to a
     * space](https://developers.google.com/workspace/chat/create-members#create-membership-calling-api).
     *
     * The async variant is {@see ChatServiceClient::createMembershipAsync()} .
     *
     * @example samples/V1/ChatServiceClient/create_membership.php
     *
     * @param CreateMembershipRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Membership
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMembership(CreateMembershipRequest $request, array $callOptions = []): Membership
    {
        return $this->startApiCall('CreateMembership', $request, $callOptions)->wait();
    }

    /**
     * Creates a message in a Google Chat space. For an example, see [Send a
     * message](https://developers.google.com/workspace/chat/create-messages).
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with the authorization scope:
     * - `https://www.googleapis.com/auth/chat.bot`
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.messages.create`
     * - `https://www.googleapis.com/auth/chat.messages`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces
     * only)
     *
     * Chat attributes the message sender differently depending on the type of
     * authentication that you use in your request.
     *
     * The following image shows how Chat attributes a message when you use app
     * authentication. Chat displays the Chat app as the message
     * sender. The content of the message can contain text (`text`), cards
     * (`cardsV2`), and accessory widgets (`accessoryWidgets`).
     *
     * ![Message sent with app
     * authentication](https://developers.google.com/workspace/chat/images/message-app-auth.svg)
     *
     * The following image shows how Chat attributes a message when you use user
     * authentication. Chat displays the user as the message sender and attributes
     * the Chat app to the message by displaying its name. The content of message
     * can only contain text (`text`).
     *
     * ![Message sent with user
     * authentication](https://developers.google.com/workspace/chat/images/message-user-auth.svg)
     *
     * The maximum message size, including the message contents, is 32,000 bytes.
     *
     * For
     * [webhook](https://developers.google.com/workspace/chat/quickstart/webhooks)
     * requests, the response doesn't contain the full message. The response only
     * populates the `name` and `thread.name` fields in addition to the
     * information that was in the request.
     *
     * The async variant is {@see ChatServiceClient::createMessageAsync()} .
     *
     * @example samples/V1/ChatServiceClient/create_message.php
     *
     * @param CreateMessageRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Message
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMessage(CreateMessageRequest $request, array $callOptions = []): Message
    {
        return $this->startApiCall('CreateMessage', $request, $callOptions)->wait();
    }

    /**
     * Creates a reaction and adds it to a message. For an example, see
     * [Add a reaction to a
     * message](https://developers.google.com/workspace/chat/create-reactions).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following [authorization
     * scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.messages.reactions.create`
     * - `https://www.googleapis.com/auth/chat.messages.reactions`
     * - `https://www.googleapis.com/auth/chat.messages`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces only)
     *
     * The async variant is {@see ChatServiceClient::createReactionAsync()} .
     *
     * @example samples/V1/ChatServiceClient/create_reaction.php
     *
     * @param CreateReactionRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Reaction
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createReaction(CreateReactionRequest $request, array $callOptions = []): Reaction
    {
        return $this->startApiCall('CreateReaction', $request, $callOptions)->wait();
    }

    /**
     * Creates a space. Can be used to create a named space, or a
     * group chat in `Import mode`. For an example, see [Create a
     * space](https://developers.google.com/workspace/chat/create-spaces).
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator approval](https://support.google.com/a?p=chat-app-auth)
     * and one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.app.spaces.create`
     * - `https://www.googleapis.com/auth/chat.app.spaces`
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.spaces.create`
     * - `https://www.googleapis.com/auth/chat.spaces`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces
     * only)
     *
     * When authenticating as an app, the `space.customer` field must be set in
     * the request.
     *
     * When authenticating as an app, the Chat app is added as a member of the
     * space. However, unlike human authentication, the Chat app is not added as a
     * space manager. By default, the Chat app can be removed from the space by
     * all space members. To allow only space managers to remove the app from a
     * space, set `space.permission_settings.manage_apps` to `managers_allowed`.
     *
     * Space membership upon creation depends on whether the space is created in
     * `Import mode`:
     *
     * * **Import mode:** No members are created.
     * * **All other modes:**  The calling user is added as a member. This is:
     * * The app itself when using app authentication.
     * * The human user when using user authentication.
     *
     * If you receive the error message `ALREADY_EXISTS` when creating
     * a space, try a different `displayName`. An existing space within
     * the Google Workspace organization might already use this display name.
     *
     * The async variant is {@see ChatServiceClient::createSpaceAsync()} .
     *
     * @example samples/V1/ChatServiceClient/create_space.php
     *
     * @param CreateSpaceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Space
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSpace(CreateSpaceRequest $request, array $callOptions = []): Space
    {
        return $this->startApiCall('CreateSpace', $request, $callOptions)->wait();
    }

    /**
     * Deletes a custom emoji. By default, users can only delete custom emoji they
     * created. [Emoji managers](https://support.google.com/a/answer/12850085)
     * assigned by the administrator can delete any custom emoji in the
     * organization. See [Learn about custom emojis in Google
     * Chat](https://support.google.com/chat/answer/12800149).
     *
     * Custom emojis are only available for Google Workspace accounts, and the
     * administrator must turn custom emojis on for the organization. For more
     * information, see [Learn about custom emojis in Google
     * Chat](https://support.google.com/chat/answer/12800149) and
     * [Manage custom emoji
     * permissions](https://support.google.com/a/answer/12850085).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with the [authorization
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.customemojis`
     *
     * The async variant is {@see ChatServiceClient::deleteCustomEmojiAsync()} .
     *
     * @example samples/V1/ChatServiceClient/delete_custom_emoji.php
     *
     * @param DeleteCustomEmojiRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCustomEmoji(DeleteCustomEmojiRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteCustomEmoji', $request, $callOptions)->wait();
    }

    /**
     * Deletes a membership. For an example, see
     * [Remove a user or a Google Chat app from a
     * space](https://developers.google.com/workspace/chat/delete-members).
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator approval](https://support.google.com/a?p=chat-app-auth)
     * and the authorization scope:
     * - `https://www.googleapis.com/auth/chat.app.memberships`
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.memberships`
     * - `https://www.googleapis.com/auth/chat.memberships.app` (to remove
     * the calling app from the space)
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces
     * only)
     * - User authentication grants administrator privileges when an
     * administrator account authenticates, `use_admin_access` is `true`, and
     * the following authorization scope is used:
     * - `https://www.googleapis.com/auth/chat.admin.memberships`
     *
     * App authentication is not supported for the following use cases:
     *
     * - Removing a Google Group from a space.
     * - Removing a Chat app from a space.
     *
     * To delete memberships for space managers, the requester
     * must be a space manager. If you're using [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * the Chat app must be the space creator.
     *
     * The async variant is {@see ChatServiceClient::deleteMembershipAsync()} .
     *
     * @example samples/V1/ChatServiceClient/delete_membership.php
     *
     * @param DeleteMembershipRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Membership
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMembership(DeleteMembershipRequest $request, array $callOptions = []): Membership
    {
        return $this->startApiCall('DeleteMembership', $request, $callOptions)->wait();
    }

    /**
     * Deletes a message.
     * For an example, see [Delete a
     * message](https://developers.google.com/workspace/chat/delete-messages).
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with the authorization scope:
     * - `https://www.googleapis.com/auth/chat.bot`
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.messages`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces
     * only)
     *
     * When using app authentication, requests can only delete messages
     * created by the calling Chat app.
     *
     * The async variant is {@see ChatServiceClient::deleteMessageAsync()} .
     *
     * @example samples/V1/ChatServiceClient/delete_message.php
     *
     * @param DeleteMessageRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMessage(DeleteMessageRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteMessage', $request, $callOptions)->wait();
    }

    /**
     * Deletes a reaction to a message. For an example, see
     * [Delete a
     * reaction](https://developers.google.com/workspace/chat/delete-reactions).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following [authorization
     * scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.messages.reactions`
     * - `https://www.googleapis.com/auth/chat.messages`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces only)
     *
     * The async variant is {@see ChatServiceClient::deleteReactionAsync()} .
     *
     * @example samples/V1/ChatServiceClient/delete_reaction.php
     *
     * @param DeleteReactionRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteReaction(DeleteReactionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteReaction', $request, $callOptions)->wait();
    }

    /**
     * Deletes a named space. Always performs a cascading delete, which means
     * that the space's child resources—like messages posted in the space and
     * memberships in the space—are also deleted. For an example, see
     * [Delete a
     * space](https://developers.google.com/workspace/chat/delete-spaces).
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator
     * approval](https://support.google.com/a?p=chat-app-auth) and the
     * authorization scope:
     * - `https://www.googleapis.com/auth/chat.app.delete` (only in
     * spaces the app created)
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.delete`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces
     * only)
     * - User authentication grants administrator privileges when an
     * administrator account authenticates, `use_admin_access` is `true`, and
     * the following authorization scope is used:
     * - `https://www.googleapis.com/auth/chat.admin.delete`
     *
     * The async variant is {@see ChatServiceClient::deleteSpaceAsync()} .
     *
     * @example samples/V1/ChatServiceClient/delete_space.php
     *
     * @param DeleteSpaceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSpace(DeleteSpaceRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSpace', $request, $callOptions)->wait();
    }

    /**
     * Returns the existing direct message with the specified user. If no direct
     * message space is found, returns a `404 NOT_FOUND` error. For an example,
     * see
     * [Find a direct message](/chat/api/guides/v1/spaces/find-direct-message).
     *
     * With [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app),
     * returns the direct message space between the specified user and the calling
     * Chat app.
     *
     * With [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
     * returns the direct message space between the specified user and the
     * authenticated user.
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with the authorization scope:
     * - `https://www.googleapis.com/auth/chat.bot`
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.spaces.readonly`
     * - `https://www.googleapis.com/auth/chat.spaces`
     *
     * The async variant is {@see ChatServiceClient::findDirectMessageAsync()} .
     *
     * @example samples/V1/ChatServiceClient/find_direct_message.php
     *
     * @param FindDirectMessageRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Space
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function findDirectMessage(FindDirectMessageRequest $request, array $callOptions = []): Space
    {
        return $this->startApiCall('FindDirectMessage', $request, $callOptions)->wait();
    }

    /**
     * Gets the metadata of a message attachment. The attachment data is fetched
     * using the [media
     * API](https://developers.google.com/workspace/chat/api/reference/rest/v1/media/download).
     * For an example, see
     * [Get metadata about a message
     * attachment](https://developers.google.com/workspace/chat/get-media-attachments).
     *
     * Requires [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with the [authorization
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.bot`
     *
     * The async variant is {@see ChatServiceClient::getAttachmentAsync()} .
     *
     * @example samples/V1/ChatServiceClient/get_attachment.php
     *
     * @param GetAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Attachment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAttachment(GetAttachmentRequest $request, array $callOptions = []): Attachment
    {
        return $this->startApiCall('GetAttachment', $request, $callOptions)->wait();
    }

    /**
     * Returns details about a custom emoji.
     *
     * Custom emojis are only available for Google Workspace accounts, and the
     * administrator must turn custom emojis on for the organization. For more
     * information, see [Learn about custom emojis in Google
     * Chat](https://support.google.com/chat/answer/12800149) and
     * [Manage custom emoji
     * permissions](https://support.google.com/a/answer/12850085).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following [authorization
     * scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.customemojis.readonly`
     * - `https://www.googleapis.com/auth/chat.customemojis`
     *
     * The async variant is {@see ChatServiceClient::getCustomEmojiAsync()} .
     *
     * @example samples/V1/ChatServiceClient/get_custom_emoji.php
     *
     * @param GetCustomEmojiRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomEmoji
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCustomEmoji(GetCustomEmojiRequest $request, array $callOptions = []): CustomEmoji
    {
        return $this->startApiCall('GetCustomEmoji', $request, $callOptions)->wait();
    }

    /**
     * Returns details about a membership. For an example, see
     * [Get details about a user's or Google Chat app's
     * membership](https://developers.google.com/workspace/chat/get-members).
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.bot`
     * - `https://www.googleapis.com/auth/chat.app.memberships` (requires
     * [administrator approval](https://support.google.com/a?p=chat-app-auth))
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.memberships.readonly`
     * - `https://www.googleapis.com/auth/chat.memberships`
     * - User authentication grants administrator privileges when an
     * administrator account authenticates, `use_admin_access` is `true`, and
     * one of the following authorization scopes is used:
     * - `https://www.googleapis.com/auth/chat.admin.memberships.readonly`
     * - `https://www.googleapis.com/auth/chat.admin.memberships`
     *
     * The async variant is {@see ChatServiceClient::getMembershipAsync()} .
     *
     * @example samples/V1/ChatServiceClient/get_membership.php
     *
     * @param GetMembershipRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Membership
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMembership(GetMembershipRequest $request, array $callOptions = []): Membership
    {
        return $this->startApiCall('GetMembership', $request, $callOptions)->wait();
    }

    /**
     * Returns details about a message.
     * For an example, see [Get details about a
     * message](https://developers.google.com/workspace/chat/get-messages).
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with the authorization scope:
     * - `https://www.googleapis.com/auth/chat.bot`
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.messages.readonly`
     * - `https://www.googleapis.com/auth/chat.messages`
     *
     * Note: Might return a message from a blocked member or space.
     *
     * The async variant is {@see ChatServiceClient::getMessageAsync()} .
     *
     * @example samples/V1/ChatServiceClient/get_message.php
     *
     * @param GetMessageRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Message
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMessage(GetMessageRequest $request, array $callOptions = []): Message
    {
        return $this->startApiCall('GetMessage', $request, $callOptions)->wait();
    }

    /**
     * Returns details about a space. For an example, see
     * [Get details about a
     * space](https://developers.google.com/workspace/chat/get-spaces).
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.bot`
     * - `https://www.googleapis.com/auth/chat.app.spaces` with [administrator
     * approval](https://support.google.com/a?p=chat-app-auth)
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.spaces.readonly`
     * - `https://www.googleapis.com/auth/chat.spaces`
     * - User authentication grants administrator privileges when an
     * administrator account authenticates, `use_admin_access` is `true`, and
     * one of the following authorization scopes is used:
     * - `https://www.googleapis.com/auth/chat.admin.spaces.readonly`
     * - `https://www.googleapis.com/auth/chat.admin.spaces`
     *
     * App authentication has the following limitations:
     *
     * - `space.access_settings` is only populated when using the
     * `chat.app.spaces` scope.
     * - `space.predefind_permission_settings` and `space.permission_settings` are
     * only populated when using the `chat.app.spaces` scope, and only for
     * spaces the app created.
     *
     * The async variant is {@see ChatServiceClient::getSpaceAsync()} .
     *
     * @example samples/V1/ChatServiceClient/get_space.php
     *
     * @param GetSpaceRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Space
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSpace(GetSpaceRequest $request, array $callOptions = []): Space
    {
        return $this->startApiCall('GetSpace', $request, $callOptions)->wait();
    }

    /**
     * Returns an event from a Google Chat space. The [event
     * payload](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.oneof_payload)
     * contains the most recent version of the resource that changed. For example,
     * if you request an event about a new message but the message was later
     * updated, the server returns the updated `Message` resource in the event
     * payload.
     *
     * Note: The `permissionSettings` field is not returned in the Space
     * object of the Space event data for this request.
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with an [authorization
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes)
     * appropriate for reading the requested data:
     *
     * - `https://www.googleapis.com/auth/chat.spaces.readonly`
     * - `https://www.googleapis.com/auth/chat.spaces`
     * - `https://www.googleapis.com/auth/chat.messages.readonly`
     * - `https://www.googleapis.com/auth/chat.messages`
     * - `https://www.googleapis.com/auth/chat.messages.reactions.readonly`
     * - `https://www.googleapis.com/auth/chat.messages.reactions`
     * - `https://www.googleapis.com/auth/chat.memberships.readonly`
     * - `https://www.googleapis.com/auth/chat.memberships`
     *
     * To get an event, the authenticated user must be a member of the space.
     *
     * For an example, see [Get details about an
     * event from a Google Chat
     * space](https://developers.google.com/workspace/chat/get-space-event).
     *
     * The async variant is {@see ChatServiceClient::getSpaceEventAsync()} .
     *
     * @example samples/V1/ChatServiceClient/get_space_event.php
     *
     * @param GetSpaceEventRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SpaceEvent
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSpaceEvent(GetSpaceEventRequest $request, array $callOptions = []): SpaceEvent
    {
        return $this->startApiCall('GetSpaceEvent', $request, $callOptions)->wait();
    }

    /**
     * Gets the space notification setting. For an example, see [Get the
     * caller's space notification
     * setting](https://developers.google.com/workspace/chat/get-space-notification-setting).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with the [authorization
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.users.spacesettings`
     *
     * The async variant is
     * {@see ChatServiceClient::getSpaceNotificationSettingAsync()} .
     *
     * @example samples/V1/ChatServiceClient/get_space_notification_setting.php
     *
     * @param GetSpaceNotificationSettingRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SpaceNotificationSetting
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSpaceNotificationSetting(
        GetSpaceNotificationSettingRequest $request,
        array $callOptions = []
    ): SpaceNotificationSetting {
        return $this->startApiCall('GetSpaceNotificationSetting', $request, $callOptions)->wait();
    }

    /**
     * Returns details about a user's read state within a space, used to identify
     * read and unread messages. For an example, see [Get details about a user's
     * space read
     * state](https://developers.google.com/workspace/chat/get-space-read-state).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following [authorization
     * scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.users.readstate.readonly`
     * - `https://www.googleapis.com/auth/chat.users.readstate`
     *
     * The async variant is {@see ChatServiceClient::getSpaceReadStateAsync()} .
     *
     * @example samples/V1/ChatServiceClient/get_space_read_state.php
     *
     * @param GetSpaceReadStateRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SpaceReadState
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSpaceReadState(GetSpaceReadStateRequest $request, array $callOptions = []): SpaceReadState
    {
        return $this->startApiCall('GetSpaceReadState', $request, $callOptions)->wait();
    }

    /**
     * Returns details about a user's read state within a thread, used to identify
     * read and unread messages. For an example, see [Get details about a user's
     * thread read
     * state](https://developers.google.com/workspace/chat/get-thread-read-state).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following [authorization
     * scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.users.readstate.readonly`
     * - `https://www.googleapis.com/auth/chat.users.readstate`
     *
     * The async variant is {@see ChatServiceClient::getThreadReadStateAsync()} .
     *
     * @example samples/V1/ChatServiceClient/get_thread_read_state.php
     *
     * @param GetThreadReadStateRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ThreadReadState
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getThreadReadState(GetThreadReadStateRequest $request, array $callOptions = []): ThreadReadState
    {
        return $this->startApiCall('GetThreadReadState', $request, $callOptions)->wait();
    }

    /**
     * Lists custom emojis visible to the authenticated user.
     *
     * Custom emojis are only available for Google Workspace accounts, and the
     * administrator must turn custom emojis on for the organization. For more
     * information, see [Learn about custom emojis in Google
     * Chat](https://support.google.com/chat/answer/12800149) and
     * [Manage custom emoji
     * permissions](https://support.google.com/a/answer/12850085).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following [authorization
     * scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.customemojis.readonly`
     * - `https://www.googleapis.com/auth/chat.customemojis`
     *
     * The async variant is {@see ChatServiceClient::listCustomEmojisAsync()} .
     *
     * @example samples/V1/ChatServiceClient/list_custom_emojis.php
     *
     * @param ListCustomEmojisRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCustomEmojis(ListCustomEmojisRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCustomEmojis', $request, $callOptions);
    }

    /**
     * Lists memberships in a space. For an example, see [List users and Google
     * Chat apps in a
     * space](https://developers.google.com/workspace/chat/list-members). Listing
     * memberships with [app
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * lists memberships in spaces that the Chat app has
     * access to, but excludes Chat app memberships,
     * including its own. Listing memberships with
     * [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * lists memberships in spaces that the authenticated user has access to.
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.bot`
     * - `https://www.googleapis.com/auth/chat.app.memberships` (requires
     * [administrator approval](https://support.google.com/a?p=chat-app-auth))
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.memberships.readonly`
     * - `https://www.googleapis.com/auth/chat.memberships`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces
     * only)
     * - User authentication grants administrator privileges when an
     * administrator account authenticates, `use_admin_access` is `true`, and
     * one of the following authorization scopes is used:
     * - `https://www.googleapis.com/auth/chat.admin.memberships.readonly`
     * - `https://www.googleapis.com/auth/chat.admin.memberships`
     *
     * The async variant is {@see ChatServiceClient::listMembershipsAsync()} .
     *
     * @example samples/V1/ChatServiceClient/list_memberships.php
     *
     * @param ListMembershipsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMemberships(ListMembershipsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMemberships', $request, $callOptions);
    }

    /**
     * Lists messages in a space that the caller is a member of, including
     * messages from blocked members and spaces. If you list messages from a
     * space with no messages, the response is an empty object. When using a
     * REST/HTTP interface, the response contains an empty JSON object, `{}`.
     * For an example, see
     * [List
     * messages](https://developers.google.com/workspace/chat/api/guides/v1/messages/list).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following [authorization
     * scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.messages.readonly`
     * - `https://www.googleapis.com/auth/chat.messages`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces only)
     *
     * The async variant is {@see ChatServiceClient::listMessagesAsync()} .
     *
     * @example samples/V1/ChatServiceClient/list_messages.php
     *
     * @param ListMessagesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMessages(ListMessagesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMessages', $request, $callOptions);
    }

    /**
     * Lists reactions to a message. For an example, see
     * [List reactions for a
     * message](https://developers.google.com/workspace/chat/list-reactions).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following [authorization
     * scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.messages.reactions.readonly`
     * - `https://www.googleapis.com/auth/chat.messages.reactions`
     * - `https://www.googleapis.com/auth/chat.messages.readonly`
     * - `https://www.googleapis.com/auth/chat.messages`
     *
     * The async variant is {@see ChatServiceClient::listReactionsAsync()} .
     *
     * @example samples/V1/ChatServiceClient/list_reactions.php
     *
     * @param ListReactionsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReactions(ListReactionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListReactions', $request, $callOptions);
    }

    /**
     * Lists events from a Google Chat space. For each event, the
     * [payload](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.oneof_payload)
     * contains the most recent version of the Chat resource. For example, if you
     * list events about new space members, the server returns `Membership`
     * resources that contain the latest membership details. If new members were
     * removed during the requested period, the event payload contains an empty
     * `Membership` resource.
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with an [authorization
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes)
     * appropriate for reading the requested data:
     *
     * - `https://www.googleapis.com/auth/chat.spaces.readonly`
     * - `https://www.googleapis.com/auth/chat.spaces`
     * - `https://www.googleapis.com/auth/chat.messages.readonly`
     * - `https://www.googleapis.com/auth/chat.messages`
     * - `https://www.googleapis.com/auth/chat.messages.reactions.readonly`
     * - `https://www.googleapis.com/auth/chat.messages.reactions`
     * - `https://www.googleapis.com/auth/chat.memberships.readonly`
     * - `https://www.googleapis.com/auth/chat.memberships`
     *
     * To list events, the authenticated user must be a member of the space.
     *
     * For an example, see [List events from a Google Chat
     * space](https://developers.google.com/workspace/chat/list-space-events).
     *
     * The async variant is {@see ChatServiceClient::listSpaceEventsAsync()} .
     *
     * @example samples/V1/ChatServiceClient/list_space_events.php
     *
     * @param ListSpaceEventsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSpaceEvents(ListSpaceEventsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSpaceEvents', $request, $callOptions);
    }

    /**
     * Lists spaces the caller is a member of. Group chats and DMs aren't listed
     * until the first message is sent. For an example, see
     * [List
     * spaces](https://developers.google.com/workspace/chat/list-spaces).
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with the authorization scope:
     * - `https://www.googleapis.com/auth/chat.bot`
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.spaces.readonly`
     * - `https://www.googleapis.com/auth/chat.spaces`
     *
     * To list all named spaces by Google Workspace organization, use the
     * [`spaces.search()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/search)
     * method using Workspace administrator privileges instead.
     *
     * The async variant is {@see ChatServiceClient::listSpacesAsync()} .
     *
     * @example samples/V1/ChatServiceClient/list_spaces.php
     *
     * @param ListSpacesRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSpaces(ListSpacesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSpaces', $request, $callOptions);
    }

    /**
     * Returns a list of spaces in a Google Workspace organization based on an
     * administrator's search.
     *
     * Requires [user
     * authentication with administrator
     * privileges](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user#admin-privileges)
     * and one of the following [authorization
     * scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.admin.spaces.readonly`
     * - `https://www.googleapis.com/auth/chat.admin.spaces`
     *
     * In the request, set `use_admin_access` to `true`.
     *
     * The async variant is {@see ChatServiceClient::searchSpacesAsync()} .
     *
     * @example samples/V1/ChatServiceClient/search_spaces.php
     *
     * @param SearchSpacesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchSpaces(SearchSpacesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchSpaces', $request, $callOptions);
    }

    /**
     * Creates a space and adds specified users to it. The calling user is
     * automatically added to the space, and shouldn't be specified as a
     * membership in the request. For an example, see
     * [Set up a space with initial
     * members](https://developers.google.com/workspace/chat/set-up-spaces).
     *
     * To specify the human members to add, add memberships with the appropriate
     * `membership.member.name`. To add a human user, use `users/{user}`, where
     * `{user}` can be the email address for the user. For users in the same
     * Workspace organization `{user}` can also be the `id` for the person from
     * the People API, or the `id` for the user in the Directory API. For example,
     * if the People API Person profile ID for `user&#64;example.com` is `123456789`,
     * you can add the user to the space by setting the `membership.member.name`
     * to `users/user&#64;example.com` or `users/123456789`.
     *
     * To specify the Google groups to add, add memberships with the
     * appropriate `membership.group_member.name`. To add or invite a Google
     * group, use `groups/{group}`, where `{group}` is the `id` for the group from
     * the Cloud Identity Groups API. For example, you can use [Cloud Identity
     * Groups lookup
     * API](https://cloud.google.com/identity/docs/reference/rest/v1/groups/lookup)
     * to retrieve the ID `123456789` for group email `group&#64;example.com`, then
     * you can add the group to the space by setting the
     * `membership.group_member.name` to `groups/123456789`. Group email is not
     * supported, and Google groups can only be added as members in named spaces.
     *
     * For a named space or group chat, if the caller blocks, or is blocked
     * by some members, or doesn't have permission to add some members, then
     * those members aren't added to the created space.
     *
     * To create a direct message (DM) between the calling user and another human
     * user, specify exactly one membership to represent the human user. If
     * one user blocks the other, the request fails and the DM isn't created.
     *
     * To create a DM between the calling user and the calling app, set
     * `Space.singleUserBotDm` to `true` and don't specify any memberships. You
     * can only use this method to set up a DM with the calling app. To add the
     * calling app as a member of a space or an existing DM between two human
     * users, see
     * [Invite or add a user or app to a
     * space](https://developers.google.com/workspace/chat/create-members).
     *
     * If a DM already exists between two users, even when one user blocks the
     * other at the time a request is made, then the existing DM is returned.
     *
     * Spaces with threaded replies aren't supported. If you receive the error
     * message `ALREADY_EXISTS` when setting up a space, try a different
     * `displayName`. An existing space within the Google Workspace organization
     * might already use this display name.
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following [authorization
     * scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.spaces.create`
     * - `https://www.googleapis.com/auth/chat.spaces`
     *
     * The async variant is {@see ChatServiceClient::setUpSpaceAsync()} .
     *
     * @example samples/V1/ChatServiceClient/set_up_space.php
     *
     * @param SetUpSpaceRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Space
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setUpSpace(SetUpSpaceRequest $request, array $callOptions = []): Space
    {
        return $this->startApiCall('SetUpSpace', $request, $callOptions)->wait();
    }

    /**
     * Updates a membership. For an example, see [Update a user's membership in
     * a space](https://developers.google.com/workspace/chat/update-members).
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator
     * approval](https://support.google.com/a?p=chat-app-auth) and the
     * authorization scope:
     * - `https://www.googleapis.com/auth/chat.app.memberships` (only in
     * spaces the app created)
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.memberships`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces
     * only)
     * - User authentication grants administrator privileges when an
     * administrator account authenticates, `use_admin_access` is `true`, and
     * the following authorization scope is used:
     * - `https://www.googleapis.com/auth/chat.admin.memberships`
     *
     * The async variant is {@see ChatServiceClient::updateMembershipAsync()} .
     *
     * @example samples/V1/ChatServiceClient/update_membership.php
     *
     * @param UpdateMembershipRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Membership
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMembership(UpdateMembershipRequest $request, array $callOptions = []): Membership
    {
        return $this->startApiCall('UpdateMembership', $request, $callOptions)->wait();
    }

    /**
     * Updates a message. There's a difference between the `patch` and `update`
     * methods. The `patch`
     * method uses a `patch` request while the `update` method uses a `put`
     * request. We recommend using the `patch` method. For an example, see
     * [Update a
     * message](https://developers.google.com/workspace/chat/update-messages).
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with the authorization scope:
     * - `https://www.googleapis.com/auth/chat.bot`
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.messages`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces
     * only)
     *
     * When using app authentication, requests can only update messages
     * created by the calling Chat app.
     *
     * The async variant is {@see ChatServiceClient::updateMessageAsync()} .
     *
     * @example samples/V1/ChatServiceClient/update_message.php
     *
     * @param UpdateMessageRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Message
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMessage(UpdateMessageRequest $request, array $callOptions = []): Message
    {
        return $this->startApiCall('UpdateMessage', $request, $callOptions)->wait();
    }

    /**
     * Updates a space. For an example, see
     * [Update a
     * space](https://developers.google.com/workspace/chat/update-spaces).
     *
     * If you're updating the `displayName` field and receive the error message
     * `ALREADY_EXISTS`, try a different display name.. An existing space within
     * the Google Workspace organization might already use this display name.
     *
     * Supports the following types of
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize):
     *
     * - [App
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
     * with [administrator approval](https://support.google.com/a?p=chat-app-auth)
     * and one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.app.spaces`
     *
     * - [User
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following authorization scopes:
     * - `https://www.googleapis.com/auth/chat.spaces`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces
     * only)
     * - User authentication grants administrator privileges when an
     * administrator account authenticates, `use_admin_access` is `true`, and
     * the following authorization scopes is used:
     * - `https://www.googleapis.com/auth/chat.admin.spaces`
     *
     * App authentication has the following limitations:
     *
     * - To update either `space.predefined_permission_settings` or
     * `space.permission_settings`, the app must be the space creator.
     * - Updating the `space.access_settings.audience` is not supported for app
     * authentication.
     *
     * The async variant is {@see ChatServiceClient::updateSpaceAsync()} .
     *
     * @example samples/V1/ChatServiceClient/update_space.php
     *
     * @param UpdateSpaceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Space
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSpace(UpdateSpaceRequest $request, array $callOptions = []): Space
    {
        return $this->startApiCall('UpdateSpace', $request, $callOptions)->wait();
    }

    /**
     * Updates the space notification setting. For an example, see [Update
     * the caller's space notification
     * setting](https://developers.google.com/workspace/chat/update-space-notification-setting).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with the [authorization
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.users.spacesettings`
     *
     * The async variant is
     * {@see ChatServiceClient::updateSpaceNotificationSettingAsync()} .
     *
     * @example samples/V1/ChatServiceClient/update_space_notification_setting.php
     *
     * @param UpdateSpaceNotificationSettingRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SpaceNotificationSetting
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSpaceNotificationSetting(
        UpdateSpaceNotificationSettingRequest $request,
        array $callOptions = []
    ): SpaceNotificationSetting {
        return $this->startApiCall('UpdateSpaceNotificationSetting', $request, $callOptions)->wait();
    }

    /**
     * Updates a user's read state within a space, used to identify read and
     * unread messages. For an example, see [Update a user's space read
     * state](https://developers.google.com/workspace/chat/update-space-read-state).
     *
     * Requires [user
     * authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with the [authorization
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.users.readstate`
     *
     * The async variant is {@see ChatServiceClient::updateSpaceReadStateAsync()} .
     *
     * @example samples/V1/ChatServiceClient/update_space_read_state.php
     *
     * @param UpdateSpaceReadStateRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SpaceReadState
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSpaceReadState(UpdateSpaceReadStateRequest $request, array $callOptions = []): SpaceReadState
    {
        return $this->startApiCall('UpdateSpaceReadState', $request, $callOptions)->wait();
    }

    /**
     * Uploads an attachment. For an example, see
     * [Upload media as a file
     * attachment](https://developers.google.com/workspace/chat/upload-media-attachments).
     *
     * Requires user
     * [authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
     * with one of the following [authorization
     * scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes):
     *
     * - `https://www.googleapis.com/auth/chat.messages.create`
     * - `https://www.googleapis.com/auth/chat.messages`
     * - `https://www.googleapis.com/auth/chat.import` (import mode spaces only)
     *
     * You can upload attachments up to 200 MB. Certain file types aren't
     * supported. For details, see [File types blocked by Google
     * Chat](https://support.google.com/chat/answer/7651457?&co=GENIE.Platform%3DDesktop#File%20types%20blocked%20in%20Google%20Chat).
     *
     * The async variant is {@see ChatServiceClient::uploadAttachmentAsync()} .
     *
     * @example samples/V1/ChatServiceClient/upload_attachment.php
     *
     * @param UploadAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return UploadAttachmentResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function uploadAttachment(
        UploadAttachmentRequest $request,
        array $callOptions = []
    ): UploadAttachmentResponse {
        return $this->startApiCall('UploadAttachment', $request, $callOptions)->wait();
    }
}
