<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/apihub/v1/common_fields.proto

namespace Google\Cloud\ApiHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a spec associated with an API version in the API
 * Hub. Note that specs of various types can be uploaded, however
 * parsing of details is supported for OpenAPI spec currently.
 *
 * Generated from protobuf message <code>google.cloud.apihub.v1.Spec</code>
 */
class Spec extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the spec.
     * Format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The display name of the spec.
     * This can contain the file name of the spec.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Required. The type of spec.
     * The value should be one of the allowed values defined for
     * `projects/{project}/locations/{location}/attributes/system-spec-type`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API.
     * Note, this field is mandatory if content is provided.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues spec_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $spec_type = null;
    /**
     * Optional. Input only. The contents of the uploaded spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.SpecContents contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $contents = null;
    /**
     * Output only. Details parsed from the spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.SpecDetails details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $details = null;
    /**
     * Optional. The URI of the spec source in case file is uploaded
     * from an external version control system.
     *
     * Generated from protobuf field <code>string source_uri = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $source_uri = '';
    /**
     * Output only. The time at which the spec was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time at which the spec was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. The lint response for the spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.LintResponse lint_response = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $lint_response = null;
    /**
     * Optional. The list of user defined attributes associated with the spec.
     * The key is the attribute name. It will be of the format:
     * `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $attributes;
    /**
     * Optional. The documentation of the spec.
     * For OpenAPI spec, this will be populated from `externalDocs` in OpenAPI
     * spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Documentation documentation = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $documentation = null;
    /**
     * Optional. Input only. Enum specifying the parsing mode for OpenAPI
     * Specification (OAS) parsing.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Spec.ParsingMode parsing_mode = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $parsing_mode = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the spec.
     *           Format:
     *           `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     *     @type string $display_name
     *           Required. The display name of the spec.
     *           This can contain the file name of the spec.
     *     @type \Google\Cloud\ApiHub\V1\AttributeValues $spec_type
     *           Required. The type of spec.
     *           The value should be one of the allowed values defined for
     *           `projects/{project}/locations/{location}/attributes/system-spec-type`
     *           attribute.
     *           The number of values for this attribute will be based on the
     *           cardinality of the attribute. The same can be retrieved via GetAttribute
     *           API.
     *           Note, this field is mandatory if content is provided.
     *     @type \Google\Cloud\ApiHub\V1\SpecContents $contents
     *           Optional. Input only. The contents of the uploaded spec.
     *     @type \Google\Cloud\ApiHub\V1\SpecDetails $details
     *           Output only. Details parsed from the spec.
     *     @type string $source_uri
     *           Optional. The URI of the spec source in case file is uploaded
     *           from an external version control system.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time at which the spec was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time at which the spec was last updated.
     *     @type \Google\Cloud\ApiHub\V1\LintResponse $lint_response
     *           Optional. The lint response for the spec.
     *     @type array|\Google\Protobuf\Internal\MapField $attributes
     *           Optional. The list of user defined attributes associated with the spec.
     *           The key is the attribute name. It will be of the format:
     *           `projects/{project}/locations/{location}/attributes/{attribute}`.
     *           The value is the attribute values associated with the resource.
     *     @type \Google\Cloud\ApiHub\V1\Documentation $documentation
     *           Optional. The documentation of the spec.
     *           For OpenAPI spec, this will be populated from `externalDocs` in OpenAPI
     *           spec.
     *     @type int $parsing_mode
     *           Optional. Input only. Enum specifying the parsing mode for OpenAPI
     *           Specification (OAS) parsing.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Apihub\V1\CommonFields::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the spec.
     * Format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the spec.
     * Format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The display name of the spec.
     * This can contain the file name of the spec.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The display name of the spec.
     * This can contain the file name of the spec.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Required. The type of spec.
     * The value should be one of the allowed values defined for
     * `projects/{project}/locations/{location}/attributes/system-spec-type`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API.
     * Note, this field is mandatory if content is provided.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues spec_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\ApiHub\V1\AttributeValues|null
     */
    public function getSpecType()
    {
        return $this->spec_type;
    }

    public function hasSpecType()
    {
        return isset($this->spec_type);
    }

    public function clearSpecType()
    {
        unset($this->spec_type);
    }

    /**
     * Required. The type of spec.
     * The value should be one of the allowed values defined for
     * `projects/{project}/locations/{location}/attributes/system-spec-type`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API.
     * Note, this field is mandatory if content is provided.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues spec_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\ApiHub\V1\AttributeValues $var
     * @return $this
     */
    public function setSpecType($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\AttributeValues::class);
        $this->spec_type = $var;

        return $this;
    }

    /**
     * Optional. Input only. The contents of the uploaded spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.SpecContents contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Cloud\ApiHub\V1\SpecContents|null
     */
    public function getContents()
    {
        return $this->contents;
    }

    public function hasContents()
    {
        return isset($this->contents);
    }

    public function clearContents()
    {
        unset($this->contents);
    }

    /**
     * Optional. Input only. The contents of the uploaded spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.SpecContents contents = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Cloud\ApiHub\V1\SpecContents $var
     * @return $this
     */
    public function setContents($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\SpecContents::class);
        $this->contents = $var;

        return $this;
    }

    /**
     * Output only. Details parsed from the spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.SpecDetails details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\ApiHub\V1\SpecDetails|null
     */
    public function getDetails()
    {
        return $this->details;
    }

    public function hasDetails()
    {
        return isset($this->details);
    }

    public function clearDetails()
    {
        unset($this->details);
    }

    /**
     * Output only. Details parsed from the spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.SpecDetails details = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\ApiHub\V1\SpecDetails $var
     * @return $this
     */
    public function setDetails($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\SpecDetails::class);
        $this->details = $var;

        return $this;
    }

    /**
     * Optional. The URI of the spec source in case file is uploaded
     * from an external version control system.
     *
     * Generated from protobuf field <code>string source_uri = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getSourceUri()
    {
        return $this->source_uri;
    }

    /**
     * Optional. The URI of the spec source in case file is uploaded
     * from an external version control system.
     *
     * Generated from protobuf field <code>string source_uri = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setSourceUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_uri = $var;

        return $this;
    }

    /**
     * Output only. The time at which the spec was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time at which the spec was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time at which the spec was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time at which the spec was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. The lint response for the spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.LintResponse lint_response = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\LintResponse|null
     */
    public function getLintResponse()
    {
        return $this->lint_response;
    }

    public function hasLintResponse()
    {
        return isset($this->lint_response);
    }

    public function clearLintResponse()
    {
        unset($this->lint_response);
    }

    /**
     * Optional. The lint response for the spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.LintResponse lint_response = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\LintResponse $var
     * @return $this
     */
    public function setLintResponse($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\LintResponse::class);
        $this->lint_response = $var;

        return $this;
    }

    /**
     * Optional. The list of user defined attributes associated with the spec.
     * The key is the attribute name. It will be of the format:
     * `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Optional. The list of user defined attributes associated with the spec.
     * The key is the attribute name. It will be of the format:
     * `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ApiHub\V1\AttributeValues::class);
        $this->attributes = $arr;

        return $this;
    }

    /**
     * Optional. The documentation of the spec.
     * For OpenAPI spec, this will be populated from `externalDocs` in OpenAPI
     * spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Documentation documentation = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\Documentation|null
     */
    public function getDocumentation()
    {
        return $this->documentation;
    }

    public function hasDocumentation()
    {
        return isset($this->documentation);
    }

    public function clearDocumentation()
    {
        unset($this->documentation);
    }

    /**
     * Optional. The documentation of the spec.
     * For OpenAPI spec, this will be populated from `externalDocs` in OpenAPI
     * spec.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Documentation documentation = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\Documentation $var
     * @return $this
     */
    public function setDocumentation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\Documentation::class);
        $this->documentation = $var;

        return $this;
    }

    /**
     * Optional. Input only. Enum specifying the parsing mode for OpenAPI
     * Specification (OAS) parsing.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Spec.ParsingMode parsing_mode = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return int
     */
    public function getParsingMode()
    {
        return $this->parsing_mode;
    }

    /**
     * Optional. Input only. Enum specifying the parsing mode for OpenAPI
     * Specification (OAS) parsing.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Spec.ParsingMode parsing_mode = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setParsingMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ApiHub\V1\Spec\ParsingMode::class);
        $this->parsing_mode = $var;

        return $this;
    }

}

