<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/datacatalog/v1/datacatalog.proto

namespace Google\Cloud\DataCatalog\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Entry metadata.
 * A Data Catalog entry represents another resource in Google
 * Cloud Platform (such as a BigQuery dataset or a Pub/Sub topic) or
 * outside of it. You can use the `linked_resource` field
 * in the entry resource to refer to the original resource ID of the source
 * system.
 * An entry resource contains resource details, for example, its schema.
 * Additionally, you can attach flexible metadata to an entry in the form of a
 * [Tag][google.cloud.datacatalog.v1.Tag].
 *
 * Generated from protobuf message <code>google.cloud.datacatalog.v1.Entry</code>
 */
class Entry extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of an entry in URL format.
     * Note: The entry itself and its child resources might not be
     * stored in the location specified in its name.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $name = '';
    /**
     * The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the
     * [Full Resource Name]
     * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     * Output only when the entry is one of the types in the `EntryType` enum.
     * For entries with a `user_specified_type`, this field is optional and
     * defaults to an empty string.
     * The resource string must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), periods (.), colons (:), slashes (/), dashes (-),
     * and hashes (#).
     * The maximum size is 200 bytes when encoded in UTF-8.
     *
     * Generated from protobuf field <code>string linked_resource = 9;</code>
     */
    private $linked_resource = '';
    /**
     * Fully qualified name (FQN) of the resource. Set automatically for entries
     * representing resources from synced systems. Settable only during creation
     * and read-only afterwards. Can be used for search and lookup of the entries.
     * FQNs take two forms:
     * * For non-regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * * For regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * Example for a DPMS table:
     * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     *
     * Generated from protobuf field <code>string fully_qualified_name = 29;</code>
     */
    private $fully_qualified_name = '';
    /**
     * Display name of an entry.
     * The maximum size is 500 bytes when encoded in UTF-8.
     * Default value is an empty string.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     */
    private $display_name = '';
    /**
     * Entry description that can consist of several sentences or paragraphs
     * that describe entry contents.
     * The description must not contain Unicode non-characters as well as C0
     * and C1 control codes except tabs (HT), new lines (LF), carriage returns
     * (CR), and page breaks (FF).
     * The maximum size is 2000 bytes when encoded in UTF-8.
     * Default value is an empty string.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     */
    private $description = '';
    /**
     * Business Context of the entry. Not supported for BigQuery datasets
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     */
    private $business_context = null;
    /**
     * Schema of the entry. An entry might not have any schema attached to it.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     */
    private $schema = null;
    /**
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    private $source_system_timestamps = null;
    /**
     * Resource usage statistics.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     */
    private $usage_signal = null;
    /**
     * Cloud labels attached to the entry.
     * In Data Catalog, you can create and modify labels attached only to custom
     * entries. Synced entries have unmodifiable labels that come from the source
     * system.
     *
     * Generated from protobuf field <code>map<string, string> labels = 14;</code>
     */
    private $labels;
    /**
     * Output only. Physical location of the entry.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $data_source = null;
    /**
     * Output only. Additional information related to the entry. Private to the
     * current user.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $personal_details = null;
    protected $entry_type;
    protected $system;
    protected $system_spec;
    protected $type_spec;
    protected $spec;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of an entry in URL format.
     *           Note: The entry itself and its child resources might not be
     *           stored in the location specified in its name.
     *     @type string $linked_resource
     *           The resource this metadata entry refers to.
     *           For Google Cloud Platform resources, `linked_resource` is the
     *           [Full Resource Name]
     *           (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     *           For example, the `linked_resource` for a table resource from BigQuery is:
     *           `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     *           Output only when the entry is one of the types in the `EntryType` enum.
     *           For entries with a `user_specified_type`, this field is optional and
     *           defaults to an empty string.
     *           The resource string must contain only letters (a-z, A-Z), numbers (0-9),
     *           underscores (_), periods (.), colons (:), slashes (/), dashes (-),
     *           and hashes (#).
     *           The maximum size is 200 bytes when encoded in UTF-8.
     *     @type string $fully_qualified_name
     *           Fully qualified name (FQN) of the resource. Set automatically for entries
     *           representing resources from synced systems. Settable only during creation
     *           and read-only afterwards. Can be used for search and lookup of the entries.
     *           FQNs take two forms:
     *           * For non-regionalized resources:
     *             `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *           * For regionalized resources:
     *             `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *           Example for a DPMS table:
     *           `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     *     @type int $type
     *           The type of the entry.
     *           Only used for entries with types listed in the `EntryType` enum.
     *           Currently, only `FILESET` enum value is allowed. All other entries
     *           created in Data Catalog must use the `user_specified_type`.
     *     @type string $user_specified_type
     *           Custom entry type that doesn't match any of the values allowed for input
     *           and listed in the `EntryType` enum.
     *           When creating an entry, first check the type values in the enum.
     *           If there are no appropriate types for the new entry,
     *           provide a custom value, for example, `my_special_type`.
     *           The `user_specified_type` string has the following limitations:
     *           * Is case insensitive.
     *           * Must begin with a letter or underscore.
     *           * Can only contain letters, numbers, and underscores.
     *           * Must be at least 1 character and at most 64 characters long.
     *     @type int $integrated_system
     *           Output only. Indicates the entry's source system that Data Catalog
     *           integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
     *     @type string $user_specified_system
     *           Indicates the entry's source system that Data Catalog doesn't
     *           automatically integrate with.
     *           The `user_specified_system` string has the following limitations:
     *           * Is case insensitive.
     *           * Must begin with a letter or underscore.
     *           * Can only contain letters, numbers, and underscores.
     *           * Must be at least 1 character and at most 64 characters long.
     *     @type \Google\Cloud\DataCatalog\V1\SqlDatabaseSystemSpec $sql_database_system_spec
     *           Specification that applies to a relational database system. Only settable
     *           when `user_specified_system` is equal to `SQL_DATABASE`
     *     @type \Google\Cloud\DataCatalog\V1\LookerSystemSpec $looker_system_spec
     *           Specification that applies to Looker sysstem. Only settable when
     *           `user_specified_system` is equal to `LOOKER`
     *     @type \Google\Cloud\DataCatalog\V1\GcsFilesetSpec $gcs_fileset_spec
     *           Specification that applies to a Cloud Storage fileset. Valid only
     *           for entries with the `FILESET` type.
     *     @type \Google\Cloud\DataCatalog\V1\BigQueryTableSpec $bigquery_table_spec
     *           Output only. Specification that applies to a BigQuery table. Valid only
     *           for entries with the `TABLE` type.
     *     @type \Google\Cloud\DataCatalog\V1\BigQueryDateShardedSpec $bigquery_date_sharded_spec
     *           Output only. Specification for a group of BigQuery tables with
     *           the `[prefix]YYYYMMDD` name pattern.
     *           For more information, see [Introduction to partitioned tables]
     *           (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     *     @type \Google\Cloud\DataCatalog\V1\DatabaseTableSpec $database_table_spec
     *           Specification that applies to a table resource. Valid only
     *           for entries with the `TABLE` or `EXPLORE` type.
     *     @type \Google\Cloud\DataCatalog\V1\DataSourceConnectionSpec $data_source_connection_spec
     *           Specification that applies to a data source connection. Valid only
     *           for entries with the `DATA_SOURCE_CONNECTION` type.
     *     @type \Google\Cloud\DataCatalog\V1\RoutineSpec $routine_spec
     *           Specification that applies to a user-defined function or procedure. Valid
     *           only for entries with the `ROUTINE` type.
     *     @type \Google\Cloud\DataCatalog\V1\FilesetSpec $fileset_spec
     *           Specification that applies to a fileset resource. Valid only
     *           for entries with the `FILESET` type.
     *     @type string $display_name
     *           Display name of an entry.
     *           The maximum size is 500 bytes when encoded in UTF-8.
     *           Default value is an empty string.
     *     @type string $description
     *           Entry description that can consist of several sentences or paragraphs
     *           that describe entry contents.
     *           The description must not contain Unicode non-characters as well as C0
     *           and C1 control codes except tabs (HT), new lines (LF), carriage returns
     *           (CR), and page breaks (FF).
     *           The maximum size is 2000 bytes when encoded in UTF-8.
     *           Default value is an empty string.
     *     @type \Google\Cloud\DataCatalog\V1\BusinessContext $business_context
     *           Business Context of the entry. Not supported for BigQuery datasets
     *     @type \Google\Cloud\DataCatalog\V1\Schema $schema
     *           Schema of the entry. An entry might not have any schema attached to it.
     *     @type \Google\Cloud\DataCatalog\V1\SystemTimestamps $source_system_timestamps
     *           Timestamps from the underlying resource, not from the Data Catalog
     *           entry.
     *           Output only when the entry has a system listed in the `IntegratedSystem`
     *           enum. For entries with `user_specified_system`, this field is optional
     *           and defaults to an empty timestamp.
     *     @type \Google\Cloud\DataCatalog\V1\UsageSignal $usage_signal
     *           Resource usage statistics.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Cloud labels attached to the entry.
     *           In Data Catalog, you can create and modify labels attached only to custom
     *           entries. Synced entries have unmodifiable labels that come from the source
     *           system.
     *     @type \Google\Cloud\DataCatalog\V1\DataSource $data_source
     *           Output only. Physical location of the entry.
     *     @type \Google\Cloud\DataCatalog\V1\PersonalDetails $personal_details
     *           Output only. Additional information related to the entry. Private to the
     *           current user.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Datacatalog\V1\Datacatalog::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of an entry in URL format.
     * Note: The entry itself and its child resources might not be
     * stored in the location specified in its name.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of an entry in URL format.
     * Note: The entry itself and its child resources might not be
     * stored in the location specified in its name.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the
     * [Full Resource Name]
     * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     * Output only when the entry is one of the types in the `EntryType` enum.
     * For entries with a `user_specified_type`, this field is optional and
     * defaults to an empty string.
     * The resource string must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), periods (.), colons (:), slashes (/), dashes (-),
     * and hashes (#).
     * The maximum size is 200 bytes when encoded in UTF-8.
     *
     * Generated from protobuf field <code>string linked_resource = 9;</code>
     * @return string
     */
    public function getLinkedResource()
    {
        return $this->linked_resource;
    }

    /**
     * The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the
     * [Full Resource Name]
     * (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     * Output only when the entry is one of the types in the `EntryType` enum.
     * For entries with a `user_specified_type`, this field is optional and
     * defaults to an empty string.
     * The resource string must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), periods (.), colons (:), slashes (/), dashes (-),
     * and hashes (#).
     * The maximum size is 200 bytes when encoded in UTF-8.
     *
     * Generated from protobuf field <code>string linked_resource = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setLinkedResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->linked_resource = $var;

        return $this;
    }

    /**
     * Fully qualified name (FQN) of the resource. Set automatically for entries
     * representing resources from synced systems. Settable only during creation
     * and read-only afterwards. Can be used for search and lookup of the entries.
     * FQNs take two forms:
     * * For non-regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * * For regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * Example for a DPMS table:
     * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     *
     * Generated from protobuf field <code>string fully_qualified_name = 29;</code>
     * @return string
     */
    public function getFullyQualifiedName()
    {
        return $this->fully_qualified_name;
    }

    /**
     * Fully qualified name (FQN) of the resource. Set automatically for entries
     * representing resources from synced systems. Settable only during creation
     * and read-only afterwards. Can be used for search and lookup of the entries.
     * FQNs take two forms:
     * * For non-regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * * For regionalized resources:
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     * Example for a DPMS table:
     * `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     *
     * Generated from protobuf field <code>string fully_qualified_name = 29;</code>
     * @param string $var
     * @return $this
     */
    public function setFullyQualifiedName($var)
    {
        GPBUtil::checkString($var, True);
        $this->fully_qualified_name = $var;

        return $this;
    }

    /**
     * The type of the entry.
     * Only used for entries with types listed in the `EntryType` enum.
     * Currently, only `FILESET` enum value is allowed. All other entries
     * created in Data Catalog must use the `user_specified_type`.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.EntryType type = 2;</code>
     * @return int
     */
    public function getType()
    {
        return $this->readOneof(2);
    }

    public function hasType()
    {
        return $this->hasOneof(2);
    }

    /**
     * The type of the entry.
     * Only used for entries with types listed in the `EntryType` enum.
     * Currently, only `FILESET` enum value is allowed. All other entries
     * created in Data Catalog must use the `user_specified_type`.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.EntryType type = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DataCatalog\V1\EntryType::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Custom entry type that doesn't match any of the values allowed for input
     * and listed in the `EntryType` enum.
     * When creating an entry, first check the type values in the enum.
     * If there are no appropriate types for the new entry,
     * provide a custom value, for example, `my_special_type`.
     * The `user_specified_type` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     *
     * Generated from protobuf field <code>string user_specified_type = 16;</code>
     * @return string
     */
    public function getUserSpecifiedType()
    {
        return $this->readOneof(16);
    }

    public function hasUserSpecifiedType()
    {
        return $this->hasOneof(16);
    }

    /**
     * Custom entry type that doesn't match any of the values allowed for input
     * and listed in the `EntryType` enum.
     * When creating an entry, first check the type values in the enum.
     * If there are no appropriate types for the new entry,
     * provide a custom value, for example, `my_special_type`.
     * The `user_specified_type` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     *
     * Generated from protobuf field <code>string user_specified_type = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setUserSpecifiedType($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(16, $var);

        return $this;
    }

    /**
     * Output only. Indicates the entry's source system that Data Catalog
     * integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getIntegratedSystem()
    {
        return $this->readOneof(17);
    }

    public function hasIntegratedSystem()
    {
        return $this->hasOneof(17);
    }

    /**
     * Output only. Indicates the entry's source system that Data Catalog
     * integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setIntegratedSystem($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DataCatalog\V1\IntegratedSystem::class);
        $this->writeOneof(17, $var);

        return $this;
    }

    /**
     * Indicates the entry's source system that Data Catalog doesn't
     * automatically integrate with.
     * The `user_specified_system` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     *
     * Generated from protobuf field <code>string user_specified_system = 18;</code>
     * @return string
     */
    public function getUserSpecifiedSystem()
    {
        return $this->readOneof(18);
    }

    public function hasUserSpecifiedSystem()
    {
        return $this->hasOneof(18);
    }

    /**
     * Indicates the entry's source system that Data Catalog doesn't
     * automatically integrate with.
     * The `user_specified_system` string has the following limitations:
     * * Is case insensitive.
     * * Must begin with a letter or underscore.
     * * Can only contain letters, numbers, and underscores.
     * * Must be at least 1 character and at most 64 characters long.
     *
     * Generated from protobuf field <code>string user_specified_system = 18;</code>
     * @param string $var
     * @return $this
     */
    public function setUserSpecifiedSystem($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(18, $var);

        return $this;
    }

    /**
     * Specification that applies to a relational database system. Only settable
     * when `user_specified_system` is equal to `SQL_DATABASE`
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;</code>
     * @return \Google\Cloud\DataCatalog\V1\SqlDatabaseSystemSpec|null
     */
    public function getSqlDatabaseSystemSpec()
    {
        return $this->readOneof(39);
    }

    public function hasSqlDatabaseSystemSpec()
    {
        return $this->hasOneof(39);
    }

    /**
     * Specification that applies to a relational database system. Only settable
     * when `user_specified_system` is equal to `SQL_DATABASE`
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.SqlDatabaseSystemSpec sql_database_system_spec = 39;</code>
     * @param \Google\Cloud\DataCatalog\V1\SqlDatabaseSystemSpec $var
     * @return $this
     */
    public function setSqlDatabaseSystemSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\SqlDatabaseSystemSpec::class);
        $this->writeOneof(39, $var);

        return $this;
    }

    /**
     * Specification that applies to Looker sysstem. Only settable when
     * `user_specified_system` is equal to `LOOKER`
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
     * @return \Google\Cloud\DataCatalog\V1\LookerSystemSpec|null
     */
    public function getLookerSystemSpec()
    {
        return $this->readOneof(40);
    }

    public function hasLookerSystemSpec()
    {
        return $this->hasOneof(40);
    }

    /**
     * Specification that applies to Looker sysstem. Only settable when
     * `user_specified_system` is equal to `LOOKER`
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.LookerSystemSpec looker_system_spec = 40;</code>
     * @param \Google\Cloud\DataCatalog\V1\LookerSystemSpec $var
     * @return $this
     */
    public function setLookerSystemSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\LookerSystemSpec::class);
        $this->writeOneof(40, $var);

        return $this;
    }

    /**
     * Specification that applies to a Cloud Storage fileset. Valid only
     * for entries with the `FILESET` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     * @return \Google\Cloud\DataCatalog\V1\GcsFilesetSpec|null
     */
    public function getGcsFilesetSpec()
    {
        return $this->readOneof(6);
    }

    public function hasGcsFilesetSpec()
    {
        return $this->hasOneof(6);
    }

    /**
     * Specification that applies to a Cloud Storage fileset. Valid only
     * for entries with the `FILESET` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     * @param \Google\Cloud\DataCatalog\V1\GcsFilesetSpec $var
     * @return $this
     */
    public function setGcsFilesetSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\GcsFilesetSpec::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Output only. Specification that applies to a BigQuery table. Valid only
     * for entries with the `TABLE` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\DataCatalog\V1\BigQueryTableSpec|null
     */
    public function getBigqueryTableSpec()
    {
        return $this->readOneof(12);
    }

    public function hasBigqueryTableSpec()
    {
        return $this->hasOneof(12);
    }

    /**
     * Output only. Specification that applies to a BigQuery table. Valid only
     * for entries with the `TABLE` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.BigQueryTableSpec bigquery_table_spec = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\DataCatalog\V1\BigQueryTableSpec $var
     * @return $this
     */
    public function setBigqueryTableSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\BigQueryTableSpec::class);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * Output only. Specification for a group of BigQuery tables with
     * the `[prefix]YYYYMMDD` name pattern.
     * For more information, see [Introduction to partitioned tables]
     * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\DataCatalog\V1\BigQueryDateShardedSpec|null
     */
    public function getBigqueryDateShardedSpec()
    {
        return $this->readOneof(15);
    }

    public function hasBigqueryDateShardedSpec()
    {
        return $this->hasOneof(15);
    }

    /**
     * Output only. Specification for a group of BigQuery tables with
     * the `[prefix]YYYYMMDD` name pattern.
     * For more information, see [Introduction to partitioned tables]
     * (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\DataCatalog\V1\BigQueryDateShardedSpec $var
     * @return $this
     */
    public function setBigqueryDateShardedSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\BigQueryDateShardedSpec::class);
        $this->writeOneof(15, $var);

        return $this;
    }

    /**
     * Specification that applies to a table resource. Valid only
     * for entries with the `TABLE` or `EXPLORE` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
     * @return \Google\Cloud\DataCatalog\V1\DatabaseTableSpec|null
     */
    public function getDatabaseTableSpec()
    {
        return $this->readOneof(24);
    }

    public function hasDatabaseTableSpec()
    {
        return $this->hasOneof(24);
    }

    /**
     * Specification that applies to a table resource. Valid only
     * for entries with the `TABLE` or `EXPLORE` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.DatabaseTableSpec database_table_spec = 24;</code>
     * @param \Google\Cloud\DataCatalog\V1\DatabaseTableSpec $var
     * @return $this
     */
    public function setDatabaseTableSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\DatabaseTableSpec::class);
        $this->writeOneof(24, $var);

        return $this;
    }

    /**
     * Specification that applies to a data source connection. Valid only
     * for entries with the `DATA_SOURCE_CONNECTION` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;</code>
     * @return \Google\Cloud\DataCatalog\V1\DataSourceConnectionSpec|null
     */
    public function getDataSourceConnectionSpec()
    {
        return $this->readOneof(27);
    }

    public function hasDataSourceConnectionSpec()
    {
        return $this->hasOneof(27);
    }

    /**
     * Specification that applies to a data source connection. Valid only
     * for entries with the `DATA_SOURCE_CONNECTION` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.DataSourceConnectionSpec data_source_connection_spec = 27;</code>
     * @param \Google\Cloud\DataCatalog\V1\DataSourceConnectionSpec $var
     * @return $this
     */
    public function setDataSourceConnectionSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\DataSourceConnectionSpec::class);
        $this->writeOneof(27, $var);

        return $this;
    }

    /**
     * Specification that applies to a user-defined function or procedure. Valid
     * only for entries with the `ROUTINE` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
     * @return \Google\Cloud\DataCatalog\V1\RoutineSpec|null
     */
    public function getRoutineSpec()
    {
        return $this->readOneof(28);
    }

    public function hasRoutineSpec()
    {
        return $this->hasOneof(28);
    }

    /**
     * Specification that applies to a user-defined function or procedure. Valid
     * only for entries with the `ROUTINE` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.RoutineSpec routine_spec = 28;</code>
     * @param \Google\Cloud\DataCatalog\V1\RoutineSpec $var
     * @return $this
     */
    public function setRoutineSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\RoutineSpec::class);
        $this->writeOneof(28, $var);

        return $this;
    }

    /**
     * Specification that applies to a fileset resource. Valid only
     * for entries with the `FILESET` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
     * @return \Google\Cloud\DataCatalog\V1\FilesetSpec|null
     */
    public function getFilesetSpec()
    {
        return $this->readOneof(33);
    }

    public function hasFilesetSpec()
    {
        return $this->hasOneof(33);
    }

    /**
     * Specification that applies to a fileset resource. Valid only
     * for entries with the `FILESET` type.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.FilesetSpec fileset_spec = 33;</code>
     * @param \Google\Cloud\DataCatalog\V1\FilesetSpec $var
     * @return $this
     */
    public function setFilesetSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\FilesetSpec::class);
        $this->writeOneof(33, $var);

        return $this;
    }

    /**
     * Display name of an entry.
     * The maximum size is 500 bytes when encoded in UTF-8.
     * Default value is an empty string.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Display name of an entry.
     * The maximum size is 500 bytes when encoded in UTF-8.
     * Default value is an empty string.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Entry description that can consist of several sentences or paragraphs
     * that describe entry contents.
     * The description must not contain Unicode non-characters as well as C0
     * and C1 control codes except tabs (HT), new lines (LF), carriage returns
     * (CR), and page breaks (FF).
     * The maximum size is 2000 bytes when encoded in UTF-8.
     * Default value is an empty string.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Entry description that can consist of several sentences or paragraphs
     * that describe entry contents.
     * The description must not contain Unicode non-characters as well as C0
     * and C1 control codes except tabs (HT), new lines (LF), carriage returns
     * (CR), and page breaks (FF).
     * The maximum size is 2000 bytes when encoded in UTF-8.
     * Default value is an empty string.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Business Context of the entry. Not supported for BigQuery datasets
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     * @return \Google\Cloud\DataCatalog\V1\BusinessContext|null
     */
    public function getBusinessContext()
    {
        return $this->business_context;
    }

    public function hasBusinessContext()
    {
        return isset($this->business_context);
    }

    public function clearBusinessContext()
    {
        unset($this->business_context);
    }

    /**
     * Business Context of the entry. Not supported for BigQuery datasets
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.BusinessContext business_context = 37;</code>
     * @param \Google\Cloud\DataCatalog\V1\BusinessContext $var
     * @return $this
     */
    public function setBusinessContext($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\BusinessContext::class);
        $this->business_context = $var;

        return $this;
    }

    /**
     * Schema of the entry. An entry might not have any schema attached to it.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     * @return \Google\Cloud\DataCatalog\V1\Schema|null
     */
    public function getSchema()
    {
        return $this->schema;
    }

    public function hasSchema()
    {
        return isset($this->schema);
    }

    public function clearSchema()
    {
        unset($this->schema);
    }

    /**
     * Schema of the entry. An entry might not have any schema attached to it.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.Schema schema = 5;</code>
     * @param \Google\Cloud\DataCatalog\V1\Schema $var
     * @return $this
     */
    public function setSchema($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\Schema::class);
        $this->schema = $var;

        return $this;
    }

    /**
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     * @return \Google\Cloud\DataCatalog\V1\SystemTimestamps|null
     */
    public function getSourceSystemTimestamps()
    {
        return $this->source_system_timestamps;
    }

    public function hasSourceSystemTimestamps()
    {
        return isset($this->source_system_timestamps);
    }

    public function clearSourceSystemTimestamps()
    {
        unset($this->source_system_timestamps);
    }

    /**
     * Timestamps from the underlying resource, not from the Data Catalog
     * entry.
     * Output only when the entry has a system listed in the `IntegratedSystem`
     * enum. For entries with `user_specified_system`, this field is optional
     * and defaults to an empty timestamp.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.SystemTimestamps source_system_timestamps = 7;</code>
     * @param \Google\Cloud\DataCatalog\V1\SystemTimestamps $var
     * @return $this
     */
    public function setSourceSystemTimestamps($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\SystemTimestamps::class);
        $this->source_system_timestamps = $var;

        return $this;
    }

    /**
     * Resource usage statistics.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     * @return \Google\Cloud\DataCatalog\V1\UsageSignal|null
     */
    public function getUsageSignal()
    {
        return $this->usage_signal;
    }

    public function hasUsageSignal()
    {
        return isset($this->usage_signal);
    }

    public function clearUsageSignal()
    {
        unset($this->usage_signal);
    }

    /**
     * Resource usage statistics.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.UsageSignal usage_signal = 13;</code>
     * @param \Google\Cloud\DataCatalog\V1\UsageSignal $var
     * @return $this
     */
    public function setUsageSignal($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\UsageSignal::class);
        $this->usage_signal = $var;

        return $this;
    }

    /**
     * Cloud labels attached to the entry.
     * In Data Catalog, you can create and modify labels attached only to custom
     * entries. Synced entries have unmodifiable labels that come from the source
     * system.
     *
     * Generated from protobuf field <code>map<string, string> labels = 14;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Cloud labels attached to the entry.
     * In Data Catalog, you can create and modify labels attached only to custom
     * entries. Synced entries have unmodifiable labels that come from the source
     * system.
     *
     * Generated from protobuf field <code>map<string, string> labels = 14;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. Physical location of the entry.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\DataCatalog\V1\DataSource|null
     */
    public function getDataSource()
    {
        return $this->data_source;
    }

    public function hasDataSource()
    {
        return isset($this->data_source);
    }

    public function clearDataSource()
    {
        unset($this->data_source);
    }

    /**
     * Output only. Physical location of the entry.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.DataSource data_source = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\DataCatalog\V1\DataSource $var
     * @return $this
     */
    public function setDataSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\DataSource::class);
        $this->data_source = $var;

        return $this;
    }

    /**
     * Output only. Additional information related to the entry. Private to the
     * current user.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\DataCatalog\V1\PersonalDetails|null
     */
    public function getPersonalDetails()
    {
        return $this->personal_details;
    }

    public function hasPersonalDetails()
    {
        return isset($this->personal_details);
    }

    public function clearPersonalDetails()
    {
        unset($this->personal_details);
    }

    /**
     * Output only. Additional information related to the entry. Private to the
     * current user.
     *
     * Generated from protobuf field <code>.google.cloud.datacatalog.v1.PersonalDetails personal_details = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\DataCatalog\V1\PersonalDetails $var
     * @return $this
     */
    public function setPersonalDetails($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DataCatalog\V1\PersonalDetails::class);
        $this->personal_details = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getEntryType()
    {
        return $this->whichOneof("entry_type");
    }

    /**
     * @return string
     */
    public function getSystem()
    {
        return $this->whichOneof("system");
    }

    /**
     * @return string
     */
    public function getSystemSpec()
    {
        return $this->whichOneof("system_spec");
    }

    /**
     * @return string
     */
    public function getTypeSpec()
    {
        return $this->whichOneof("type_spec");
    }

    /**
     * @return string
     */
    public function getSpec()
    {
        return $this->whichOneof("spec");
    }

}

