<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/bigquery/analyticshub/v1/analyticshub.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\BigQuery\AnalyticsHub\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\BigQuery\AnalyticsHub\V1\CreateDataExchangeRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\CreateListingRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\DataExchange;
use Google\Cloud\BigQuery\AnalyticsHub\V1\DeleteDataExchangeRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\DeleteListingRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\DestinationDataset;
use Google\Cloud\BigQuery\AnalyticsHub\V1\GetDataExchangeRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\GetListingRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListDataExchangesRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListDataExchangesResponse;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListListingsRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListListingsResponse;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListOrgDataExchangesRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListOrgDataExchangesResponse;
use Google\Cloud\BigQuery\AnalyticsHub\V1\Listing;
use Google\Cloud\BigQuery\AnalyticsHub\V1\SubscribeListingRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\SubscribeListingResponse;
use Google\Cloud\BigQuery\AnalyticsHub\V1\UpdateDataExchangeRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\UpdateListingRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: The `AnalyticsHubService` API facilitates data sharing within and across
 * organizations. It allows data providers to publish listings that reference
 * shared datasets. With Analytics Hub, users can discover and search for
 * listings that they have access to. Subscribers can view and subscribe to
 * listings. When you subscribe to a listing, Analytics Hub creates a linked
 * dataset in your project.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
 * try {
 *     $formattedParent = $analyticsHubServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $dataExchangeId = 'data_exchange_id';
 *     $dataExchange = new DataExchange();
 *     $response = $analyticsHubServiceClient->createDataExchange($formattedParent, $dataExchangeId, $dataExchange);
 * } finally {
 *     $analyticsHubServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class AnalyticsHubServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.bigquery.analyticshub.v1.AnalyticsHubService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'analyticshub.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/bigquery',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $dataExchangeNameTemplate;

    private static $listingNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/analytics_hub_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/analytics_hub_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/analytics_hub_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/analytics_hub_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getDataExchangeNameTemplate()
    {
        if (self::$dataExchangeNameTemplate == null) {
            self::$dataExchangeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/dataExchanges/{data_exchange}'
            );
        }

        return self::$dataExchangeNameTemplate;
    }

    private static function getListingNameTemplate()
    {
        if (self::$listingNameTemplate == null) {
            self::$listingNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/dataExchanges/{data_exchange}/listings/{listing}'
            );
        }

        return self::$listingNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'dataExchange' => self::getDataExchangeNameTemplate(),
                'listing' => self::getListingNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_exchange resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataExchange
     *
     * @return string The formatted data_exchange resource.
     */
    public static function dataExchangeName($project, $location, $dataExchange)
    {
        return self::getDataExchangeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'data_exchange' => $dataExchange,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a listing
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataExchange
     * @param string $listing
     *
     * @return string The formatted listing resource.
     */
    public static function listingName(
        $project,
        $location,
        $dataExchange,
        $listing
    ) {
        return self::getListingNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'data_exchange' => $dataExchange,
            'listing' => $listing,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - dataExchange: projects/{project}/locations/{location}/dataExchanges/{data_exchange}
     * - listing: projects/{project}/locations/{location}/dataExchanges/{data_exchange}/listings/{listing}
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'analyticshub.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Creates a new data exchange.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $formattedParent = $analyticsHubServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $dataExchangeId = 'data_exchange_id';
     *     $dataExchange = new DataExchange();
     *     $response = $analyticsHubServiceClient->createDataExchange($formattedParent, $dataExchangeId, $dataExchange);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string       $parent         Required. The parent resource path of the data exchange.
     *                                     e.g. `projects/myproject/locations/US`.
     * @param string       $dataExchangeId Required. The ID of the data exchange.
     *                                     Must contain only Unicode letters, numbers (0-9), underscores (_).
     *                                     Should not use characters that require URL-escaping, or characters
     *                                     outside of ASCII, spaces.
     *                                     Max length: 100 bytes.
     * @param DataExchange $dataExchange   Required. The data exchange to create.
     * @param array        $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\AnalyticsHub\V1\DataExchange
     *
     * @throws ApiException if the remote call fails
     */
    public function createDataExchange(
        $parent,
        $dataExchangeId,
        $dataExchange,
        array $optionalArgs = []
    ) {
        $request = new CreateDataExchangeRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDataExchangeId($dataExchangeId);
        $request->setDataExchange($dataExchange);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateDataExchange',
            DataExchange::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a new listing.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $formattedParent = $analyticsHubServiceClient->dataExchangeName('[PROJECT]', '[LOCATION]', '[DATA_EXCHANGE]');
     *     $listingId = 'listing_id';
     *     $listing = new Listing();
     *     $response = $analyticsHubServiceClient->createListing($formattedParent, $listingId, $listing);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The parent resource path of the listing.
     *                              e.g. `projects/myproject/locations/US/dataExchanges/123`.
     * @param string  $listingId    Required. The ID of the listing to create.
     *                              Must contain only Unicode letters, numbers (0-9), underscores (_).
     *                              Should not use characters that require URL-escaping, or characters
     *                              outside of ASCII, spaces.
     *                              Max length: 100 bytes.
     * @param Listing $listing      Required. The listing to create.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\AnalyticsHub\V1\Listing
     *
     * @throws ApiException if the remote call fails
     */
    public function createListing(
        $parent,
        $listingId,
        $listing,
        array $optionalArgs = []
    ) {
        $request = new CreateListingRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setListingId($listingId);
        $request->setListing($listing);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateListing',
            Listing::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes an existing data exchange.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $formattedName = $analyticsHubServiceClient->dataExchangeName('[PROJECT]', '[LOCATION]', '[DATA_EXCHANGE]');
     *     $analyticsHubServiceClient->deleteDataExchange($formattedName);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The full name of the data exchange resource that you want to delete.
     *                             For example, `projects/myproject/locations/US/dataExchanges/123`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDataExchange($name, array $optionalArgs = [])
    {
        $request = new DeleteDataExchangeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteDataExchange',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a listing.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $formattedName = $analyticsHubServiceClient->listingName('[PROJECT]', '[LOCATION]', '[DATA_EXCHANGE]', '[LISTING]');
     *     $analyticsHubServiceClient->deleteListing($formattedName);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the listing to delete.
     *                             e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteListing($name, array $optionalArgs = [])
    {
        $request = new DeleteListingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteListing',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets the details of a data exchange.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $formattedName = $analyticsHubServiceClient->dataExchangeName('[PROJECT]', '[LOCATION]', '[DATA_EXCHANGE]');
     *     $response = $analyticsHubServiceClient->getDataExchange($formattedName);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the data exchange.
     *                             e.g. `projects/myproject/locations/US/dataExchanges/123`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\AnalyticsHub\V1\DataExchange
     *
     * @throws ApiException if the remote call fails
     */
    public function getDataExchange($name, array $optionalArgs = [])
    {
        $request = new GetDataExchangeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDataExchange',
            DataExchange::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets the IAM policy.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $analyticsHubServiceClient->getIamPolicy($resource);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets the details of a listing.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $formattedName = $analyticsHubServiceClient->listingName('[PROJECT]', '[LOCATION]', '[DATA_EXCHANGE]', '[LISTING]');
     *     $response = $analyticsHubServiceClient->getListing($formattedName);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the listing.
     *                             e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\AnalyticsHub\V1\Listing
     *
     * @throws ApiException if the remote call fails
     */
    public function getListing($name, array $optionalArgs = [])
    {
        $request = new GetListingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetListing',
            Listing::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists all data exchanges in a given project and location.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $formattedParent = $analyticsHubServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsHubServiceClient->listDataExchanges($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsHubServiceClient->listDataExchanges($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource path of the data exchanges.
     *                             e.g. `projects/myproject/locations/US`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDataExchanges($parent, array $optionalArgs = [])
    {
        $request = new ListDataExchangesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListDataExchanges',
            $optionalArgs,
            ListDataExchangesResponse::class,
            $request
        );
    }

    /**
     * Lists all listings in a given project and location.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $formattedParent = $analyticsHubServiceClient->dataExchangeName('[PROJECT]', '[LOCATION]', '[DATA_EXCHANGE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsHubServiceClient->listListings($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsHubServiceClient->listListings($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource path of the listing.
     *                             e.g. `projects/myproject/locations/US/dataExchanges/123`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listListings($parent, array $optionalArgs = [])
    {
        $request = new ListListingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListListings',
            $optionalArgs,
            ListListingsResponse::class,
            $request
        );
    }

    /**
     * Lists all data exchanges from projects in a given organization and
     * location.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $organization = 'organization';
     *     // Iterate over pages of elements
     *     $pagedResponse = $analyticsHubServiceClient->listOrgDataExchanges($organization);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $analyticsHubServiceClient->listOrgDataExchanges($organization);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string $organization Required. The organization resource path of the projects containing DataExchanges.
     *                             e.g. `organizations/myorg/locations/US`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listOrgDataExchanges(
        $organization,
        array $optionalArgs = []
    ) {
        $request = new ListOrgDataExchangesRequest();
        $requestParamHeaders = [];
        $request->setOrganization($organization);
        $requestParamHeaders['organization'] = $organization;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListOrgDataExchanges',
            $optionalArgs,
            ListOrgDataExchangesResponse::class,
            $request
        );
    }

    /**
     * Sets the IAM policy.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $analyticsHubServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Subscribes to a listing.
     *
     * Currently, with Analytics Hub, you can create listings that
     * reference only BigQuery datasets.
     * Upon subscription to a listing for a BigQuery dataset, Analytics Hub
     * creates a linked dataset in the subscriber's project.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $formattedName = $analyticsHubServiceClient->listingName('[PROJECT]', '[LOCATION]', '[DATA_EXCHANGE]', '[LISTING]');
     *     $response = $analyticsHubServiceClient->subscribeListing($formattedName);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the listing that you want to subscribe to.
     *                             e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type DestinationDataset $destinationDataset
     *           BigQuery destination dataset to create for the subscriber.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\AnalyticsHub\V1\SubscribeListingResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function subscribeListing($name, array $optionalArgs = [])
    {
        $request = new SubscribeListingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['destinationDataset'])) {
            $request->setDestinationDataset(
                $optionalArgs['destinationDataset']
            );
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SubscribeListing',
            SubscribeListingResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the permissions that a caller has.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $analyticsHubServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates an existing data exchange.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $dataExchange = new DataExchange();
     *     $response = $analyticsHubServiceClient->updateDataExchange($updateMask, $dataExchange);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask    $updateMask   Required. Field mask specifies the fields to update in the data exchange
     *                                   resource. The fields specified in the
     *                                   `updateMask` are relative to the resource and are not a full request.
     * @param DataExchange $dataExchange Required. The data exchange to update.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\AnalyticsHub\V1\DataExchange
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDataExchange(
        $updateMask,
        $dataExchange,
        array $optionalArgs = []
    ) {
        $request = new UpdateDataExchangeRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setDataExchange($dataExchange);
        $requestParamHeaders['data_exchange.name'] = $dataExchange->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateDataExchange',
            DataExchange::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates an existing listing.
     *
     * Sample code:
     * ```
     * $analyticsHubServiceClient = new AnalyticsHubServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $listing = new Listing();
     *     $response = $analyticsHubServiceClient->updateListing($updateMask, $listing);
     * } finally {
     *     $analyticsHubServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Field mask specifies the fields to update in the listing resource. The
     *                                fields specified in the `updateMask` are relative to the resource and are
     *                                not a full request.
     * @param Listing   $listing      Required. The listing to update.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BigQuery\AnalyticsHub\V1\Listing
     *
     * @throws ApiException if the remote call fails
     */
    public function updateListing(
        $updateMask,
        $listing,
        array $optionalArgs = []
    ) {
        $request = new UpdateListingRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setListing($listing);
        $requestParamHeaders['listing.name'] = $listing->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateListing',
            Listing::class,
            $optionalArgs,
            $request
        )->wait();
    }
}
