<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto

namespace Google\Cloud\PrivilegedAccessManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message for creating an entitlement.
 *
 * Generated from protobuf message <code>google.cloud.privilegedaccessmanager.v1.CreateEntitlementRequest</code>
 */
class CreateEntitlementRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Name of the parent resource for the entitlement.
     * Possible formats:
     * * `organizations/{organization-number}/locations/{region}`
     * * `folders/{folder-number}/locations/{region}`
     * * `projects/{project-id|project-number}/locations/{region}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The ID to use for this entitlement. This becomes the last part of
     * the resource name.
     * This value should be 4-63 characters in length, and valid characters are
     * "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
     * This value should be unique among all other entitlements under the
     * specified `parent`.
     *
     * Generated from protobuf field <code>string entitlement_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $entitlement_id = '';
    /**
     * Required. The resource being created
     *
     * Generated from protobuf field <code>.google.cloud.privilegedaccessmanager.v1.Entitlement entitlement = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $entitlement = null;
    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server knows to
     * ignore the request if it has already been completed. The server guarantees
     * this for at least 60 minutes after the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, ignores the second request and returns the
     * previous operation's response. This prevents clients from accidentally
     * creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $request_id = '';

    /**
     * @param string                                               $parent        Required. Name of the parent resource for the entitlement.
     *                                                                            Possible formats:
     *
     *                                                                            * `organizations/{organization-number}/locations/{region}`
     *                                                                            * `folders/{folder-number}/locations/{region}`
     *                                                                            * `projects/{project-id|project-number}/locations/{region}`
     *                                                                            Please see {@see PrivilegedAccessManagerClient::organizationLocationName()} for help formatting this field.
     * @param \Google\Cloud\PrivilegedAccessManager\V1\Entitlement $entitlement   Required. The resource being created
     * @param string                                               $entitlementId Required. The ID to use for this entitlement. This becomes the last part of
     *                                                                            the resource name.
     *
     *                                                                            This value should be 4-63 characters in length, and valid characters are
     *                                                                            "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
     *
     *                                                                            This value should be unique among all other entitlements under the
     *                                                                            specified `parent`.
     *
     * @return \Google\Cloud\PrivilegedAccessManager\V1\CreateEntitlementRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\PrivilegedAccessManager\V1\Entitlement $entitlement, string $entitlementId): self
    {
        return (new self())
            ->setParent($parent)
            ->setEntitlement($entitlement)
            ->setEntitlementId($entitlementId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. Name of the parent resource for the entitlement.
     *           Possible formats:
     *           * `organizations/{organization-number}/locations/{region}`
     *           * `folders/{folder-number}/locations/{region}`
     *           * `projects/{project-id|project-number}/locations/{region}`
     *     @type string $entitlement_id
     *           Required. The ID to use for this entitlement. This becomes the last part of
     *           the resource name.
     *           This value should be 4-63 characters in length, and valid characters are
     *           "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
     *           This value should be unique among all other entitlements under the
     *           specified `parent`.
     *     @type \Google\Cloud\PrivilegedAccessManager\V1\Entitlement $entitlement
     *           Required. The resource being created
     *     @type string $request_id
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server knows to
     *           ignore the request if it has already been completed. The server guarantees
     *           this for at least 60 minutes after the first request.
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, ignores the second request and returns the
     *           previous operation's response. This prevents clients from accidentally
     *           creating duplicate commitments.
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Privilegedaccessmanager\V1\Privilegedaccessmanager::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Name of the parent resource for the entitlement.
     * Possible formats:
     * * `organizations/{organization-number}/locations/{region}`
     * * `folders/{folder-number}/locations/{region}`
     * * `projects/{project-id|project-number}/locations/{region}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. Name of the parent resource for the entitlement.
     * Possible formats:
     * * `organizations/{organization-number}/locations/{region}`
     * * `folders/{folder-number}/locations/{region}`
     * * `projects/{project-id|project-number}/locations/{region}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The ID to use for this entitlement. This becomes the last part of
     * the resource name.
     * This value should be 4-63 characters in length, and valid characters are
     * "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
     * This value should be unique among all other entitlements under the
     * specified `parent`.
     *
     * Generated from protobuf field <code>string entitlement_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getEntitlementId()
    {
        return $this->entitlement_id;
    }

    /**
     * Required. The ID to use for this entitlement. This becomes the last part of
     * the resource name.
     * This value should be 4-63 characters in length, and valid characters are
     * "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
     * This value should be unique among all other entitlements under the
     * specified `parent`.
     *
     * Generated from protobuf field <code>string entitlement_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setEntitlementId($var)
    {
        GPBUtil::checkString($var, True);
        $this->entitlement_id = $var;

        return $this;
    }

    /**
     * Required. The resource being created
     *
     * Generated from protobuf field <code>.google.cloud.privilegedaccessmanager.v1.Entitlement entitlement = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\PrivilegedAccessManager\V1\Entitlement|null
     */
    public function getEntitlement()
    {
        return $this->entitlement;
    }

    public function hasEntitlement()
    {
        return isset($this->entitlement);
    }

    public function clearEntitlement()
    {
        unset($this->entitlement);
    }

    /**
     * Required. The resource being created
     *
     * Generated from protobuf field <code>.google.cloud.privilegedaccessmanager.v1.Entitlement entitlement = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\PrivilegedAccessManager\V1\Entitlement $var
     * @return $this
     */
    public function setEntitlement($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PrivilegedAccessManager\V1\Entitlement::class);
        $this->entitlement = $var;

        return $this;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server knows to
     * ignore the request if it has already been completed. The server guarantees
     * this for at least 60 minutes after the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, ignores the second request and returns the
     * previous operation's response. This prevents clients from accidentally
     * creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server knows to
     * ignore the request if it has already been completed. The server guarantees
     * this for at least 60 minutes after the first request.
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, ignores the second request and returns the
     * previous operation's response. This prevents clients from accidentally
     * creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

}

