<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/config/v1/config.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Config\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Config\V1\CreateDeploymentRequest;
use Google\Cloud\Config\V1\CreatePreviewRequest;
use Google\Cloud\Config\V1\DeleteDeploymentRequest;
use Google\Cloud\Config\V1\DeletePreviewRequest;
use Google\Cloud\Config\V1\DeleteStatefileRequest;
use Google\Cloud\Config\V1\Deployment;
use Google\Cloud\Config\V1\ExportDeploymentStatefileRequest;
use Google\Cloud\Config\V1\ExportLockInfoRequest;
use Google\Cloud\Config\V1\ExportPreviewResultRequest;
use Google\Cloud\Config\V1\ExportPreviewResultResponse;
use Google\Cloud\Config\V1\ExportRevisionStatefileRequest;
use Google\Cloud\Config\V1\GetDeploymentRequest;
use Google\Cloud\Config\V1\GetPreviewRequest;
use Google\Cloud\Config\V1\GetResourceRequest;
use Google\Cloud\Config\V1\GetRevisionRequest;
use Google\Cloud\Config\V1\GetTerraformVersionRequest;
use Google\Cloud\Config\V1\ImportStatefileRequest;
use Google\Cloud\Config\V1\ListDeploymentsRequest;
use Google\Cloud\Config\V1\ListPreviewsRequest;
use Google\Cloud\Config\V1\ListResourcesRequest;
use Google\Cloud\Config\V1\ListRevisionsRequest;
use Google\Cloud\Config\V1\ListTerraformVersionsRequest;
use Google\Cloud\Config\V1\LockDeploymentRequest;
use Google\Cloud\Config\V1\LockInfo;
use Google\Cloud\Config\V1\Preview;
use Google\Cloud\Config\V1\Resource;
use Google\Cloud\Config\V1\Revision;
use Google\Cloud\Config\V1\Statefile;
use Google\Cloud\Config\V1\TerraformVersion;
use Google\Cloud\Config\V1\UnlockDeploymentRequest;
use Google\Cloud\Config\V1\UpdateDeploymentRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Infrastructure Manager is a managed service that automates the deployment and
 * management of Google Cloud infrastructure resources.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface createDeploymentAsync(CreateDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createPreviewAsync(CreatePreviewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteDeploymentAsync(DeleteDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePreviewAsync(DeletePreviewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteStatefileAsync(DeleteStatefileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface exportDeploymentStatefileAsync(ExportDeploymentStatefileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface exportLockInfoAsync(ExportLockInfoRequest $request, array $optionalArgs = [])
 * @method PromiseInterface exportPreviewResultAsync(ExportPreviewResultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface exportRevisionStatefileAsync(ExportRevisionStatefileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDeploymentAsync(GetDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPreviewAsync(GetPreviewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getResourceAsync(GetResourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRevisionAsync(GetRevisionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getTerraformVersionAsync(GetTerraformVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface importStatefileAsync(ImportStatefileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDeploymentsAsync(ListDeploymentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPreviewsAsync(ListPreviewsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listResourcesAsync(ListResourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listRevisionsAsync(ListRevisionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listTerraformVersionsAsync(ListTerraformVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface lockDeploymentAsync(LockDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface unlockDeploymentAsync(UnlockDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDeploymentAsync(UpdateDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class ConfigClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.config.v1.Config';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'config.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'config.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/config_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/config_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/config_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/config_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a deployment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deployment
     *
     * @return string The formatted deployment resource.
     */
    public static function deploymentName(string $project, string $location, string $deployment): string
    {
        return self::getPathTemplate('deployment')->render([
            'project' => $project,
            'location' => $location,
            'deployment' => $deployment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a preview
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $preview
     *
     * @return string The formatted preview resource.
     */
    public static function previewName(string $project, string $location, string $preview): string
    {
        return self::getPathTemplate('preview')->render([
            'project' => $project,
            'location' => $location,
            'preview' => $preview,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a resource
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deployment
     * @param string $revision
     * @param string $resource
     *
     * @return string The formatted resource resource.
     */
    public static function resourceName(
        string $project,
        string $location,
        string $deployment,
        string $revision,
        string $resource
    ): string {
        return self::getPathTemplate('resource')->render([
            'project' => $project,
            'location' => $location,
            'deployment' => $deployment,
            'revision' => $revision,
            'resource' => $resource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a revision
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deployment
     * @param string $revision
     *
     * @return string The formatted revision resource.
     */
    public static function revisionName(string $project, string $location, string $deployment, string $revision): string
    {
        return self::getPathTemplate('revision')->render([
            'project' => $project,
            'location' => $location,
            'deployment' => $deployment,
            'revision' => $revision,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_account resource.
     *
     * @param string $project
     * @param string $serviceAccount
     *
     * @return string The formatted service_account resource.
     */
    public static function serviceAccountName(string $project, string $serviceAccount): string
    {
        return self::getPathTemplate('serviceAccount')->render([
            'project' => $project,
            'service_account' => $serviceAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * terraform_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $terraformVersion
     *
     * @return string The formatted terraform_version resource.
     */
    public static function terraformVersionName(string $project, string $location, string $terraformVersion): string
    {
        return self::getPathTemplate('terraformVersion')->render([
            'project' => $project,
            'location' => $location,
            'terraform_version' => $terraformVersion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a worker_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $workerPool
     *
     * @return string The formatted worker_pool resource.
     */
    public static function workerPoolName(string $project, string $location, string $workerPool): string
    {
        return self::getPathTemplate('workerPool')->render([
            'project' => $project,
            'location' => $location,
            'worker_pool' => $workerPool,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - deployment: projects/{project}/locations/{location}/deployments/{deployment}
     * - location: projects/{project}/locations/{location}
     * - preview: projects/{project}/locations/{location}/previews/{preview}
     * - resource: projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}/resources/{resource}
     * - revision: projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}
     * - serviceAccount: projects/{project}/serviceAccounts/{service_account}
     * - terraformVersion: projects/{project}/locations/{location}/terraformVersions/{terraform_version}
     * - workerPool: projects/{project}/locations/{location}/workerPools/{worker_pool}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'config.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a [Deployment][google.cloud.config.v1.Deployment].
     *
     * The async variant is {@see ConfigClient::createDeploymentAsync()} .
     *
     * @example samples/V1/ConfigClient/create_deployment.php
     *
     * @param CreateDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDeployment(CreateDeploymentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateDeployment', $request, $callOptions)->wait();
    }

    /**
     * Creates a [Preview][google.cloud.config.v1.Preview].
     *
     * The async variant is {@see ConfigClient::createPreviewAsync()} .
     *
     * @example samples/V1/ConfigClient/create_preview.php
     *
     * @param CreatePreviewRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPreview(CreatePreviewRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreatePreview', $request, $callOptions)->wait();
    }

    /**
     * Deletes a [Deployment][google.cloud.config.v1.Deployment].
     *
     * The async variant is {@see ConfigClient::deleteDeploymentAsync()} .
     *
     * @example samples/V1/ConfigClient/delete_deployment.php
     *
     * @param DeleteDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDeployment(DeleteDeploymentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteDeployment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a [Preview][google.cloud.config.v1.Preview].
     *
     * The async variant is {@see ConfigClient::deletePreviewAsync()} .
     *
     * @example samples/V1/ConfigClient/delete_preview.php
     *
     * @param DeletePreviewRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePreview(DeletePreviewRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePreview', $request, $callOptions)->wait();
    }

    /**
     * Deletes Terraform state file in a given deployment.
     *
     * The async variant is {@see ConfigClient::deleteStatefileAsync()} .
     *
     * @example samples/V1/ConfigClient/delete_statefile.php
     *
     * @param DeleteStatefileRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteStatefile(DeleteStatefileRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteStatefile', $request, $callOptions)->wait();
    }

    /**
     * Exports Terraform state file from a given deployment.
     *
     * The async variant is {@see ConfigClient::exportDeploymentStatefileAsync()} .
     *
     * @example samples/V1/ConfigClient/export_deployment_statefile.php
     *
     * @param ExportDeploymentStatefileRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Statefile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportDeploymentStatefile(
        ExportDeploymentStatefileRequest $request,
        array $callOptions = []
    ): Statefile {
        return $this->startApiCall('ExportDeploymentStatefile', $request, $callOptions)->wait();
    }

    /**
     * Exports the lock info on a locked deployment.
     *
     * The async variant is {@see ConfigClient::exportLockInfoAsync()} .
     *
     * @example samples/V1/ConfigClient/export_lock_info.php
     *
     * @param ExportLockInfoRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LockInfo
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportLockInfo(ExportLockInfoRequest $request, array $callOptions = []): LockInfo
    {
        return $this->startApiCall('ExportLockInfo', $request, $callOptions)->wait();
    }

    /**
     * Export [Preview][google.cloud.config.v1.Preview] results.
     *
     * The async variant is {@see ConfigClient::exportPreviewResultAsync()} .
     *
     * @example samples/V1/ConfigClient/export_preview_result.php
     *
     * @param ExportPreviewResultRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExportPreviewResultResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportPreviewResult(
        ExportPreviewResultRequest $request,
        array $callOptions = []
    ): ExportPreviewResultResponse {
        return $this->startApiCall('ExportPreviewResult', $request, $callOptions)->wait();
    }

    /**
     * Exports Terraform state file from a given revision.
     *
     * The async variant is {@see ConfigClient::exportRevisionStatefileAsync()} .
     *
     * @example samples/V1/ConfigClient/export_revision_statefile.php
     *
     * @param ExportRevisionStatefileRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Statefile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportRevisionStatefile(ExportRevisionStatefileRequest $request, array $callOptions = []): Statefile
    {
        return $this->startApiCall('ExportRevisionStatefile', $request, $callOptions)->wait();
    }

    /**
     * Gets details about a [Deployment][google.cloud.config.v1.Deployment].
     *
     * The async variant is {@see ConfigClient::getDeploymentAsync()} .
     *
     * @example samples/V1/ConfigClient/get_deployment.php
     *
     * @param GetDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDeployment(GetDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('GetDeployment', $request, $callOptions)->wait();
    }

    /**
     * Gets details about a [Preview][google.cloud.config.v1.Preview].
     *
     * The async variant is {@see ConfigClient::getPreviewAsync()} .
     *
     * @example samples/V1/ConfigClient/get_preview.php
     *
     * @param GetPreviewRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Preview
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPreview(GetPreviewRequest $request, array $callOptions = []): Preview
    {
        return $this->startApiCall('GetPreview', $request, $callOptions)->wait();
    }

    /**
     * Gets details about a [Resource][google.cloud.config.v1.Resource] deployed
     * by Infra Manager.
     *
     * The async variant is {@see ConfigClient::getResourceAsync()} .
     *
     * @example samples/V1/ConfigClient/get_resource.php
     *
     * @param GetResourceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Resource
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getResource(GetResourceRequest $request, array $callOptions = []): Resource
    {
        return $this->startApiCall('GetResource', $request, $callOptions)->wait();
    }

    /**
     * Gets details about a [Revision][google.cloud.config.v1.Revision].
     *
     * The async variant is {@see ConfigClient::getRevisionAsync()} .
     *
     * @example samples/V1/ConfigClient/get_revision.php
     *
     * @param GetRevisionRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Revision
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRevision(GetRevisionRequest $request, array $callOptions = []): Revision
    {
        return $this->startApiCall('GetRevision', $request, $callOptions)->wait();
    }

    /**
     * Gets details about a
     * [TerraformVersion][google.cloud.config.v1.TerraformVersion].
     *
     * The async variant is {@see ConfigClient::getTerraformVersionAsync()} .
     *
     * @example samples/V1/ConfigClient/get_terraform_version.php
     *
     * @param GetTerraformVersionRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TerraformVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTerraformVersion(GetTerraformVersionRequest $request, array $callOptions = []): TerraformVersion
    {
        return $this->startApiCall('GetTerraformVersion', $request, $callOptions)->wait();
    }

    /**
     * Imports Terraform state file in a given deployment. The state file does not
     * take effect until the Deployment has been unlocked.
     *
     * The async variant is {@see ConfigClient::importStatefileAsync()} .
     *
     * @example samples/V1/ConfigClient/import_statefile.php
     *
     * @param ImportStatefileRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Statefile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importStatefile(ImportStatefileRequest $request, array $callOptions = []): Statefile
    {
        return $this->startApiCall('ImportStatefile', $request, $callOptions)->wait();
    }

    /**
     * Lists [Deployment][google.cloud.config.v1.Deployment]s in a given project
     * and location.
     *
     * The async variant is {@see ConfigClient::listDeploymentsAsync()} .
     *
     * @example samples/V1/ConfigClient/list_deployments.php
     *
     * @param ListDeploymentsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDeployments(ListDeploymentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDeployments', $request, $callOptions);
    }

    /**
     * Lists [Preview][google.cloud.config.v1.Preview]s in a given project and
     * location.
     *
     * The async variant is {@see ConfigClient::listPreviewsAsync()} .
     *
     * @example samples/V1/ConfigClient/list_previews.php
     *
     * @param ListPreviewsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPreviews(ListPreviewsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPreviews', $request, $callOptions);
    }

    /**
     * Lists [Resource][google.cloud.config.v1.Resource]s in a given revision.
     *
     * The async variant is {@see ConfigClient::listResourcesAsync()} .
     *
     * @example samples/V1/ConfigClient/list_resources.php
     *
     * @param ListResourcesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listResources(ListResourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListResources', $request, $callOptions);
    }

    /**
     * Lists [Revision][google.cloud.config.v1.Revision]s of a deployment.
     *
     * The async variant is {@see ConfigClient::listRevisionsAsync()} .
     *
     * @example samples/V1/ConfigClient/list_revisions.php
     *
     * @param ListRevisionsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRevisions(ListRevisionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRevisions', $request, $callOptions);
    }

    /**
     * Lists [TerraformVersion][google.cloud.config.v1.TerraformVersion]s in a
     * given project and location.
     *
     * The async variant is {@see ConfigClient::listTerraformVersionsAsync()} .
     *
     * @example samples/V1/ConfigClient/list_terraform_versions.php
     *
     * @param ListTerraformVersionsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTerraformVersions(
        ListTerraformVersionsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListTerraformVersions', $request, $callOptions);
    }

    /**
     * Locks a deployment.
     *
     * The async variant is {@see ConfigClient::lockDeploymentAsync()} .
     *
     * @example samples/V1/ConfigClient/lock_deployment.php
     *
     * @param LockDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function lockDeployment(LockDeploymentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('LockDeployment', $request, $callOptions)->wait();
    }

    /**
     * Unlocks a locked deployment.
     *
     * The async variant is {@see ConfigClient::unlockDeploymentAsync()} .
     *
     * @example samples/V1/ConfigClient/unlock_deployment.php
     *
     * @param UnlockDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function unlockDeployment(UnlockDeploymentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UnlockDeployment', $request, $callOptions)->wait();
    }

    /**
     * Updates a [Deployment][google.cloud.config.v1.Deployment].
     *
     * The async variant is {@see ConfigClient::updateDeploymentAsync()} .
     *
     * @example samples/V1/ConfigClient/update_deployment.php
     *
     * @param UpdateDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDeployment(UpdateDeploymentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDeployment', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ConfigClient::getLocationAsync()} .
     *
     * @example samples/V1/ConfigClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see ConfigClient::listLocationsAsync()} .
     *
     * @example samples/V1/ConfigClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see ConfigClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/ConfigClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see ConfigClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/ConfigClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see ConfigClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/ConfigClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
