<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/message.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Lists messages in the specified space, that the user is a member of.
 *
 * Generated from protobuf message <code>google.chat.v1.ListMessagesRequest</code>
 */
class ListMessagesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the space to list messages from.
     * Format: `spaces/{space}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * The maximum number of messages returned. The service might return fewer
     * messages than this value.
     * If unspecified, at most 25 are returned.
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     * Negative values return an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     */
    protected $page_size = 0;
    /**
     * Optional, if resuming from a previous query.
     * A page token received from a previous list messages call. Provide this
     * parameter to retrieve the subsequent page.
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     */
    protected $page_token = '';
    /**
     * A query filter.
     * You can filter messages by date (`create_time`) and thread (`thread.name`).
     * To filter messages by the date they were created, specify the `create_time`
     * with a timestamp in [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339)
     * format and double quotation marks. For example,
     * `"2023-04-21T11:30:00-04:00"`. You can use the greater than operator `>` to
     * list messages that were created after a timestamp, or the less than
     * operator `<` to list messages that were created before a timestamp. To
     * filter messages within a time interval, use the `AND` operator between two
     * timestamps.
     * To filter by thread, specify the `thread.name`, formatted as
     * `spaces/{space}/threads/{thread}`. You can only specify one
     * `thread.name` per query.
     * To filter by both thread and date, use the `AND` operator in your query.
     * For example, the following queries are valid:
     * ```
     * create_time > "2012-04-21T11:30:00-04:00"
     * create_time > "2012-04-21T11:30:00-04:00" AND
     *   thread.name = spaces/AAAAAAAAAAA/threads/123
     * create_time > "2012-04-21T11:30:00+00:00" AND
     * create_time < "2013-01-01T00:00:00+00:00" AND
     *   thread.name = spaces/AAAAAAAAAAA/threads/123
     * thread.name = spaces/AAAAAAAAAAA/threads/123
     * ```
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     *
     * Generated from protobuf field <code>string filter = 4;</code>
     */
    protected $filter = '';
    /**
     * Optional, if resuming from a previous query.
     * How the list of messages is ordered. Specify a value to order by an
     * ordering operation. Valid ordering operation values are as follows:
     * - `ASC` for ascending.
     * - `DESC` for descending.
     * The default ordering is `create_time ASC`.
     *
     * Generated from protobuf field <code>string order_by = 5;</code>
     */
    protected $order_by = '';
    /**
     * Whether to include deleted messages. Deleted messages include deleted time
     * and metadata about their deletion, but message content is unavailable.
     *
     * Generated from protobuf field <code>bool show_deleted = 6;</code>
     */
    protected $show_deleted = false;

    /**
     * @param string $parent Required. The resource name of the space to list messages from.
     *
     *                       Format: `spaces/{space}`
     *                       Please see {@see ChatServiceClient::spaceName()} for help formatting this field.
     *
     * @return \Google\Apps\Chat\V1\ListMessagesRequest
     *
     * @experimental
     */
    public static function build(string $parent): self
    {
        return (new self())
            ->setParent($parent);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The resource name of the space to list messages from.
     *           Format: `spaces/{space}`
     *     @type int $page_size
     *           The maximum number of messages returned. The service might return fewer
     *           messages than this value.
     *           If unspecified, at most 25 are returned.
     *           The maximum value is 1000. If you use a value more than 1000, it's
     *           automatically changed to 1000.
     *           Negative values return an `INVALID_ARGUMENT` error.
     *     @type string $page_token
     *           Optional, if resuming from a previous query.
     *           A page token received from a previous list messages call. Provide this
     *           parameter to retrieve the subsequent page.
     *           When paginating, all other parameters provided should match the call that
     *           provided the page token. Passing different values to the other parameters
     *           might lead to unexpected results.
     *     @type string $filter
     *           A query filter.
     *           You can filter messages by date (`create_time`) and thread (`thread.name`).
     *           To filter messages by the date they were created, specify the `create_time`
     *           with a timestamp in [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339)
     *           format and double quotation marks. For example,
     *           `"2023-04-21T11:30:00-04:00"`. You can use the greater than operator `>` to
     *           list messages that were created after a timestamp, or the less than
     *           operator `<` to list messages that were created before a timestamp. To
     *           filter messages within a time interval, use the `AND` operator between two
     *           timestamps.
     *           To filter by thread, specify the `thread.name`, formatted as
     *           `spaces/{space}/threads/{thread}`. You can only specify one
     *           `thread.name` per query.
     *           To filter by both thread and date, use the `AND` operator in your query.
     *           For example, the following queries are valid:
     *           ```
     *           create_time > "2012-04-21T11:30:00-04:00"
     *           create_time > "2012-04-21T11:30:00-04:00" AND
     *             thread.name = spaces/AAAAAAAAAAA/threads/123
     *           create_time > "2012-04-21T11:30:00+00:00" AND
     *           create_time < "2013-01-01T00:00:00+00:00" AND
     *             thread.name = spaces/AAAAAAAAAAA/threads/123
     *           thread.name = spaces/AAAAAAAAAAA/threads/123
     *           ```
     *           Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     *           error.
     *     @type string $order_by
     *           Optional, if resuming from a previous query.
     *           How the list of messages is ordered. Specify a value to order by an
     *           ordering operation. Valid ordering operation values are as follows:
     *           - `ASC` for ascending.
     *           - `DESC` for descending.
     *           The default ordering is `create_time ASC`.
     *     @type bool $show_deleted
     *           Whether to include deleted messages. Deleted messages include deleted time
     *           and metadata about their deletion, but message content is unavailable.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the space to list messages from.
     * Format: `spaces/{space}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The resource name of the space to list messages from.
     * Format: `spaces/{space}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * The maximum number of messages returned. The service might return fewer
     * messages than this value.
     * If unspecified, at most 25 are returned.
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     * Negative values return an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * The maximum number of messages returned. The service might return fewer
     * messages than this value.
     * If unspecified, at most 25 are returned.
     * The maximum value is 1000. If you use a value more than 1000, it's
     * automatically changed to 1000.
     * Negative values return an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Optional, if resuming from a previous query.
     * A page token received from a previous list messages call. Provide this
     * parameter to retrieve the subsequent page.
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * Optional, if resuming from a previous query.
     * A page token received from a previous list messages call. Provide this
     * parameter to retrieve the subsequent page.
     * When paginating, all other parameters provided should match the call that
     * provided the page token. Passing different values to the other parameters
     * might lead to unexpected results.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * A query filter.
     * You can filter messages by date (`create_time`) and thread (`thread.name`).
     * To filter messages by the date they were created, specify the `create_time`
     * with a timestamp in [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339)
     * format and double quotation marks. For example,
     * `"2023-04-21T11:30:00-04:00"`. You can use the greater than operator `>` to
     * list messages that were created after a timestamp, or the less than
     * operator `<` to list messages that were created before a timestamp. To
     * filter messages within a time interval, use the `AND` operator between two
     * timestamps.
     * To filter by thread, specify the `thread.name`, formatted as
     * `spaces/{space}/threads/{thread}`. You can only specify one
     * `thread.name` per query.
     * To filter by both thread and date, use the `AND` operator in your query.
     * For example, the following queries are valid:
     * ```
     * create_time > "2012-04-21T11:30:00-04:00"
     * create_time > "2012-04-21T11:30:00-04:00" AND
     *   thread.name = spaces/AAAAAAAAAAA/threads/123
     * create_time > "2012-04-21T11:30:00+00:00" AND
     * create_time < "2013-01-01T00:00:00+00:00" AND
     *   thread.name = spaces/AAAAAAAAAAA/threads/123
     * thread.name = spaces/AAAAAAAAAAA/threads/123
     * ```
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     *
     * Generated from protobuf field <code>string filter = 4;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * A query filter.
     * You can filter messages by date (`create_time`) and thread (`thread.name`).
     * To filter messages by the date they were created, specify the `create_time`
     * with a timestamp in [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339)
     * format and double quotation marks. For example,
     * `"2023-04-21T11:30:00-04:00"`. You can use the greater than operator `>` to
     * list messages that were created after a timestamp, or the less than
     * operator `<` to list messages that were created before a timestamp. To
     * filter messages within a time interval, use the `AND` operator between two
     * timestamps.
     * To filter by thread, specify the `thread.name`, formatted as
     * `spaces/{space}/threads/{thread}`. You can only specify one
     * `thread.name` per query.
     * To filter by both thread and date, use the `AND` operator in your query.
     * For example, the following queries are valid:
     * ```
     * create_time > "2012-04-21T11:30:00-04:00"
     * create_time > "2012-04-21T11:30:00-04:00" AND
     *   thread.name = spaces/AAAAAAAAAAA/threads/123
     * create_time > "2012-04-21T11:30:00+00:00" AND
     * create_time < "2013-01-01T00:00:00+00:00" AND
     *   thread.name = spaces/AAAAAAAAAAA/threads/123
     * thread.name = spaces/AAAAAAAAAAA/threads/123
     * ```
     * Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
     * error.
     *
     * Generated from protobuf field <code>string filter = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * Optional, if resuming from a previous query.
     * How the list of messages is ordered. Specify a value to order by an
     * ordering operation. Valid ordering operation values are as follows:
     * - `ASC` for ascending.
     * - `DESC` for descending.
     * The default ordering is `create_time ASC`.
     *
     * Generated from protobuf field <code>string order_by = 5;</code>
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }

    /**
     * Optional, if resuming from a previous query.
     * How the list of messages is ordered. Specify a value to order by an
     * ordering operation. Valid ordering operation values are as follows:
     * - `ASC` for ascending.
     * - `DESC` for descending.
     * The default ordering is `create_time ASC`.
     *
     * Generated from protobuf field <code>string order_by = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setOrderBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->order_by = $var;

        return $this;
    }

    /**
     * Whether to include deleted messages. Deleted messages include deleted time
     * and metadata about their deletion, but message content is unavailable.
     *
     * Generated from protobuf field <code>bool show_deleted = 6;</code>
     * @return bool
     */
    public function getShowDeleted()
    {
        return $this->show_deleted;
    }

    /**
     * Whether to include deleted messages. Deleted messages include deleted time
     * and metadata about their deletion, but message content is unavailable.
     *
     * Generated from protobuf field <code>bool show_deleted = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setShowDeleted($var)
    {
        GPBUtil::checkBool($var);
        $this->show_deleted = $var;

        return $this;
    }

}

