<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/gkemulticloud/v1/azure_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\GkeMultiCloud\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\GkeMultiCloud\V1\AzureClient;
use Google\Cloud\GkeMultiCloud\V1\AzureCluster;
use Google\Cloud\GkeMultiCloud\V1\AzureJsonWebKeys;
use Google\Cloud\GkeMultiCloud\V1\AzureNodePool;
use Google\Cloud\GkeMultiCloud\V1\AzureOpenIdConfig;
use Google\Cloud\GkeMultiCloud\V1\AzureServerConfig;
use Google\Cloud\GkeMultiCloud\V1\CreateAzureClientRequest;
use Google\Cloud\GkeMultiCloud\V1\CreateAzureClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\CreateAzureNodePoolRequest;
use Google\Cloud\GkeMultiCloud\V1\DeleteAzureClientRequest;
use Google\Cloud\GkeMultiCloud\V1\DeleteAzureClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\DeleteAzureNodePoolRequest;
use Google\Cloud\GkeMultiCloud\V1\GenerateAzureAccessTokenRequest;
use Google\Cloud\GkeMultiCloud\V1\GenerateAzureAccessTokenResponse;
use Google\Cloud\GkeMultiCloud\V1\GenerateAzureClusterAgentTokenRequest;
use Google\Cloud\GkeMultiCloud\V1\GenerateAzureClusterAgentTokenResponse;
use Google\Cloud\GkeMultiCloud\V1\GetAzureClientRequest;
use Google\Cloud\GkeMultiCloud\V1\GetAzureClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\GetAzureJsonWebKeysRequest;
use Google\Cloud\GkeMultiCloud\V1\GetAzureNodePoolRequest;
use Google\Cloud\GkeMultiCloud\V1\GetAzureOpenIdConfigRequest;
use Google\Cloud\GkeMultiCloud\V1\GetAzureServerConfigRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAzureClientsRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAzureClustersRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAzureNodePoolsRequest;
use Google\Cloud\GkeMultiCloud\V1\UpdateAzureClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\UpdateAzureNodePoolRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: The AzureClusters API provides a single centrally managed service
 * to create and manage Anthos clusters that run on Azure infrastructure.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createAzureClientAsync(CreateAzureClientRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createAzureClusterAsync(CreateAzureClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createAzureNodePoolAsync(CreateAzureNodePoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteAzureClientAsync(DeleteAzureClientRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteAzureClusterAsync(DeleteAzureClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteAzureNodePoolAsync(DeleteAzureNodePoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<GenerateAzureAccessTokenResponse> generateAzureAccessTokenAsync(GenerateAzureAccessTokenRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<GenerateAzureClusterAgentTokenResponse> generateAzureClusterAgentTokenAsync(GenerateAzureClusterAgentTokenRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AzureClient> getAzureClientAsync(GetAzureClientRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AzureCluster> getAzureClusterAsync(GetAzureClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AzureJsonWebKeys> getAzureJsonWebKeysAsync(GetAzureJsonWebKeysRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AzureNodePool> getAzureNodePoolAsync(GetAzureNodePoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AzureOpenIdConfig> getAzureOpenIdConfigAsync(GetAzureOpenIdConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AzureServerConfig> getAzureServerConfigAsync(GetAzureServerConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAzureClientsAsync(ListAzureClientsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAzureClustersAsync(ListAzureClustersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAzureNodePoolsAsync(ListAzureNodePoolsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateAzureClusterAsync(UpdateAzureClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateAzureNodePoolAsync(UpdateAzureNodePoolRequest $request, array $optionalArgs = [])
 */
final class AzureClustersClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.gkemulticloud.v1.AzureClusters';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'gkemulticloud.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'gkemulticloud.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/azure_clusters_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/azure_clusters_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/azure_clusters_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/azure_clusters_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a azure_client
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $azureClient
     *
     * @return string The formatted azure_client resource.
     */
    public static function azureClientName(string $project, string $location, string $azureClient): string
    {
        return self::getPathTemplate('azureClient')->render([
            'project' => $project,
            'location' => $location,
            'azure_client' => $azureClient,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * azure_cluster resource.
     *
     * @param string $project
     * @param string $location
     * @param string $azureCluster
     *
     * @return string The formatted azure_cluster resource.
     */
    public static function azureClusterName(string $project, string $location, string $azureCluster): string
    {
        return self::getPathTemplate('azureCluster')->render([
            'project' => $project,
            'location' => $location,
            'azure_cluster' => $azureCluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * azure_node_pool resource.
     *
     * @param string $project
     * @param string $location
     * @param string $azureCluster
     * @param string $azureNodePool
     *
     * @return string The formatted azure_node_pool resource.
     */
    public static function azureNodePoolName(
        string $project,
        string $location,
        string $azureCluster,
        string $azureNodePool
    ): string {
        return self::getPathTemplate('azureNodePool')->render([
            'project' => $project,
            'location' => $location,
            'azure_cluster' => $azureCluster,
            'azure_node_pool' => $azureNodePool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * azure_server_config resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted azure_server_config resource.
     */
    public static function azureServerConfigName(string $project, string $location): string
    {
        return self::getPathTemplate('azureServerConfig')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - azureClient: projects/{project}/locations/{location}/azureClients/{azure_client}
     * - azureCluster: projects/{project}/locations/{location}/azureClusters/{azure_cluster}
     * - azureNodePool: projects/{project}/locations/{location}/azureClusters/{azure_cluster}/azureNodePools/{azure_node_pool}
     * - azureServerConfig: projects/{project}/locations/{location}/azureServerConfig
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'gkemulticloud.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
     * resource on a given Google Cloud project and region.
     *
     * `AzureClient` resources hold client authentication
     * information needed by the Anthos Multicloud API to manage Azure resources
     * on your Azure subscription on your behalf.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * The async variant is {@see AzureClustersClient::createAzureClientAsync()} .
     *
     * @example samples/V1/AzureClustersClient/create_azure_client.php
     *
     * @param CreateAzureClientRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAzureClient(CreateAzureClientRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAzureClient', $request, $callOptions)->wait();
    }

    /**
     * Creates a new [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
     * resource on a given Google Cloud Platform project and region.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * The async variant is {@see AzureClustersClient::createAzureClusterAsync()} .
     *
     * @example samples/V1/AzureClustersClient/create_azure_cluster.php
     *
     * @param CreateAzureClusterRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAzureCluster(CreateAzureClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAzureCluster', $request, $callOptions)->wait();
    }

    /**
     * Creates a new [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool],
     * attached to a given
     * [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * The async variant is {@see AzureClustersClient::createAzureNodePoolAsync()} .
     *
     * @example samples/V1/AzureClustersClient/create_azure_node_pool.php
     *
     * @param CreateAzureNodePoolRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAzureNodePool(CreateAzureNodePoolRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAzureNodePool', $request, $callOptions)->wait();
    }

    /**
     * Deletes a specific [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
     * resource.
     *
     * If the client is used by one or more clusters, deletion will
     * fail and a `FAILED_PRECONDITION` error will be returned.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * The async variant is {@see AzureClustersClient::deleteAzureClientAsync()} .
     *
     * @example samples/V1/AzureClustersClient/delete_azure_client.php
     *
     * @param DeleteAzureClientRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAzureClient(DeleteAzureClientRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteAzureClient', $request, $callOptions)->wait();
    }

    /**
     * Deletes a specific
     * [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
     *
     * Fails if the cluster has one or more associated
     * [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * The async variant is {@see AzureClustersClient::deleteAzureClusterAsync()} .
     *
     * @example samples/V1/AzureClustersClient/delete_azure_cluster.php
     *
     * @param DeleteAzureClusterRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAzureCluster(DeleteAzureClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteAzureCluster', $request, $callOptions)->wait();
    }

    /**
     * Deletes a specific
     * [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * The async variant is {@see AzureClustersClient::deleteAzureNodePoolAsync()} .
     *
     * @example samples/V1/AzureClustersClient/delete_azure_node_pool.php
     *
     * @param DeleteAzureNodePoolRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAzureNodePool(DeleteAzureNodePoolRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteAzureNodePool', $request, $callOptions)->wait();
    }

    /**
     * Generates a short-lived access token to authenticate to a given
     * [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
     *
     * The async variant is {@see AzureClustersClient::generateAzureAccessTokenAsync()}
     * .
     *
     * @example samples/V1/AzureClustersClient/generate_azure_access_token.php
     *
     * @param GenerateAzureAccessTokenRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GenerateAzureAccessTokenResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function generateAzureAccessToken(
        GenerateAzureAccessTokenRequest $request,
        array $callOptions = []
    ): GenerateAzureAccessTokenResponse {
        return $this->startApiCall('GenerateAzureAccessToken', $request, $callOptions)->wait();
    }

    /**
     * Generates an access token for a cluster agent.
     *
     * The async variant is
     * {@see AzureClustersClient::generateAzureClusterAgentTokenAsync()} .
     *
     * @example samples/V1/AzureClustersClient/generate_azure_cluster_agent_token.php
     *
     * @param GenerateAzureClusterAgentTokenRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GenerateAzureClusterAgentTokenResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function generateAzureClusterAgentToken(
        GenerateAzureClusterAgentTokenRequest $request,
        array $callOptions = []
    ): GenerateAzureClusterAgentTokenResponse {
        return $this->startApiCall('GenerateAzureClusterAgentToken', $request, $callOptions)->wait();
    }

    /**
     * Describes a specific
     * [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource.
     *
     * The async variant is {@see AzureClustersClient::getAzureClientAsync()} .
     *
     * @example samples/V1/AzureClustersClient/get_azure_client.php
     *
     * @param GetAzureClientRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AzureClient
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAzureClient(GetAzureClientRequest $request, array $callOptions = []): AzureClient
    {
        return $this->startApiCall('GetAzureClient', $request, $callOptions)->wait();
    }

    /**
     * Describes a specific
     * [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
     *
     * The async variant is {@see AzureClustersClient::getAzureClusterAsync()} .
     *
     * @example samples/V1/AzureClustersClient/get_azure_cluster.php
     *
     * @param GetAzureClusterRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AzureCluster
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAzureCluster(GetAzureClusterRequest $request, array $callOptions = []): AzureCluster
    {
        return $this->startApiCall('GetAzureCluster', $request, $callOptions)->wait();
    }

    /**
     * Gets the public component of the cluster signing keys in
     * JSON Web Key format.
     *
     * The async variant is {@see AzureClustersClient::getAzureJsonWebKeysAsync()} .
     *
     * @example samples/V1/AzureClustersClient/get_azure_json_web_keys.php
     *
     * @param GetAzureJsonWebKeysRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AzureJsonWebKeys
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAzureJsonWebKeys(GetAzureJsonWebKeysRequest $request, array $callOptions = []): AzureJsonWebKeys
    {
        return $this->startApiCall('GetAzureJsonWebKeys', $request, $callOptions)->wait();
    }

    /**
     * Describes a specific
     * [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
     *
     * The async variant is {@see AzureClustersClient::getAzureNodePoolAsync()} .
     *
     * @example samples/V1/AzureClustersClient/get_azure_node_pool.php
     *
     * @param GetAzureNodePoolRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AzureNodePool
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAzureNodePool(GetAzureNodePoolRequest $request, array $callOptions = []): AzureNodePool
    {
        return $this->startApiCall('GetAzureNodePool', $request, $callOptions)->wait();
    }

    /**
     * Gets the OIDC discovery document for the cluster.
     * See the
     * [OpenID Connect Discovery 1.0
     * specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
     * for details.
     *
     * The async variant is {@see AzureClustersClient::getAzureOpenIdConfigAsync()} .
     *
     * @example samples/V1/AzureClustersClient/get_azure_open_id_config.php
     *
     * @param GetAzureOpenIdConfigRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AzureOpenIdConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAzureOpenIdConfig(
        GetAzureOpenIdConfigRequest $request,
        array $callOptions = []
    ): AzureOpenIdConfig {
        return $this->startApiCall('GetAzureOpenIdConfig', $request, $callOptions)->wait();
    }

    /**
     * Returns information, such as supported Azure regions and Kubernetes
     * versions, on a given Google Cloud location.
     *
     * The async variant is {@see AzureClustersClient::getAzureServerConfigAsync()} .
     *
     * @example samples/V1/AzureClustersClient/get_azure_server_config.php
     *
     * @param GetAzureServerConfigRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AzureServerConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAzureServerConfig(
        GetAzureServerConfigRequest $request,
        array $callOptions = []
    ): AzureServerConfig {
        return $this->startApiCall('GetAzureServerConfig', $request, $callOptions)->wait();
    }

    /**
     * Lists all [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
     * resources on a given Google Cloud project and region.
     *
     * The async variant is {@see AzureClustersClient::listAzureClientsAsync()} .
     *
     * @example samples/V1/AzureClustersClient/list_azure_clients.php
     *
     * @param ListAzureClientsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAzureClients(ListAzureClientsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAzureClients', $request, $callOptions);
    }

    /**
     * Lists all [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
     * resources on a given Google Cloud project and region.
     *
     * The async variant is {@see AzureClustersClient::listAzureClustersAsync()} .
     *
     * @example samples/V1/AzureClustersClient/list_azure_clusters.php
     *
     * @param ListAzureClustersRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAzureClusters(ListAzureClustersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAzureClusters', $request, $callOptions);
    }

    /**
     * Lists all [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
     * resources on a given
     * [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
     *
     * The async variant is {@see AzureClustersClient::listAzureNodePoolsAsync()} .
     *
     * @example samples/V1/AzureClustersClient/list_azure_node_pools.php
     *
     * @param ListAzureNodePoolsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAzureNodePools(ListAzureNodePoolsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAzureNodePools', $request, $callOptions);
    }

    /**
     * Updates an [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
     *
     * The async variant is {@see AzureClustersClient::updateAzureClusterAsync()} .
     *
     * @example samples/V1/AzureClustersClient/update_azure_cluster.php
     *
     * @param UpdateAzureClusterRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAzureCluster(UpdateAzureClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateAzureCluster', $request, $callOptions)->wait();
    }

    /**
     * Updates an [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool].
     *
     * The async variant is {@see AzureClustersClient::updateAzureNodePoolAsync()} .
     *
     * @example samples/V1/AzureClustersClient/update_azure_node_pool.php
     *
     * @param UpdateAzureNodePoolRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAzureNodePool(UpdateAzureNodePoolRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateAzureNodePool', $request, $callOptions)->wait();
    }
}
