<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/dataflow/v1beta3/jobs.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\Dataflow\V1beta3\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataflow\V1beta3\CheckActiveJobsRequest;
use Google\Cloud\Dataflow\V1beta3\CheckActiveJobsResponse;
use Google\Cloud\Dataflow\V1beta3\CreateJobRequest;
use Google\Cloud\Dataflow\V1beta3\GetJobRequest;
use Google\Cloud\Dataflow\V1beta3\Job;
use Google\Cloud\Dataflow\V1beta3\ListJobsRequest;
use Google\Cloud\Dataflow\V1beta3\Snapshot;
use Google\Cloud\Dataflow\V1beta3\SnapshotJobRequest;
use Google\Cloud\Dataflow\V1beta3\UpdateJobRequest;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Provides a method to create and modify Google Cloud Dataflow jobs.
 * A Job is a multi-stage computation graph run by the Cloud Dataflow service.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * @experimental
 *
 * @method PromiseInterface<PagedListResponse> aggregatedListJobsAsync(ListJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CheckActiveJobsResponse> checkActiveJobsAsync(CheckActiveJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Job> createJobAsync(CreateJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Job> getJobAsync(GetJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listJobsAsync(ListJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Snapshot> snapshotJobAsync(SnapshotJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Job> updateJobAsync(UpdateJobRequest $request, array $optionalArgs = [])
 */
final class JobsV1Beta3Client
{
    use GapicClientTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.dataflow.v1beta3.JobsV1Beta3';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'dataflow.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dataflow.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/compute',
        'https://www.googleapis.com/auth/compute.readonly',
        'https://www.googleapis.com/auth/userinfo.email',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/jobs_v1_beta3_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/jobs_v1_beta3_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/jobs_v1_beta3_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/jobs_v1_beta3_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * List the jobs of a project across all regions.
     *
     * The async variant is {@see JobsV1Beta3Client::aggregatedListJobsAsync()} .
     *
     * @example samples/V1beta3/JobsV1Beta3Client/aggregated_list_jobs.php
     *
     * @param ListJobsRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function aggregatedListJobs(ListJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('AggregatedListJobs', $request, $callOptions);
    }

    /**
     * Check for existence of active jobs in the given project across all regions.
     *
     * The async variant is {@see JobsV1Beta3Client::checkActiveJobsAsync()} .
     *
     * @example samples/V1beta3/JobsV1Beta3Client/check_active_jobs.php
     *
     * @param CheckActiveJobsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CheckActiveJobsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function checkActiveJobs(CheckActiveJobsRequest $request, array $callOptions = []): CheckActiveJobsResponse
    {
        return $this->startApiCall('CheckActiveJobs', $request, $callOptions)->wait();
    }

    /**
     * Creates a Cloud Dataflow job.
     *
     * To create a job, we recommend using `projects.locations.jobs.create` with a
     * [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
     * `projects.jobs.create` is not recommended, as your job will always start
     * in `us-central1`.
     *
     * The async variant is {@see JobsV1Beta3Client::createJobAsync()} .
     *
     * @example samples/V1beta3/JobsV1Beta3Client/create_job.php
     *
     * @param CreateJobRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Job
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createJob(CreateJobRequest $request, array $callOptions = []): Job
    {
        return $this->startApiCall('CreateJob', $request, $callOptions)->wait();
    }

    /**
     * Gets the state of the specified Cloud Dataflow job.
     *
     * To get the state of a job, we recommend using `projects.locations.jobs.get`
     * with a [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
     * `projects.jobs.get` is not recommended, as you can only get the state of
     * jobs that are running in `us-central1`.
     *
     * The async variant is {@see JobsV1Beta3Client::getJobAsync()} .
     *
     * @example samples/V1beta3/JobsV1Beta3Client/get_job.php
     *
     * @param GetJobRequest $request     A request to house fields associated with the call.
     * @param array         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Job
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getJob(GetJobRequest $request, array $callOptions = []): Job
    {
        return $this->startApiCall('GetJob', $request, $callOptions)->wait();
    }

    /**
     * List the jobs of a project.
     *
     * To list the jobs of a project in a region, we recommend using
     * `projects.locations.jobs.list` with a [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). To
     * list the all jobs across all regions, use `projects.jobs.aggregated`. Using
     * `projects.jobs.list` is not recommended, as you can only get the list of
     * jobs that are running in `us-central1`.
     *
     * The async variant is {@see JobsV1Beta3Client::listJobsAsync()} .
     *
     * @example samples/V1beta3/JobsV1Beta3Client/list_jobs.php
     *
     * @param ListJobsRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listJobs(ListJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListJobs', $request, $callOptions);
    }

    /**
     * Snapshot the state of a streaming job.
     *
     * The async variant is {@see JobsV1Beta3Client::snapshotJobAsync()} .
     *
     * @example samples/V1beta3/JobsV1Beta3Client/snapshot_job.php
     *
     * @param SnapshotJobRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Snapshot
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function snapshotJob(SnapshotJobRequest $request, array $callOptions = []): Snapshot
    {
        return $this->startApiCall('SnapshotJob', $request, $callOptions)->wait();
    }

    /**
     * Updates the state of an existing Cloud Dataflow job.
     *
     * To update the state of an existing job, we recommend using
     * `projects.locations.jobs.update` with a [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
     * `projects.jobs.update` is not recommended, as you can only update the state
     * of jobs that are running in `us-central1`.
     *
     * The async variant is {@see JobsV1Beta3Client::updateJobAsync()} .
     *
     * @example samples/V1beta3/JobsV1Beta3Client/update_job.php
     *
     * @param UpdateJobRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Job
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateJob(UpdateJobRequest $request, array $callOptions = []): Job
    {
        return $this->startApiCall('UpdateJob', $request, $callOptions)->wait();
    }
}
