<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Sets the scheduling options for an Instance.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Scheduling</code>
 */
class Scheduling extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     *
     * Generated from protobuf field <code>optional bool automatic_restart = 350821371;</code>
     */
    private $automatic_restart = null;
    /**
     * Specifies the availability domain to place the instance in. The value must be a number between 1 and the number of availability domains specified in the spread placement policy attached to the instance.
     *
     * Generated from protobuf field <code>optional int32 availability_domain = 252514344;</code>
     */
    private $availability_domain = null;
    /**
     * Specifies the termination action for the instance.
     * Check the InstanceTerminationAction enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string instance_termination_action = 107380667;</code>
     */
    private $instance_termination_action = null;
    /**
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;</code>
     */
    private $local_ssd_recovery_timeout = null;
    /**
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>optional string location_hint = 350519505;</code>
     */
    private $location_hint = null;
    /**
     * Specifies the max run duration for the given instance. If specified, the instance termination action will be performed at the end of the run duration.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration max_run_duration = 430839747;</code>
     */
    private $max_run_duration = null;
    /**
     * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     *
     * Generated from protobuf field <code>optional int32 min_node_cpus = 317231675;</code>
     */
    private $min_node_cpus = null;
    /**
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;</code>
     */
    private $node_affinities;
    /**
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
     * Check the OnHostMaintenance enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string on_host_maintenance = 64616796;</code>
     */
    private $on_host_maintenance = null;
    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.SchedulingOnInstanceStopAction on_instance_stop_action = 529876681;</code>
     */
    private $on_instance_stop_action = null;
    /**
     * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     *
     * Generated from protobuf field <code>optional bool preemptible = 324203169;</code>
     */
    private $preemptible = null;
    /**
     * Specifies the provisioning model of the instance.
     * Check the ProvisioningModel enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string provisioning_model = 494423;</code>
     */
    private $provisioning_model = null;
    /**
     * Specifies the timestamp, when the instance will be terminated, in RFC3339 text format. If specified, the instance termination action will be performed at the termination time.
     *
     * Generated from protobuf field <code>optional string termination_time = 428082984;</code>
     */
    private $termination_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $automatic_restart
     *           Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     *     @type int $availability_domain
     *           Specifies the availability domain to place the instance in. The value must be a number between 1 and the number of availability domains specified in the spread placement policy attached to the instance.
     *     @type string $instance_termination_action
     *           Specifies the termination action for the instance.
     *           Check the InstanceTerminationAction enum for the list of possible values.
     *     @type \Google\Cloud\Compute\V1\Duration $local_ssd_recovery_timeout
     *           Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     *     @type string $location_hint
     *           An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     *     @type \Google\Cloud\Compute\V1\Duration $max_run_duration
     *           Specifies the max run duration for the given instance. If specified, the instance termination action will be performed at the end of the run duration.
     *     @type int $min_node_cpus
     *           The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     *     @type array<\Google\Cloud\Compute\V1\SchedulingNodeAffinity>|\Google\Protobuf\Internal\RepeatedField $node_affinities
     *           A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     *     @type string $on_host_maintenance
     *           Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
     *           Check the OnHostMaintenance enum for the list of possible values.
     *     @type \Google\Cloud\Compute\V1\SchedulingOnInstanceStopAction $on_instance_stop_action
     *     @type bool $preemptible
     *           Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     *     @type string $provisioning_model
     *           Specifies the provisioning model of the instance.
     *           Check the ProvisioningModel enum for the list of possible values.
     *     @type string $termination_time
     *           Specifies the timestamp, when the instance will be terminated, in RFC3339 text format. If specified, the instance termination action will be performed at the termination time.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     *
     * Generated from protobuf field <code>optional bool automatic_restart = 350821371;</code>
     * @return bool
     */
    public function getAutomaticRestart()
    {
        return isset($this->automatic_restart) ? $this->automatic_restart : false;
    }

    public function hasAutomaticRestart()
    {
        return isset($this->automatic_restart);
    }

    public function clearAutomaticRestart()
    {
        unset($this->automatic_restart);
    }

    /**
     * Specifies whether the instance should be automatically restarted if it is terminated by Compute Engine (not terminated by a user). You can only set the automatic restart option for standard instances. Preemptible instances cannot be automatically restarted. By default, this is set to true so an instance is automatically restarted if it is terminated by Compute Engine.
     *
     * Generated from protobuf field <code>optional bool automatic_restart = 350821371;</code>
     * @param bool $var
     * @return $this
     */
    public function setAutomaticRestart($var)
    {
        GPBUtil::checkBool($var);
        $this->automatic_restart = $var;

        return $this;
    }

    /**
     * Specifies the availability domain to place the instance in. The value must be a number between 1 and the number of availability domains specified in the spread placement policy attached to the instance.
     *
     * Generated from protobuf field <code>optional int32 availability_domain = 252514344;</code>
     * @return int
     */
    public function getAvailabilityDomain()
    {
        return isset($this->availability_domain) ? $this->availability_domain : 0;
    }

    public function hasAvailabilityDomain()
    {
        return isset($this->availability_domain);
    }

    public function clearAvailabilityDomain()
    {
        unset($this->availability_domain);
    }

    /**
     * Specifies the availability domain to place the instance in. The value must be a number between 1 and the number of availability domains specified in the spread placement policy attached to the instance.
     *
     * Generated from protobuf field <code>optional int32 availability_domain = 252514344;</code>
     * @param int $var
     * @return $this
     */
    public function setAvailabilityDomain($var)
    {
        GPBUtil::checkInt32($var);
        $this->availability_domain = $var;

        return $this;
    }

    /**
     * Specifies the termination action for the instance.
     * Check the InstanceTerminationAction enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string instance_termination_action = 107380667;</code>
     * @return string
     */
    public function getInstanceTerminationAction()
    {
        return isset($this->instance_termination_action) ? $this->instance_termination_action : '';
    }

    public function hasInstanceTerminationAction()
    {
        return isset($this->instance_termination_action);
    }

    public function clearInstanceTerminationAction()
    {
        unset($this->instance_termination_action);
    }

    /**
     * Specifies the termination action for the instance.
     * Check the InstanceTerminationAction enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string instance_termination_action = 107380667;</code>
     * @param string $var
     * @return $this
     */
    public function setInstanceTerminationAction($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance_termination_action = $var;

        return $this;
    }

    /**
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;</code>
     * @return \Google\Cloud\Compute\V1\Duration|null
     */
    public function getLocalSsdRecoveryTimeout()
    {
        return $this->local_ssd_recovery_timeout;
    }

    public function hasLocalSsdRecoveryTimeout()
    {
        return isset($this->local_ssd_recovery_timeout);
    }

    public function clearLocalSsdRecoveryTimeout()
    {
        unset($this->local_ssd_recovery_timeout);
    }

    /**
     * Specifies the maximum amount of time a Local Ssd Vm should wait while recovery of the Local Ssd state is attempted. Its value should be in between 0 and 168 hours with hour granularity and the default value being 1 hour.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration local_ssd_recovery_timeout = 268015590;</code>
     * @param \Google\Cloud\Compute\V1\Duration $var
     * @return $this
     */
    public function setLocalSsdRecoveryTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Duration::class);
        $this->local_ssd_recovery_timeout = $var;

        return $this;
    }

    /**
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>optional string location_hint = 350519505;</code>
     * @return string
     */
    public function getLocationHint()
    {
        return isset($this->location_hint) ? $this->location_hint : '';
    }

    public function hasLocationHint()
    {
        return isset($this->location_hint);
    }

    public function clearLocationHint()
    {
        unset($this->location_hint);
    }

    /**
     * An opaque location hint used to place the instance close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>optional string location_hint = 350519505;</code>
     * @param string $var
     * @return $this
     */
    public function setLocationHint($var)
    {
        GPBUtil::checkString($var, True);
        $this->location_hint = $var;

        return $this;
    }

    /**
     * Specifies the max run duration for the given instance. If specified, the instance termination action will be performed at the end of the run duration.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration max_run_duration = 430839747;</code>
     * @return \Google\Cloud\Compute\V1\Duration|null
     */
    public function getMaxRunDuration()
    {
        return $this->max_run_duration;
    }

    public function hasMaxRunDuration()
    {
        return isset($this->max_run_duration);
    }

    public function clearMaxRunDuration()
    {
        unset($this->max_run_duration);
    }

    /**
     * Specifies the max run duration for the given instance. If specified, the instance termination action will be performed at the end of the run duration.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration max_run_duration = 430839747;</code>
     * @param \Google\Cloud\Compute\V1\Duration $var
     * @return $this
     */
    public function setMaxRunDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Duration::class);
        $this->max_run_duration = $var;

        return $this;
    }

    /**
     * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     *
     * Generated from protobuf field <code>optional int32 min_node_cpus = 317231675;</code>
     * @return int
     */
    public function getMinNodeCpus()
    {
        return isset($this->min_node_cpus) ? $this->min_node_cpus : 0;
    }

    public function hasMinNodeCpus()
    {
        return isset($this->min_node_cpus);
    }

    public function clearMinNodeCpus()
    {
        unset($this->min_node_cpus);
    }

    /**
     * The minimum number of virtual CPUs this instance will consume when running on a sole-tenant node.
     *
     * Generated from protobuf field <code>optional int32 min_node_cpus = 317231675;</code>
     * @param int $var
     * @return $this
     */
    public function setMinNodeCpus($var)
    {
        GPBUtil::checkInt32($var);
        $this->min_node_cpus = $var;

        return $this;
    }

    /**
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNodeAffinities()
    {
        return $this->node_affinities;
    }

    /**
     * A set of node affinity and anti-affinity configurations. Refer to Configuring node affinity for more information. Overrides reservationAffinity.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.SchedulingNodeAffinity node_affinities = 461799971;</code>
     * @param array<\Google\Cloud\Compute\V1\SchedulingNodeAffinity>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNodeAffinities($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\SchedulingNodeAffinity::class);
        $this->node_affinities = $arr;

        return $this;
    }

    /**
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
     * Check the OnHostMaintenance enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string on_host_maintenance = 64616796;</code>
     * @return string
     */
    public function getOnHostMaintenance()
    {
        return isset($this->on_host_maintenance) ? $this->on_host_maintenance : '';
    }

    public function hasOnHostMaintenance()
    {
        return isset($this->on_host_maintenance);
    }

    public function clearOnHostMaintenance()
    {
        unset($this->on_host_maintenance);
    }

    /**
     * Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Set VM host maintenance policy.
     * Check the OnHostMaintenance enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string on_host_maintenance = 64616796;</code>
     * @param string $var
     * @return $this
     */
    public function setOnHostMaintenance($var)
    {
        GPBUtil::checkString($var, True);
        $this->on_host_maintenance = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.SchedulingOnInstanceStopAction on_instance_stop_action = 529876681;</code>
     * @return \Google\Cloud\Compute\V1\SchedulingOnInstanceStopAction|null
     */
    public function getOnInstanceStopAction()
    {
        return $this->on_instance_stop_action;
    }

    public function hasOnInstanceStopAction()
    {
        return isset($this->on_instance_stop_action);
    }

    public function clearOnInstanceStopAction()
    {
        unset($this->on_instance_stop_action);
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.SchedulingOnInstanceStopAction on_instance_stop_action = 529876681;</code>
     * @param \Google\Cloud\Compute\V1\SchedulingOnInstanceStopAction $var
     * @return $this
     */
    public function setOnInstanceStopAction($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\SchedulingOnInstanceStopAction::class);
        $this->on_instance_stop_action = $var;

        return $this;
    }

    /**
     * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     *
     * Generated from protobuf field <code>optional bool preemptible = 324203169;</code>
     * @return bool
     */
    public function getPreemptible()
    {
        return isset($this->preemptible) ? $this->preemptible : false;
    }

    public function hasPreemptible()
    {
        return isset($this->preemptible);
    }

    public function clearPreemptible()
    {
        unset($this->preemptible);
    }

    /**
     * Defines whether the instance is preemptible. This can only be set during instance creation or while the instance is stopped and therefore, in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states.
     *
     * Generated from protobuf field <code>optional bool preemptible = 324203169;</code>
     * @param bool $var
     * @return $this
     */
    public function setPreemptible($var)
    {
        GPBUtil::checkBool($var);
        $this->preemptible = $var;

        return $this;
    }

    /**
     * Specifies the provisioning model of the instance.
     * Check the ProvisioningModel enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string provisioning_model = 494423;</code>
     * @return string
     */
    public function getProvisioningModel()
    {
        return isset($this->provisioning_model) ? $this->provisioning_model : '';
    }

    public function hasProvisioningModel()
    {
        return isset($this->provisioning_model);
    }

    public function clearProvisioningModel()
    {
        unset($this->provisioning_model);
    }

    /**
     * Specifies the provisioning model of the instance.
     * Check the ProvisioningModel enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string provisioning_model = 494423;</code>
     * @param string $var
     * @return $this
     */
    public function setProvisioningModel($var)
    {
        GPBUtil::checkString($var, True);
        $this->provisioning_model = $var;

        return $this;
    }

    /**
     * Specifies the timestamp, when the instance will be terminated, in RFC3339 text format. If specified, the instance termination action will be performed at the termination time.
     *
     * Generated from protobuf field <code>optional string termination_time = 428082984;</code>
     * @return string
     */
    public function getTerminationTime()
    {
        return isset($this->termination_time) ? $this->termination_time : '';
    }

    public function hasTerminationTime()
    {
        return isset($this->termination_time);
    }

    public function clearTerminationTime()
    {
        unset($this->termination_time);
    }

    /**
     * Specifies the timestamp, when the instance will be terminated, in RFC3339 text format. If specified, the instance termination action will be performed at the termination time.
     *
     * Generated from protobuf field <code>optional string termination_time = 428082984;</code>
     * @param string $var
     * @return $this
     */
    public function setTerminationTime($var)
    {
        GPBUtil::checkString($var, True);
        $this->termination_time = $var;

        return $this;
    }

}

