<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/v2/bigtable.proto

namespace Google\Cloud\Bigtable\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * NOTE: This API is intended to be used by Apache Beam BigtableIO.
 * Request message for Bigtable.ReadChangeStream.
 *
 * Generated from protobuf message <code>google.bigtable.v2.ReadChangeStreamRequest</code>
 */
class ReadChangeStreamRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The unique name of the table from which to read a change stream.
     * Values are of the form
     * `projects/<project>/instances/<instance>/tables/<table>`.
     * Change streaming must be enabled on the table.
     *
     * Generated from protobuf field <code>string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $table_name = '';
    /**
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * Single cluster routing must be configured on the profile.
     *
     * Generated from protobuf field <code>string app_profile_id = 2;</code>
     */
    protected $app_profile_id = '';
    /**
     * The partition to read changes from.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     */
    protected $partition = null;
    /**
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    protected $end_time = null;
    /**
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     */
    protected $heartbeat_duration = null;
    protected $start_from;

    /**
     * @param string $tableName Required. The unique name of the table from which to read a change stream.
     *                          Values are of the form
     *                          `projects/<project>/instances/<instance>/tables/<table>`.
     *                          Change streaming must be enabled on the table. Please see
     *                          {@see BigtableClient::tableName()} for help formatting this field.
     *
     * @return \Google\Cloud\Bigtable\V2\ReadChangeStreamRequest
     *
     * @experimental
     */
    public static function build(string $tableName): self
    {
        return (new self())
            ->setTableName($tableName);
    }

    /**
     * @param string $tableName    Required. The unique name of the table from which to read a change stream.
     *                             Values are of the form
     *                             `projects/<project>/instances/<instance>/tables/<table>`.
     *                             Change streaming must be enabled on the table. Please see
     *                             {@see BigtableClient::tableName()} for help formatting this field.
     * @param string $appProfileId This value specifies routing for replication. If not specified, the
     *                             "default" application profile will be used.
     *                             Single cluster routing must be configured on the profile.
     *
     * @return \Google\Cloud\Bigtable\V2\ReadChangeStreamRequest
     *
     * @experimental
     */
    public static function buildFromTableNameAppProfileId(string $tableName, string $appProfileId): self
    {
        return (new self())
            ->setTableName($tableName)
            ->setAppProfileId($appProfileId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $table_name
     *           Required. The unique name of the table from which to read a change stream.
     *           Values are of the form
     *           `projects/<project>/instances/<instance>/tables/<table>`.
     *           Change streaming must be enabled on the table.
     *     @type string $app_profile_id
     *           This value specifies routing for replication. If not specified, the
     *           "default" application profile will be used.
     *           Single cluster routing must be configured on the profile.
     *     @type \Google\Cloud\Bigtable\V2\StreamPartition $partition
     *           The partition to read changes from.
     *     @type \Google\Protobuf\Timestamp $start_time
     *           Start reading the stream at the specified timestamp. This timestamp must
     *           be within the change stream retention period, less than or equal to the
     *           current time, and after change stream creation, whichever is greater.
     *           This value is inclusive and will be truncated to microsecond granularity.
     *     @type \Google\Cloud\Bigtable\V2\StreamContinuationTokens $continuation_tokens
     *           Tokens that describe how to resume reading a stream where reading
     *           previously left off. If specified, changes will be read starting at the
     *           the position. Tokens are delivered on the stream as part of `Heartbeat`
     *           and `CloseStream` messages.
     *           If a single token is provided, the token’s partition must exactly match
     *           the request’s partition. If multiple tokens are provided, as in the case
     *           of a partition merge, the union of the token partitions must exactly
     *           cover the request’s partition. Otherwise, INVALID_ARGUMENT will be
     *           returned.
     *     @type \Google\Protobuf\Timestamp $end_time
     *           If specified, OK will be returned when the stream advances beyond
     *           this time. Otherwise, changes will be continuously delivered on the stream.
     *           This value is inclusive and will be truncated to microsecond granularity.
     *     @type \Google\Protobuf\Duration $heartbeat_duration
     *           If specified, the duration between `Heartbeat` messages on the stream.
     *           Otherwise, defaults to 5 seconds.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\V2\Bigtable::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The unique name of the table from which to read a change stream.
     * Values are of the form
     * `projects/<project>/instances/<instance>/tables/<table>`.
     * Change streaming must be enabled on the table.
     *
     * Generated from protobuf field <code>string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getTableName()
    {
        return $this->table_name;
    }

    /**
     * Required. The unique name of the table from which to read a change stream.
     * Values are of the form
     * `projects/<project>/instances/<instance>/tables/<table>`.
     * Change streaming must be enabled on the table.
     *
     * Generated from protobuf field <code>string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setTableName($var)
    {
        GPBUtil::checkString($var, True);
        $this->table_name = $var;

        return $this;
    }

    /**
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * Single cluster routing must be configured on the profile.
     *
     * Generated from protobuf field <code>string app_profile_id = 2;</code>
     * @return string
     */
    public function getAppProfileId()
    {
        return $this->app_profile_id;
    }

    /**
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * Single cluster routing must be configured on the profile.
     *
     * Generated from protobuf field <code>string app_profile_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAppProfileId($var)
    {
        GPBUtil::checkString($var, True);
        $this->app_profile_id = $var;

        return $this;
    }

    /**
     * The partition to read changes from.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     * @return \Google\Cloud\Bigtable\V2\StreamPartition|null
     */
    public function getPartition()
    {
        return $this->partition;
    }

    public function hasPartition()
    {
        return isset($this->partition);
    }

    public function clearPartition()
    {
        unset($this->partition);
    }

    /**
     * The partition to read changes from.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.StreamPartition partition = 3;</code>
     * @param \Google\Cloud\Bigtable\V2\StreamPartition $var
     * @return $this
     */
    public function setPartition($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Bigtable\V2\StreamPartition::class);
        $this->partition = $var;

        return $this;
    }

    /**
     * Start reading the stream at the specified timestamp. This timestamp must
     * be within the change stream retention period, less than or equal to the
     * current time, and after change stream creation, whichever is greater.
     * This value is inclusive and will be truncated to microsecond granularity.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 4;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTime()
    {
        return $this->readOneof(4);
    }

    public function hasStartTime()
    {
        return $this->hasOneof(4);
    }

    /**
     * Start reading the stream at the specified timestamp. This timestamp must
     * be within the change stream retention period, less than or equal to the
     * current time, and after change stream creation, whichever is greater.
     * This value is inclusive and will be truncated to microsecond granularity.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 4;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Tokens that describe how to resume reading a stream where reading
     * previously left off. If specified, changes will be read starting at the
     * the position. Tokens are delivered on the stream as part of `Heartbeat`
     * and `CloseStream` messages.
     * If a single token is provided, the token’s partition must exactly match
     * the request’s partition. If multiple tokens are provided, as in the case
     * of a partition merge, the union of the token partitions must exactly
     * cover the request’s partition. Otherwise, INVALID_ARGUMENT will be
     * returned.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
     * @return \Google\Cloud\Bigtable\V2\StreamContinuationTokens|null
     */
    public function getContinuationTokens()
    {
        return $this->readOneof(6);
    }

    public function hasContinuationTokens()
    {
        return $this->hasOneof(6);
    }

    /**
     * Tokens that describe how to resume reading a stream where reading
     * previously left off. If specified, changes will be read starting at the
     * the position. Tokens are delivered on the stream as part of `Heartbeat`
     * and `CloseStream` messages.
     * If a single token is provided, the token’s partition must exactly match
     * the request’s partition. If multiple tokens are provided, as in the case
     * of a partition merge, the union of the token partitions must exactly
     * cover the request’s partition. Otherwise, INVALID_ARGUMENT will be
     * returned.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.StreamContinuationTokens continuation_tokens = 6;</code>
     * @param \Google\Cloud\Bigtable\V2\StreamContinuationTokens $var
     * @return $this
     */
    public function setContinuationTokens($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Bigtable\V2\StreamContinuationTokens::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 5;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    public function hasEndTime()
    {
        return isset($this->end_time);
    }

    public function clearEndTime()
    {
        unset($this->end_time);
    }

    /**
     * If specified, OK will be returned when the stream advances beyond
     * this time. Otherwise, changes will be continuously delivered on the stream.
     * This value is inclusive and will be truncated to microsecond granularity.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

    /**
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getHeartbeatDuration()
    {
        return $this->heartbeat_duration;
    }

    public function hasHeartbeatDuration()
    {
        return isset($this->heartbeat_duration);
    }

    public function clearHeartbeatDuration()
    {
        unset($this->heartbeat_duration);
    }

    /**
     * If specified, the duration between `Heartbeat` messages on the stream.
     * Otherwise, defaults to 5 seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration heartbeat_duration = 7;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setHeartbeatDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->heartbeat_duration = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getStartFrom()
    {
        return $this->whichOneof("start_from");
    }

}

