<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/v2/data.proto

namespace Google\Cloud\Bigtable\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A partial result set from the streaming query API.
 * CBT client will buffer partial_rows from result_sets until it gets a
 * resumption_token.
 *
 * Generated from protobuf message <code>google.bigtable.v2.PartialResultSet</code>
 */
class PartialResultSet extends \Google\Protobuf\Internal\Message
{
    /**
     * An opaque token sent by the server to allow query resumption and signal
     * the client to accumulate `partial_rows` since the last non-empty
     * `resume_token`. On resumption, the resumed query will return the remaining
     * rows for this query.
     * If there is a batch in progress, a non-empty `resume_token`
     * means that that the batch of `partial_rows` will be complete after merging
     * the `partial_rows` from this response. The client must only yield
     * completed batches to the application, and must ensure that any future
     * retries send the latest token to avoid returning duplicate data.
     * The server may set 'resume_token' without a 'partial_rows'. If there is a
     * batch in progress the client should yield it.
     * The server will also send a sentinel `resume_token` when last batch of
     * `partial_rows` is sent. If the client retries the ExecuteQueryRequest with
     * the sentinel `resume_token`, the server will emit it again without any
     * `partial_rows`, then return OK.
     *
     * Generated from protobuf field <code>bytes resume_token = 5;</code>
     */
    protected $resume_token = '';
    /**
     * Estimated size of a new batch. The server will always set this when
     * returning the first `partial_rows` of a batch, and will not set it at any
     * other time.
     * The client can use this estimate to allocate an initial buffer for the
     * batched results. This helps minimize the number of allocations required,
     * though the buffer size may still need to be increased if the estimate is
     * too low.
     *
     * Generated from protobuf field <code>int32 estimated_batch_size = 4;</code>
     */
    protected $estimated_batch_size = 0;
    protected $partial_rows;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Bigtable\V2\ProtoRowsBatch $proto_rows_batch
     *           Partial rows in serialized ProtoRows format.
     *     @type string $resume_token
     *           An opaque token sent by the server to allow query resumption and signal
     *           the client to accumulate `partial_rows` since the last non-empty
     *           `resume_token`. On resumption, the resumed query will return the remaining
     *           rows for this query.
     *           If there is a batch in progress, a non-empty `resume_token`
     *           means that that the batch of `partial_rows` will be complete after merging
     *           the `partial_rows` from this response. The client must only yield
     *           completed batches to the application, and must ensure that any future
     *           retries send the latest token to avoid returning duplicate data.
     *           The server may set 'resume_token' without a 'partial_rows'. If there is a
     *           batch in progress the client should yield it.
     *           The server will also send a sentinel `resume_token` when last batch of
     *           `partial_rows` is sent. If the client retries the ExecuteQueryRequest with
     *           the sentinel `resume_token`, the server will emit it again without any
     *           `partial_rows`, then return OK.
     *     @type int $estimated_batch_size
     *           Estimated size of a new batch. The server will always set this when
     *           returning the first `partial_rows` of a batch, and will not set it at any
     *           other time.
     *           The client can use this estimate to allocate an initial buffer for the
     *           batched results. This helps minimize the number of allocations required,
     *           though the buffer size may still need to be increased if the estimate is
     *           too low.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\V2\Data::initOnce();
        parent::__construct($data);
    }

    /**
     * Partial rows in serialized ProtoRows format.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.ProtoRowsBatch proto_rows_batch = 3;</code>
     * @return \Google\Cloud\Bigtable\V2\ProtoRowsBatch|null
     */
    public function getProtoRowsBatch()
    {
        return $this->readOneof(3);
    }

    public function hasProtoRowsBatch()
    {
        return $this->hasOneof(3);
    }

    /**
     * Partial rows in serialized ProtoRows format.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.ProtoRowsBatch proto_rows_batch = 3;</code>
     * @param \Google\Cloud\Bigtable\V2\ProtoRowsBatch $var
     * @return $this
     */
    public function setProtoRowsBatch($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Bigtable\V2\ProtoRowsBatch::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * An opaque token sent by the server to allow query resumption and signal
     * the client to accumulate `partial_rows` since the last non-empty
     * `resume_token`. On resumption, the resumed query will return the remaining
     * rows for this query.
     * If there is a batch in progress, a non-empty `resume_token`
     * means that that the batch of `partial_rows` will be complete after merging
     * the `partial_rows` from this response. The client must only yield
     * completed batches to the application, and must ensure that any future
     * retries send the latest token to avoid returning duplicate data.
     * The server may set 'resume_token' without a 'partial_rows'. If there is a
     * batch in progress the client should yield it.
     * The server will also send a sentinel `resume_token` when last batch of
     * `partial_rows` is sent. If the client retries the ExecuteQueryRequest with
     * the sentinel `resume_token`, the server will emit it again without any
     * `partial_rows`, then return OK.
     *
     * Generated from protobuf field <code>bytes resume_token = 5;</code>
     * @return string
     */
    public function getResumeToken()
    {
        return $this->resume_token;
    }

    /**
     * An opaque token sent by the server to allow query resumption and signal
     * the client to accumulate `partial_rows` since the last non-empty
     * `resume_token`. On resumption, the resumed query will return the remaining
     * rows for this query.
     * If there is a batch in progress, a non-empty `resume_token`
     * means that that the batch of `partial_rows` will be complete after merging
     * the `partial_rows` from this response. The client must only yield
     * completed batches to the application, and must ensure that any future
     * retries send the latest token to avoid returning duplicate data.
     * The server may set 'resume_token' without a 'partial_rows'. If there is a
     * batch in progress the client should yield it.
     * The server will also send a sentinel `resume_token` when last batch of
     * `partial_rows` is sent. If the client retries the ExecuteQueryRequest with
     * the sentinel `resume_token`, the server will emit it again without any
     * `partial_rows`, then return OK.
     *
     * Generated from protobuf field <code>bytes resume_token = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setResumeToken($var)
    {
        GPBUtil::checkString($var, False);
        $this->resume_token = $var;

        return $this;
    }

    /**
     * Estimated size of a new batch. The server will always set this when
     * returning the first `partial_rows` of a batch, and will not set it at any
     * other time.
     * The client can use this estimate to allocate an initial buffer for the
     * batched results. This helps minimize the number of allocations required,
     * though the buffer size may still need to be increased if the estimate is
     * too low.
     *
     * Generated from protobuf field <code>int32 estimated_batch_size = 4;</code>
     * @return int
     */
    public function getEstimatedBatchSize()
    {
        return $this->estimated_batch_size;
    }

    /**
     * Estimated size of a new batch. The server will always set this when
     * returning the first `partial_rows` of a batch, and will not set it at any
     * other time.
     * The client can use this estimate to allocate an initial buffer for the
     * batched results. This helps minimize the number of allocations required,
     * though the buffer size may still need to be increased if the estimate is
     * too low.
     *
     * Generated from protobuf field <code>int32 estimated_batch_size = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setEstimatedBatchSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->estimated_batch_size = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getPartialRows()
    {
        return $this->whichOneof("partial_rows");
    }

}

