<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/apihub/v1/apihub_service.proto

namespace Google\Cloud\ApiHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The [CreateAttribute][google.cloud.apihub.v1.ApiHub.CreateAttribute] method's
 * request.
 *
 * Generated from protobuf message <code>google.cloud.apihub.v1.CreateAttributeRequest</code>
 */
class CreateAttributeRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource for Attribute.
     * Format: `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Optional. The ID to use for the attribute, which will become the final
     * component of the attribute's resource name. This field is optional.
     * * If provided, the same will be used. The service will throw an error if
     * the specified id is already used by another attribute resource in the API
     * hub.
     * * If not provided, a system generated id will be used.
     * This value should be 4-500 characters, and valid characters
     * are /[a-z][A-Z][0-9]-_/.
     *
     * Generated from protobuf field <code>string attribute_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $attribute_id = '';
    /**
     * Required. The attribute to create.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Attribute attribute = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $attribute = null;

    /**
     * @param string                            $parent      Required. The parent resource for Attribute.
     *                                                       Format: `projects/{project}/locations/{location}`
     *                                                       Please see {@see ApiHubClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\ApiHub\V1\Attribute $attribute   Required. The attribute to create.
     * @param string                            $attributeId Optional. The ID to use for the attribute, which will become the final
     *                                                       component of the attribute's resource name. This field is optional.
     *
     *                                                       * If provided, the same will be used. The service will throw an error if
     *                                                       the specified id is already used by another attribute resource in the API
     *                                                       hub.
     *                                                       * If not provided, a system generated id will be used.
     *
     *                                                       This value should be 4-500 characters, and valid characters
     *                                                       are /[a-z][A-Z][0-9]-_/.
     *
     * @return \Google\Cloud\ApiHub\V1\CreateAttributeRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\ApiHub\V1\Attribute $attribute, string $attributeId): self
    {
        return (new self())
            ->setParent($parent)
            ->setAttribute($attribute)
            ->setAttributeId($attributeId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent resource for Attribute.
     *           Format: `projects/{project}/locations/{location}`
     *     @type string $attribute_id
     *           Optional. The ID to use for the attribute, which will become the final
     *           component of the attribute's resource name. This field is optional.
     *           * If provided, the same will be used. The service will throw an error if
     *           the specified id is already used by another attribute resource in the API
     *           hub.
     *           * If not provided, a system generated id will be used.
     *           This value should be 4-500 characters, and valid characters
     *           are /[a-z][A-Z][0-9]-_/.
     *     @type \Google\Cloud\ApiHub\V1\Attribute $attribute
     *           Required. The attribute to create.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Apihub\V1\ApihubService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent resource for Attribute.
     * Format: `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource for Attribute.
     * Format: `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Optional. The ID to use for the attribute, which will become the final
     * component of the attribute's resource name. This field is optional.
     * * If provided, the same will be used. The service will throw an error if
     * the specified id is already used by another attribute resource in the API
     * hub.
     * * If not provided, a system generated id will be used.
     * This value should be 4-500 characters, and valid characters
     * are /[a-z][A-Z][0-9]-_/.
     *
     * Generated from protobuf field <code>string attribute_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAttributeId()
    {
        return $this->attribute_id;
    }

    /**
     * Optional. The ID to use for the attribute, which will become the final
     * component of the attribute's resource name. This field is optional.
     * * If provided, the same will be used. The service will throw an error if
     * the specified id is already used by another attribute resource in the API
     * hub.
     * * If not provided, a system generated id will be used.
     * This value should be 4-500 characters, and valid characters
     * are /[a-z][A-Z][0-9]-_/.
     *
     * Generated from protobuf field <code>string attribute_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAttributeId($var)
    {
        GPBUtil::checkString($var, True);
        $this->attribute_id = $var;

        return $this;
    }

    /**
     * Required. The attribute to create.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Attribute attribute = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\ApiHub\V1\Attribute|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }

    public function hasAttribute()
    {
        return isset($this->attribute);
    }

    public function clearAttribute()
    {
        unset($this->attribute);
    }

    /**
     * Required. The attribute to create.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Attribute attribute = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\ApiHub\V1\Attribute $var
     * @return $this
     */
    public function setAttribute($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\Attribute::class);
        $this->attribute = $var;

        return $this;
    }

}

