<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/logging/v2/logging_config.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Logging\V2\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Logging\V2\CmekSettings;
use Google\Cloud\Logging\V2\CopyLogEntriesRequest;
use Google\Cloud\Logging\V2\CreateBucketRequest;
use Google\Cloud\Logging\V2\CreateExclusionRequest;
use Google\Cloud\Logging\V2\CreateLinkRequest;
use Google\Cloud\Logging\V2\CreateSinkRequest;
use Google\Cloud\Logging\V2\CreateViewRequest;
use Google\Cloud\Logging\V2\DeleteBucketRequest;
use Google\Cloud\Logging\V2\DeleteExclusionRequest;
use Google\Cloud\Logging\V2\DeleteLinkRequest;
use Google\Cloud\Logging\V2\DeleteSinkRequest;
use Google\Cloud\Logging\V2\DeleteViewRequest;
use Google\Cloud\Logging\V2\GetBucketRequest;
use Google\Cloud\Logging\V2\GetCmekSettingsRequest;
use Google\Cloud\Logging\V2\GetExclusionRequest;
use Google\Cloud\Logging\V2\GetLinkRequest;
use Google\Cloud\Logging\V2\GetSettingsRequest;
use Google\Cloud\Logging\V2\GetSinkRequest;
use Google\Cloud\Logging\V2\GetViewRequest;
use Google\Cloud\Logging\V2\Link;
use Google\Cloud\Logging\V2\ListBucketsRequest;
use Google\Cloud\Logging\V2\ListExclusionsRequest;
use Google\Cloud\Logging\V2\ListLinksRequest;
use Google\Cloud\Logging\V2\ListSinksRequest;
use Google\Cloud\Logging\V2\ListViewsRequest;
use Google\Cloud\Logging\V2\LogBucket;
use Google\Cloud\Logging\V2\LogExclusion;
use Google\Cloud\Logging\V2\LogSink;
use Google\Cloud\Logging\V2\LogView;
use Google\Cloud\Logging\V2\Settings;
use Google\Cloud\Logging\V2\UndeleteBucketRequest;
use Google\Cloud\Logging\V2\UpdateBucketRequest;
use Google\Cloud\Logging\V2\UpdateCmekSettingsRequest;
use Google\Cloud\Logging\V2\UpdateExclusionRequest;
use Google\Cloud\Logging\V2\UpdateSettingsRequest;
use Google\Cloud\Logging\V2\UpdateSinkRequest;
use Google\Cloud\Logging\V2\UpdateViewRequest;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service for configuring sinks used to route log entries.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\Logging\V2\ConfigServiceV2Client} for the stable implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface copyLogEntriesAsync(CopyLogEntriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createBucketAsync(CreateBucketRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createBucketAsyncAsync(CreateBucketRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createExclusionAsync(CreateExclusionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createLinkAsync(CreateLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSinkAsync(CreateSinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createViewAsync(CreateViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteBucketAsync(DeleteBucketRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteExclusionAsync(DeleteExclusionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteLinkAsync(DeleteLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSinkAsync(DeleteSinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteViewAsync(DeleteViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getBucketAsync(GetBucketRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCmekSettingsAsync(GetCmekSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getExclusionAsync(GetExclusionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLinkAsync(GetLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSettingsAsync(GetSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSinkAsync(GetSinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getViewAsync(GetViewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBucketsAsync(ListBucketsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listExclusionsAsync(ListExclusionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLinksAsync(ListLinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSinksAsync(ListSinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listViewsAsync(ListViewsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface undeleteBucketAsync(UndeleteBucketRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateBucketAsync(UpdateBucketRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateBucketAsyncAsync(UpdateBucketRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCmekSettingsAsync(UpdateCmekSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateExclusionAsync(UpdateExclusionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSettingsAsync(UpdateSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSinkAsync(UpdateSinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateViewAsync(UpdateViewRequest $request, array $optionalArgs = [])
 */
abstract class ConfigServiceV2BaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.logging.v2.ConfigServiceV2';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'logging.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-platform.read-only',
        'https://www.googleapis.com/auth/logging.admin',
        'https://www.googleapis.com/auth/logging.read',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/config_service_v2_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/config_service_v2_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/config_service_v2_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/config_service_v2_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account resource.
     *
     * @param string $billingAccount
     *
     * @return string The formatted billing_account resource.
     */
    public static function billingAccountName(string $billingAccount): string
    {
        return self::getPathTemplate('billingAccount')->render([
            'billing_account' => $billingAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_cmekSettings resource.
     *
     * @param string $billingAccount
     *
     * @return string The formatted billing_account_cmekSettings resource.
     */
    public static function billingAccountCmekSettingsName(string $billingAccount): string
    {
        return self::getPathTemplate('billingAccountCmekSettings')->render([
            'billing_account' => $billingAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_exclusion resource.
     *
     * @param string $billingAccount
     * @param string $exclusion
     *
     * @return string The formatted billing_account_exclusion resource.
     */
    public static function billingAccountExclusionName(string $billingAccount, string $exclusion): string
    {
        return self::getPathTemplate('billingAccountExclusion')->render([
            'billing_account' => $billingAccount,
            'exclusion' => $exclusion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_location resource.
     *
     * @param string $billingAccount
     * @param string $location
     *
     * @return string The formatted billing_account_location resource.
     */
    public static function billingAccountLocationName(string $billingAccount, string $location): string
    {
        return self::getPathTemplate('billingAccountLocation')->render([
            'billing_account' => $billingAccount,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_location_bucket resource.
     *
     * @param string $billingAccount
     * @param string $location
     * @param string $bucket
     *
     * @return string The formatted billing_account_location_bucket resource.
     */
    public static function billingAccountLocationBucketName(string $billingAccount, string $location, string $bucket): string
    {
        return self::getPathTemplate('billingAccountLocationBucket')->render([
            'billing_account' => $billingAccount,
            'location' => $location,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_location_bucket_link resource.
     *
     * @param string $billingAccount
     * @param string $location
     * @param string $bucket
     * @param string $link
     *
     * @return string The formatted billing_account_location_bucket_link resource.
     */
    public static function billingAccountLocationBucketLinkName(string $billingAccount, string $location, string $bucket, string $link): string
    {
        return self::getPathTemplate('billingAccountLocationBucketLink')->render([
            'billing_account' => $billingAccount,
            'location' => $location,
            'bucket' => $bucket,
            'link' => $link,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_location_bucket_view resource.
     *
     * @param string $billingAccount
     * @param string $location
     * @param string $bucket
     * @param string $view
     *
     * @return string The formatted billing_account_location_bucket_view resource.
     */
    public static function billingAccountLocationBucketViewName(string $billingAccount, string $location, string $bucket, string $view): string
    {
        return self::getPathTemplate('billingAccountLocationBucketView')->render([
            'billing_account' => $billingAccount,
            'location' => $location,
            'bucket' => $bucket,
            'view' => $view,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_settings resource.
     *
     * @param string $billingAccount
     *
     * @return string The formatted billing_account_settings resource.
     */
    public static function billingAccountSettingsName(string $billingAccount): string
    {
        return self::getPathTemplate('billingAccountSettings')->render([
            'billing_account' => $billingAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_sink resource.
     *
     * @param string $billingAccount
     * @param string $sink
     *
     * @return string The formatted billing_account_sink resource.
     */
    public static function billingAccountSinkName(string $billingAccount, string $sink): string
    {
        return self::getPathTemplate('billingAccountSink')->render([
            'billing_account' => $billingAccount,
            'sink' => $sink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * cmek_settings resource.
     *
     * @param string $project
     *
     * @return string The formatted cmek_settings resource.
     */
    public static function cmekSettingsName(string $project): string
    {
        return self::getPathTemplate('cmekSettings')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName(string $folder): string
    {
        return self::getPathTemplate('folder')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_cmekSettings resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder_cmekSettings resource.
     */
    public static function folderCmekSettingsName(string $folder): string
    {
        return self::getPathTemplate('folderCmekSettings')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_exclusion resource.
     *
     * @param string $folder
     * @param string $exclusion
     *
     * @return string The formatted folder_exclusion resource.
     */
    public static function folderExclusionName(string $folder, string $exclusion): string
    {
        return self::getPathTemplate('folderExclusion')->render([
            'folder' => $folder,
            'exclusion' => $exclusion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted folder_location resource.
     */
    public static function folderLocationName(string $folder, string $location): string
    {
        return self::getPathTemplate('folderLocation')->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_bucket resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $bucket
     *
     * @return string The formatted folder_location_bucket resource.
     */
    public static function folderLocationBucketName(string $folder, string $location, string $bucket): string
    {
        return self::getPathTemplate('folderLocationBucket')->render([
            'folder' => $folder,
            'location' => $location,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_bucket_link resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $bucket
     * @param string $link
     *
     * @return string The formatted folder_location_bucket_link resource.
     */
    public static function folderLocationBucketLinkName(string $folder, string $location, string $bucket, string $link): string
    {
        return self::getPathTemplate('folderLocationBucketLink')->render([
            'folder' => $folder,
            'location' => $location,
            'bucket' => $bucket,
            'link' => $link,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_bucket_view resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $bucket
     * @param string $view
     *
     * @return string The formatted folder_location_bucket_view resource.
     */
    public static function folderLocationBucketViewName(string $folder, string $location, string $bucket, string $view): string
    {
        return self::getPathTemplate('folderLocationBucketView')->render([
            'folder' => $folder,
            'location' => $location,
            'bucket' => $bucket,
            'view' => $view,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_settings resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder_settings resource.
     */
    public static function folderSettingsName(string $folder): string
    {
        return self::getPathTemplate('folderSettings')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder_sink
     * resource.
     *
     * @param string $folder
     * @param string $sink
     *
     * @return string The formatted folder_sink resource.
     */
    public static function folderSinkName(string $folder, string $sink): string
    {
        return self::getPathTemplate('folderSink')->render([
            'folder' => $folder,
            'sink' => $sink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a link
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $bucket
     * @param string $link
     *
     * @return string The formatted link resource.
     */
    public static function linkName(string $project, string $location, string $bucket, string $link): string
    {
        return self::getPathTemplate('link')->render([
            'project' => $project,
            'location' => $location,
            'bucket' => $bucket,
            'link' => $link,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a log_bucket
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $bucket
     *
     * @return string The formatted log_bucket resource.
     */
    public static function logBucketName(string $project, string $location, string $bucket): string
    {
        return self::getPathTemplate('logBucket')->render([
            'project' => $project,
            'location' => $location,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * log_exclusion resource.
     *
     * @param string $project
     * @param string $exclusion
     *
     * @return string The formatted log_exclusion resource.
     */
    public static function logExclusionName(string $project, string $exclusion): string
    {
        return self::getPathTemplate('logExclusion')->render([
            'project' => $project,
            'exclusion' => $exclusion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a log_sink
     * resource.
     *
     * @param string $project
     * @param string $sink
     *
     * @return string The formatted log_sink resource.
     */
    public static function logSinkName(string $project, string $sink): string
    {
        return self::getPathTemplate('logSink')->render([
            'project' => $project,
            'sink' => $sink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a log_view
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $bucket
     * @param string $view
     *
     * @return string The formatted log_view resource.
     */
    public static function logViewName(string $project, string $location, string $bucket, string $view): string
    {
        return self::getPathTemplate('logView')->render([
            'project' => $project,
            'location' => $location,
            'bucket' => $bucket,
            'view' => $view,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName(string $organization): string
    {
        return self::getPathTemplate('organization')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_cmekSettings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_cmekSettings resource.
     */
    public static function organizationCmekSettingsName(string $organization): string
    {
        return self::getPathTemplate('organizationCmekSettings')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_exclusion resource.
     *
     * @param string $organization
     * @param string $exclusion
     *
     * @return string The formatted organization_exclusion resource.
     */
    public static function organizationExclusionName(string $organization, string $exclusion): string
    {
        return self::getPathTemplate('organizationExclusion')->render([
            'organization' => $organization,
            'exclusion' => $exclusion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName(string $organization, string $location): string
    {
        return self::getPathTemplate('organizationLocation')->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_bucket resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $bucket
     *
     * @return string The formatted organization_location_bucket resource.
     */
    public static function organizationLocationBucketName(string $organization, string $location, string $bucket): string
    {
        return self::getPathTemplate('organizationLocationBucket')->render([
            'organization' => $organization,
            'location' => $location,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_bucket_link resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $bucket
     * @param string $link
     *
     * @return string The formatted organization_location_bucket_link resource.
     */
    public static function organizationLocationBucketLinkName(string $organization, string $location, string $bucket, string $link): string
    {
        return self::getPathTemplate('organizationLocationBucketLink')->render([
            'organization' => $organization,
            'location' => $location,
            'bucket' => $bucket,
            'link' => $link,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_bucket_view resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $bucket
     * @param string $view
     *
     * @return string The formatted organization_location_bucket_view resource.
     */
    public static function organizationLocationBucketViewName(string $organization, string $location, string $bucket, string $view): string
    {
        return self::getPathTemplate('organizationLocationBucketView')->render([
            'organization' => $organization,
            'location' => $location,
            'bucket' => $bucket,
            'view' => $view,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_settings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_settings resource.
     */
    public static function organizationSettingsName(string $organization): string
    {
        return self::getPathTemplate('organizationSettings')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_sink resource.
     *
     * @param string $organization
     * @param string $sink
     *
     * @return string The formatted organization_sink resource.
     */
    public static function organizationSinkName(string $organization, string $sink): string
    {
        return self::getPathTemplate('organizationSink')->render([
            'organization' => $organization,
            'sink' => $sink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_cmekSettings resource.
     *
     * @param string $project
     *
     * @return string The formatted project_cmekSettings resource.
     */
    public static function projectCmekSettingsName(string $project): string
    {
        return self::getPathTemplate('projectCmekSettings')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_exclusion resource.
     *
     * @param string $project
     * @param string $exclusion
     *
     * @return string The formatted project_exclusion resource.
     */
    public static function projectExclusionName(string $project, string $exclusion): string
    {
        return self::getPathTemplate('projectExclusion')->render([
            'project' => $project,
            'exclusion' => $exclusion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_bucket resource.
     *
     * @param string $project
     * @param string $location
     * @param string $bucket
     *
     * @return string The formatted project_location_bucket resource.
     */
    public static function projectLocationBucketName(string $project, string $location, string $bucket): string
    {
        return self::getPathTemplate('projectLocationBucket')->render([
            'project' => $project,
            'location' => $location,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_bucket_link resource.
     *
     * @param string $project
     * @param string $location
     * @param string $bucket
     * @param string $link
     *
     * @return string The formatted project_location_bucket_link resource.
     */
    public static function projectLocationBucketLinkName(string $project, string $location, string $bucket, string $link): string
    {
        return self::getPathTemplate('projectLocationBucketLink')->render([
            'project' => $project,
            'location' => $location,
            'bucket' => $bucket,
            'link' => $link,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_bucket_view resource.
     *
     * @param string $project
     * @param string $location
     * @param string $bucket
     * @param string $view
     *
     * @return string The formatted project_location_bucket_view resource.
     */
    public static function projectLocationBucketViewName(string $project, string $location, string $bucket, string $view): string
    {
        return self::getPathTemplate('projectLocationBucketView')->render([
            'project' => $project,
            'location' => $location,
            'bucket' => $bucket,
            'view' => $view,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_settings resource.
     *
     * @param string $project
     *
     * @return string The formatted project_settings resource.
     */
    public static function projectSettingsName(string $project): string
    {
        return self::getPathTemplate('projectSettings')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project_sink
     * resource.
     *
     * @param string $project
     * @param string $sink
     *
     * @return string The formatted project_sink resource.
     */
    public static function projectSinkName(string $project, string $sink): string
    {
        return self::getPathTemplate('projectSink')->render([
            'project' => $project,
            'sink' => $sink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a settings
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted settings resource.
     */
    public static function settingsName(string $project): string
    {
        return self::getPathTemplate('settings')->render([
            'project' => $project,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - billingAccount: billingAccounts/{billing_account}
     * - billingAccountCmekSettings: billingAccounts/{billing_account}/cmekSettings
     * - billingAccountExclusion: billingAccounts/{billing_account}/exclusions/{exclusion}
     * - billingAccountLocation: billingAccounts/{billing_account}/locations/{location}
     * - billingAccountLocationBucket: billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}
     * - billingAccountLocationBucketLink: billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}/links/{link}
     * - billingAccountLocationBucketView: billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}/views/{view}
     * - billingAccountSettings: billingAccounts/{billing_account}/settings
     * - billingAccountSink: billingAccounts/{billing_account}/sinks/{sink}
     * - cmekSettings: projects/{project}/cmekSettings
     * - folder: folders/{folder}
     * - folderCmekSettings: folders/{folder}/cmekSettings
     * - folderExclusion: folders/{folder}/exclusions/{exclusion}
     * - folderLocation: folders/{folder}/locations/{location}
     * - folderLocationBucket: folders/{folder}/locations/{location}/buckets/{bucket}
     * - folderLocationBucketLink: folders/{folder}/locations/{location}/buckets/{bucket}/links/{link}
     * - folderLocationBucketView: folders/{folder}/locations/{location}/buckets/{bucket}/views/{view}
     * - folderSettings: folders/{folder}/settings
     * - folderSink: folders/{folder}/sinks/{sink}
     * - link: projects/{project}/locations/{location}/buckets/{bucket}/links/{link}
     * - location: projects/{project}/locations/{location}
     * - logBucket: projects/{project}/locations/{location}/buckets/{bucket}
     * - logExclusion: projects/{project}/exclusions/{exclusion}
     * - logSink: projects/{project}/sinks/{sink}
     * - logView: projects/{project}/locations/{location}/buckets/{bucket}/views/{view}
     * - organization: organizations/{organization}
     * - organizationCmekSettings: organizations/{organization}/cmekSettings
     * - organizationExclusion: organizations/{organization}/exclusions/{exclusion}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationBucket: organizations/{organization}/locations/{location}/buckets/{bucket}
     * - organizationLocationBucketLink: organizations/{organization}/locations/{location}/buckets/{bucket}/links/{link}
     * - organizationLocationBucketView: organizations/{organization}/locations/{location}/buckets/{bucket}/views/{view}
     * - organizationSettings: organizations/{organization}/settings
     * - organizationSink: organizations/{organization}/sinks/{sink}
     * - project: projects/{project}
     * - projectCmekSettings: projects/{project}/cmekSettings
     * - projectExclusion: projects/{project}/exclusions/{exclusion}
     * - projectLocationBucket: projects/{project}/locations/{location}/buckets/{bucket}
     * - projectLocationBucketLink: projects/{project}/locations/{location}/buckets/{bucket}/links/{link}
     * - projectLocationBucketView: projects/{project}/locations/{location}/buckets/{bucket}/views/{view}
     * - projectSettings: projects/{project}/settings
     * - projectSink: projects/{project}/sinks/{sink}
     * - settings: projects/{project}/settings
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'logging.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Copies a set of log entries from a log bucket to a Cloud Storage bucket.
     *
     * The async variant is {@see self::copyLogEntriesAsync()} .
     *
     * @param CopyLogEntriesRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function copyLogEntries(CopyLogEntriesRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CopyLogEntries', $request, $callOptions)->wait();
    }

    /**
     * Creates a log bucket that can be used to store log entries. After a bucket
     * has been created, the bucket's location cannot be changed.
     *
     * The async variant is {@see self::createBucketAsync()} .
     *
     * @param CreateBucketRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogBucket
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBucket(CreateBucketRequest $request, array $callOptions = []): LogBucket
    {
        return $this->startApiCall('CreateBucket', $request, $callOptions)->wait();
    }

    /**
     * Creates a log bucket asynchronously that can be used to store log entries.
     *
     * After a bucket has been created, the bucket's location cannot be changed.
     *
     * The async variant is {@see self::createBucketAsyncAsync()} .
     *
     * @param CreateBucketRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBucketAsync(CreateBucketRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBucketAsync', $request, $callOptions)->wait();
    }

    /**
     * Creates a new exclusion in the _Default sink in a specified parent
     * resource. Only log entries belonging to that resource can be excluded. You
     * can have up to 10 exclusions in a resource.
     *
     * The async variant is {@see self::createExclusionAsync()} .
     *
     * @param CreateExclusionRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogExclusion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createExclusion(CreateExclusionRequest $request, array $callOptions = []): LogExclusion
    {
        return $this->startApiCall('CreateExclusion', $request, $callOptions)->wait();
    }

    /**
     * Asynchronously creates a linked dataset in BigQuery which makes it possible
     * to use BigQuery to read the logs stored in the log bucket. A log bucket may
     * currently only contain one link.
     *
     * The async variant is {@see self::createLinkAsync()} .
     *
     * @param CreateLinkRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createLink(CreateLinkRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateLink', $request, $callOptions)->wait();
    }

    /**
     * Creates a sink that exports specified log entries to a destination. The
     * export of newly-ingested log entries begins immediately, unless the sink's
     * `writer_identity` is not permitted to write to the destination. A sink can
     * export log entries only from the resource owning the sink.
     *
     * The async variant is {@see self::createSinkAsync()} .
     *
     * @param CreateSinkRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogSink
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSink(CreateSinkRequest $request, array $callOptions = []): LogSink
    {
        return $this->startApiCall('CreateSink', $request, $callOptions)->wait();
    }

    /**
     * Creates a view over log entries in a log bucket. A bucket may contain a
     * maximum of 30 views.
     *
     * The async variant is {@see self::createViewAsync()} .
     *
     * @param CreateViewRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogView
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createView(CreateViewRequest $request, array $callOptions = []): LogView
    {
        return $this->startApiCall('CreateView', $request, $callOptions)->wait();
    }

    /**
     * Deletes a log bucket.
     *
     * Changes the bucket's `lifecycle_state` to the `DELETE_REQUESTED` state.
     * After 7 days, the bucket will be purged and all log entries in the bucket
     * will be permanently deleted.
     *
     * The async variant is {@see self::deleteBucketAsync()} .
     *
     * @param DeleteBucketRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBucket(DeleteBucketRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteBucket', $request, $callOptions)->wait();
    }

    /**
     * Deletes an exclusion in the _Default sink.
     *
     * The async variant is {@see self::deleteExclusionAsync()} .
     *
     * @param DeleteExclusionRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteExclusion(DeleteExclusionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteExclusion', $request, $callOptions)->wait();
    }

    /**
     * Deletes a link. This will also delete the corresponding BigQuery linked
     * dataset.
     *
     * The async variant is {@see self::deleteLinkAsync()} .
     *
     * @param DeleteLinkRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteLink(DeleteLinkRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteLink', $request, $callOptions)->wait();
    }

    /**
     * Deletes a sink. If the sink has a unique `writer_identity`, then that
     * service account is also deleted.
     *
     * The async variant is {@see self::deleteSinkAsync()} .
     *
     * @param DeleteSinkRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSink(DeleteSinkRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSink', $request, $callOptions)->wait();
    }

    /**
     * Deletes a view on a log bucket.
     * If an `UNAVAILABLE` error is returned, this indicates that system is not in
     * a state where it can delete the view. If this occurs, please try again in a
     * few minutes.
     *
     * The async variant is {@see self::deleteViewAsync()} .
     *
     * @param DeleteViewRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteView(DeleteViewRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteView', $request, $callOptions)->wait();
    }

    /**
     * Gets a log bucket.
     *
     * The async variant is {@see self::getBucketAsync()} .
     *
     * @param GetBucketRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogBucket
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBucket(GetBucketRequest $request, array $callOptions = []): LogBucket
    {
        return $this->startApiCall('GetBucket', $request, $callOptions)->wait();
    }

    /**
     * Gets the Logging CMEK settings for the given resource.
     *
     * Note: CMEK for the Log Router can be configured for Google Cloud projects,
     * folders, organizations and billing accounts. Once configured for an
     * organization, it applies to all projects and folders in the Google Cloud
     * organization.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * The async variant is {@see self::getCmekSettingsAsync()} .
     *
     * @param GetCmekSettingsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CmekSettings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCmekSettings(GetCmekSettingsRequest $request, array $callOptions = []): CmekSettings
    {
        return $this->startApiCall('GetCmekSettings', $request, $callOptions)->wait();
    }

    /**
     * Gets the description of an exclusion in the _Default sink.
     *
     * The async variant is {@see self::getExclusionAsync()} .
     *
     * @param GetExclusionRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogExclusion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getExclusion(GetExclusionRequest $request, array $callOptions = []): LogExclusion
    {
        return $this->startApiCall('GetExclusion', $request, $callOptions)->wait();
    }

    /**
     * Gets a link.
     *
     * The async variant is {@see self::getLinkAsync()} .
     *
     * @param GetLinkRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Link
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLink(GetLinkRequest $request, array $callOptions = []): Link
    {
        return $this->startApiCall('GetLink', $request, $callOptions)->wait();
    }

    /**
     * Gets the Log Router settings for the given resource.
     *
     * Note: Settings for the Log Router can be get for Google Cloud projects,
     * folders, organizations and billing accounts. Currently it can only be
     * configured for organizations. Once configured for an organization, it
     * applies to all projects and folders in the Google Cloud organization.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * The async variant is {@see self::getSettingsAsync()} .
     *
     * @param GetSettingsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Settings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSettings(GetSettingsRequest $request, array $callOptions = []): Settings
    {
        return $this->startApiCall('GetSettings', $request, $callOptions)->wait();
    }

    /**
     * Gets a sink.
     *
     * The async variant is {@see self::getSinkAsync()} .
     *
     * @param GetSinkRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogSink
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSink(GetSinkRequest $request, array $callOptions = []): LogSink
    {
        return $this->startApiCall('GetSink', $request, $callOptions)->wait();
    }

    /**
     * Gets a view on a log bucket..
     *
     * The async variant is {@see self::getViewAsync()} .
     *
     * @param GetViewRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogView
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getView(GetViewRequest $request, array $callOptions = []): LogView
    {
        return $this->startApiCall('GetView', $request, $callOptions)->wait();
    }

    /**
     * Lists log buckets.
     *
     * The async variant is {@see self::listBucketsAsync()} .
     *
     * @param ListBucketsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBuckets(ListBucketsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBuckets', $request, $callOptions);
    }

    /**
     * Lists all the exclusions on the _Default sink in a parent resource.
     *
     * The async variant is {@see self::listExclusionsAsync()} .
     *
     * @param ListExclusionsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listExclusions(ListExclusionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListExclusions', $request, $callOptions);
    }

    /**
     * Lists links.
     *
     * The async variant is {@see self::listLinksAsync()} .
     *
     * @param ListLinksRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLinks(ListLinksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLinks', $request, $callOptions);
    }

    /**
     * Lists sinks.
     *
     * The async variant is {@see self::listSinksAsync()} .
     *
     * @param ListSinksRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSinks(ListSinksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSinks', $request, $callOptions);
    }

    /**
     * Lists views on a log bucket.
     *
     * The async variant is {@see self::listViewsAsync()} .
     *
     * @param ListViewsRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listViews(ListViewsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListViews', $request, $callOptions);
    }

    /**
     * Undeletes a log bucket. A bucket that has been deleted can be undeleted
     * within the grace period of 7 days.
     *
     * The async variant is {@see self::undeleteBucketAsync()} .
     *
     * @param UndeleteBucketRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function undeleteBucket(UndeleteBucketRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('UndeleteBucket', $request, $callOptions)->wait();
    }

    /**
     * Updates a log bucket.
     *
     * If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
     * `FAILED_PRECONDITION` will be returned.
     *
     * After a bucket has been created, the bucket's location cannot be changed.
     *
     * The async variant is {@see self::updateBucketAsync()} .
     *
     * @param UpdateBucketRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogBucket
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBucket(UpdateBucketRequest $request, array $callOptions = []): LogBucket
    {
        return $this->startApiCall('UpdateBucket', $request, $callOptions)->wait();
    }

    /**
     * Updates a log bucket asynchronously.
     *
     * If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
     * `FAILED_PRECONDITION` will be returned.
     *
     * After a bucket has been created, the bucket's location cannot be changed.
     *
     * The async variant is {@see self::updateBucketAsyncAsync()} .
     *
     * @param UpdateBucketRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBucketAsync(UpdateBucketRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBucketAsync', $request, $callOptions)->wait();
    }

    /**
     * Updates the Log Router CMEK settings for the given resource.
     *
     * Note: CMEK for the Log Router can currently only be configured for Google
     * Cloud organizations. Once configured, it applies to all projects and
     * folders in the Google Cloud organization.
     *
     * [UpdateCmekSettings][google.logging.v2.ConfigServiceV2.UpdateCmekSettings]
     * will fail if 1) `kms_key_name` is invalid, or 2) the associated service
     * account does not have the required
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
     * 3) access to the key is disabled.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * The async variant is {@see self::updateCmekSettingsAsync()} .
     *
     * @param UpdateCmekSettingsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CmekSettings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCmekSettings(UpdateCmekSettingsRequest $request, array $callOptions = []): CmekSettings
    {
        return $this->startApiCall('UpdateCmekSettings', $request, $callOptions)->wait();
    }

    /**
     * Changes one or more properties of an existing exclusion in the _Default
     * sink.
     *
     * The async variant is {@see self::updateExclusionAsync()} .
     *
     * @param UpdateExclusionRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogExclusion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateExclusion(UpdateExclusionRequest $request, array $callOptions = []): LogExclusion
    {
        return $this->startApiCall('UpdateExclusion', $request, $callOptions)->wait();
    }

    /**
     * Updates the Log Router settings for the given resource.
     *
     * Note: Settings for the Log Router can currently only be configured for
     * Google Cloud organizations. Once configured, it applies to all projects and
     * folders in the Google Cloud organization.
     *
     * [UpdateSettings][google.logging.v2.ConfigServiceV2.UpdateSettings]
     * will fail if 1) `kms_key_name` is invalid, or 2) the associated service
     * account does not have the required
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
     * 3) access to the key is disabled. 4) `location_id` is not supported by
     * Logging. 5) `location_id` violate OrgPolicy.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * The async variant is {@see self::updateSettingsAsync()} .
     *
     * @param UpdateSettingsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Settings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSettings(UpdateSettingsRequest $request, array $callOptions = []): Settings
    {
        return $this->startApiCall('UpdateSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates a sink. This method replaces the following fields in the existing
     * sink with values from the new sink: `destination`, and `filter`.
     *
     * The updated sink might also have a new `writer_identity`; see the
     * `unique_writer_identity` field.
     *
     * The async variant is {@see self::updateSinkAsync()} .
     *
     * @param UpdateSinkRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogSink
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSink(UpdateSinkRequest $request, array $callOptions = []): LogSink
    {
        return $this->startApiCall('UpdateSink', $request, $callOptions)->wait();
    }

    /**
     * Updates a view on a log bucket. This method replaces the following fields
     * in the existing view with values from the new view: `filter`.
     * If an `UNAVAILABLE` error is returned, this indicates that system is not in
     * a state where it can update the view. If this occurs, please try again in a
     * few minutes.
     *
     * The async variant is {@see self::updateViewAsync()} .
     *
     * @param UpdateViewRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LogView
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateView(UpdateViewRequest $request, array $callOptions = []): LogView
    {
        return $this->startApiCall('UpdateView', $request, $callOptions)->wait();
    }
}
