<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/sql/v1beta4/cloud_sql_resources.proto

namespace Google\Cloud\Sql\V1beta4;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Cloud SQL instance resource.
 *
 * Generated from protobuf message <code>google.cloud.sql.v1beta4.DatabaseInstance</code>
 */
class DatabaseInstance extends \Google\Protobuf\Internal\Message
{
    /**
     * This is always <b>sql#instance</b>.
     *
     * Generated from protobuf field <code>string kind = 1;</code>
     */
    private $kind = '';
    /**
     * The current serving state of the Cloud SQL instance. This can be one of the
     * following. <br><b>SQL_INSTANCE_STATE_UNSPECIFIED</b>: The state of the
     * instance is unknown. <br><b>RUNNABLE</b>: The instance is running, or has
     * been stopped by owner.
     * <br><b>SUSPENDED</b>: The instance is not available, for example due to
     * problems with billing.
     * <br><b>PENDING_DELETE</b>: The instance is being deleted.
     * <br><b>PENDING_CREATE</b>: The instance is being created.
     * <br><b>MAINTENANCE</b>: The instance is down for maintenance.
     * <br><b>FAILED</b>: The instance creation failed.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlInstanceState state = 2;</code>
     */
    private $state = 0;
    /**
     * The database engine type and version. The <b>databaseVersion</b>
     * field cannot be changed after instance creation.
     * <br>MySQL instances: <b>MYSQL_8_0</b>, <b>MYSQL_5_7</b> (default),
     * or <b>MYSQL_5_6</b>.
     * <br>PostgreSQL instances: <b>POSTGRES_9_6</b>, <b>POSTGRES_10</b>,
     * <b>POSTGRES_11</b>, <b>POSTGRES_12</b>, or <b>POSTGRES_13</b> (default).
     * <br>SQL Server instances: <b>SQLSERVER_2017_STANDARD</b> (default),
     * <b>SQLSERVER_2017_ENTERPRISE</b>, <b>SQLSERVER_2017_EXPRESS</b>, or
     * <b>SQLSERVER_2017_WEB</b>.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlDatabaseVersion database_version = 3;</code>
     */
    private $database_version = 0;
    /**
     * The user settings.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.Settings settings = 4;</code>
     */
    private $settings = null;
    /**
     * This field is deprecated and will be removed from a future version of the
     * API. Use the <b>settings.settingsVersion</b> field instead.
     *
     * Generated from protobuf field <code>string etag = 5;</code>
     */
    private $etag = '';
    /**
     * The name and status of the failover replica. This property is applicable
     * only to Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlFailoverReplica failover_replica = 6;</code>
     */
    private $failover_replica = null;
    /**
     * The name of the instance which will act as primary in the replication
     * setup.
     *
     * Generated from protobuf field <code>string master_instance_name = 7;</code>
     */
    private $master_instance_name = '';
    /**
     * The replicas of the instance.
     *
     * Generated from protobuf field <code>repeated string replica_names = 8;</code>
     */
    private $replica_names;
    /**
     * The maximum disk size of the instance in bytes.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value max_disk_size = 9 [deprecated = true];</code>
     * @deprecated
     */
    protected $max_disk_size = null;
    /**
     * The current disk usage of the instance in bytes. This property has been
     * deprecated. Use the
     * "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     * Monitoring API instead. Please see <a
     * href="https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ">this
     * announcement</a> for details.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value current_disk_size = 10 [deprecated = true];</code>
     * @deprecated
     */
    protected $current_disk_size = null;
    /**
     * The assigned IP addresses for the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1beta4.IpMapping ip_addresses = 11;</code>
     */
    private $ip_addresses;
    /**
     * SSL configuration.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SslCert server_ca_cert = 12;</code>
     */
    private $server_ca_cert = null;
    /**
     * The instance type. This can be one of the following.
     * <br><b>CLOUD_SQL_INSTANCE</b>: A Cloud SQL instance that is not replicating
     * from a primary instance. <br><b>ON_PREMISES_INSTANCE</b>: An instance
     * running on the customer's premises. <br><b>READ_REPLICA_INSTANCE</b>: A
     * Cloud SQL instance configured as a read-replica.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlInstanceType instance_type = 13;</code>
     */
    private $instance_type = 0;
    /**
     * The project ID of the project containing the Cloud SQL instance. The Google
     * apps domain is prefixed if applicable.
     *
     * Generated from protobuf field <code>string project = 14;</code>
     */
    private $project = '';
    /**
     * The IPv6 address assigned to the instance.
     * (Deprecated) This property was applicable only
     * to First Generation instances.
     *
     * Generated from protobuf field <code>string ipv6_address = 15 [deprecated = true];</code>
     * @deprecated
     */
    protected $ipv6_address = '';
    /**
     * The service account email address assigned to the instance. <br>This
     * property is read-only.
     *
     * Generated from protobuf field <code>string service_account_email_address = 16;</code>
     */
    private $service_account_email_address = '';
    /**
     * Configuration specific to on-premises instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.OnPremisesConfiguration on_premises_configuration = 17;</code>
     */
    private $on_premises_configuration = null;
    /**
     * Configuration specific to failover replicas and read replicas.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.ReplicaConfiguration replica_configuration = 18;</code>
     */
    private $replica_configuration = null;
    /**
     * <br><b>SECOND_GEN</b>: Cloud SQL database instance.
     * <br><b>EXTERNAL</b>: A database server that is not
     * managed by Google. <br>This property is read-only; use the
     * <b>tier</b> property in the <b>settings</b> object to determine
     * the database type.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlBackendType backend_type = 19;</code>
     */
    private $backend_type = 0;
    /**
     * The URI of this resource.
     *
     * Generated from protobuf field <code>string self_link = 20;</code>
     */
    private $self_link = '';
    /**
     * If the instance state is SUSPENDED, the reason for the suspension.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1beta4.SqlSuspensionReason suspension_reason = 21;</code>
     */
    private $suspension_reason;
    /**
     * Connection name of the Cloud SQL instance used in connection strings.
     *
     * Generated from protobuf field <code>string connection_name = 22;</code>
     */
    private $connection_name = '';
    /**
     * Name of the Cloud SQL instance. This does not include the project ID.
     *
     * Generated from protobuf field <code>string name = 23;</code>
     */
    private $name = '';
    /**
     * The geographical region. Can be
     * <br><b>us-central</b> (<b>FIRST_GEN</b> instances only)
     * <br><b>us-central1</b> (<b>SECOND_GEN</b> instances only)
     * <br><b>asia-east1</b> or <b>europe-west1</b>.
     * <br>Defaults to <b>us-central</b> or
     * <b>us-central1</b> depending on the instance type.
     * The region cannot be changed after instance creation.
     *
     * Generated from protobuf field <code>string region = 24;</code>
     */
    private $region = '';
    /**
     * The Compute Engine zone that the instance is currently serving from. This
     * value could be different from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary zone.
     *
     * Generated from protobuf field <code>string gce_zone = 25;</code>
     */
    private $gce_zone = '';
    /**
     * The Compute Engine zone that the failover instance is currently serving
     * from for a regional instance. This value could be different
     * from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary/failover zone.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>string secondary_gce_zone = 34;</code>
     */
    private $secondary_gce_zone = '';
    /**
     * Disk encryption configuration specific to an instance.
     * Applies only to Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DiskEncryptionConfiguration disk_encryption_configuration = 26;</code>
     */
    private $disk_encryption_configuration = null;
    /**
     * Disk encryption status specific to an instance.
     * Applies only to Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DiskEncryptionStatus disk_encryption_status = 27;</code>
     */
    private $disk_encryption_status = null;
    /**
     * Initial root password. Use only on creation.
     *
     * Generated from protobuf field <code>string root_password = 29;</code>
     */
    private $root_password = '';
    /**
     * The start time of any upcoming scheduled maintenance for this instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlScheduledMaintenance scheduled_maintenance = 30;</code>
     */
    private $scheduled_maintenance = null;
    /**
     * The status indicating if instance satisfiesPzs.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 35;</code>
     */
    private $satisfies_pzs = null;
    /**
     * This field represents the report generated by the proactive database
     * wellness job for OutOfDisk issues.
     * Writers:
     *    -- the proactive database wellness job for OOD.
     * Readers:
     *    -- the proactive database wellness job
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlOutOfDiskReport out_of_disk_report = 38;</code>
     */
    private $out_of_disk_report = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $kind
     *           This is always <b>sql#instance</b>.
     *     @type int $state
     *           The current serving state of the Cloud SQL instance. This can be one of the
     *           following. <br><b>SQL_INSTANCE_STATE_UNSPECIFIED</b>: The state of the
     *           instance is unknown. <br><b>RUNNABLE</b>: The instance is running, or has
     *           been stopped by owner.
     *           <br><b>SUSPENDED</b>: The instance is not available, for example due to
     *           problems with billing.
     *           <br><b>PENDING_DELETE</b>: The instance is being deleted.
     *           <br><b>PENDING_CREATE</b>: The instance is being created.
     *           <br><b>MAINTENANCE</b>: The instance is down for maintenance.
     *           <br><b>FAILED</b>: The instance creation failed.
     *     @type int $database_version
     *           The database engine type and version. The <b>databaseVersion</b>
     *           field cannot be changed after instance creation.
     *           <br>MySQL instances: <b>MYSQL_8_0</b>, <b>MYSQL_5_7</b> (default),
     *           or <b>MYSQL_5_6</b>.
     *           <br>PostgreSQL instances: <b>POSTGRES_9_6</b>, <b>POSTGRES_10</b>,
     *           <b>POSTGRES_11</b>, <b>POSTGRES_12</b>, or <b>POSTGRES_13</b> (default).
     *           <br>SQL Server instances: <b>SQLSERVER_2017_STANDARD</b> (default),
     *           <b>SQLSERVER_2017_ENTERPRISE</b>, <b>SQLSERVER_2017_EXPRESS</b>, or
     *           <b>SQLSERVER_2017_WEB</b>.
     *     @type \Google\Cloud\Sql\V1beta4\Settings $settings
     *           The user settings.
     *     @type string $etag
     *           This field is deprecated and will be removed from a future version of the
     *           API. Use the <b>settings.settingsVersion</b> field instead.
     *     @type \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlFailoverReplica $failover_replica
     *           The name and status of the failover replica. This property is applicable
     *           only to Second Generation instances.
     *     @type string $master_instance_name
     *           The name of the instance which will act as primary in the replication
     *           setup.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $replica_names
     *           The replicas of the instance.
     *     @type \Google\Protobuf\Int64Value $max_disk_size
     *           The maximum disk size of the instance in bytes.
     *     @type \Google\Protobuf\Int64Value $current_disk_size
     *           The current disk usage of the instance in bytes. This property has been
     *           deprecated. Use the
     *           "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     *           Monitoring API instead. Please see <a
     *           href="https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ">this
     *           announcement</a> for details.
     *     @type \Google\Cloud\Sql\V1beta4\IpMapping[]|\Google\Protobuf\Internal\RepeatedField $ip_addresses
     *           The assigned IP addresses for the instance.
     *     @type \Google\Cloud\Sql\V1beta4\SslCert $server_ca_cert
     *           SSL configuration.
     *     @type int $instance_type
     *           The instance type. This can be one of the following.
     *           <br><b>CLOUD_SQL_INSTANCE</b>: A Cloud SQL instance that is not replicating
     *           from a primary instance. <br><b>ON_PREMISES_INSTANCE</b>: An instance
     *           running on the customer's premises. <br><b>READ_REPLICA_INSTANCE</b>: A
     *           Cloud SQL instance configured as a read-replica.
     *     @type string $project
     *           The project ID of the project containing the Cloud SQL instance. The Google
     *           apps domain is prefixed if applicable.
     *     @type string $ipv6_address
     *           The IPv6 address assigned to the instance.
     *           (Deprecated) This property was applicable only
     *           to First Generation instances.
     *     @type string $service_account_email_address
     *           The service account email address assigned to the instance. <br>This
     *           property is read-only.
     *     @type \Google\Cloud\Sql\V1beta4\OnPremisesConfiguration $on_premises_configuration
     *           Configuration specific to on-premises instances.
     *     @type \Google\Cloud\Sql\V1beta4\ReplicaConfiguration $replica_configuration
     *           Configuration specific to failover replicas and read replicas.
     *     @type int $backend_type
     *           <br><b>SECOND_GEN</b>: Cloud SQL database instance.
     *           <br><b>EXTERNAL</b>: A database server that is not
     *           managed by Google. <br>This property is read-only; use the
     *           <b>tier</b> property in the <b>settings</b> object to determine
     *           the database type.
     *     @type string $self_link
     *           The URI of this resource.
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $suspension_reason
     *           If the instance state is SUSPENDED, the reason for the suspension.
     *     @type string $connection_name
     *           Connection name of the Cloud SQL instance used in connection strings.
     *     @type string $name
     *           Name of the Cloud SQL instance. This does not include the project ID.
     *     @type string $region
     *           The geographical region. Can be
     *           <br><b>us-central</b> (<b>FIRST_GEN</b> instances only)
     *           <br><b>us-central1</b> (<b>SECOND_GEN</b> instances only)
     *           <br><b>asia-east1</b> or <b>europe-west1</b>.
     *           <br>Defaults to <b>us-central</b> or
     *           <b>us-central1</b> depending on the instance type.
     *           The region cannot be changed after instance creation.
     *     @type string $gce_zone
     *           The Compute Engine zone that the instance is currently serving from. This
     *           value could be different from the zone that was specified when the instance
     *           was created if the instance has failed over to its secondary zone.
     *     @type string $secondary_gce_zone
     *           The Compute Engine zone that the failover instance is currently serving
     *           from for a regional instance. This value could be different
     *           from the zone that was specified when the instance
     *           was created if the instance has failed over to its secondary/failover zone.
     *           Reserved for future use.
     *     @type \Google\Cloud\Sql\V1beta4\DiskEncryptionConfiguration $disk_encryption_configuration
     *           Disk encryption configuration specific to an instance.
     *           Applies only to Second Generation instances.
     *     @type \Google\Cloud\Sql\V1beta4\DiskEncryptionStatus $disk_encryption_status
     *           Disk encryption status specific to an instance.
     *           Applies only to Second Generation instances.
     *     @type string $root_password
     *           Initial root password. Use only on creation.
     *     @type \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlScheduledMaintenance $scheduled_maintenance
     *           The start time of any upcoming scheduled maintenance for this instance.
     *     @type \Google\Protobuf\BoolValue $satisfies_pzs
     *           The status indicating if instance satisfiesPzs.
     *           Reserved for future use.
     *     @type \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlOutOfDiskReport $out_of_disk_report
     *           This field represents the report generated by the proactive database
     *           wellness job for OutOfDisk issues.
     *           Writers:
     *              -- the proactive database wellness job for OOD.
     *           Readers:
     *              -- the proactive database wellness job
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Sql\V1Beta4\CloudSqlResources::initOnce();
        parent::__construct($data);
    }

    /**
     * This is always <b>sql#instance</b>.
     *
     * Generated from protobuf field <code>string kind = 1;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * This is always <b>sql#instance</b>.
     *
     * Generated from protobuf field <code>string kind = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * The current serving state of the Cloud SQL instance. This can be one of the
     * following. <br><b>SQL_INSTANCE_STATE_UNSPECIFIED</b>: The state of the
     * instance is unknown. <br><b>RUNNABLE</b>: The instance is running, or has
     * been stopped by owner.
     * <br><b>SUSPENDED</b>: The instance is not available, for example due to
     * problems with billing.
     * <br><b>PENDING_DELETE</b>: The instance is being deleted.
     * <br><b>PENDING_CREATE</b>: The instance is being created.
     * <br><b>MAINTENANCE</b>: The instance is down for maintenance.
     * <br><b>FAILED</b>: The instance creation failed.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlInstanceState state = 2;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * The current serving state of the Cloud SQL instance. This can be one of the
     * following. <br><b>SQL_INSTANCE_STATE_UNSPECIFIED</b>: The state of the
     * instance is unknown. <br><b>RUNNABLE</b>: The instance is running, or has
     * been stopped by owner.
     * <br><b>SUSPENDED</b>: The instance is not available, for example due to
     * problems with billing.
     * <br><b>PENDING_DELETE</b>: The instance is being deleted.
     * <br><b>PENDING_CREATE</b>: The instance is being created.
     * <br><b>MAINTENANCE</b>: The instance is down for maintenance.
     * <br><b>FAILED</b>: The instance creation failed.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlInstanceState state = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlInstanceState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * The database engine type and version. The <b>databaseVersion</b>
     * field cannot be changed after instance creation.
     * <br>MySQL instances: <b>MYSQL_8_0</b>, <b>MYSQL_5_7</b> (default),
     * or <b>MYSQL_5_6</b>.
     * <br>PostgreSQL instances: <b>POSTGRES_9_6</b>, <b>POSTGRES_10</b>,
     * <b>POSTGRES_11</b>, <b>POSTGRES_12</b>, or <b>POSTGRES_13</b> (default).
     * <br>SQL Server instances: <b>SQLSERVER_2017_STANDARD</b> (default),
     * <b>SQLSERVER_2017_ENTERPRISE</b>, <b>SQLSERVER_2017_EXPRESS</b>, or
     * <b>SQLSERVER_2017_WEB</b>.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlDatabaseVersion database_version = 3;</code>
     * @return int
     */
    public function getDatabaseVersion()
    {
        return $this->database_version;
    }

    /**
     * The database engine type and version. The <b>databaseVersion</b>
     * field cannot be changed after instance creation.
     * <br>MySQL instances: <b>MYSQL_8_0</b>, <b>MYSQL_5_7</b> (default),
     * or <b>MYSQL_5_6</b>.
     * <br>PostgreSQL instances: <b>POSTGRES_9_6</b>, <b>POSTGRES_10</b>,
     * <b>POSTGRES_11</b>, <b>POSTGRES_12</b>, or <b>POSTGRES_13</b> (default).
     * <br>SQL Server instances: <b>SQLSERVER_2017_STANDARD</b> (default),
     * <b>SQLSERVER_2017_ENTERPRISE</b>, <b>SQLSERVER_2017_EXPRESS</b>, or
     * <b>SQLSERVER_2017_WEB</b>.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlDatabaseVersion database_version = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setDatabaseVersion($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1beta4\SqlDatabaseVersion::class);
        $this->database_version = $var;

        return $this;
    }

    /**
     * The user settings.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.Settings settings = 4;</code>
     * @return \Google\Cloud\Sql\V1beta4\Settings|null
     */
    public function getSettings()
    {
        return isset($this->settings) ? $this->settings : null;
    }

    public function hasSettings()
    {
        return isset($this->settings);
    }

    public function clearSettings()
    {
        unset($this->settings);
    }

    /**
     * The user settings.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.Settings settings = 4;</code>
     * @param \Google\Cloud\Sql\V1beta4\Settings $var
     * @return $this
     */
    public function setSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1beta4\Settings::class);
        $this->settings = $var;

        return $this;
    }

    /**
     * This field is deprecated and will be removed from a future version of the
     * API. Use the <b>settings.settingsVersion</b> field instead.
     *
     * Generated from protobuf field <code>string etag = 5;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * This field is deprecated and will be removed from a future version of the
     * API. Use the <b>settings.settingsVersion</b> field instead.
     *
     * Generated from protobuf field <code>string etag = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * The name and status of the failover replica. This property is applicable
     * only to Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlFailoverReplica failover_replica = 6;</code>
     * @return \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlFailoverReplica|null
     */
    public function getFailoverReplica()
    {
        return isset($this->failover_replica) ? $this->failover_replica : null;
    }

    public function hasFailoverReplica()
    {
        return isset($this->failover_replica);
    }

    public function clearFailoverReplica()
    {
        unset($this->failover_replica);
    }

    /**
     * The name and status of the failover replica. This property is applicable
     * only to Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlFailoverReplica failover_replica = 6;</code>
     * @param \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlFailoverReplica $var
     * @return $this
     */
    public function setFailoverReplica($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlFailoverReplica::class);
        $this->failover_replica = $var;

        return $this;
    }

    /**
     * The name of the instance which will act as primary in the replication
     * setup.
     *
     * Generated from protobuf field <code>string master_instance_name = 7;</code>
     * @return string
     */
    public function getMasterInstanceName()
    {
        return $this->master_instance_name;
    }

    /**
     * The name of the instance which will act as primary in the replication
     * setup.
     *
     * Generated from protobuf field <code>string master_instance_name = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setMasterInstanceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->master_instance_name = $var;

        return $this;
    }

    /**
     * The replicas of the instance.
     *
     * Generated from protobuf field <code>repeated string replica_names = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReplicaNames()
    {
        return $this->replica_names;
    }

    /**
     * The replicas of the instance.
     *
     * Generated from protobuf field <code>repeated string replica_names = 8;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReplicaNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->replica_names = $arr;

        return $this;
    }

    /**
     * The maximum disk size of the instance in bytes.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value max_disk_size = 9 [deprecated = true];</code>
     * @return \Google\Protobuf\Int64Value|null
     * @deprecated
     */
    public function getMaxDiskSize()
    {
        @trigger_error('max_disk_size is deprecated.', E_USER_DEPRECATED);
        return isset($this->max_disk_size) ? $this->max_disk_size : null;
    }

    public function hasMaxDiskSize()
    {
        @trigger_error('max_disk_size is deprecated.', E_USER_DEPRECATED);
        return isset($this->max_disk_size);
    }

    public function clearMaxDiskSize()
    {
        @trigger_error('max_disk_size is deprecated.', E_USER_DEPRECATED);
        unset($this->max_disk_size);
    }

    /**
     * Returns the unboxed value from <code>getMaxDiskSize()</code>

     * The maximum disk size of the instance in bytes.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value max_disk_size = 9 [deprecated = true];</code>
     * @return int|string|null
     */
    public function getMaxDiskSizeValue()
    {
        @trigger_error('max_disk_size is deprecated.', E_USER_DEPRECATED);
        return $this->readWrapperValue("max_disk_size");
    }

    /**
     * The maximum disk size of the instance in bytes.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value max_disk_size = 9 [deprecated = true];</code>
     * @param \Google\Protobuf\Int64Value $var
     * @return $this
     * @deprecated
     */
    public function setMaxDiskSize($var)
    {
        @trigger_error('max_disk_size is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\Int64Value::class);
        $this->max_disk_size = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int64Value object.

     * The maximum disk size of the instance in bytes.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value max_disk_size = 9 [deprecated = true];</code>
     * @param int|string|null $var
     * @return $this
     */
    public function setMaxDiskSizeValue($var)
    {
        $this->writeWrapperValue("max_disk_size", $var);
        return $this;}

    /**
     * The current disk usage of the instance in bytes. This property has been
     * deprecated. Use the
     * "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     * Monitoring API instead. Please see <a
     * href="https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ">this
     * announcement</a> for details.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value current_disk_size = 10 [deprecated = true];</code>
     * @return \Google\Protobuf\Int64Value|null
     * @deprecated
     */
    public function getCurrentDiskSize()
    {
        @trigger_error('current_disk_size is deprecated.', E_USER_DEPRECATED);
        return isset($this->current_disk_size) ? $this->current_disk_size : null;
    }

    public function hasCurrentDiskSize()
    {
        @trigger_error('current_disk_size is deprecated.', E_USER_DEPRECATED);
        return isset($this->current_disk_size);
    }

    public function clearCurrentDiskSize()
    {
        @trigger_error('current_disk_size is deprecated.', E_USER_DEPRECATED);
        unset($this->current_disk_size);
    }

    /**
     * Returns the unboxed value from <code>getCurrentDiskSize()</code>

     * The current disk usage of the instance in bytes. This property has been
     * deprecated. Use the
     * "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     * Monitoring API instead. Please see <a
     * href="https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ">this
     * announcement</a> for details.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value current_disk_size = 10 [deprecated = true];</code>
     * @return int|string|null
     */
    public function getCurrentDiskSizeValue()
    {
        @trigger_error('current_disk_size is deprecated.', E_USER_DEPRECATED);
        return $this->readWrapperValue("current_disk_size");
    }

    /**
     * The current disk usage of the instance in bytes. This property has been
     * deprecated. Use the
     * "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     * Monitoring API instead. Please see <a
     * href="https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ">this
     * announcement</a> for details.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value current_disk_size = 10 [deprecated = true];</code>
     * @param \Google\Protobuf\Int64Value $var
     * @return $this
     * @deprecated
     */
    public function setCurrentDiskSize($var)
    {
        @trigger_error('current_disk_size is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\Int64Value::class);
        $this->current_disk_size = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int64Value object.

     * The current disk usage of the instance in bytes. This property has been
     * deprecated. Use the
     * "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     * Monitoring API instead. Please see <a
     * href="https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ">this
     * announcement</a> for details.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value current_disk_size = 10 [deprecated = true];</code>
     * @param int|string|null $var
     * @return $this
     */
    public function setCurrentDiskSizeValue($var)
    {
        $this->writeWrapperValue("current_disk_size", $var);
        return $this;}

    /**
     * The assigned IP addresses for the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1beta4.IpMapping ip_addresses = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIpAddresses()
    {
        return $this->ip_addresses;
    }

    /**
     * The assigned IP addresses for the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1beta4.IpMapping ip_addresses = 11;</code>
     * @param \Google\Cloud\Sql\V1beta4\IpMapping[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIpAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Sql\V1beta4\IpMapping::class);
        $this->ip_addresses = $arr;

        return $this;
    }

    /**
     * SSL configuration.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SslCert server_ca_cert = 12;</code>
     * @return \Google\Cloud\Sql\V1beta4\SslCert|null
     */
    public function getServerCaCert()
    {
        return isset($this->server_ca_cert) ? $this->server_ca_cert : null;
    }

    public function hasServerCaCert()
    {
        return isset($this->server_ca_cert);
    }

    public function clearServerCaCert()
    {
        unset($this->server_ca_cert);
    }

    /**
     * SSL configuration.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SslCert server_ca_cert = 12;</code>
     * @param \Google\Cloud\Sql\V1beta4\SslCert $var
     * @return $this
     */
    public function setServerCaCert($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1beta4\SslCert::class);
        $this->server_ca_cert = $var;

        return $this;
    }

    /**
     * The instance type. This can be one of the following.
     * <br><b>CLOUD_SQL_INSTANCE</b>: A Cloud SQL instance that is not replicating
     * from a primary instance. <br><b>ON_PREMISES_INSTANCE</b>: An instance
     * running on the customer's premises. <br><b>READ_REPLICA_INSTANCE</b>: A
     * Cloud SQL instance configured as a read-replica.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlInstanceType instance_type = 13;</code>
     * @return int
     */
    public function getInstanceType()
    {
        return $this->instance_type;
    }

    /**
     * The instance type. This can be one of the following.
     * <br><b>CLOUD_SQL_INSTANCE</b>: A Cloud SQL instance that is not replicating
     * from a primary instance. <br><b>ON_PREMISES_INSTANCE</b>: An instance
     * running on the customer's premises. <br><b>READ_REPLICA_INSTANCE</b>: A
     * Cloud SQL instance configured as a read-replica.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlInstanceType instance_type = 13;</code>
     * @param int $var
     * @return $this
     */
    public function setInstanceType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1beta4\SqlInstanceType::class);
        $this->instance_type = $var;

        return $this;
    }

    /**
     * The project ID of the project containing the Cloud SQL instance. The Google
     * apps domain is prefixed if applicable.
     *
     * Generated from protobuf field <code>string project = 14;</code>
     * @return string
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * The project ID of the project containing the Cloud SQL instance. The Google
     * apps domain is prefixed if applicable.
     *
     * Generated from protobuf field <code>string project = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->project = $var;

        return $this;
    }

    /**
     * The IPv6 address assigned to the instance.
     * (Deprecated) This property was applicable only
     * to First Generation instances.
     *
     * Generated from protobuf field <code>string ipv6_address = 15 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getIpv6Address()
    {
        @trigger_error('ipv6_address is deprecated.', E_USER_DEPRECATED);
        return $this->ipv6_address;
    }

    /**
     * The IPv6 address assigned to the instance.
     * (Deprecated) This property was applicable only
     * to First Generation instances.
     *
     * Generated from protobuf field <code>string ipv6_address = 15 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setIpv6Address($var)
    {
        @trigger_error('ipv6_address is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->ipv6_address = $var;

        return $this;
    }

    /**
     * The service account email address assigned to the instance. <br>This
     * property is read-only.
     *
     * Generated from protobuf field <code>string service_account_email_address = 16;</code>
     * @return string
     */
    public function getServiceAccountEmailAddress()
    {
        return $this->service_account_email_address;
    }

    /**
     * The service account email address assigned to the instance. <br>This
     * property is read-only.
     *
     * Generated from protobuf field <code>string service_account_email_address = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccountEmailAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account_email_address = $var;

        return $this;
    }

    /**
     * Configuration specific to on-premises instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.OnPremisesConfiguration on_premises_configuration = 17;</code>
     * @return \Google\Cloud\Sql\V1beta4\OnPremisesConfiguration|null
     */
    public function getOnPremisesConfiguration()
    {
        return isset($this->on_premises_configuration) ? $this->on_premises_configuration : null;
    }

    public function hasOnPremisesConfiguration()
    {
        return isset($this->on_premises_configuration);
    }

    public function clearOnPremisesConfiguration()
    {
        unset($this->on_premises_configuration);
    }

    /**
     * Configuration specific to on-premises instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.OnPremisesConfiguration on_premises_configuration = 17;</code>
     * @param \Google\Cloud\Sql\V1beta4\OnPremisesConfiguration $var
     * @return $this
     */
    public function setOnPremisesConfiguration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1beta4\OnPremisesConfiguration::class);
        $this->on_premises_configuration = $var;

        return $this;
    }

    /**
     * Configuration specific to failover replicas and read replicas.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.ReplicaConfiguration replica_configuration = 18;</code>
     * @return \Google\Cloud\Sql\V1beta4\ReplicaConfiguration|null
     */
    public function getReplicaConfiguration()
    {
        return isset($this->replica_configuration) ? $this->replica_configuration : null;
    }

    public function hasReplicaConfiguration()
    {
        return isset($this->replica_configuration);
    }

    public function clearReplicaConfiguration()
    {
        unset($this->replica_configuration);
    }

    /**
     * Configuration specific to failover replicas and read replicas.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.ReplicaConfiguration replica_configuration = 18;</code>
     * @param \Google\Cloud\Sql\V1beta4\ReplicaConfiguration $var
     * @return $this
     */
    public function setReplicaConfiguration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1beta4\ReplicaConfiguration::class);
        $this->replica_configuration = $var;

        return $this;
    }

    /**
     * <br><b>SECOND_GEN</b>: Cloud SQL database instance.
     * <br><b>EXTERNAL</b>: A database server that is not
     * managed by Google. <br>This property is read-only; use the
     * <b>tier</b> property in the <b>settings</b> object to determine
     * the database type.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlBackendType backend_type = 19;</code>
     * @return int
     */
    public function getBackendType()
    {
        return $this->backend_type;
    }

    /**
     * <br><b>SECOND_GEN</b>: Cloud SQL database instance.
     * <br><b>EXTERNAL</b>: A database server that is not
     * managed by Google. <br>This property is read-only; use the
     * <b>tier</b> property in the <b>settings</b> object to determine
     * the database type.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.SqlBackendType backend_type = 19;</code>
     * @param int $var
     * @return $this
     */
    public function setBackendType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1beta4\SqlBackendType::class);
        $this->backend_type = $var;

        return $this;
    }

    /**
     * The URI of this resource.
     *
     * Generated from protobuf field <code>string self_link = 20;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * The URI of this resource.
     *
     * Generated from protobuf field <code>string self_link = 20;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * If the instance state is SUSPENDED, the reason for the suspension.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1beta4.SqlSuspensionReason suspension_reason = 21;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSuspensionReason()
    {
        return $this->suspension_reason;
    }

    /**
     * If the instance state is SUSPENDED, the reason for the suspension.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1beta4.SqlSuspensionReason suspension_reason = 21;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSuspensionReason($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Sql\V1beta4\SqlSuspensionReason::class);
        $this->suspension_reason = $arr;

        return $this;
    }

    /**
     * Connection name of the Cloud SQL instance used in connection strings.
     *
     * Generated from protobuf field <code>string connection_name = 22;</code>
     * @return string
     */
    public function getConnectionName()
    {
        return $this->connection_name;
    }

    /**
     * Connection name of the Cloud SQL instance used in connection strings.
     *
     * Generated from protobuf field <code>string connection_name = 22;</code>
     * @param string $var
     * @return $this
     */
    public function setConnectionName($var)
    {
        GPBUtil::checkString($var, True);
        $this->connection_name = $var;

        return $this;
    }

    /**
     * Name of the Cloud SQL instance. This does not include the project ID.
     *
     * Generated from protobuf field <code>string name = 23;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the Cloud SQL instance. This does not include the project ID.
     *
     * Generated from protobuf field <code>string name = 23;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The geographical region. Can be
     * <br><b>us-central</b> (<b>FIRST_GEN</b> instances only)
     * <br><b>us-central1</b> (<b>SECOND_GEN</b> instances only)
     * <br><b>asia-east1</b> or <b>europe-west1</b>.
     * <br>Defaults to <b>us-central</b> or
     * <b>us-central1</b> depending on the instance type.
     * The region cannot be changed after instance creation.
     *
     * Generated from protobuf field <code>string region = 24;</code>
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * The geographical region. Can be
     * <br><b>us-central</b> (<b>FIRST_GEN</b> instances only)
     * <br><b>us-central1</b> (<b>SECOND_GEN</b> instances only)
     * <br><b>asia-east1</b> or <b>europe-west1</b>.
     * <br>Defaults to <b>us-central</b> or
     * <b>us-central1</b> depending on the instance type.
     * The region cannot be changed after instance creation.
     *
     * Generated from protobuf field <code>string region = 24;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * The Compute Engine zone that the instance is currently serving from. This
     * value could be different from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary zone.
     *
     * Generated from protobuf field <code>string gce_zone = 25;</code>
     * @return string
     */
    public function getGceZone()
    {
        return $this->gce_zone;
    }

    /**
     * The Compute Engine zone that the instance is currently serving from. This
     * value could be different from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary zone.
     *
     * Generated from protobuf field <code>string gce_zone = 25;</code>
     * @param string $var
     * @return $this
     */
    public function setGceZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->gce_zone = $var;

        return $this;
    }

    /**
     * The Compute Engine zone that the failover instance is currently serving
     * from for a regional instance. This value could be different
     * from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary/failover zone.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>string secondary_gce_zone = 34;</code>
     * @return string
     */
    public function getSecondaryGceZone()
    {
        return $this->secondary_gce_zone;
    }

    /**
     * The Compute Engine zone that the failover instance is currently serving
     * from for a regional instance. This value could be different
     * from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary/failover zone.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>string secondary_gce_zone = 34;</code>
     * @param string $var
     * @return $this
     */
    public function setSecondaryGceZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->secondary_gce_zone = $var;

        return $this;
    }

    /**
     * Disk encryption configuration specific to an instance.
     * Applies only to Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DiskEncryptionConfiguration disk_encryption_configuration = 26;</code>
     * @return \Google\Cloud\Sql\V1beta4\DiskEncryptionConfiguration|null
     */
    public function getDiskEncryptionConfiguration()
    {
        return isset($this->disk_encryption_configuration) ? $this->disk_encryption_configuration : null;
    }

    public function hasDiskEncryptionConfiguration()
    {
        return isset($this->disk_encryption_configuration);
    }

    public function clearDiskEncryptionConfiguration()
    {
        unset($this->disk_encryption_configuration);
    }

    /**
     * Disk encryption configuration specific to an instance.
     * Applies only to Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DiskEncryptionConfiguration disk_encryption_configuration = 26;</code>
     * @param \Google\Cloud\Sql\V1beta4\DiskEncryptionConfiguration $var
     * @return $this
     */
    public function setDiskEncryptionConfiguration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1beta4\DiskEncryptionConfiguration::class);
        $this->disk_encryption_configuration = $var;

        return $this;
    }

    /**
     * Disk encryption status specific to an instance.
     * Applies only to Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DiskEncryptionStatus disk_encryption_status = 27;</code>
     * @return \Google\Cloud\Sql\V1beta4\DiskEncryptionStatus|null
     */
    public function getDiskEncryptionStatus()
    {
        return isset($this->disk_encryption_status) ? $this->disk_encryption_status : null;
    }

    public function hasDiskEncryptionStatus()
    {
        return isset($this->disk_encryption_status);
    }

    public function clearDiskEncryptionStatus()
    {
        unset($this->disk_encryption_status);
    }

    /**
     * Disk encryption status specific to an instance.
     * Applies only to Second Generation instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DiskEncryptionStatus disk_encryption_status = 27;</code>
     * @param \Google\Cloud\Sql\V1beta4\DiskEncryptionStatus $var
     * @return $this
     */
    public function setDiskEncryptionStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1beta4\DiskEncryptionStatus::class);
        $this->disk_encryption_status = $var;

        return $this;
    }

    /**
     * Initial root password. Use only on creation.
     *
     * Generated from protobuf field <code>string root_password = 29;</code>
     * @return string
     */
    public function getRootPassword()
    {
        return $this->root_password;
    }

    /**
     * Initial root password. Use only on creation.
     *
     * Generated from protobuf field <code>string root_password = 29;</code>
     * @param string $var
     * @return $this
     */
    public function setRootPassword($var)
    {
        GPBUtil::checkString($var, True);
        $this->root_password = $var;

        return $this;
    }

    /**
     * The start time of any upcoming scheduled maintenance for this instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlScheduledMaintenance scheduled_maintenance = 30;</code>
     * @return \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlScheduledMaintenance|null
     */
    public function getScheduledMaintenance()
    {
        return isset($this->scheduled_maintenance) ? $this->scheduled_maintenance : null;
    }

    public function hasScheduledMaintenance()
    {
        return isset($this->scheduled_maintenance);
    }

    public function clearScheduledMaintenance()
    {
        unset($this->scheduled_maintenance);
    }

    /**
     * The start time of any upcoming scheduled maintenance for this instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlScheduledMaintenance scheduled_maintenance = 30;</code>
     * @param \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlScheduledMaintenance $var
     * @return $this
     */
    public function setScheduledMaintenance($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlScheduledMaintenance::class);
        $this->scheduled_maintenance = $var;

        return $this;
    }

    /**
     * The status indicating if instance satisfiesPzs.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 35;</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getSatisfiesPzs()
    {
        return isset($this->satisfies_pzs) ? $this->satisfies_pzs : null;
    }

    public function hasSatisfiesPzs()
    {
        return isset($this->satisfies_pzs);
    }

    public function clearSatisfiesPzs()
    {
        unset($this->satisfies_pzs);
    }

    /**
     * Returns the unboxed value from <code>getSatisfiesPzs()</code>

     * The status indicating if instance satisfiesPzs.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 35;</code>
     * @return bool|null
     */
    public function getSatisfiesPzsValue()
    {
        return $this->readWrapperValue("satisfies_pzs");
    }

    /**
     * The status indicating if instance satisfiesPzs.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 35;</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * The status indicating if instance satisfiesPzs.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 35;</code>
     * @param bool|null $var
     * @return $this
     */
    public function setSatisfiesPzsValue($var)
    {
        $this->writeWrapperValue("satisfies_pzs", $var);
        return $this;}

    /**
     * This field represents the report generated by the proactive database
     * wellness job for OutOfDisk issues.
     * Writers:
     *    -- the proactive database wellness job for OOD.
     * Readers:
     *    -- the proactive database wellness job
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlOutOfDiskReport out_of_disk_report = 38;</code>
     * @return \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlOutOfDiskReport|null
     */
    public function getOutOfDiskReport()
    {
        return isset($this->out_of_disk_report) ? $this->out_of_disk_report : null;
    }

    public function hasOutOfDiskReport()
    {
        return isset($this->out_of_disk_report);
    }

    public function clearOutOfDiskReport()
    {
        unset($this->out_of_disk_report);
    }

    /**
     * This field represents the report generated by the proactive database
     * wellness job for OutOfDisk issues.
     * Writers:
     *    -- the proactive database wellness job for OOD.
     * Readers:
     *    -- the proactive database wellness job
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1beta4.DatabaseInstance.SqlOutOfDiskReport out_of_disk_report = 38;</code>
     * @param \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlOutOfDiskReport $var
     * @return $this
     */
    public function setOutOfDiskReport($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1beta4\DatabaseInstance\SqlOutOfDiskReport::class);
        $this->out_of_disk_report = $var;

        return $this;
    }

}

