<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/admin/database/v1/backup.proto

namespace Google\Cloud\Spanner\Admin\Database\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request for [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup].
 *
 * Generated from protobuf message <code>google.spanner.admin.database.v1.CreateBackupRequest</code>
 */
class CreateBackupRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the instance in which the backup will be
     * created. This must be the same instance that contains the database the
     * backup will be created from. The backup will be stored in the
     * location(s) specified in the instance configuration of this
     * instance. Values are of the form
     * `projects/<project>/instances/<instance>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Required. The id of the backup to be created. The `backup_id` appended to
     * `parent` forms the full backup name of the form
     * `projects/<project>/instances/<instance>/backups/<backup_id>`.
     *
     * Generated from protobuf field <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $backup_id = '';
    /**
     * Required. The backup to create.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.Backup backup = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $backup = null;
    /**
     * Optional. The encryption configuration used to encrypt the backup. If this field is
     * not specified, the backup will use the same
     * encryption configuration as the database by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CreateBackupEncryptionConfig.encryption_type] =
     * `USE_DATABASE_ENCRYPTION`.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $encryption_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The name of the instance in which the backup will be
     *           created. This must be the same instance that contains the database the
     *           backup will be created from. The backup will be stored in the
     *           location(s) specified in the instance configuration of this
     *           instance. Values are of the form
     *           `projects/<project>/instances/<instance>`.
     *     @type string $backup_id
     *           Required. The id of the backup to be created. The `backup_id` appended to
     *           `parent` forms the full backup name of the form
     *           `projects/<project>/instances/<instance>/backups/<backup_id>`.
     *     @type \Google\Cloud\Spanner\Admin\Database\V1\Backup $backup
     *           Required. The backup to create.
     *     @type \Google\Cloud\Spanner\Admin\Database\V1\CreateBackupEncryptionConfig $encryption_config
     *           Optional. The encryption configuration used to encrypt the backup. If this field is
     *           not specified, the backup will use the same
     *           encryption configuration as the database by default, namely
     *           [encryption_type][google.spanner.admin.database.v1.CreateBackupEncryptionConfig.encryption_type] =
     *           `USE_DATABASE_ENCRYPTION`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\Admin\Database\V1\Backup::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the instance in which the backup will be
     * created. This must be the same instance that contains the database the
     * backup will be created from. The backup will be stored in the
     * location(s) specified in the instance configuration of this
     * instance. Values are of the form
     * `projects/<project>/instances/<instance>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The name of the instance in which the backup will be
     * created. This must be the same instance that contains the database the
     * backup will be created from. The backup will be stored in the
     * location(s) specified in the instance configuration of this
     * instance. Values are of the form
     * `projects/<project>/instances/<instance>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The id of the backup to be created. The `backup_id` appended to
     * `parent` forms the full backup name of the form
     * `projects/<project>/instances/<instance>/backups/<backup_id>`.
     *
     * Generated from protobuf field <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getBackupId()
    {
        return $this->backup_id;
    }

    /**
     * Required. The id of the backup to be created. The `backup_id` appended to
     * `parent` forms the full backup name of the form
     * `projects/<project>/instances/<instance>/backups/<backup_id>`.
     *
     * Generated from protobuf field <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setBackupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_id = $var;

        return $this;
    }

    /**
     * Required. The backup to create.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.Backup backup = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Spanner\Admin\Database\V1\Backup|null
     */
    public function getBackup()
    {
        return isset($this->backup) ? $this->backup : null;
    }

    public function hasBackup()
    {
        return isset($this->backup);
    }

    public function clearBackup()
    {
        unset($this->backup);
    }

    /**
     * Required. The backup to create.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.Backup backup = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Spanner\Admin\Database\V1\Backup $var
     * @return $this
     */
    public function setBackup($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\Admin\Database\V1\Backup::class);
        $this->backup = $var;

        return $this;
    }

    /**
     * Optional. The encryption configuration used to encrypt the backup. If this field is
     * not specified, the backup will use the same
     * encryption configuration as the database by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CreateBackupEncryptionConfig.encryption_type] =
     * `USE_DATABASE_ENCRYPTION`.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Spanner\Admin\Database\V1\CreateBackupEncryptionConfig|null
     */
    public function getEncryptionConfig()
    {
        return isset($this->encryption_config) ? $this->encryption_config : null;
    }

    public function hasEncryptionConfig()
    {
        return isset($this->encryption_config);
    }

    public function clearEncryptionConfig()
    {
        unset($this->encryption_config);
    }

    /**
     * Optional. The encryption configuration used to encrypt the backup. If this field is
     * not specified, the backup will use the same
     * encryption configuration as the database by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CreateBackupEncryptionConfig.encryption_type] =
     * `USE_DATABASE_ENCRYPTION`.
     *
     * Generated from protobuf field <code>.google.spanner.admin.database.v1.CreateBackupEncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Spanner\Admin\Database\V1\CreateBackupEncryptionConfig $var
     * @return $this
     */
    public function setEncryptionConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\Admin\Database\V1\CreateBackupEncryptionConfig::class);
        $this->encryption_config = $var;

        return $this;
    }

}

