<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/tpu/v2/cloud_tpu.proto

namespace Google\Cloud\Tpu\V2\QueuedResourceState;

use UnexpectedValueException;

/**
 * Output only state of the request
 *
 * Protobuf type <code>google.cloud.tpu.v2.QueuedResourceState.State</code>
 */
class State
{
    /**
     * State of the QueuedResource request is not known/set.
     *
     * Generated from protobuf enum <code>STATE_UNSPECIFIED = 0;</code>
     */
    const STATE_UNSPECIFIED = 0;
    /**
     * The QueuedResource request has been received. We're still working on
     * determining if we will be able to honor this request.
     *
     * Generated from protobuf enum <code>CREATING = 1;</code>
     */
    const CREATING = 1;
    /**
     * The QueuedResource request has passed initial validation/admission
     * control and has been persisted in the queue.
     *
     * Generated from protobuf enum <code>ACCEPTED = 2;</code>
     */
    const ACCEPTED = 2;
    /**
     * The QueuedResource request has been selected. The
     * associated resources are currently being provisioned (or very soon
     * will begin provisioning).
     *
     * Generated from protobuf enum <code>PROVISIONING = 3;</code>
     */
    const PROVISIONING = 3;
    /**
     * The request could not be completed. This may be due to some
     * late-discovered problem with the request itself, or due to
     * unavailability of resources within the constraints of the request
     * (e.g., the 'valid until' start timing constraint expired).
     *
     * Generated from protobuf enum <code>FAILED = 4;</code>
     */
    const FAILED = 4;
    /**
     * The QueuedResource is being deleted.
     *
     * Generated from protobuf enum <code>DELETING = 5;</code>
     */
    const DELETING = 5;
    /**
     * The resources specified in the QueuedResource request have been
     * provisioned and are ready for use by the end-user/consumer.
     *
     * Generated from protobuf enum <code>ACTIVE = 6;</code>
     */
    const ACTIVE = 6;
    /**
     * The resources specified in the QueuedResource request are being
     * deleted. This may have been initiated by the user, or
     * the Cloud TPU service. Inspect the state data for more details.
     *
     * Generated from protobuf enum <code>SUSPENDING = 7;</code>
     */
    const SUSPENDING = 7;
    /**
     * The resources specified in the QueuedResource request have been
     * deleted.
     *
     * Generated from protobuf enum <code>SUSPENDED = 8;</code>
     */
    const SUSPENDED = 8;
    /**
     * The QueuedResource request has passed initial validation and has been
     * persisted in the queue. It will remain in this state until there are
     * sufficient free resources to begin provisioning your request. Wait times
     * will vary significantly depending on demand levels. When demand is high,
     * not all requests can be immediately provisioned. If you
     * need more reliable obtainability of TPUs consider purchasing a
     * reservation. To put a limit on how long you are willing to wait, use
     * [timing
     * constraints](https://cloud.google.com/tpu/docs/queued-resources#request_a_queued_resource_before_a_specified_time).
     *
     * Generated from protobuf enum <code>WAITING_FOR_RESOURCES = 9;</code>
     */
    const WAITING_FOR_RESOURCES = 9;

    private static $valueToName = [
        self::STATE_UNSPECIFIED => 'STATE_UNSPECIFIED',
        self::CREATING => 'CREATING',
        self::ACCEPTED => 'ACCEPTED',
        self::PROVISIONING => 'PROVISIONING',
        self::FAILED => 'FAILED',
        self::DELETING => 'DELETING',
        self::ACTIVE => 'ACTIVE',
        self::SUSPENDING => 'SUSPENDING',
        self::SUSPENDED => 'SUSPENDED',
        self::WAITING_FOR_RESOURCES => 'WAITING_FOR_RESOURCES',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


