<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/texttospeech/v1/cloud_tts.proto

namespace Google\Cloud\TextToSpeech\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Description of which voice to use for a synthesis request.
 *
 * Generated from protobuf message <code>google.cloud.texttospeech.v1.VoiceSelectionParams</code>
 */
class VoiceSelectionParams extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The language (and potentially also the region) of the voice
     * expressed as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag, e.g. "en-US". This should not include a script tag (e.g. use
     * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
     * from the input provided in the SynthesisInput.  The TTS service
     * will use this parameter to help choose an appropriate voice.  Note that
     * the TTS service may choose a voice with a slightly different language code
     * than the one selected; it may substitute a different region
     * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
     * available), or even a different language, e.g. using "nb" (Norwegian
     * Bokmal) instead of "no" (Norwegian)".
     *
     * Generated from protobuf field <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $language_code = '';
    /**
     * The name of the voice. If both the name and the gender are not set,
     * the service will choose a voice based on the other parameters such as
     * language_code.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     */
    protected $name = '';
    /**
     * The preferred gender of the voice. If not set, the service will
     * choose a voice based on the other parameters such as language_code and
     * name. Note that this is only a preference, not requirement; if a
     * voice of the appropriate gender is not available, the synthesizer should
     * substitute a voice with a different gender rather than failing the request.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.SsmlVoiceGender ssml_gender = 3;</code>
     */
    protected $ssml_gender = 0;
    /**
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.CustomVoiceParams custom_voice = 4;</code>
     */
    protected $custom_voice = null;
    /**
     * Optional. The configuration for a voice clone. If
     * [VoiceCloneParams.voice_clone_key] is set, the service chooses the voice
     * clone matching the specified configuration.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.VoiceCloneParams voice_clone = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $voice_clone = null;
    /**
     * Optional. The name of the model. If set, the service will choose the model
     * matching the specified configuration.
     *
     * Generated from protobuf field <code>string model_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $model_name = '';
    /**
     * Optional. The configuration for a Gemini multi-speaker text-to-speech
     * setup. Enables the use of two distinct voices in a single synthesis
     * request.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.MultiSpeakerVoiceConfig multi_speaker_voice_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $multi_speaker_voice_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $language_code
     *           Required. The language (and potentially also the region) of the voice
     *           expressed as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     *           language tag, e.g. "en-US". This should not include a script tag (e.g. use
     *           "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
     *           from the input provided in the SynthesisInput.  The TTS service
     *           will use this parameter to help choose an appropriate voice.  Note that
     *           the TTS service may choose a voice with a slightly different language code
     *           than the one selected; it may substitute a different region
     *           (e.g. using en-US rather than en-CA if there isn't a Canadian voice
     *           available), or even a different language, e.g. using "nb" (Norwegian
     *           Bokmal) instead of "no" (Norwegian)".
     *     @type string $name
     *           The name of the voice. If both the name and the gender are not set,
     *           the service will choose a voice based on the other parameters such as
     *           language_code.
     *     @type int $ssml_gender
     *           The preferred gender of the voice. If not set, the service will
     *           choose a voice based on the other parameters such as language_code and
     *           name. Note that this is only a preference, not requirement; if a
     *           voice of the appropriate gender is not available, the synthesizer should
     *           substitute a voice with a different gender rather than failing the request.
     *     @type \Google\Cloud\TextToSpeech\V1\CustomVoiceParams $custom_voice
     *           The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     *           the service will choose the custom voice matching the specified
     *           configuration.
     *     @type \Google\Cloud\TextToSpeech\V1\VoiceCloneParams $voice_clone
     *           Optional. The configuration for a voice clone. If
     *           [VoiceCloneParams.voice_clone_key] is set, the service chooses the voice
     *           clone matching the specified configuration.
     *     @type string $model_name
     *           Optional. The name of the model. If set, the service will choose the model
     *           matching the specified configuration.
     *     @type \Google\Cloud\TextToSpeech\V1\MultiSpeakerVoiceConfig $multi_speaker_voice_config
     *           Optional. The configuration for a Gemini multi-speaker text-to-speech
     *           setup. Enables the use of two distinct voices in a single synthesis
     *           request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Texttospeech\V1\CloudTts::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The language (and potentially also the region) of the voice
     * expressed as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag, e.g. "en-US". This should not include a script tag (e.g. use
     * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
     * from the input provided in the SynthesisInput.  The TTS service
     * will use this parameter to help choose an appropriate voice.  Note that
     * the TTS service may choose a voice with a slightly different language code
     * than the one selected; it may substitute a different region
     * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
     * available), or even a different language, e.g. using "nb" (Norwegian
     * Bokmal) instead of "no" (Norwegian)".
     *
     * Generated from protobuf field <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * Required. The language (and potentially also the region) of the voice
     * expressed as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag, e.g. "en-US". This should not include a script tag (e.g. use
     * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
     * from the input provided in the SynthesisInput.  The TTS service
     * will use this parameter to help choose an appropriate voice.  Note that
     * the TTS service may choose a voice with a slightly different language code
     * than the one selected; it may substitute a different region
     * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
     * available), or even a different language, e.g. using "nb" (Norwegian
     * Bokmal) instead of "no" (Norwegian)".
     *
     * Generated from protobuf field <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

    /**
     * The name of the voice. If both the name and the gender are not set,
     * the service will choose a voice based on the other parameters such as
     * language_code.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of the voice. If both the name and the gender are not set,
     * the service will choose a voice based on the other parameters such as
     * language_code.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The preferred gender of the voice. If not set, the service will
     * choose a voice based on the other parameters such as language_code and
     * name. Note that this is only a preference, not requirement; if a
     * voice of the appropriate gender is not available, the synthesizer should
     * substitute a voice with a different gender rather than failing the request.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.SsmlVoiceGender ssml_gender = 3;</code>
     * @return int
     */
    public function getSsmlGender()
    {
        return $this->ssml_gender;
    }

    /**
     * The preferred gender of the voice. If not set, the service will
     * choose a voice based on the other parameters such as language_code and
     * name. Note that this is only a preference, not requirement; if a
     * voice of the appropriate gender is not available, the synthesizer should
     * substitute a voice with a different gender rather than failing the request.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.SsmlVoiceGender ssml_gender = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setSsmlGender($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\TextToSpeech\V1\SsmlVoiceGender::class);
        $this->ssml_gender = $var;

        return $this;
    }

    /**
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.CustomVoiceParams custom_voice = 4;</code>
     * @return \Google\Cloud\TextToSpeech\V1\CustomVoiceParams|null
     */
    public function getCustomVoice()
    {
        return $this->custom_voice;
    }

    public function hasCustomVoice()
    {
        return isset($this->custom_voice);
    }

    public function clearCustomVoice()
    {
        unset($this->custom_voice);
    }

    /**
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.CustomVoiceParams custom_voice = 4;</code>
     * @param \Google\Cloud\TextToSpeech\V1\CustomVoiceParams $var
     * @return $this
     */
    public function setCustomVoice($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\TextToSpeech\V1\CustomVoiceParams::class);
        $this->custom_voice = $var;

        return $this;
    }

    /**
     * Optional. The configuration for a voice clone. If
     * [VoiceCloneParams.voice_clone_key] is set, the service chooses the voice
     * clone matching the specified configuration.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.VoiceCloneParams voice_clone = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\TextToSpeech\V1\VoiceCloneParams|null
     */
    public function getVoiceClone()
    {
        return $this->voice_clone;
    }

    public function hasVoiceClone()
    {
        return isset($this->voice_clone);
    }

    public function clearVoiceClone()
    {
        unset($this->voice_clone);
    }

    /**
     * Optional. The configuration for a voice clone. If
     * [VoiceCloneParams.voice_clone_key] is set, the service chooses the voice
     * clone matching the specified configuration.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.VoiceCloneParams voice_clone = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\TextToSpeech\V1\VoiceCloneParams $var
     * @return $this
     */
    public function setVoiceClone($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\TextToSpeech\V1\VoiceCloneParams::class);
        $this->voice_clone = $var;

        return $this;
    }

    /**
     * Optional. The name of the model. If set, the service will choose the model
     * matching the specified configuration.
     *
     * Generated from protobuf field <code>string model_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getModelName()
    {
        return $this->model_name;
    }

    /**
     * Optional. The name of the model. If set, the service will choose the model
     * matching the specified configuration.
     *
     * Generated from protobuf field <code>string model_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setModelName($var)
    {
        GPBUtil::checkString($var, True);
        $this->model_name = $var;

        return $this;
    }

    /**
     * Optional. The configuration for a Gemini multi-speaker text-to-speech
     * setup. Enables the use of two distinct voices in a single synthesis
     * request.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.MultiSpeakerVoiceConfig multi_speaker_voice_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\TextToSpeech\V1\MultiSpeakerVoiceConfig|null
     */
    public function getMultiSpeakerVoiceConfig()
    {
        return $this->multi_speaker_voice_config;
    }

    public function hasMultiSpeakerVoiceConfig()
    {
        return isset($this->multi_speaker_voice_config);
    }

    public function clearMultiSpeakerVoiceConfig()
    {
        unset($this->multi_speaker_voice_config);
    }

    /**
     * Optional. The configuration for a Gemini multi-speaker text-to-speech
     * setup. Enables the use of two distinct voices in a single synthesis
     * request.
     *
     * Generated from protobuf field <code>.google.cloud.texttospeech.v1.MultiSpeakerVoiceConfig multi_speaker_voice_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\TextToSpeech\V1\MultiSpeakerVoiceConfig $var
     * @return $this
     */
    public function setMultiSpeakerVoiceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\TextToSpeech\V1\MultiSpeakerVoiceConfig::class);
        $this->multi_speaker_voice_config = $var;

        return $this;
    }

}

