<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/change_stream.proto

namespace Google\Cloud\Spanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Spanner Change Streams enable customers to capture and stream out changes to
 * their Spanner databases in real-time. A change stream
 * can be created with option partition_mode='IMMUTABLE_KEY_RANGE' or
 * partition_mode='MUTABLE_KEY_RANGE'.
 * This message is only used in Change Streams created with the option
 * partition_mode='MUTABLE_KEY_RANGE'. Spanner automatically creates a special
 * Table-Valued Function (TVF) along with each Change Streams. The function
 * provides access to the change stream's records. The function is named
 * READ_<change_stream_name> (where <change_stream_name> is the
 * name of the change stream), and it returns a table with only one column
 * called ChangeRecord.
 *
 * Generated from protobuf message <code>google.spanner.v1.ChangeStreamRecord</code>
 */
class ChangeStreamRecord extends \Google\Protobuf\Internal\Message
{
    protected $record;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord $data_change_record
     *           Data change record describing a data change for a change stream
     *           partition.
     *     @type \Google\Cloud\Spanner\V1\ChangeStreamRecord\HeartbeatRecord $heartbeat_record
     *           Heartbeat record describing a heartbeat for a change stream partition.
     *     @type \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionStartRecord $partition_start_record
     *           Partition start record describing a new change stream partition.
     *     @type \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEndRecord $partition_end_record
     *           Partition end record describing a terminated change stream partition.
     *     @type \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEventRecord $partition_event_record
     *           Partition event record describing key range changes for a change stream
     *           partition.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\ChangeStream::initOnce();
        parent::__construct($data);
    }

    /**
     * Data change record describing a data change for a change stream
     * partition.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
     * @return \Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord|null
     */
    public function getDataChangeRecord()
    {
        return $this->readOneof(1);
    }

    public function hasDataChangeRecord()
    {
        return $this->hasOneof(1);
    }

    /**
     * Data change record describing a data change for a change stream
     * partition.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
     * @param \Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord $var
     * @return $this
     */
    public function setDataChangeRecord($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\ChangeStreamRecord\DataChangeRecord::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Heartbeat record describing a heartbeat for a change stream partition.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
     * @return \Google\Cloud\Spanner\V1\ChangeStreamRecord\HeartbeatRecord|null
     */
    public function getHeartbeatRecord()
    {
        return $this->readOneof(2);
    }

    public function hasHeartbeatRecord()
    {
        return $this->hasOneof(2);
    }

    /**
     * Heartbeat record describing a heartbeat for a change stream partition.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
     * @param \Google\Cloud\Spanner\V1\ChangeStreamRecord\HeartbeatRecord $var
     * @return $this
     */
    public function setHeartbeatRecord($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\ChangeStreamRecord\HeartbeatRecord::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Partition start record describing a new change stream partition.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;</code>
     * @return \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionStartRecord|null
     */
    public function getPartitionStartRecord()
    {
        return $this->readOneof(3);
    }

    public function hasPartitionStartRecord()
    {
        return $this->hasOneof(3);
    }

    /**
     * Partition start record describing a new change stream partition.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;</code>
     * @param \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionStartRecord $var
     * @return $this
     */
    public function setPartitionStartRecord($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionStartRecord::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Partition end record describing a terminated change stream partition.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;</code>
     * @return \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEndRecord|null
     */
    public function getPartitionEndRecord()
    {
        return $this->readOneof(4);
    }

    public function hasPartitionEndRecord()
    {
        return $this->hasOneof(4);
    }

    /**
     * Partition end record describing a terminated change stream partition.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;</code>
     * @param \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEndRecord $var
     * @return $this
     */
    public function setPartitionEndRecord($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEndRecord::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Partition event record describing key range changes for a change stream
     * partition.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;</code>
     * @return \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEventRecord|null
     */
    public function getPartitionEventRecord()
    {
        return $this->readOneof(5);
    }

    public function hasPartitionEventRecord()
    {
        return $this->hasOneof(5);
    }

    /**
     * Partition event record describing key range changes for a change stream
     * partition.
     *
     * Generated from protobuf field <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;</code>
     * @param \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEventRecord $var
     * @return $this
     */
    public function setPartitionEventRecord($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\ChangeStreamRecord\PartitionEventRecord::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getRecord()
    {
        return $this->whichOneof("record");
    }

}

