<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/networkconnectivity/v1/cross_network_automation.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\NetworkConnectivity\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\NetworkConnectivity\V1\CreateServiceConnectionMapRequest;
use Google\Cloud\NetworkConnectivity\V1\CreateServiceConnectionPolicyRequest;
use Google\Cloud\NetworkConnectivity\V1\CreateServiceConnectionTokenRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteServiceClassRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteServiceConnectionMapRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteServiceConnectionPolicyRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteServiceConnectionTokenRequest;
use Google\Cloud\NetworkConnectivity\V1\GetServiceClassRequest;
use Google\Cloud\NetworkConnectivity\V1\GetServiceConnectionMapRequest;
use Google\Cloud\NetworkConnectivity\V1\GetServiceConnectionPolicyRequest;
use Google\Cloud\NetworkConnectivity\V1\GetServiceConnectionTokenRequest;
use Google\Cloud\NetworkConnectivity\V1\ListServiceClassesRequest;
use Google\Cloud\NetworkConnectivity\V1\ListServiceConnectionMapsRequest;
use Google\Cloud\NetworkConnectivity\V1\ListServiceConnectionPoliciesRequest;
use Google\Cloud\NetworkConnectivity\V1\ListServiceConnectionTokensRequest;
use Google\Cloud\NetworkConnectivity\V1\ServiceClass;
use Google\Cloud\NetworkConnectivity\V1\ServiceConnectionMap;
use Google\Cloud\NetworkConnectivity\V1\ServiceConnectionPolicy;
use Google\Cloud\NetworkConnectivity\V1\ServiceConnectionToken;
use Google\Cloud\NetworkConnectivity\V1\UpdateServiceClassRequest;
use Google\Cloud\NetworkConnectivity\V1\UpdateServiceConnectionMapRequest;
use Google\Cloud\NetworkConnectivity\V1\UpdateServiceConnectionPolicyRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The service for CrossNetworkAutomation resources.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createServiceConnectionMapAsync(CreateServiceConnectionMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createServiceConnectionPolicyAsync(CreateServiceConnectionPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createServiceConnectionTokenAsync(CreateServiceConnectionTokenRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteServiceClassAsync(DeleteServiceClassRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteServiceConnectionMapAsync(DeleteServiceConnectionMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteServiceConnectionPolicyAsync(DeleteServiceConnectionPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteServiceConnectionTokenAsync(DeleteServiceConnectionTokenRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ServiceClass> getServiceClassAsync(GetServiceClassRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ServiceConnectionMap> getServiceConnectionMapAsync(GetServiceConnectionMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ServiceConnectionPolicy> getServiceConnectionPolicyAsync(GetServiceConnectionPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ServiceConnectionToken> getServiceConnectionTokenAsync(GetServiceConnectionTokenRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listServiceClassesAsync(ListServiceClassesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listServiceConnectionMapsAsync(ListServiceConnectionMapsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listServiceConnectionPoliciesAsync(ListServiceConnectionPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listServiceConnectionTokensAsync(ListServiceConnectionTokensRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateServiceClassAsync(UpdateServiceClassRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateServiceConnectionMapAsync(UpdateServiceConnectionMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateServiceConnectionPolicyAsync(UpdateServiceConnectionPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class CrossNetworkAutomationServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.networkconnectivity.v1.CrossNetworkAutomationService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'networkconnectivity.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'networkconnectivity.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/cross_network_automation_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/cross_network_automation_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/cross_network_automation_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ . '/../resources/cross_network_automation_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $resourceId
     *
     * @return string The formatted network resource.
     */
    public static function networkName(string $project, string $resourceId): string
    {
        return self::getPathTemplate('network')->render([
            'project' => $project,
            'resource_id' => $resourceId,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_attachment resource.
     *
     * @param string $project
     * @param string $region
     * @param string $serviceAttachment
     *
     * @return string The formatted service_attachment resource.
     */
    public static function serviceAttachmentName(string $project, string $region, string $serviceAttachment): string
    {
        return self::getPathTemplate('serviceAttachment')->render([
            'project' => $project,
            'region' => $region,
            'service_attachment' => $serviceAttachment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_class resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serviceClass
     *
     * @return string The formatted service_class resource.
     */
    public static function serviceClassName(string $project, string $location, string $serviceClass): string
    {
        return self::getPathTemplate('serviceClass')->render([
            'project' => $project,
            'location' => $location,
            'service_class' => $serviceClass,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_connection_map resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serviceConnectionMap
     *
     * @return string The formatted service_connection_map resource.
     */
    public static function serviceConnectionMapName(
        string $project,
        string $location,
        string $serviceConnectionMap
    ): string {
        return self::getPathTemplate('serviceConnectionMap')->render([
            'project' => $project,
            'location' => $location,
            'service_connection_map' => $serviceConnectionMap,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_connection_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serviceConnectionPolicy
     *
     * @return string The formatted service_connection_policy resource.
     */
    public static function serviceConnectionPolicyName(
        string $project,
        string $location,
        string $serviceConnectionPolicy
    ): string {
        return self::getPathTemplate('serviceConnectionPolicy')->render([
            'project' => $project,
            'location' => $location,
            'service_connection_policy' => $serviceConnectionPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_connection_token resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serviceConnectionToken
     *
     * @return string The formatted service_connection_token resource.
     */
    public static function serviceConnectionTokenName(
        string $project,
        string $location,
        string $serviceConnectionToken
    ): string {
        return self::getPathTemplate('serviceConnectionToken')->render([
            'project' => $project,
            'location' => $location,
            'service_connection_token' => $serviceConnectionToken,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a subnetwork
     * resource.
     *
     * @param string $project
     * @param string $region
     * @param string $subnetwork
     *
     * @return string The formatted subnetwork resource.
     */
    public static function subnetworkName(string $project, string $region, string $subnetwork): string
    {
        return self::getPathTemplate('subnetwork')->render([
            'project' => $project,
            'region' => $region,
            'subnetwork' => $subnetwork,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: projects/{project}/locations/{location}
     * - network: projects/{project}/global/networks/{resource_id}
     * - project: projects/{project}
     * - serviceAttachment: projects/{project}/regions/{region}/serviceAttachments/{service_attachment}
     * - serviceClass: projects/{project}/locations/{location}/serviceClasses/{service_class}
     * - serviceConnectionMap: projects/{project}/locations/{location}/serviceConnectionMaps/{service_connection_map}
     * - serviceConnectionPolicy: projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy}
     * - serviceConnectionToken: projects/{project}/locations/{location}/serviceConnectionTokens/{service_connection_token}
     * - subnetwork: projects/{project}/regions/{region}/subnetworks/{subnetwork}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'networkconnectivity.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\NetworkConnectivity\V1\CrossNetworkAutomationServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new CrossNetworkAutomationServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new ServiceConnectionMap in a given project and location.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::createServiceConnectionMapAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/create_service_connection_map.php
     *
     * @param CreateServiceConnectionMapRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ServiceConnectionMap>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createServiceConnectionMap(
        CreateServiceConnectionMapRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateServiceConnectionMap', $request, $callOptions)->wait();
    }

    /**
     * Creates a new ServiceConnectionPolicy in a given project and location.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::createServiceConnectionPolicyAsync()}
     * .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/create_service_connection_policy.php
     *
     * @param CreateServiceConnectionPolicyRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ServiceConnectionPolicy>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createServiceConnectionPolicy(
        CreateServiceConnectionPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateServiceConnectionPolicy', $request, $callOptions)->wait();
    }

    /**
     * Creates a new ServiceConnectionToken in a given project and location.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::createServiceConnectionTokenAsync()}
     * .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/create_service_connection_token.php
     *
     * @param CreateServiceConnectionTokenRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ServiceConnectionToken>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createServiceConnectionToken(
        CreateServiceConnectionTokenRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateServiceConnectionToken', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single ServiceClass.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::deleteServiceClassAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/delete_service_class.php
     *
     * @param DeleteServiceClassRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteServiceClass(DeleteServiceClassRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteServiceClass', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single ServiceConnectionMap.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::deleteServiceConnectionMapAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/delete_service_connection_map.php
     *
     * @param DeleteServiceConnectionMapRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteServiceConnectionMap(
        DeleteServiceConnectionMapRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteServiceConnectionMap', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single ServiceConnectionPolicy.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::deleteServiceConnectionPolicyAsync()}
     * .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/delete_service_connection_policy.php
     *
     * @param DeleteServiceConnectionPolicyRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteServiceConnectionPolicy(
        DeleteServiceConnectionPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteServiceConnectionPolicy', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single ServiceConnectionToken.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::deleteServiceConnectionTokenAsync()}
     * .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/delete_service_connection_token.php
     *
     * @param DeleteServiceConnectionTokenRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteServiceConnectionToken(
        DeleteServiceConnectionTokenRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteServiceConnectionToken', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ServiceClass.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::getServiceClassAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/get_service_class.php
     *
     * @param GetServiceClassRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServiceClass
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getServiceClass(GetServiceClassRequest $request, array $callOptions = []): ServiceClass
    {
        return $this->startApiCall('GetServiceClass', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ServiceConnectionMap.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::getServiceConnectionMapAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/get_service_connection_map.php
     *
     * @param GetServiceConnectionMapRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServiceConnectionMap
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getServiceConnectionMap(
        GetServiceConnectionMapRequest $request,
        array $callOptions = []
    ): ServiceConnectionMap {
        return $this->startApiCall('GetServiceConnectionMap', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ServiceConnectionPolicy.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::getServiceConnectionPolicyAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/get_service_connection_policy.php
     *
     * @param GetServiceConnectionPolicyRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServiceConnectionPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getServiceConnectionPolicy(
        GetServiceConnectionPolicyRequest $request,
        array $callOptions = []
    ): ServiceConnectionPolicy {
        return $this->startApiCall('GetServiceConnectionPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ServiceConnectionToken.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::getServiceConnectionTokenAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/get_service_connection_token.php
     *
     * @param GetServiceConnectionTokenRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServiceConnectionToken
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getServiceConnectionToken(
        GetServiceConnectionTokenRequest $request,
        array $callOptions = []
    ): ServiceConnectionToken {
        return $this->startApiCall('GetServiceConnectionToken', $request, $callOptions)->wait();
    }

    /**
     * Lists ServiceClasses in a given project and location.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::listServiceClassesAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/list_service_classes.php
     *
     * @param ListServiceClassesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServiceClasses(ListServiceClassesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListServiceClasses', $request, $callOptions);
    }

    /**
     * Lists ServiceConnectionMaps in a given project and location.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::listServiceConnectionMapsAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/list_service_connection_maps.php
     *
     * @param ListServiceConnectionMapsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServiceConnectionMaps(
        ListServiceConnectionMapsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListServiceConnectionMaps', $request, $callOptions);
    }

    /**
     * Lists ServiceConnectionPolicies in a given project and location.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::listServiceConnectionPoliciesAsync()}
     * .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/list_service_connection_policies.php
     *
     * @param ListServiceConnectionPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServiceConnectionPolicies(
        ListServiceConnectionPoliciesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListServiceConnectionPolicies', $request, $callOptions);
    }

    /**
     * Lists ServiceConnectionTokens in a given project and location.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::listServiceConnectionTokensAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/list_service_connection_tokens.php
     *
     * @param ListServiceConnectionTokensRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServiceConnectionTokens(
        ListServiceConnectionTokensRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListServiceConnectionTokens', $request, $callOptions);
    }

    /**
     * Updates the parameters of a single ServiceClass.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::updateServiceClassAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/update_service_class.php
     *
     * @param UpdateServiceClassRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ServiceClass>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateServiceClass(UpdateServiceClassRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateServiceClass', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single ServiceConnectionMap.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::updateServiceConnectionMapAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/update_service_connection_map.php
     *
     * @param UpdateServiceConnectionMapRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ServiceConnectionMap>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateServiceConnectionMap(
        UpdateServiceConnectionMapRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateServiceConnectionMap', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single ServiceConnectionPolicy.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::updateServiceConnectionPolicyAsync()}
     * .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/update_service_connection_policy.php
     *
     * @param UpdateServiceConnectionPolicyRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ServiceConnectionPolicy>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateServiceConnectionPolicy(
        UpdateServiceConnectionPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateServiceConnectionPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is
     * {@see CrossNetworkAutomationServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/CrossNetworkAutomationServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
