<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/bigquery/analyticshub/v1/analyticshub.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\BigQuery\AnalyticsHub\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ApproveQueryTemplateRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\CreateDataExchangeRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\CreateListingRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\CreateQueryTemplateRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\DataExchange;
use Google\Cloud\BigQuery\AnalyticsHub\V1\DeleteDataExchangeRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\DeleteListingRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\DeleteQueryTemplateRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\DeleteSubscriptionRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\GetDataExchangeRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\GetListingRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\GetQueryTemplateRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\GetSubscriptionRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListDataExchangesRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListListingsRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListOrgDataExchangesRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListQueryTemplatesRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListSharedResourceSubscriptionsRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\ListSubscriptionsRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\Listing;
use Google\Cloud\BigQuery\AnalyticsHub\V1\QueryTemplate;
use Google\Cloud\BigQuery\AnalyticsHub\V1\RefreshSubscriptionRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\RefreshSubscriptionResponse;
use Google\Cloud\BigQuery\AnalyticsHub\V1\RevokeSubscriptionRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\RevokeSubscriptionResponse;
use Google\Cloud\BigQuery\AnalyticsHub\V1\SubmitQueryTemplateRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\SubscribeDataExchangeRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\SubscribeDataExchangeResponse;
use Google\Cloud\BigQuery\AnalyticsHub\V1\SubscribeListingRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\SubscribeListingResponse;
use Google\Cloud\BigQuery\AnalyticsHub\V1\Subscription;
use Google\Cloud\BigQuery\AnalyticsHub\V1\UpdateDataExchangeRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\UpdateListingRequest;
use Google\Cloud\BigQuery\AnalyticsHub\V1\UpdateQueryTemplateRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The `AnalyticsHubService` API facilitates data sharing within and across
 * organizations. It allows data providers to publish listings that reference
 * shared datasets. With Analytics Hub, users can discover and search for
 * listings that they have access to. Subscribers can view and subscribe to
 * listings. When you subscribe to a listing, Analytics Hub creates a linked
 * dataset in your project.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<QueryTemplate> approveQueryTemplateAsync(ApproveQueryTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataExchange> createDataExchangeAsync(CreateDataExchangeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Listing> createListingAsync(CreateListingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<QueryTemplate> createQueryTemplateAsync(CreateQueryTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteDataExchangeAsync(DeleteDataExchangeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteListingAsync(DeleteListingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteQueryTemplateAsync(DeleteQueryTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteSubscriptionAsync(DeleteSubscriptionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataExchange> getDataExchangeAsync(GetDataExchangeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Listing> getListingAsync(GetListingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<QueryTemplate> getQueryTemplateAsync(GetQueryTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Subscription> getSubscriptionAsync(GetSubscriptionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDataExchangesAsync(ListDataExchangesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listListingsAsync(ListListingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listOrgDataExchangesAsync(ListOrgDataExchangesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listQueryTemplatesAsync(ListQueryTemplatesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSharedResourceSubscriptionsAsync(ListSharedResourceSubscriptionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSubscriptionsAsync(ListSubscriptionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> refreshSubscriptionAsync(RefreshSubscriptionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RevokeSubscriptionResponse> revokeSubscriptionAsync(RevokeSubscriptionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<QueryTemplate> submitQueryTemplateAsync(SubmitQueryTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> subscribeDataExchangeAsync(SubscribeDataExchangeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SubscribeListingResponse> subscribeListingAsync(SubscribeListingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataExchange> updateDataExchangeAsync(UpdateDataExchangeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Listing> updateListingAsync(UpdateListingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<QueryTemplate> updateQueryTemplateAsync(UpdateQueryTemplateRequest $request, array $optionalArgs = [])
 */
final class AnalyticsHubServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.bigquery.analyticshub.v1.AnalyticsHubService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'analyticshub.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'analyticshub.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/bigquery',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/analytics_hub_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/analytics_hub_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/analytics_hub_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/analytics_hub_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_exchange resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataExchange
     *
     * @return string The formatted data_exchange resource.
     */
    public static function dataExchangeName(string $project, string $location, string $dataExchange): string
    {
        return self::getPathTemplate('dataExchange')->render([
            'project' => $project,
            'location' => $location,
            'data_exchange' => $dataExchange,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a dataset
     * resource.
     *
     * @param string $project
     * @param string $dataset
     *
     * @return string The formatted dataset resource.
     */
    public static function datasetName(string $project, string $dataset): string
    {
        return self::getPathTemplate('dataset')->render([
            'project' => $project,
            'dataset' => $dataset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a listing
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataExchange
     * @param string $listing
     *
     * @return string The formatted listing resource.
     */
    public static function listingName(string $project, string $location, string $dataExchange, string $listing): string
    {
        return self::getPathTemplate('listing')->render([
            'project' => $project,
            'location' => $location,
            'data_exchange' => $dataExchange,
            'listing' => $listing,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * managed_service resource.
     *
     * @param string $service
     *
     * @return string The formatted managed_service resource.
     */
    public static function managedServiceName(string $service): string
    {
        return self::getPathTemplate('managedService')->render([
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * query_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataExchange
     * @param string $queryTemplate
     *
     * @return string The formatted query_template resource.
     */
    public static function queryTemplateName(string $project, string $location, string $dataExchange, string $queryTemplate): string
    {
        return self::getPathTemplate('queryTemplate')->render([
            'project' => $project,
            'location' => $location,
            'data_exchange' => $dataExchange,
            'query_template' => $queryTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a routine
     * resource.
     *
     * @param string $project
     * @param string $dataset
     * @param string $routine
     *
     * @return string The formatted routine resource.
     */
    public static function routineName(string $project, string $dataset, string $routine): string
    {
        return self::getPathTemplate('routine')->render([
            'project' => $project,
            'dataset' => $dataset,
            'routine' => $routine,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a subscription
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $subscription
     *
     * @return string The formatted subscription resource.
     */
    public static function subscriptionName(string $project, string $location, string $subscription): string
    {
        return self::getPathTemplate('subscription')->render([
            'project' => $project,
            'location' => $location,
            'subscription' => $subscription,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a table
     * resource.
     *
     * @param string $project
     * @param string $dataset
     * @param string $table
     *
     * @return string The formatted table resource.
     */
    public static function tableName(string $project, string $dataset, string $table): string
    {
        return self::getPathTemplate('table')->render([
            'project' => $project,
            'dataset' => $dataset,
            'table' => $table,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a topic
     * resource.
     *
     * @param string $project
     * @param string $topic
     *
     * @return string The formatted topic resource.
     */
    public static function topicName(string $project, string $topic): string
    {
        return self::getPathTemplate('topic')->render([
            'project' => $project,
            'topic' => $topic,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - dataExchange: projects/{project}/locations/{location}/dataExchanges/{data_exchange}
     * - dataset: projects/{project}/datasets/{dataset}
     * - listing: projects/{project}/locations/{location}/dataExchanges/{data_exchange}/listings/{listing}
     * - location: projects/{project}/locations/{location}
     * - managedService: services/{service}
     * - queryTemplate: projects/{project}/locations/{location}/dataExchanges/{data_exchange}/queryTemplates/{query_template}
     * - routine: projects/{project}/datasets/{dataset}/routines/{routine}
     * - subscription: projects/{project}/locations/{location}/subscriptions/{subscription}
     * - table: projects/{project}/datasets/{dataset}/tables/{table}
     * - topic: projects/{project}/topics/{topic}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'analyticshub.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\BigQuery\AnalyticsHub\V1\AnalyticsHubServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new AnalyticsHubServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Approves a query template.
     *
     * The async variant is
     * {@see AnalyticsHubServiceClient::approveQueryTemplateAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/approve_query_template.php
     *
     * @param ApproveQueryTemplateRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return QueryTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function approveQueryTemplate(ApproveQueryTemplateRequest $request, array $callOptions = []): QueryTemplate
    {
        return $this->startApiCall('ApproveQueryTemplate', $request, $callOptions)->wait();
    }

    /**
     * Creates a new data exchange.
     *
     * The async variant is {@see AnalyticsHubServiceClient::createDataExchangeAsync()}
     * .
     *
     * @example samples/V1/AnalyticsHubServiceClient/create_data_exchange.php
     *
     * @param CreateDataExchangeRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataExchange
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDataExchange(CreateDataExchangeRequest $request, array $callOptions = []): DataExchange
    {
        return $this->startApiCall('CreateDataExchange', $request, $callOptions)->wait();
    }

    /**
     * Creates a new listing.
     *
     * The async variant is {@see AnalyticsHubServiceClient::createListingAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/create_listing.php
     *
     * @param CreateListingRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Listing
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createListing(CreateListingRequest $request, array $callOptions = []): Listing
    {
        return $this->startApiCall('CreateListing', $request, $callOptions)->wait();
    }

    /**
     * Creates a new QueryTemplate
     *
     * The async variant is
     * {@see AnalyticsHubServiceClient::createQueryTemplateAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/create_query_template.php
     *
     * @param CreateQueryTemplateRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return QueryTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createQueryTemplate(CreateQueryTemplateRequest $request, array $callOptions = []): QueryTemplate
    {
        return $this->startApiCall('CreateQueryTemplate', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing data exchange.
     *
     * The async variant is {@see AnalyticsHubServiceClient::deleteDataExchangeAsync()}
     * .
     *
     * @example samples/V1/AnalyticsHubServiceClient/delete_data_exchange.php
     *
     * @param DeleteDataExchangeRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDataExchange(DeleteDataExchangeRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDataExchange', $request, $callOptions)->wait();
    }

    /**
     * Deletes a listing.
     *
     * The async variant is {@see AnalyticsHubServiceClient::deleteListingAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/delete_listing.php
     *
     * @param DeleteListingRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteListing(DeleteListingRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteListing', $request, $callOptions)->wait();
    }

    /**
     * Deletes a query template.
     *
     * The async variant is
     * {@see AnalyticsHubServiceClient::deleteQueryTemplateAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/delete_query_template.php
     *
     * @param DeleteQueryTemplateRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteQueryTemplate(DeleteQueryTemplateRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteQueryTemplate', $request, $callOptions)->wait();
    }

    /**
     * Deletes a subscription.
     *
     * The async variant is {@see AnalyticsHubServiceClient::deleteSubscriptionAsync()}
     * .
     *
     * @example samples/V1/AnalyticsHubServiceClient/delete_subscription.php
     *
     * @param DeleteSubscriptionRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSubscription(DeleteSubscriptionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteSubscription', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a data exchange.
     *
     * The async variant is {@see AnalyticsHubServiceClient::getDataExchangeAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/get_data_exchange.php
     *
     * @param GetDataExchangeRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataExchange
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDataExchange(GetDataExchangeRequest $request, array $callOptions = []): DataExchange
    {
        return $this->startApiCall('GetDataExchange', $request, $callOptions)->wait();
    }

    /**
     * Gets the IAM policy.
     *
     * The async variant is {@see AnalyticsHubServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a listing.
     *
     * The async variant is {@see AnalyticsHubServiceClient::getListingAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/get_listing.php
     *
     * @param GetListingRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Listing
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getListing(GetListingRequest $request, array $callOptions = []): Listing
    {
        return $this->startApiCall('GetListing', $request, $callOptions)->wait();
    }

    /**
     * Gets a QueryTemplate
     *
     * The async variant is {@see AnalyticsHubServiceClient::getQueryTemplateAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/get_query_template.php
     *
     * @param GetQueryTemplateRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return QueryTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getQueryTemplate(GetQueryTemplateRequest $request, array $callOptions = []): QueryTemplate
    {
        return $this->startApiCall('GetQueryTemplate', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a Subscription.
     *
     * The async variant is {@see AnalyticsHubServiceClient::getSubscriptionAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/get_subscription.php
     *
     * @param GetSubscriptionRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Subscription
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSubscription(GetSubscriptionRequest $request, array $callOptions = []): Subscription
    {
        return $this->startApiCall('GetSubscription', $request, $callOptions)->wait();
    }

    /**
     * Lists all data exchanges in a given project and location.
     *
     * The async variant is {@see AnalyticsHubServiceClient::listDataExchangesAsync()}
     * .
     *
     * @example samples/V1/AnalyticsHubServiceClient/list_data_exchanges.php
     *
     * @param ListDataExchangesRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDataExchanges(ListDataExchangesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDataExchanges', $request, $callOptions);
    }

    /**
     * Lists all listings in a given project and location.
     *
     * The async variant is {@see AnalyticsHubServiceClient::listListingsAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/list_listings.php
     *
     * @param ListListingsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listListings(ListListingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListListings', $request, $callOptions);
    }

    /**
     * Lists all data exchanges from projects in a given organization and
     * location.
     *
     * The async variant is
     * {@see AnalyticsHubServiceClient::listOrgDataExchangesAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/list_org_data_exchanges.php
     *
     * @param ListOrgDataExchangesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listOrgDataExchanges(ListOrgDataExchangesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListOrgDataExchanges', $request, $callOptions);
    }

    /**
     * Lists all QueryTemplates in a given project and location.
     *
     * The async variant is {@see AnalyticsHubServiceClient::listQueryTemplatesAsync()}
     * .
     *
     * @example samples/V1/AnalyticsHubServiceClient/list_query_templates.php
     *
     * @param ListQueryTemplatesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listQueryTemplates(ListQueryTemplatesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListQueryTemplates', $request, $callOptions);
    }

    /**
     * Lists all subscriptions on a given Data Exchange or Listing.
     *
     * The async variant is
     * {@see AnalyticsHubServiceClient::listSharedResourceSubscriptionsAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/list_shared_resource_subscriptions.php
     *
     * @param ListSharedResourceSubscriptionsRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSharedResourceSubscriptions(ListSharedResourceSubscriptionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSharedResourceSubscriptions', $request, $callOptions);
    }

    /**
     * Lists all subscriptions in a given project and location.
     *
     * The async variant is {@see AnalyticsHubServiceClient::listSubscriptionsAsync()}
     * .
     *
     * @example samples/V1/AnalyticsHubServiceClient/list_subscriptions.php
     *
     * @param ListSubscriptionsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSubscriptions(ListSubscriptionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSubscriptions', $request, $callOptions);
    }

    /**
     * Refreshes a Subscription to a Data Exchange. A Data Exchange can become
     * stale when a publisher adds or removes data. This is a long-running
     * operation as it may create many linked datasets.
     *
     * The async variant is
     * {@see AnalyticsHubServiceClient::refreshSubscriptionAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/refresh_subscription.php
     *
     * @param RefreshSubscriptionRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<RefreshSubscriptionResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function refreshSubscription(RefreshSubscriptionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RefreshSubscription', $request, $callOptions)->wait();
    }

    /**
     * Revokes a given subscription.
     *
     * The async variant is {@see AnalyticsHubServiceClient::revokeSubscriptionAsync()}
     * .
     *
     * @example samples/V1/AnalyticsHubServiceClient/revoke_subscription.php
     *
     * @param RevokeSubscriptionRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RevokeSubscriptionResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function revokeSubscription(RevokeSubscriptionRequest $request, array $callOptions = []): RevokeSubscriptionResponse
    {
        return $this->startApiCall('RevokeSubscription', $request, $callOptions)->wait();
    }

    /**
     * Sets the IAM policy.
     *
     * The async variant is {@see AnalyticsHubServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Submits a query template for approval.
     *
     * The async variant is
     * {@see AnalyticsHubServiceClient::submitQueryTemplateAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/submit_query_template.php
     *
     * @param SubmitQueryTemplateRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return QueryTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function submitQueryTemplate(SubmitQueryTemplateRequest $request, array $callOptions = []): QueryTemplate
    {
        return $this->startApiCall('SubmitQueryTemplate', $request, $callOptions)->wait();
    }

    /**
     * Creates a Subscription to a Data Clean Room. This is a
     * long-running operation as it will create one or more linked datasets.
     * Throws a Bad Request error if the Data Exchange does not contain any
     * listings.
     *
     * The async variant is
     * {@see AnalyticsHubServiceClient::subscribeDataExchangeAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/subscribe_data_exchange.php
     *
     * @param SubscribeDataExchangeRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<SubscribeDataExchangeResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function subscribeDataExchange(SubscribeDataExchangeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SubscribeDataExchange', $request, $callOptions)->wait();
    }

    /**
     * Subscribes to a listing.
     *
     * Currently, with Analytics Hub, you can create listings that
     * reference only BigQuery datasets.
     * Upon subscription to a listing for a BigQuery dataset, Analytics Hub
     * creates a linked dataset in the subscriber's project.
     *
     * The async variant is {@see AnalyticsHubServiceClient::subscribeListingAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/subscribe_listing.php
     *
     * @param SubscribeListingRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SubscribeListingResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function subscribeListing(SubscribeListingRequest $request, array $callOptions = []): SubscribeListingResponse
    {
        return $this->startApiCall('SubscribeListing', $request, $callOptions)->wait();
    }

    /**
     * Returns the permissions that a caller has.
     *
     * The async variant is {@see AnalyticsHubServiceClient::testIamPermissionsAsync()}
     * .
     *
     * @example samples/V1/AnalyticsHubServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Updates an existing data exchange.
     *
     * The async variant is {@see AnalyticsHubServiceClient::updateDataExchangeAsync()}
     * .
     *
     * @example samples/V1/AnalyticsHubServiceClient/update_data_exchange.php
     *
     * @param UpdateDataExchangeRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataExchange
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDataExchange(UpdateDataExchangeRequest $request, array $callOptions = []): DataExchange
    {
        return $this->startApiCall('UpdateDataExchange', $request, $callOptions)->wait();
    }

    /**
     * Updates an existing listing.
     *
     * The async variant is {@see AnalyticsHubServiceClient::updateListingAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/update_listing.php
     *
     * @param UpdateListingRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Listing
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateListing(UpdateListingRequest $request, array $callOptions = []): Listing
    {
        return $this->startApiCall('UpdateListing', $request, $callOptions)->wait();
    }

    /**
     * Updates an existing QueryTemplate
     *
     * The async variant is
     * {@see AnalyticsHubServiceClient::updateQueryTemplateAsync()} .
     *
     * @example samples/V1/AnalyticsHubServiceClient/update_query_template.php
     *
     * @param UpdateQueryTemplateRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return QueryTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateQueryTemplate(UpdateQueryTemplateRequest $request, array $callOptions = []): QueryTemplate
    {
        return $this->startApiCall('UpdateQueryTemplate', $request, $callOptions)->wait();
    }
}
