<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkservices/v1/http_route.proto

namespace Google\Cloud\NetworkServices\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * HttpRoute is the resource defining how HTTP traffic should be routed by a
 * Mesh or Gateway resource.
 *
 * Generated from protobuf message <code>google.cloud.networkservices.v1.HttpRoute</code>
 */
class HttpRoute extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Name of the HttpRoute resource. It matches pattern
     * `projects/&#42;&#47;locations/global/httpRoutes/http_route_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $self_link = '';
    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Required. Hostnames define a set of hosts that should match against the
     * HTTP host header to select a HttpRoute to process the request. Hostname is
     * the fully qualified domain name of a network host, as defined by RFC 1123
     * with the exception that:
     *  - IPs are not allowed.
     *  - A hostname may be prefixed with a wildcard label (`*.`). The wildcard
     *    label must appear by itself as the first label.
     * Hostname can be "precise" which is a domain name without the terminating
     * dot of a network host (e.g. `foo.example.com`) or "wildcard", which is a
     * domain name prefixed with a single wildcard label (e.g. `*.example.com`).
     * Note that as per RFC1035 and RFC1123, a label must consist of lower case
     * alphanumeric characters or '-', and must start and end with an alphanumeric
     * character. No other punctuation is allowed.
     * The routes associated with a Mesh or Gateways  must have unique hostnames.
     * If you attempt to attach multiple routes with conflicting hostnames,
     * the configuration will be rejected.
     * For example, while it is acceptable for routes for the hostnames
     * `*.foo.bar.com` and `*.bar.com` to be associated with the same Mesh (or
     * Gateways under the same scope), it is not possible to associate two routes
     * both with `*.bar.com` or both with `bar.com`.
     *
     * Generated from protobuf field <code>repeated string hostnames = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $hostnames;
    /**
     * Optional. Meshes defines a list of meshes this HttpRoute is attached to, as
     * one of the routing rules to route the requests served by the mesh.
     * Each mesh reference should match the pattern:
     * `projects/&#42;&#47;locations/global/meshes/<mesh_name>`
     * The attached Mesh should be of a type SIDECAR
     *
     * Generated from protobuf field <code>repeated string meshes = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $meshes;
    /**
     * Optional. Gateways defines a list of gateways this HttpRoute is attached
     * to, as one of the routing rules to route the requests served by the
     * gateway.
     * Each gateway reference should match the pattern:
     * `projects/&#42;&#47;locations/global/gateways/<gateway_name>`
     *
     * Generated from protobuf field <code>repeated string gateways = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $gateways;
    /**
     * Optional. Set of label tags associated with the HttpRoute resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Required. Rules that define how traffic is routed and handled.
     * Rules will be matched sequentially based on the RouteMatch specified for
     * the rule.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkservices.v1.HttpRoute.RouteRule rules = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $rules;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. Name of the HttpRoute resource. It matches pattern
     *           `projects/&#42;&#47;locations/global/httpRoutes/http_route_name>`.
     *     @type string $self_link
     *           Output only. Server-defined URL of this resource
     *     @type string $description
     *           Optional. A free-text description of the resource. Max length 1024
     *           characters.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when the resource was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when the resource was updated.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $hostnames
     *           Required. Hostnames define a set of hosts that should match against the
     *           HTTP host header to select a HttpRoute to process the request. Hostname is
     *           the fully qualified domain name of a network host, as defined by RFC 1123
     *           with the exception that:
     *            - IPs are not allowed.
     *            - A hostname may be prefixed with a wildcard label (`*.`). The wildcard
     *              label must appear by itself as the first label.
     *           Hostname can be "precise" which is a domain name without the terminating
     *           dot of a network host (e.g. `foo.example.com`) or "wildcard", which is a
     *           domain name prefixed with a single wildcard label (e.g. `*.example.com`).
     *           Note that as per RFC1035 and RFC1123, a label must consist of lower case
     *           alphanumeric characters or '-', and must start and end with an alphanumeric
     *           character. No other punctuation is allowed.
     *           The routes associated with a Mesh or Gateways  must have unique hostnames.
     *           If you attempt to attach multiple routes with conflicting hostnames,
     *           the configuration will be rejected.
     *           For example, while it is acceptable for routes for the hostnames
     *           `*.foo.bar.com` and `*.bar.com` to be associated with the same Mesh (or
     *           Gateways under the same scope), it is not possible to associate two routes
     *           both with `*.bar.com` or both with `bar.com`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $meshes
     *           Optional. Meshes defines a list of meshes this HttpRoute is attached to, as
     *           one of the routing rules to route the requests served by the mesh.
     *           Each mesh reference should match the pattern:
     *           `projects/&#42;&#47;locations/global/meshes/<mesh_name>`
     *           The attached Mesh should be of a type SIDECAR
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $gateways
     *           Optional. Gateways defines a list of gateways this HttpRoute is attached
     *           to, as one of the routing rules to route the requests served by the
     *           gateway.
     *           Each gateway reference should match the pattern:
     *           `projects/&#42;&#47;locations/global/gateways/<gateway_name>`
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Set of label tags associated with the HttpRoute resource.
     *     @type array<\Google\Cloud\NetworkServices\V1\HttpRoute\RouteRule>|\Google\Protobuf\Internal\RepeatedField $rules
     *           Required. Rules that define how traffic is routed and handled.
     *           Rules will be matched sequentially based on the RouteMatch specified for
     *           the rule.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkservices\V1\HttpRoute::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Name of the HttpRoute resource. It matches pattern
     * `projects/&#42;&#47;locations/global/httpRoutes/http_route_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Name of the HttpRoute resource. It matches pattern
     * `projects/&#42;&#47;locations/global/httpRoutes/http_route_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Required. Hostnames define a set of hosts that should match against the
     * HTTP host header to select a HttpRoute to process the request. Hostname is
     * the fully qualified domain name of a network host, as defined by RFC 1123
     * with the exception that:
     *  - IPs are not allowed.
     *  - A hostname may be prefixed with a wildcard label (`*.`). The wildcard
     *    label must appear by itself as the first label.
     * Hostname can be "precise" which is a domain name without the terminating
     * dot of a network host (e.g. `foo.example.com`) or "wildcard", which is a
     * domain name prefixed with a single wildcard label (e.g. `*.example.com`).
     * Note that as per RFC1035 and RFC1123, a label must consist of lower case
     * alphanumeric characters or '-', and must start and end with an alphanumeric
     * character. No other punctuation is allowed.
     * The routes associated with a Mesh or Gateways  must have unique hostnames.
     * If you attempt to attach multiple routes with conflicting hostnames,
     * the configuration will be rejected.
     * For example, while it is acceptable for routes for the hostnames
     * `*.foo.bar.com` and `*.bar.com` to be associated with the same Mesh (or
     * Gateways under the same scope), it is not possible to associate two routes
     * both with `*.bar.com` or both with `bar.com`.
     *
     * Generated from protobuf field <code>repeated string hostnames = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHostnames()
    {
        return $this->hostnames;
    }

    /**
     * Required. Hostnames define a set of hosts that should match against the
     * HTTP host header to select a HttpRoute to process the request. Hostname is
     * the fully qualified domain name of a network host, as defined by RFC 1123
     * with the exception that:
     *  - IPs are not allowed.
     *  - A hostname may be prefixed with a wildcard label (`*.`). The wildcard
     *    label must appear by itself as the first label.
     * Hostname can be "precise" which is a domain name without the terminating
     * dot of a network host (e.g. `foo.example.com`) or "wildcard", which is a
     * domain name prefixed with a single wildcard label (e.g. `*.example.com`).
     * Note that as per RFC1035 and RFC1123, a label must consist of lower case
     * alphanumeric characters or '-', and must start and end with an alphanumeric
     * character. No other punctuation is allowed.
     * The routes associated with a Mesh or Gateways  must have unique hostnames.
     * If you attempt to attach multiple routes with conflicting hostnames,
     * the configuration will be rejected.
     * For example, while it is acceptable for routes for the hostnames
     * `*.foo.bar.com` and `*.bar.com` to be associated with the same Mesh (or
     * Gateways under the same scope), it is not possible to associate two routes
     * both with `*.bar.com` or both with `bar.com`.
     *
     * Generated from protobuf field <code>repeated string hostnames = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHostnames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->hostnames = $arr;

        return $this;
    }

    /**
     * Optional. Meshes defines a list of meshes this HttpRoute is attached to, as
     * one of the routing rules to route the requests served by the mesh.
     * Each mesh reference should match the pattern:
     * `projects/&#42;&#47;locations/global/meshes/<mesh_name>`
     * The attached Mesh should be of a type SIDECAR
     *
     * Generated from protobuf field <code>repeated string meshes = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMeshes()
    {
        return $this->meshes;
    }

    /**
     * Optional. Meshes defines a list of meshes this HttpRoute is attached to, as
     * one of the routing rules to route the requests served by the mesh.
     * Each mesh reference should match the pattern:
     * `projects/&#42;&#47;locations/global/meshes/<mesh_name>`
     * The attached Mesh should be of a type SIDECAR
     *
     * Generated from protobuf field <code>repeated string meshes = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMeshes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->meshes = $arr;

        return $this;
    }

    /**
     * Optional. Gateways defines a list of gateways this HttpRoute is attached
     * to, as one of the routing rules to route the requests served by the
     * gateway.
     * Each gateway reference should match the pattern:
     * `projects/&#42;&#47;locations/global/gateways/<gateway_name>`
     *
     * Generated from protobuf field <code>repeated string gateways = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGateways()
    {
        return $this->gateways;
    }

    /**
     * Optional. Gateways defines a list of gateways this HttpRoute is attached
     * to, as one of the routing rules to route the requests served by the
     * gateway.
     * Each gateway reference should match the pattern:
     * `projects/&#42;&#47;locations/global/gateways/<gateway_name>`
     *
     * Generated from protobuf field <code>repeated string gateways = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGateways($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->gateways = $arr;

        return $this;
    }

    /**
     * Optional. Set of label tags associated with the HttpRoute resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Set of label tags associated with the HttpRoute resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Required. Rules that define how traffic is routed and handled.
     * Rules will be matched sequentially based on the RouteMatch specified for
     * the rule.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkservices.v1.HttpRoute.RouteRule rules = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRules()
    {
        return $this->rules;
    }

    /**
     * Required. Rules that define how traffic is routed and handled.
     * Rules will be matched sequentially based on the RouteMatch specified for
     * the rule.
     *
     * Generated from protobuf field <code>repeated .google.cloud.networkservices.v1.HttpRoute.RouteRule rules = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\NetworkServices\V1\HttpRoute\RouteRule>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRules($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\NetworkServices\V1\HttpRoute\RouteRule::class);
        $this->rules = $arr;

        return $this;
    }

}

