<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/apihub/v1/common_fields.proto

namespace Google\Cloud\ApiHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a version of the API resource in API hub. This is also referred
 * to as the API version.
 *
 * Generated from protobuf message <code>google.cloud.apihub.v1.Version</code>
 */
class Version extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the version.
     * Format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The display name of the version.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Optional. The description of the version.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. The documentation of the version.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Documentation documentation = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $documentation = null;
    /**
     * Output only. The specs associated with this version.
     * Note that an API version can be associated with multiple specs.
     * Format is
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     *
     * Generated from protobuf field <code>repeated string specs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $specs;
    /**
     * Output only. The operations contained in the API version.
     * These operations will be added to the version when a new spec is
     * added or when an existing spec is updated. Format is
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
     *
     * Generated from protobuf field <code>repeated string api_operations = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $api_operations;
    /**
     * Output only. The definitions contained in the API version.
     * These definitions will be added to the version when a new spec is
     * added or when an existing spec is updated. Format is
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}`
     *
     * Generated from protobuf field <code>repeated string definitions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $definitions;
    /**
     * Optional. The deployments linked to this API version.
     * Note: A particular API version could be deployed to multiple deployments
     * (for dev deployment, UAT deployment, etc)
     * Format is
     * `projects/{project}/locations/{location}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>repeated string deployments = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $deployments;
    /**
     * Output only. The time at which the version was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time at which the version was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. The lifecycle of the API version.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-lifecycle`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues lifecycle = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $lifecycle = null;
    /**
     * Optional. The compliance associated with the API version.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-compliance`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues compliance = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $compliance = null;
    /**
     * Optional. The accreditations associated with the API version.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-accreditation`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues accreditation = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $accreditation = null;
    /**
     * Optional. The list of user defined attributes associated with the Version
     * resource. The key is the attribute name. It will be of the format:
     * `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $attributes;
    /**
     * Optional. The selected deployment for a Version resource.
     * This can be used when special handling is needed on client side for a
     * particular deployment linked to the version.
     * Format is
     * `projects/{project}/locations/{location}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>string selected_deployment = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $selected_deployment = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the version.
     *           Format:
     *           `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
     *     @type string $display_name
     *           Required. The display name of the version.
     *     @type string $description
     *           Optional. The description of the version.
     *     @type \Google\Cloud\ApiHub\V1\Documentation $documentation
     *           Optional. The documentation of the version.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $specs
     *           Output only. The specs associated with this version.
     *           Note that an API version can be associated with multiple specs.
     *           Format is
     *           `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $api_operations
     *           Output only. The operations contained in the API version.
     *           These operations will be added to the version when a new spec is
     *           added or when an existing spec is updated. Format is
     *           `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $definitions
     *           Output only. The definitions contained in the API version.
     *           These definitions will be added to the version when a new spec is
     *           added or when an existing spec is updated. Format is
     *           `projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $deployments
     *           Optional. The deployments linked to this API version.
     *           Note: A particular API version could be deployed to multiple deployments
     *           (for dev deployment, UAT deployment, etc)
     *           Format is
     *           `projects/{project}/locations/{location}/deployments/{deployment}`
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time at which the version was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time at which the version was last updated.
     *     @type \Google\Cloud\ApiHub\V1\AttributeValues $lifecycle
     *           Optional. The lifecycle of the API version.
     *           This maps to the following system defined attribute:
     *           `projects/{project}/locations/{location}/attributes/system-lifecycle`
     *           attribute.
     *           The number of values for this attribute will be based on the
     *           cardinality of the attribute. The same can be retrieved via GetAttribute
     *           API. All values should be from the list of allowed values defined for the
     *           attribute.
     *     @type \Google\Cloud\ApiHub\V1\AttributeValues $compliance
     *           Optional. The compliance associated with the API version.
     *           This maps to the following system defined attribute:
     *           `projects/{project}/locations/{location}/attributes/system-compliance`
     *           attribute.
     *           The number of values for this attribute will be based on the
     *           cardinality of the attribute. The same can be retrieved via GetAttribute
     *           API. All values should be from the list of allowed values defined for the
     *           attribute.
     *     @type \Google\Cloud\ApiHub\V1\AttributeValues $accreditation
     *           Optional. The accreditations associated with the API version.
     *           This maps to the following system defined attribute:
     *           `projects/{project}/locations/{location}/attributes/system-accreditation`
     *           attribute.
     *           The number of values for this attribute will be based on the
     *           cardinality of the attribute. The same can be retrieved via GetAttribute
     *           API. All values should be from the list of allowed values defined for the
     *           attribute.
     *     @type array|\Google\Protobuf\Internal\MapField $attributes
     *           Optional. The list of user defined attributes associated with the Version
     *           resource. The key is the attribute name. It will be of the format:
     *           `projects/{project}/locations/{location}/attributes/{attribute}`.
     *           The value is the attribute values associated with the resource.
     *     @type string $selected_deployment
     *           Optional. The selected deployment for a Version resource.
     *           This can be used when special handling is needed on client side for a
     *           particular deployment linked to the version.
     *           Format is
     *           `projects/{project}/locations/{location}/deployments/{deployment}`
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Apihub\V1\CommonFields::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the version.
     * Format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the version.
     * Format:
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The display name of the version.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The display name of the version.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. The description of the version.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. The description of the version.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. The documentation of the version.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Documentation documentation = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\Documentation|null
     */
    public function getDocumentation()
    {
        return $this->documentation;
    }

    public function hasDocumentation()
    {
        return isset($this->documentation);
    }

    public function clearDocumentation()
    {
        unset($this->documentation);
    }

    /**
     * Optional. The documentation of the version.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Documentation documentation = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\Documentation $var
     * @return $this
     */
    public function setDocumentation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\Documentation::class);
        $this->documentation = $var;

        return $this;
    }

    /**
     * Output only. The specs associated with this version.
     * Note that an API version can be associated with multiple specs.
     * Format is
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     *
     * Generated from protobuf field <code>repeated string specs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSpecs()
    {
        return $this->specs;
    }

    /**
     * Output only. The specs associated with this version.
     * Note that an API version can be associated with multiple specs.
     * Format is
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}`
     *
     * Generated from protobuf field <code>repeated string specs = 5 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSpecs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->specs = $arr;

        return $this;
    }

    /**
     * Output only. The operations contained in the API version.
     * These operations will be added to the version when a new spec is
     * added or when an existing spec is updated. Format is
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
     *
     * Generated from protobuf field <code>repeated string api_operations = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getApiOperations()
    {
        return $this->api_operations;
    }

    /**
     * Output only. The operations contained in the API version.
     * These operations will be added to the version when a new spec is
     * added or when an existing spec is updated. Format is
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}`
     *
     * Generated from protobuf field <code>repeated string api_operations = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setApiOperations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->api_operations = $arr;

        return $this;
    }

    /**
     * Output only. The definitions contained in the API version.
     * These definitions will be added to the version when a new spec is
     * added or when an existing spec is updated. Format is
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}`
     *
     * Generated from protobuf field <code>repeated string definitions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDefinitions()
    {
        return $this->definitions;
    }

    /**
     * Output only. The definitions contained in the API version.
     * These definitions will be added to the version when a new spec is
     * added or when an existing spec is updated. Format is
     * `projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}`
     *
     * Generated from protobuf field <code>repeated string definitions = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDefinitions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->definitions = $arr;

        return $this;
    }

    /**
     * Optional. The deployments linked to this API version.
     * Note: A particular API version could be deployed to multiple deployments
     * (for dev deployment, UAT deployment, etc)
     * Format is
     * `projects/{project}/locations/{location}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>repeated string deployments = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDeployments()
    {
        return $this->deployments;
    }

    /**
     * Optional. The deployments linked to this API version.
     * Note: A particular API version could be deployed to multiple deployments
     * (for dev deployment, UAT deployment, etc)
     * Format is
     * `projects/{project}/locations/{location}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>repeated string deployments = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDeployments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->deployments = $arr;

        return $this;
    }

    /**
     * Output only. The time at which the version was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time at which the version was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time at which the version was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time at which the version was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. The lifecycle of the API version.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-lifecycle`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues lifecycle = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\AttributeValues|null
     */
    public function getLifecycle()
    {
        return $this->lifecycle;
    }

    public function hasLifecycle()
    {
        return isset($this->lifecycle);
    }

    public function clearLifecycle()
    {
        unset($this->lifecycle);
    }

    /**
     * Optional. The lifecycle of the API version.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-lifecycle`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues lifecycle = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\AttributeValues $var
     * @return $this
     */
    public function setLifecycle($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\AttributeValues::class);
        $this->lifecycle = $var;

        return $this;
    }

    /**
     * Optional. The compliance associated with the API version.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-compliance`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues compliance = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\AttributeValues|null
     */
    public function getCompliance()
    {
        return $this->compliance;
    }

    public function hasCompliance()
    {
        return isset($this->compliance);
    }

    public function clearCompliance()
    {
        unset($this->compliance);
    }

    /**
     * Optional. The compliance associated with the API version.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-compliance`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues compliance = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\AttributeValues $var
     * @return $this
     */
    public function setCompliance($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\AttributeValues::class);
        $this->compliance = $var;

        return $this;
    }

    /**
     * Optional. The accreditations associated with the API version.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-accreditation`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues accreditation = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\AttributeValues|null
     */
    public function getAccreditation()
    {
        return $this->accreditation;
    }

    public function hasAccreditation()
    {
        return isset($this->accreditation);
    }

    public function clearAccreditation()
    {
        unset($this->accreditation);
    }

    /**
     * Optional. The accreditations associated with the API version.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-accreditation`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues accreditation = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\AttributeValues $var
     * @return $this
     */
    public function setAccreditation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\AttributeValues::class);
        $this->accreditation = $var;

        return $this;
    }

    /**
     * Optional. The list of user defined attributes associated with the Version
     * resource. The key is the attribute name. It will be of the format:
     * `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Optional. The list of user defined attributes associated with the Version
     * resource. The key is the attribute name. It will be of the format:
     * `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ApiHub\V1\AttributeValues::class);
        $this->attributes = $arr;

        return $this;
    }

    /**
     * Optional. The selected deployment for a Version resource.
     * This can be used when special handling is needed on client side for a
     * particular deployment linked to the version.
     * Format is
     * `projects/{project}/locations/{location}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>string selected_deployment = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSelectedDeployment()
    {
        return $this->selected_deployment;
    }

    /**
     * Optional. The selected deployment for a Version resource.
     * This can be used when special handling is needed on client side for a
     * particular deployment linked to the version.
     * Format is
     * `projects/{project}/locations/{location}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>string selected_deployment = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSelectedDeployment($var)
    {
        GPBUtil::checkString($var, True);
        $this->selected_deployment = $var;

        return $this;
    }

}

