<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/oracledatabase/v1/exadb_vm_cluster.proto

namespace Google\Cloud\OracleDatabase\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * ExadbVmCluster represents a cluster of VMs that are used to run Exadata
 * workloads.
 * https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/ExadbVmCluster/
 *
 * Generated from protobuf message <code>google.cloud.oracledatabase.v1.ExadbVmCluster</code>
 */
class ExadbVmCluster extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the ExadbVmCluster resource in the following
     * format:
     * projects/{project}/locations/{region}/exadbVmClusters/{exadb_vm_cluster}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The properties of the ExadbVmCluster.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.ExadbVmClusterProperties properties = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $properties = null;
    /**
     * Output only. Immutable. The GCP Oracle zone where Oracle ExadbVmCluster is
     * hosted. Example: us-east4-b-r2. During creation, the system will pick the
     * zone assigned to the ExascaleDbStorageVault.
     *
     * Generated from protobuf field <code>string gcp_oracle_zone = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $gcp_oracle_zone = '';
    /**
     * Optional. The labels or tags associated with the ExadbVmCluster.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. Immutable. The name of the OdbNetwork associated with the
     * ExadbVmCluster. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
     * optional but if specified, this should match the parent ODBNetwork of the
     * OdbSubnet.
     *
     * Generated from protobuf field <code>string odb_network = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    protected $odb_network = '';
    /**
     * Required. Immutable. The name of the OdbSubnet associated with the
     * ExadbVmCluster for IP allocation. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string odb_subnet = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    protected $odb_subnet = '';
    /**
     * Required. Immutable. The name of the backup OdbSubnet associated with the
     * ExadbVmCluster. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string backup_odb_subnet = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    protected $backup_odb_subnet = '';
    /**
     * Required. Immutable. The display name for the ExadbVmCluster. The name does
     * not have to be unique within your project. The name must be 1-255
     * characters long and can only contain alphanumeric characters.
     *
     * Generated from protobuf field <code>string display_name = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $display_name = '';
    /**
     * Output only. The date and time that the ExadbVmCluster was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The ID of the subscription entitlement associated with the
     * ExadbVmCluster.
     *
     * Generated from protobuf field <code>string entitlement_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $entitlement_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the ExadbVmCluster resource in the following
     *           format:
     *           projects/{project}/locations/{region}/exadbVmClusters/{exadb_vm_cluster}
     *     @type \Google\Cloud\OracleDatabase\V1\ExadbVmClusterProperties $properties
     *           Required. The properties of the ExadbVmCluster.
     *     @type string $gcp_oracle_zone
     *           Output only. Immutable. The GCP Oracle zone where Oracle ExadbVmCluster is
     *           hosted. Example: us-east4-b-r2. During creation, the system will pick the
     *           zone assigned to the ExascaleDbStorageVault.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. The labels or tags associated with the ExadbVmCluster.
     *     @type string $odb_network
     *           Optional. Immutable. The name of the OdbNetwork associated with the
     *           ExadbVmCluster. Format:
     *           projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
     *           optional but if specified, this should match the parent ODBNetwork of the
     *           OdbSubnet.
     *     @type string $odb_subnet
     *           Required. Immutable. The name of the OdbSubnet associated with the
     *           ExadbVmCluster for IP allocation. Format:
     *           projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *     @type string $backup_odb_subnet
     *           Required. Immutable. The name of the backup OdbSubnet associated with the
     *           ExadbVmCluster. Format:
     *           projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *     @type string $display_name
     *           Required. Immutable. The display name for the ExadbVmCluster. The name does
     *           not have to be unique within your project. The name must be 1-255
     *           characters long and can only contain alphanumeric characters.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The date and time that the ExadbVmCluster was created.
     *     @type string $entitlement_id
     *           Output only. The ID of the subscription entitlement associated with the
     *           ExadbVmCluster.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Oracledatabase\V1\ExadbVmCluster::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the ExadbVmCluster resource in the following
     * format:
     * projects/{project}/locations/{region}/exadbVmClusters/{exadb_vm_cluster}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the ExadbVmCluster resource in the following
     * format:
     * projects/{project}/locations/{region}/exadbVmClusters/{exadb_vm_cluster}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The properties of the ExadbVmCluster.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.ExadbVmClusterProperties properties = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\OracleDatabase\V1\ExadbVmClusterProperties|null
     */
    public function getProperties()
    {
        return $this->properties;
    }

    public function hasProperties()
    {
        return isset($this->properties);
    }

    public function clearProperties()
    {
        unset($this->properties);
    }

    /**
     * Required. The properties of the ExadbVmCluster.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.ExadbVmClusterProperties properties = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\OracleDatabase\V1\ExadbVmClusterProperties $var
     * @return $this
     */
    public function setProperties($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\ExadbVmClusterProperties::class);
        $this->properties = $var;

        return $this;
    }

    /**
     * Output only. Immutable. The GCP Oracle zone where Oracle ExadbVmCluster is
     * hosted. Example: us-east4-b-r2. During creation, the system will pick the
     * zone assigned to the ExascaleDbStorageVault.
     *
     * Generated from protobuf field <code>string gcp_oracle_zone = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getGcpOracleZone()
    {
        return $this->gcp_oracle_zone;
    }

    /**
     * Output only. Immutable. The GCP Oracle zone where Oracle ExadbVmCluster is
     * hosted. Example: us-east4-b-r2. During creation, the system will pick the
     * zone assigned to the ExascaleDbStorageVault.
     *
     * Generated from protobuf field <code>string gcp_oracle_zone = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setGcpOracleZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->gcp_oracle_zone = $var;

        return $this;
    }

    /**
     * Optional. The labels or tags associated with the ExadbVmCluster.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. The labels or tags associated with the ExadbVmCluster.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. Immutable. The name of the OdbNetwork associated with the
     * ExadbVmCluster. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
     * optional but if specified, this should match the parent ODBNetwork of the
     * OdbSubnet.
     *
     * Generated from protobuf field <code>string odb_network = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getOdbNetwork()
    {
        return $this->odb_network;
    }

    /**
     * Optional. Immutable. The name of the OdbNetwork associated with the
     * ExadbVmCluster. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network} It is
     * optional but if specified, this should match the parent ODBNetwork of the
     * OdbSubnet.
     *
     * Generated from protobuf field <code>string odb_network = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setOdbNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->odb_network = $var;

        return $this;
    }

    /**
     * Required. Immutable. The name of the OdbSubnet associated with the
     * ExadbVmCluster for IP allocation. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string odb_subnet = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getOdbSubnet()
    {
        return $this->odb_subnet;
    }

    /**
     * Required. Immutable. The name of the OdbSubnet associated with the
     * ExadbVmCluster for IP allocation. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string odb_subnet = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setOdbSubnet($var)
    {
        GPBUtil::checkString($var, True);
        $this->odb_subnet = $var;

        return $this;
    }

    /**
     * Required. Immutable. The name of the backup OdbSubnet associated with the
     * ExadbVmCluster. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string backup_odb_subnet = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getBackupOdbSubnet()
    {
        return $this->backup_odb_subnet;
    }

    /**
     * Required. Immutable. The name of the backup OdbSubnet associated with the
     * ExadbVmCluster. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string backup_odb_subnet = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setBackupOdbSubnet($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_odb_subnet = $var;

        return $this;
    }

    /**
     * Required. Immutable. The display name for the ExadbVmCluster. The name does
     * not have to be unique within your project. The name must be 1-255
     * characters long and can only contain alphanumeric characters.
     *
     * Generated from protobuf field <code>string display_name = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. Immutable. The display name for the ExadbVmCluster. The name does
     * not have to be unique within your project. The name must be 1-255
     * characters long and can only contain alphanumeric characters.
     *
     * Generated from protobuf field <code>string display_name = 9 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. The date and time that the ExadbVmCluster was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The date and time that the ExadbVmCluster was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The ID of the subscription entitlement associated with the
     * ExadbVmCluster.
     *
     * Generated from protobuf field <code>string entitlement_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEntitlementId()
    {
        return $this->entitlement_id;
    }

    /**
     * Output only. The ID of the subscription entitlement associated with the
     * ExadbVmCluster.
     *
     * Generated from protobuf field <code>string entitlement_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEntitlementId($var)
    {
        GPBUtil::checkString($var, True);
        $this->entitlement_id = $var;

        return $this;
    }

}

