<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/managedkafka/v1/resources.proto

namespace Google\Cloud\ManagedKafka\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An Apache Kafka Connect cluster deployed in a location.
 *
 * Generated from protobuf message <code>google.cloud.managedkafka.v1.ConnectCluster</code>
 */
class ConnectCluster extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the Kafka Connect cluster. Structured like:
     * projects/{project_number}/locations/{location}/connectClusters/{connect_cluster_id}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. Immutable. The name of the Kafka cluster this Kafka Connect
     * cluster is attached to. Structured like:
     * projects/{project}/locations/{location}/clusters/{cluster}
     *
     * Generated from protobuf field <code>string kafka_cluster = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $kafka_cluster = '';
    /**
     * Output only. The time when the cluster was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time when the cluster was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. Labels as key value pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Required. Capacity configuration for the Kafka Connect cluster.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.CapacityConfig capacity_config = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $capacity_config = null;
    /**
     * Output only. The current state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.ConnectCluster.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Optional. Configurations for the worker that are overridden from the
     * defaults. The key of the map is a Kafka Connect worker property name, for
     * example: `exactly.once.source.support`.
     *
     * Generated from protobuf field <code>map<string, string> config = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $config;
    protected $platform_config;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\ManagedKafka\V1\ConnectGcpConfig $gcp_config
     *           Required. Configuration properties for a Kafka Connect cluster deployed
     *           to Google Cloud Platform.
     *     @type string $name
     *           Identifier. The name of the Kafka Connect cluster. Structured like:
     *           projects/{project_number}/locations/{location}/connectClusters/{connect_cluster_id}
     *     @type string $kafka_cluster
     *           Required. Immutable. The name of the Kafka cluster this Kafka Connect
     *           cluster is attached to. Structured like:
     *           projects/{project}/locations/{location}/clusters/{cluster}
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the cluster was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time when the cluster was last updated.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Labels as key value pairs.
     *     @type \Google\Cloud\ManagedKafka\V1\CapacityConfig $capacity_config
     *           Required. Capacity configuration for the Kafka Connect cluster.
     *     @type int $state
     *           Output only. The current state of the cluster.
     *     @type array|\Google\Protobuf\Internal\MapField $config
     *           Optional. Configurations for the worker that are overridden from the
     *           defaults. The key of the map is a Kafka Connect worker property name, for
     *           example: `exactly.once.source.support`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Managedkafka\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Configuration properties for a Kafka Connect cluster deployed
     * to Google Cloud Platform.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.ConnectGcpConfig gcp_config = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\ManagedKafka\V1\ConnectGcpConfig|null
     */
    public function getGcpConfig()
    {
        return $this->readOneof(7);
    }

    public function hasGcpConfig()
    {
        return $this->hasOneof(7);
    }

    /**
     * Required. Configuration properties for a Kafka Connect cluster deployed
     * to Google Cloud Platform.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.ConnectGcpConfig gcp_config = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\ManagedKafka\V1\ConnectGcpConfig $var
     * @return $this
     */
    public function setGcpConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ManagedKafka\V1\ConnectGcpConfig::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Identifier. The name of the Kafka Connect cluster. Structured like:
     * projects/{project_number}/locations/{location}/connectClusters/{connect_cluster_id}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the Kafka Connect cluster. Structured like:
     * projects/{project_number}/locations/{location}/connectClusters/{connect_cluster_id}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Immutable. The name of the Kafka cluster this Kafka Connect
     * cluster is attached to. Structured like:
     * projects/{project}/locations/{location}/clusters/{cluster}
     *
     * Generated from protobuf field <code>string kafka_cluster = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getKafkaCluster()
    {
        return $this->kafka_cluster;
    }

    /**
     * Required. Immutable. The name of the Kafka cluster this Kafka Connect
     * cluster is attached to. Structured like:
     * projects/{project}/locations/{location}/clusters/{cluster}
     *
     * Generated from protobuf field <code>string kafka_cluster = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setKafkaCluster($var)
    {
        GPBUtil::checkString($var, True);
        $this->kafka_cluster = $var;

        return $this;
    }

    /**
     * Output only. The time when the cluster was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the cluster was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time when the cluster was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time when the cluster was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. Labels as key value pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Labels as key value pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Required. Capacity configuration for the Kafka Connect cluster.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.CapacityConfig capacity_config = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\ManagedKafka\V1\CapacityConfig|null
     */
    public function getCapacityConfig()
    {
        return $this->capacity_config;
    }

    public function hasCapacityConfig()
    {
        return isset($this->capacity_config);
    }

    public function clearCapacityConfig()
    {
        unset($this->capacity_config);
    }

    /**
     * Required. Capacity configuration for the Kafka Connect cluster.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.CapacityConfig capacity_config = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\ManagedKafka\V1\CapacityConfig $var
     * @return $this
     */
    public function setCapacityConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ManagedKafka\V1\CapacityConfig::class);
        $this->capacity_config = $var;

        return $this;
    }

    /**
     * Output only. The current state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.ConnectCluster.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.managedkafka.v1.ConnectCluster.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ManagedKafka\V1\ConnectCluster\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Optional. Configurations for the worker that are overridden from the
     * defaults. The key of the map is a Kafka Connect worker property name, for
     * example: `exactly.once.source.support`.
     *
     * Generated from protobuf field <code>map<string, string> config = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Optional. Configurations for the worker that are overridden from the
     * defaults. The key of the map is a Kafka Connect worker property name, for
     * example: `exactly.once.source.support`.
     *
     * Generated from protobuf field <code>map<string, string> config = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setConfig($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->config = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getPlatformConfig()
    {
        return $this->whichOneof("platform_config");
    }

}

