<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Parameters for node pool-level network config.
 *
 * Generated from protobuf message <code>google.container.v1.NodeNetworkConfig</code>
 */
class NodeNetworkConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Input only. Whether to create a new range for pod IPs in this node pool.
     * Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they
     * are not specified.
     * If neither `create_pod_range` or `pod_range` are specified, the
     * cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is
     * used.
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     * This field cannot be changed after the node pool has been created.
     *
     * Generated from protobuf field <code>bool create_pod_range = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $create_pod_range = false;
    /**
     * The ID of the secondary range for pod IPs.
     * If `create_pod_range` is true, this ID is used for the new range.
     * If `create_pod_range` is false, uses an existing secondary range with this
     * ID.
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     * This field cannot be changed after the node pool has been created.
     *
     * Generated from protobuf field <code>string pod_range = 5;</code>
     */
    protected $pod_range = '';
    /**
     * The IP address range for pod IPs in this node pool.
     * Only applicable if `create_pod_range` is true.
     * Set to blank to have a range chosen with the default size.
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     * This field cannot be changed after the node pool has been created.
     *
     * Generated from protobuf field <code>string pod_ipv4_cidr_block = 6;</code>
     */
    protected $pod_ipv4_cidr_block = '';
    /**
     * Whether nodes have internal IP addresses only.
     * If enable_private_nodes is not specified, then the value is derived from
     * [Cluster.NetworkConfig.default_enable_private_nodes][]
     *
     * Generated from protobuf field <code>optional bool enable_private_nodes = 9;</code>
     */
    protected $enable_private_nodes = null;
    /**
     * Network bandwidth tier configuration.
     *
     * Generated from protobuf field <code>optional .google.container.v1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;</code>
     */
    protected $network_performance_config = null;
    /**
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     *
     * Generated from protobuf field <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;</code>
     */
    protected $pod_cidr_overprovision_config = null;
    /**
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;</code>
     */
    private $additional_node_network_configs;
    /**
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;</code>
     */
    private $additional_pod_network_configs;
    /**
     * Output only. The utilization of the IPv4 range for the pod.
     * The ratio is Usage/[Total number of IPs in the secondary range],
     * Usage=numNodes*numZones*podIPsPerNode.
     *
     * Generated from protobuf field <code>double pod_ipv4_range_utilization = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $pod_ipv4_range_utilization = 0.0;
    /**
     * Output only. The subnetwork path for the node pool.
     * Format: projects/{project}/regions/{region}/subnetworks/{subnetwork}
     * If the cluster is associated with multiple subnetworks, the subnetwork for
     * the node pool is picked based on the IP utilization during node pool
     * creation and is immutable.
     *
     * Generated from protobuf field <code>string subnetwork = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $subnetwork = '';
    /**
     * Output only. The network tier configuration for the node pool inherits from
     * the cluster-level configuration and remains immutable throughout the node
     * pool's lifecycle, including during upgrades.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkTierConfig network_tier_config = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $network_tier_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $create_pod_range
     *           Input only. Whether to create a new range for pod IPs in this node pool.
     *           Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they
     *           are not specified.
     *           If neither `create_pod_range` or `pod_range` are specified, the
     *           cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is
     *           used.
     *           Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *           This field cannot be changed after the node pool has been created.
     *     @type string $pod_range
     *           The ID of the secondary range for pod IPs.
     *           If `create_pod_range` is true, this ID is used for the new range.
     *           If `create_pod_range` is false, uses an existing secondary range with this
     *           ID.
     *           Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *           This field cannot be changed after the node pool has been created.
     *     @type string $pod_ipv4_cidr_block
     *           The IP address range for pod IPs in this node pool.
     *           Only applicable if `create_pod_range` is true.
     *           Set to blank to have a range chosen with the default size.
     *           Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     *           netmask.
     *           Set to a
     *           [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     *           notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
     *           Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     *           This field cannot be changed after the node pool has been created.
     *     @type bool $enable_private_nodes
     *           Whether nodes have internal IP addresses only.
     *           If enable_private_nodes is not specified, then the value is derived from
     *           [Cluster.NetworkConfig.default_enable_private_nodes][]
     *     @type \Google\Cloud\Container\V1\NodeNetworkConfig\NetworkPerformanceConfig $network_performance_config
     *           Network bandwidth tier configuration.
     *     @type \Google\Cloud\Container\V1\PodCIDROverprovisionConfig $pod_cidr_overprovision_config
     *           [PRIVATE FIELD]
     *           Pod CIDR size overprovisioning config for the nodepool.
     *           Pod CIDR size per node depends on max_pods_per_node. By default, the value
     *           of max_pods_per_node is rounded off to next power of 2 and we then double
     *           that to get the size of pod CIDR block per node.
     *           Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     *           This config can disable the doubling of IPs (we still round off to next
     *           power of 2)
     *           Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     *           overprovisioning is disabled.
     *     @type array<\Google\Cloud\Container\V1\AdditionalNodeNetworkConfig>|\Google\Protobuf\Internal\RepeatedField $additional_node_network_configs
     *           We specify the additional node networks for this node pool using this list.
     *           Each node network corresponds to an additional interface
     *     @type array<\Google\Cloud\Container\V1\AdditionalPodNetworkConfig>|\Google\Protobuf\Internal\RepeatedField $additional_pod_network_configs
     *           We specify the additional pod networks for this node pool using this list.
     *           Each pod network corresponds to an additional alias IP range for the node
     *     @type float $pod_ipv4_range_utilization
     *           Output only. The utilization of the IPv4 range for the pod.
     *           The ratio is Usage/[Total number of IPs in the secondary range],
     *           Usage=numNodes*numZones*podIPsPerNode.
     *     @type string $subnetwork
     *           Output only. The subnetwork path for the node pool.
     *           Format: projects/{project}/regions/{region}/subnetworks/{subnetwork}
     *           If the cluster is associated with multiple subnetworks, the subnetwork for
     *           the node pool is picked based on the IP utilization during node pool
     *           creation and is immutable.
     *     @type \Google\Cloud\Container\V1\NetworkTierConfig $network_tier_config
     *           Output only. The network tier configuration for the node pool inherits from
     *           the cluster-level configuration and remains immutable throughout the node
     *           pool's lifecycle, including during upgrades.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * Input only. Whether to create a new range for pod IPs in this node pool.
     * Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they
     * are not specified.
     * If neither `create_pod_range` or `pod_range` are specified, the
     * cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is
     * used.
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     * This field cannot be changed after the node pool has been created.
     *
     * Generated from protobuf field <code>bool create_pod_range = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return bool
     */
    public function getCreatePodRange()
    {
        return $this->create_pod_range;
    }

    /**
     * Input only. Whether to create a new range for pod IPs in this node pool.
     * Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they
     * are not specified.
     * If neither `create_pod_range` or `pod_range` are specified, the
     * cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is
     * used.
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     * This field cannot be changed after the node pool has been created.
     *
     * Generated from protobuf field <code>bool create_pod_range = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setCreatePodRange($var)
    {
        GPBUtil::checkBool($var);
        $this->create_pod_range = $var;

        return $this;
    }

    /**
     * The ID of the secondary range for pod IPs.
     * If `create_pod_range` is true, this ID is used for the new range.
     * If `create_pod_range` is false, uses an existing secondary range with this
     * ID.
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     * This field cannot be changed after the node pool has been created.
     *
     * Generated from protobuf field <code>string pod_range = 5;</code>
     * @return string
     */
    public function getPodRange()
    {
        return $this->pod_range;
    }

    /**
     * The ID of the secondary range for pod IPs.
     * If `create_pod_range` is true, this ID is used for the new range.
     * If `create_pod_range` is false, uses an existing secondary range with this
     * ID.
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     * This field cannot be changed after the node pool has been created.
     *
     * Generated from protobuf field <code>string pod_range = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setPodRange($var)
    {
        GPBUtil::checkString($var, True);
        $this->pod_range = $var;

        return $this;
    }

    /**
     * The IP address range for pod IPs in this node pool.
     * Only applicable if `create_pod_range` is true.
     * Set to blank to have a range chosen with the default size.
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     * This field cannot be changed after the node pool has been created.
     *
     * Generated from protobuf field <code>string pod_ipv4_cidr_block = 6;</code>
     * @return string
     */
    public function getPodIpv4CidrBlock()
    {
        return $this->pod_ipv4_cidr_block;
    }

    /**
     * The IP address range for pod IPs in this node pool.
     * Only applicable if `create_pod_range` is true.
     * Set to blank to have a range chosen with the default size.
     * Set to /netmask (e.g. `/14`) to have a range chosen with a specific
     * netmask.
     * Set to a
     * [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
     * notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
     * Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
     * This field cannot be changed after the node pool has been created.
     *
     * Generated from protobuf field <code>string pod_ipv4_cidr_block = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setPodIpv4CidrBlock($var)
    {
        GPBUtil::checkString($var, True);
        $this->pod_ipv4_cidr_block = $var;

        return $this;
    }

    /**
     * Whether nodes have internal IP addresses only.
     * If enable_private_nodes is not specified, then the value is derived from
     * [Cluster.NetworkConfig.default_enable_private_nodes][]
     *
     * Generated from protobuf field <code>optional bool enable_private_nodes = 9;</code>
     * @return bool
     */
    public function getEnablePrivateNodes()
    {
        return isset($this->enable_private_nodes) ? $this->enable_private_nodes : false;
    }

    public function hasEnablePrivateNodes()
    {
        return isset($this->enable_private_nodes);
    }

    public function clearEnablePrivateNodes()
    {
        unset($this->enable_private_nodes);
    }

    /**
     * Whether nodes have internal IP addresses only.
     * If enable_private_nodes is not specified, then the value is derived from
     * [Cluster.NetworkConfig.default_enable_private_nodes][]
     *
     * Generated from protobuf field <code>optional bool enable_private_nodes = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnablePrivateNodes($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_private_nodes = $var;

        return $this;
    }

    /**
     * Network bandwidth tier configuration.
     *
     * Generated from protobuf field <code>optional .google.container.v1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;</code>
     * @return \Google\Cloud\Container\V1\NodeNetworkConfig\NetworkPerformanceConfig|null
     */
    public function getNetworkPerformanceConfig()
    {
        return $this->network_performance_config;
    }

    public function hasNetworkPerformanceConfig()
    {
        return isset($this->network_performance_config);
    }

    public function clearNetworkPerformanceConfig()
    {
        unset($this->network_performance_config);
    }

    /**
     * Network bandwidth tier configuration.
     *
     * Generated from protobuf field <code>optional .google.container.v1.NodeNetworkConfig.NetworkPerformanceConfig network_performance_config = 11;</code>
     * @param \Google\Cloud\Container\V1\NodeNetworkConfig\NetworkPerformanceConfig $var
     * @return $this
     */
    public function setNetworkPerformanceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodeNetworkConfig\NetworkPerformanceConfig::class);
        $this->network_performance_config = $var;

        return $this;
    }

    /**
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     *
     * Generated from protobuf field <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;</code>
     * @return \Google\Cloud\Container\V1\PodCIDROverprovisionConfig|null
     */
    public function getPodCidrOverprovisionConfig()
    {
        return $this->pod_cidr_overprovision_config;
    }

    public function hasPodCidrOverprovisionConfig()
    {
        return isset($this->pod_cidr_overprovision_config);
    }

    public function clearPodCidrOverprovisionConfig()
    {
        unset($this->pod_cidr_overprovision_config);
    }

    /**
     * [PRIVATE FIELD]
     * Pod CIDR size overprovisioning config for the nodepool.
     * Pod CIDR size per node depends on max_pods_per_node. By default, the value
     * of max_pods_per_node is rounded off to next power of 2 and we then double
     * that to get the size of pod CIDR block per node.
     * Example: max_pods_per_node of 30 would result in 64 IPs (/26).
     * This config can disable the doubling of IPs (we still round off to next
     * power of 2)
     * Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
     * overprovisioning is disabled.
     *
     * Generated from protobuf field <code>.google.container.v1.PodCIDROverprovisionConfig pod_cidr_overprovision_config = 13;</code>
     * @param \Google\Cloud\Container\V1\PodCIDROverprovisionConfig $var
     * @return $this
     */
    public function setPodCidrOverprovisionConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\PodCIDROverprovisionConfig::class);
        $this->pod_cidr_overprovision_config = $var;

        return $this;
    }

    /**
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdditionalNodeNetworkConfigs()
    {
        return $this->additional_node_network_configs;
    }

    /**
     * We specify the additional node networks for this node pool using this list.
     * Each node network corresponds to an additional interface
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AdditionalNodeNetworkConfig additional_node_network_configs = 14;</code>
     * @param array<\Google\Cloud\Container\V1\AdditionalNodeNetworkConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdditionalNodeNetworkConfigs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\AdditionalNodeNetworkConfig::class);
        $this->additional_node_network_configs = $arr;

        return $this;
    }

    /**
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdditionalPodNetworkConfigs()
    {
        return $this->additional_pod_network_configs;
    }

    /**
     * We specify the additional pod networks for this node pool using this list.
     * Each pod network corresponds to an additional alias IP range for the node
     *
     * Generated from protobuf field <code>repeated .google.container.v1.AdditionalPodNetworkConfig additional_pod_network_configs = 15;</code>
     * @param array<\Google\Cloud\Container\V1\AdditionalPodNetworkConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdditionalPodNetworkConfigs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\AdditionalPodNetworkConfig::class);
        $this->additional_pod_network_configs = $arr;

        return $this;
    }

    /**
     * Output only. The utilization of the IPv4 range for the pod.
     * The ratio is Usage/[Total number of IPs in the secondary range],
     * Usage=numNodes*numZones*podIPsPerNode.
     *
     * Generated from protobuf field <code>double pod_ipv4_range_utilization = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return float
     */
    public function getPodIpv4RangeUtilization()
    {
        return $this->pod_ipv4_range_utilization;
    }

    /**
     * Output only. The utilization of the IPv4 range for the pod.
     * The ratio is Usage/[Total number of IPs in the secondary range],
     * Usage=numNodes*numZones*podIPsPerNode.
     *
     * Generated from protobuf field <code>double pod_ipv4_range_utilization = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param float $var
     * @return $this
     */
    public function setPodIpv4RangeUtilization($var)
    {
        GPBUtil::checkDouble($var);
        $this->pod_ipv4_range_utilization = $var;

        return $this;
    }

    /**
     * Output only. The subnetwork path for the node pool.
     * Format: projects/{project}/regions/{region}/subnetworks/{subnetwork}
     * If the cluster is associated with multiple subnetworks, the subnetwork for
     * the node pool is picked based on the IP utilization during node pool
     * creation and is immutable.
     *
     * Generated from protobuf field <code>string subnetwork = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSubnetwork()
    {
        return $this->subnetwork;
    }

    /**
     * Output only. The subnetwork path for the node pool.
     * Format: projects/{project}/regions/{region}/subnetworks/{subnetwork}
     * If the cluster is associated with multiple subnetworks, the subnetwork for
     * the node pool is picked based on the IP utilization during node pool
     * creation and is immutable.
     *
     * Generated from protobuf field <code>string subnetwork = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSubnetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->subnetwork = $var;

        return $this;
    }

    /**
     * Output only. The network tier configuration for the node pool inherits from
     * the cluster-level configuration and remains immutable throughout the node
     * pool's lifecycle, including during upgrades.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkTierConfig network_tier_config = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Container\V1\NetworkTierConfig|null
     */
    public function getNetworkTierConfig()
    {
        return $this->network_tier_config;
    }

    public function hasNetworkTierConfig()
    {
        return isset($this->network_tier_config);
    }

    public function clearNetworkTierConfig()
    {
        unset($this->network_tier_config);
    }

    /**
     * Output only. The network tier configuration for the node pool inherits from
     * the cluster-level configuration and remains immutable throughout the node
     * pool's lifecycle, including during upgrades.
     *
     * Generated from protobuf field <code>.google.container.v1.NetworkTierConfig network_tier_config = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Container\V1\NetworkTierConfig $var
     * @return $this
     */
    public function setNetworkTierConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NetworkTierConfig::class);
        $this->network_tier_config = $var;

        return $this;
    }

}

