<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/translate/v3/translation_service.proto

namespace Google\Cloud\Translate\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Stored in the
 * [google.longrunning.Operation.response][google.longrunning.Operation.response]
 * field returned by BatchTranslateDocument if at least one document is
 * translated successfully.
 *
 * Generated from protobuf message <code>google.cloud.translation.v3.BatchTranslateDocumentResponse</code>
 */
class BatchTranslateDocumentResponse extends \Google\Protobuf\Internal\Message
{
    /**
     * Total number of pages to translate in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     *
     * Generated from protobuf field <code>int64 total_pages = 1;</code>
     */
    protected $total_pages = 0;
    /**
     * Number of successfully translated pages in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     *
     * Generated from protobuf field <code>int64 translated_pages = 2;</code>
     */
    protected $translated_pages = 0;
    /**
     * Number of pages that failed to process in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     *
     * Generated from protobuf field <code>int64 failed_pages = 3;</code>
     */
    protected $failed_pages = 0;
    /**
     * Number of billable pages in documents with clear page definition (such as
     * PDF, DOCX, PPTX)
     *
     * Generated from protobuf field <code>int64 total_billable_pages = 4;</code>
     */
    protected $total_billable_pages = 0;
    /**
     * Total number of characters (Unicode codepoints) in all documents.
     *
     * Generated from protobuf field <code>int64 total_characters = 5;</code>
     */
    protected $total_characters = 0;
    /**
     * Number of successfully translated characters (Unicode codepoints) in all
     * documents.
     *
     * Generated from protobuf field <code>int64 translated_characters = 6;</code>
     */
    protected $translated_characters = 0;
    /**
     * Number of characters that have failed to process (Unicode codepoints) in
     * all documents.
     *
     * Generated from protobuf field <code>int64 failed_characters = 7;</code>
     */
    protected $failed_characters = 0;
    /**
     * Number of billable characters (Unicode codepoints) in documents without
     * clear page definition, such as XLSX.
     *
     * Generated from protobuf field <code>int64 total_billable_characters = 8;</code>
     */
    protected $total_billable_characters = 0;
    /**
     * Time when the operation was submitted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp submit_time = 9;</code>
     */
    protected $submit_time = null;
    /**
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 10;</code>
     */
    protected $end_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $total_pages
     *           Total number of pages to translate in all documents. Documents without
     *           clear page definition (such as XLSX) are not counted.
     *     @type int|string $translated_pages
     *           Number of successfully translated pages in all documents. Documents without
     *           clear page definition (such as XLSX) are not counted.
     *     @type int|string $failed_pages
     *           Number of pages that failed to process in all documents. Documents without
     *           clear page definition (such as XLSX) are not counted.
     *     @type int|string $total_billable_pages
     *           Number of billable pages in documents with clear page definition (such as
     *           PDF, DOCX, PPTX)
     *     @type int|string $total_characters
     *           Total number of characters (Unicode codepoints) in all documents.
     *     @type int|string $translated_characters
     *           Number of successfully translated characters (Unicode codepoints) in all
     *           documents.
     *     @type int|string $failed_characters
     *           Number of characters that have failed to process (Unicode codepoints) in
     *           all documents.
     *     @type int|string $total_billable_characters
     *           Number of billable characters (Unicode codepoints) in documents without
     *           clear page definition, such as XLSX.
     *     @type \Google\Protobuf\Timestamp $submit_time
     *           Time when the operation was submitted.
     *     @type \Google\Protobuf\Timestamp $end_time
     *           The time when the operation is finished and
     *           [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     *           set to true.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Translate\V3\TranslationService::initOnce();
        parent::__construct($data);
    }

    /**
     * Total number of pages to translate in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     *
     * Generated from protobuf field <code>int64 total_pages = 1;</code>
     * @return int|string
     */
    public function getTotalPages()
    {
        return $this->total_pages;
    }

    /**
     * Total number of pages to translate in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     *
     * Generated from protobuf field <code>int64 total_pages = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTotalPages($var)
    {
        GPBUtil::checkInt64($var);
        $this->total_pages = $var;

        return $this;
    }

    /**
     * Number of successfully translated pages in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     *
     * Generated from protobuf field <code>int64 translated_pages = 2;</code>
     * @return int|string
     */
    public function getTranslatedPages()
    {
        return $this->translated_pages;
    }

    /**
     * Number of successfully translated pages in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     *
     * Generated from protobuf field <code>int64 translated_pages = 2;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTranslatedPages($var)
    {
        GPBUtil::checkInt64($var);
        $this->translated_pages = $var;

        return $this;
    }

    /**
     * Number of pages that failed to process in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     *
     * Generated from protobuf field <code>int64 failed_pages = 3;</code>
     * @return int|string
     */
    public function getFailedPages()
    {
        return $this->failed_pages;
    }

    /**
     * Number of pages that failed to process in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     *
     * Generated from protobuf field <code>int64 failed_pages = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setFailedPages($var)
    {
        GPBUtil::checkInt64($var);
        $this->failed_pages = $var;

        return $this;
    }

    /**
     * Number of billable pages in documents with clear page definition (such as
     * PDF, DOCX, PPTX)
     *
     * Generated from protobuf field <code>int64 total_billable_pages = 4;</code>
     * @return int|string
     */
    public function getTotalBillablePages()
    {
        return $this->total_billable_pages;
    }

    /**
     * Number of billable pages in documents with clear page definition (such as
     * PDF, DOCX, PPTX)
     *
     * Generated from protobuf field <code>int64 total_billable_pages = 4;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTotalBillablePages($var)
    {
        GPBUtil::checkInt64($var);
        $this->total_billable_pages = $var;

        return $this;
    }

    /**
     * Total number of characters (Unicode codepoints) in all documents.
     *
     * Generated from protobuf field <code>int64 total_characters = 5;</code>
     * @return int|string
     */
    public function getTotalCharacters()
    {
        return $this->total_characters;
    }

    /**
     * Total number of characters (Unicode codepoints) in all documents.
     *
     * Generated from protobuf field <code>int64 total_characters = 5;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTotalCharacters($var)
    {
        GPBUtil::checkInt64($var);
        $this->total_characters = $var;

        return $this;
    }

    /**
     * Number of successfully translated characters (Unicode codepoints) in all
     * documents.
     *
     * Generated from protobuf field <code>int64 translated_characters = 6;</code>
     * @return int|string
     */
    public function getTranslatedCharacters()
    {
        return $this->translated_characters;
    }

    /**
     * Number of successfully translated characters (Unicode codepoints) in all
     * documents.
     *
     * Generated from protobuf field <code>int64 translated_characters = 6;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTranslatedCharacters($var)
    {
        GPBUtil::checkInt64($var);
        $this->translated_characters = $var;

        return $this;
    }

    /**
     * Number of characters that have failed to process (Unicode codepoints) in
     * all documents.
     *
     * Generated from protobuf field <code>int64 failed_characters = 7;</code>
     * @return int|string
     */
    public function getFailedCharacters()
    {
        return $this->failed_characters;
    }

    /**
     * Number of characters that have failed to process (Unicode codepoints) in
     * all documents.
     *
     * Generated from protobuf field <code>int64 failed_characters = 7;</code>
     * @param int|string $var
     * @return $this
     */
    public function setFailedCharacters($var)
    {
        GPBUtil::checkInt64($var);
        $this->failed_characters = $var;

        return $this;
    }

    /**
     * Number of billable characters (Unicode codepoints) in documents without
     * clear page definition, such as XLSX.
     *
     * Generated from protobuf field <code>int64 total_billable_characters = 8;</code>
     * @return int|string
     */
    public function getTotalBillableCharacters()
    {
        return $this->total_billable_characters;
    }

    /**
     * Number of billable characters (Unicode codepoints) in documents without
     * clear page definition, such as XLSX.
     *
     * Generated from protobuf field <code>int64 total_billable_characters = 8;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTotalBillableCharacters($var)
    {
        GPBUtil::checkInt64($var);
        $this->total_billable_characters = $var;

        return $this;
    }

    /**
     * Time when the operation was submitted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp submit_time = 9;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getSubmitTime()
    {
        return $this->submit_time;
    }

    public function hasSubmitTime()
    {
        return isset($this->submit_time);
    }

    public function clearSubmitTime()
    {
        unset($this->submit_time);
    }

    /**
     * Time when the operation was submitted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp submit_time = 9;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setSubmitTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->submit_time = $var;

        return $this;
    }

    /**
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 10;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    public function hasEndTime()
    {
        return isset($this->end_time);
    }

    public function clearEndTime()
    {
        unset($this->end_time);
    }

    /**
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

}

