<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/support/v2beta/case.proto

namespace Google\Cloud\Support\V2beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Case Classification represents the topic that a case is about. It's very
 * important to use accurate classifications, because they're
 * used to route your cases to specialists who can help you.
 * A classification always has an ID that is its unique identifier.
 * A valid ID is required when creating a case.
 *
 * Generated from protobuf message <code>google.cloud.support.v2beta.CaseClassification</code>
 */
class CaseClassification extends \Google\Protobuf\Internal\Message
{
    /**
     * The unique ID for a classification. Must be specified for case creation.
     * To retrieve valid classification IDs for case creation, use
     * `caseClassifications.search`.
     * Classification IDs returned by `caseClassifications.search` are guaranteed
     * to be valid for at least 6 months. If a given classification is
     * deactiveated, it will immediately stop being returned. After 6 months,
     * `case.create` requests using the classification ID will fail.
     *
     * Generated from protobuf field <code>string id = 3;</code>
     */
    protected $id = '';
    /**
     * A display name for the classification.
     * The display name is not static and can change. To uniquely and consistently
     * identify classifications, use the `CaseClassification.id` field.
     *
     * Generated from protobuf field <code>string display_name = 4;</code>
     */
    protected $display_name = '';
    /**
     * The full product the classification corresponds to.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2beta.Product product = 10;</code>
     */
    protected $product = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $id
     *           The unique ID for a classification. Must be specified for case creation.
     *           To retrieve valid classification IDs for case creation, use
     *           `caseClassifications.search`.
     *           Classification IDs returned by `caseClassifications.search` are guaranteed
     *           to be valid for at least 6 months. If a given classification is
     *           deactiveated, it will immediately stop being returned. After 6 months,
     *           `case.create` requests using the classification ID will fail.
     *     @type string $display_name
     *           A display name for the classification.
     *           The display name is not static and can change. To uniquely and consistently
     *           identify classifications, use the `CaseClassification.id` field.
     *     @type \Google\Cloud\Support\V2beta\Product $product
     *           The full product the classification corresponds to.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Support\V2Beta\PBCase::initOnce();
        parent::__construct($data);
    }

    /**
     * The unique ID for a classification. Must be specified for case creation.
     * To retrieve valid classification IDs for case creation, use
     * `caseClassifications.search`.
     * Classification IDs returned by `caseClassifications.search` are guaranteed
     * to be valid for at least 6 months. If a given classification is
     * deactiveated, it will immediately stop being returned. After 6 months,
     * `case.create` requests using the classification ID will fail.
     *
     * Generated from protobuf field <code>string id = 3;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * The unique ID for a classification. Must be specified for case creation.
     * To retrieve valid classification IDs for case creation, use
     * `caseClassifications.search`.
     * Classification IDs returned by `caseClassifications.search` are guaranteed
     * to be valid for at least 6 months. If a given classification is
     * deactiveated, it will immediately stop being returned. After 6 months,
     * `case.create` requests using the classification ID will fail.
     *
     * Generated from protobuf field <code>string id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * A display name for the classification.
     * The display name is not static and can change. To uniquely and consistently
     * identify classifications, use the `CaseClassification.id` field.
     *
     * Generated from protobuf field <code>string display_name = 4;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * A display name for the classification.
     * The display name is not static and can change. To uniquely and consistently
     * identify classifications, use the `CaseClassification.id` field.
     *
     * Generated from protobuf field <code>string display_name = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The full product the classification corresponds to.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2beta.Product product = 10;</code>
     * @return \Google\Cloud\Support\V2beta\Product|null
     */
    public function getProduct()
    {
        return $this->product;
    }

    public function hasProduct()
    {
        return isset($this->product);
    }

    public function clearProduct()
    {
        unset($this->product);
    }

    /**
     * The full product the classification corresponds to.
     *
     * Generated from protobuf field <code>.google.cloud.support.v2beta.Product product = 10;</code>
     * @param \Google\Cloud\Support\V2beta\Product $var
     * @return $this
     */
    public function setProduct($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Support\V2beta\Product::class);
        $this->product = $var;

        return $this;
    }

}

