<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/spanner.proto

namespace Google\Cloud\Spanner\V1\ExecuteSqlRequest;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Query optimizer configuration.
 *
 * Generated from protobuf message <code>google.spanner.v1.ExecuteSqlRequest.QueryOptions</code>
 */
class QueryOptions extends \Google\Protobuf\Internal\Message
{
    /**
     * An option to control the selection of optimizer version.
     * This parameter allows individual queries to pick different query
     * optimizer versions.
     * Specifying `latest` as a value instructs Cloud Spanner to use the
     * latest supported query optimizer version. If not specified, Cloud Spanner
     * uses the optimizer version set at the database level options. Any other
     * positive integer (from the list of supported optimizer versions)
     * overrides the default optimizer version for query execution.
     * The list of supported optimizer versions can be queried from
     * `SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS`.
     * Executing a SQL statement with an invalid optimizer version fails with
     * an `INVALID_ARGUMENT` error.
     * See
     * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
     * for more information on managing the query optimizer.
     * The `optimizer_version` statement hint has precedence over this setting.
     *
     * Generated from protobuf field <code>string optimizer_version = 1;</code>
     */
    protected $optimizer_version = '';
    /**
     * An option to control the selection of optimizer statistics package.
     * This parameter allows individual queries to use a different query
     * optimizer statistics package.
     * Specifying `latest` as a value instructs Cloud Spanner to use the latest
     * generated statistics package. If not specified, Cloud Spanner uses
     * the statistics package set at the database level options, or the latest
     * package if the database option isn't set.
     * The statistics package requested by the query has to be exempt from
     * garbage collection. This can be achieved with the following DDL
     * statement:
     * ```sql
     * ALTER STATISTICS <package_name> SET OPTIONS (allow_gc=false)
     * ```
     * The list of available statistics packages can be queried from
     * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
     * Executing a SQL statement with an invalid optimizer statistics package
     * or with a statistics package that allows garbage collection fails with
     * an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>string optimizer_statistics_package = 2;</code>
     */
    protected $optimizer_statistics_package = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $optimizer_version
     *           An option to control the selection of optimizer version.
     *           This parameter allows individual queries to pick different query
     *           optimizer versions.
     *           Specifying `latest` as a value instructs Cloud Spanner to use the
     *           latest supported query optimizer version. If not specified, Cloud Spanner
     *           uses the optimizer version set at the database level options. Any other
     *           positive integer (from the list of supported optimizer versions)
     *           overrides the default optimizer version for query execution.
     *           The list of supported optimizer versions can be queried from
     *           `SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS`.
     *           Executing a SQL statement with an invalid optimizer version fails with
     *           an `INVALID_ARGUMENT` error.
     *           See
     *           https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
     *           for more information on managing the query optimizer.
     *           The `optimizer_version` statement hint has precedence over this setting.
     *     @type string $optimizer_statistics_package
     *           An option to control the selection of optimizer statistics package.
     *           This parameter allows individual queries to use a different query
     *           optimizer statistics package.
     *           Specifying `latest` as a value instructs Cloud Spanner to use the latest
     *           generated statistics package. If not specified, Cloud Spanner uses
     *           the statistics package set at the database level options, or the latest
     *           package if the database option isn't set.
     *           The statistics package requested by the query has to be exempt from
     *           garbage collection. This can be achieved with the following DDL
     *           statement:
     *           ```sql
     *           ALTER STATISTICS <package_name> SET OPTIONS (allow_gc=false)
     *           ```
     *           The list of available statistics packages can be queried from
     *           `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
     *           Executing a SQL statement with an invalid optimizer statistics package
     *           or with a statistics package that allows garbage collection fails with
     *           an `INVALID_ARGUMENT` error.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Spanner::initOnce();
        parent::__construct($data);
    }

    /**
     * An option to control the selection of optimizer version.
     * This parameter allows individual queries to pick different query
     * optimizer versions.
     * Specifying `latest` as a value instructs Cloud Spanner to use the
     * latest supported query optimizer version. If not specified, Cloud Spanner
     * uses the optimizer version set at the database level options. Any other
     * positive integer (from the list of supported optimizer versions)
     * overrides the default optimizer version for query execution.
     * The list of supported optimizer versions can be queried from
     * `SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS`.
     * Executing a SQL statement with an invalid optimizer version fails with
     * an `INVALID_ARGUMENT` error.
     * See
     * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
     * for more information on managing the query optimizer.
     * The `optimizer_version` statement hint has precedence over this setting.
     *
     * Generated from protobuf field <code>string optimizer_version = 1;</code>
     * @return string
     */
    public function getOptimizerVersion()
    {
        return $this->optimizer_version;
    }

    /**
     * An option to control the selection of optimizer version.
     * This parameter allows individual queries to pick different query
     * optimizer versions.
     * Specifying `latest` as a value instructs Cloud Spanner to use the
     * latest supported query optimizer version. If not specified, Cloud Spanner
     * uses the optimizer version set at the database level options. Any other
     * positive integer (from the list of supported optimizer versions)
     * overrides the default optimizer version for query execution.
     * The list of supported optimizer versions can be queried from
     * `SPANNER_SYS.SUPPORTED_OPTIMIZER_VERSIONS`.
     * Executing a SQL statement with an invalid optimizer version fails with
     * an `INVALID_ARGUMENT` error.
     * See
     * https://cloud.google.com/spanner/docs/query-optimizer/manage-query-optimizer
     * for more information on managing the query optimizer.
     * The `optimizer_version` statement hint has precedence over this setting.
     *
     * Generated from protobuf field <code>string optimizer_version = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setOptimizerVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->optimizer_version = $var;

        return $this;
    }

    /**
     * An option to control the selection of optimizer statistics package.
     * This parameter allows individual queries to use a different query
     * optimizer statistics package.
     * Specifying `latest` as a value instructs Cloud Spanner to use the latest
     * generated statistics package. If not specified, Cloud Spanner uses
     * the statistics package set at the database level options, or the latest
     * package if the database option isn't set.
     * The statistics package requested by the query has to be exempt from
     * garbage collection. This can be achieved with the following DDL
     * statement:
     * ```sql
     * ALTER STATISTICS <package_name> SET OPTIONS (allow_gc=false)
     * ```
     * The list of available statistics packages can be queried from
     * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
     * Executing a SQL statement with an invalid optimizer statistics package
     * or with a statistics package that allows garbage collection fails with
     * an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>string optimizer_statistics_package = 2;</code>
     * @return string
     */
    public function getOptimizerStatisticsPackage()
    {
        return $this->optimizer_statistics_package;
    }

    /**
     * An option to control the selection of optimizer statistics package.
     * This parameter allows individual queries to use a different query
     * optimizer statistics package.
     * Specifying `latest` as a value instructs Cloud Spanner to use the latest
     * generated statistics package. If not specified, Cloud Spanner uses
     * the statistics package set at the database level options, or the latest
     * package if the database option isn't set.
     * The statistics package requested by the query has to be exempt from
     * garbage collection. This can be achieved with the following DDL
     * statement:
     * ```sql
     * ALTER STATISTICS <package_name> SET OPTIONS (allow_gc=false)
     * ```
     * The list of available statistics packages can be queried from
     * `INFORMATION_SCHEMA.SPANNER_STATISTICS`.
     * Executing a SQL statement with an invalid optimizer statistics package
     * or with a statistics package that allows garbage collection fails with
     * an `INVALID_ARGUMENT` error.
     *
     * Generated from protobuf field <code>string optimizer_statistics_package = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setOptimizerStatisticsPackage($var)
    {
        GPBUtil::checkString($var, True);
        $this->optimizer_statistics_package = $var;

        return $this;
    }

}


