<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/compute/v1/compute.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Compute\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Compute\V1\DisableXpnHostProjectRequest;
use Google\Cloud\Compute\V1\DisableXpnResourceProjectRequest;
use Google\Cloud\Compute\V1\EnableXpnHostProjectRequest;
use Google\Cloud\Compute\V1\EnableXpnResourceProjectRequest;
use Google\Cloud\Compute\V1\GetProjectRequest;
use Google\Cloud\Compute\V1\GetXpnHostProjectRequest;
use Google\Cloud\Compute\V1\GetXpnResourcesProjectsRequest;
use Google\Cloud\Compute\V1\ListXpnHostsProjectsRequest;
use Google\Cloud\Compute\V1\MoveDiskProjectRequest;
use Google\Cloud\Compute\V1\MoveInstanceProjectRequest;
use Google\Cloud\Compute\V1\Project;
use Google\Cloud\Compute\V1\SetCloudArmorTierProjectRequest;
use Google\Cloud\Compute\V1\SetCommonInstanceMetadataProjectRequest;
use Google\Cloud\Compute\V1\SetDefaultNetworkTierProjectRequest;
use Google\Cloud\Compute\V1\SetUsageExportBucketProjectRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The Projects API.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * @method PromiseInterface<OperationResponse> disableXpnHostAsync(DisableXpnHostProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> disableXpnResourceAsync(DisableXpnResourceProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> enableXpnHostAsync(EnableXpnHostProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> enableXpnResourceAsync(EnableXpnResourceProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Project> getAsync(GetProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Project> getXpnHostAsync(GetXpnHostProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> getXpnResourcesAsync(GetXpnResourcesProjectsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listXpnHostsAsync(ListXpnHostsProjectsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> moveDiskAsync(MoveDiskProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> moveInstanceAsync(MoveInstanceProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> setCloudArmorTierAsync(SetCloudArmorTierProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> setCommonInstanceMetadataAsync(SetCommonInstanceMetadataProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> setDefaultNetworkTierAsync(SetDefaultNetworkTierProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> setUsageExportBucketAsync(SetUsageExportBucketProjectRequest $request, array $optionalArgs = [])
 */
final class ProjectsClient
{
    use GapicClientTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.compute.v1.Projects';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'compute.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'compute.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/compute',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/projects_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/projects_descriptor_config.php',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
                'useJwtAccessWithScope' => false,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/projects_rest_client_config.php',
                ],
            ],
        ];
    }

    /** Implements GapicClientTrait::defaultTransport. */
    private static function defaultTransport()
    {
        return 'rest';
    }

    /** Implements ClientOptionsTrait::supportedTransports. */
    private static function supportedTransports()
    {
        return ['rest'];
    }

    /**
     * Return an GlobalOperationsClient object with the same endpoint as $this.
     *
     * @return GlobalOperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /** Return the default longrunning operation descriptor config. */
    private function getDefaultOperationDescriptor()
    {
        return [
            'additionalArgumentMethods' => ['getProject'],
            'getOperationMethod' => 'get',
            'cancelOperationMethod' => null,
            'deleteOperationMethod' => 'delete',
            'operationErrorCodeMethod' => 'getHttpErrorStatusCode',
            'operationErrorMessageMethod' => 'getHttpErrorMessage',
            'operationNameMethod' => 'getName',
            'operationStatusMethod' => 'getStatus',
            'operationStatusDoneValue' => \Google\Cloud\Compute\V1\Operation\Status::DONE,
            'getOperationRequest' => '\Google\Cloud\Compute\V1\GetGlobalOperationRequest',
            'cancelOperationRequest' => null,
            'deleteOperationRequest' => '\Google\Cloud\Compute\V1\DeleteGlobalOperationRequest',
        ];
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? $this->getDefaultOperationDescriptor();
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return GlobalOperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new GlobalOperationsClient($options);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'compute.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Compute\V1\ProjectsClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new ProjectsClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. At the moment, supports only
     *           `rest`. *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\RestTransport::build()} method for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Disable this project as a shared VPC host project.
     *
     * The async variant is {@see ProjectsClient::disableXpnHostAsync()} .
     *
     * @example samples/V1/ProjectsClient/disable_xpn_host.php
     *
     * @param DisableXpnHostProjectRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function disableXpnHost(DisableXpnHostProjectRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DisableXpnHost', $request, $callOptions)->wait();
    }

    /**
     * Disable a service resource (also known as service project) associated with this host project.
     *
     * The async variant is {@see ProjectsClient::disableXpnResourceAsync()} .
     *
     * @example samples/V1/ProjectsClient/disable_xpn_resource.php
     *
     * @param DisableXpnResourceProjectRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function disableXpnResource(
        DisableXpnResourceProjectRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DisableXpnResource', $request, $callOptions)->wait();
    }

    /**
     * Enable this project as a shared VPC host project.
     *
     * The async variant is {@see ProjectsClient::enableXpnHostAsync()} .
     *
     * @example samples/V1/ProjectsClient/enable_xpn_host.php
     *
     * @param EnableXpnHostProjectRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function enableXpnHost(EnableXpnHostProjectRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('EnableXpnHost', $request, $callOptions)->wait();
    }

    /**
     * Enable service resource (a.k.a service project) for a host project, so that subnets in the host project can be used by instances in the service project.
     *
     * The async variant is {@see ProjectsClient::enableXpnResourceAsync()} .
     *
     * @example samples/V1/ProjectsClient/enable_xpn_resource.php
     *
     * @param EnableXpnResourceProjectRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function enableXpnResource(
        EnableXpnResourceProjectRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('EnableXpnResource', $request, $callOptions)->wait();
    }

    /**
     * Returns the specified Project resource. To decrease latency for this method, you can optionally omit any unneeded information from the response by using a field mask. This practice is especially recommended for unused quota information (the `quotas` field). To exclude one or more fields, set your request's `fields` query parameter to only include the fields you need. For example, to only include the `id` and `selfLink` fields, add the query parameter `?fields=id,selfLink` to your request.
     *
     * The async variant is {@see ProjectsClient::getAsync()} .
     *
     * @example samples/V1/ProjectsClient/get.php
     *
     * @param GetProjectRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Project
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function get(GetProjectRequest $request, array $callOptions = []): Project
    {
        return $this->startApiCall('Get', $request, $callOptions)->wait();
    }

    /**
     * Gets the shared VPC host project that this project links to. May be empty if no link exists.
     *
     * The async variant is {@see ProjectsClient::getXpnHostAsync()} .
     *
     * @example samples/V1/ProjectsClient/get_xpn_host.php
     *
     * @param GetXpnHostProjectRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Project
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getXpnHost(GetXpnHostProjectRequest $request, array $callOptions = []): Project
    {
        return $this->startApiCall('GetXpnHost', $request, $callOptions)->wait();
    }

    /**
     * Gets service resources (a.k.a service project) associated with this host project.
     *
     * The async variant is {@see ProjectsClient::getXpnResourcesAsync()} .
     *
     * @example samples/V1/ProjectsClient/get_xpn_resources.php
     *
     * @param GetXpnResourcesProjectsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getXpnResources(GetXpnResourcesProjectsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('GetXpnResources', $request, $callOptions);
    }

    /**
     * Lists all shared VPC host projects visible to the user in an organization.
     *
     * The async variant is {@see ProjectsClient::listXpnHostsAsync()} .
     *
     * @example samples/V1/ProjectsClient/list_xpn_hosts.php
     *
     * @param ListXpnHostsProjectsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listXpnHosts(ListXpnHostsProjectsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListXpnHosts', $request, $callOptions);
    }

    /**
     * Starting September 29, 2025, you can't use the moveDisk API on new projects. To move a disk to a different region or zone, follow the steps in [Change the location of a disk](https://{$universe.dns_names.final_documentation_domain}/compute/docs/disks/migrate-to-hyperdisk#migrate-to-hd). Projects that already use the moveDisk API can continue usage until September 29, 2026. Starting November 1, 2025, API responses will include a warning message in the response body about the upcoming deprecation. You can skip the message to continue using the service without interruption.
     *
     * The async variant is {@see ProjectsClient::moveDiskAsync()} .
     *
     * @example samples/V1/ProjectsClient/move_disk.php
     *
     * @param MoveDiskProjectRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function moveDisk(MoveDiskProjectRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('MoveDisk', $request, $callOptions)->wait();
    }

    /**
     * Moves an instance and its attached persistent disks from one zone to another. *Note*: Moving VMs or disks by using this method might cause unexpected behavior. For more information, see the [known issue](/compute/docs/troubleshooting/known-issues#moving_vms_or_disks_using_the_moveinstance_api_or_the_causes_unexpected_behavior). [Deprecated] This method is deprecated. See [moving instance across zones](/compute/docs/instances/moving-instance-across-zones) instead.
     *
     * The async variant is {@see ProjectsClient::moveInstanceAsync()} .
     *
     * @example samples/V1/ProjectsClient/move_instance.php
     *
     * @param MoveInstanceProjectRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function moveInstance(MoveInstanceProjectRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('MoveInstance', $request, $callOptions)->wait();
    }

    /**
     * Sets the Cloud Armor tier of the project. To set ENTERPRISE or above the billing account of the project must be subscribed to Cloud Armor Enterprise. See Subscribing to Cloud Armor Enterprise for more information.
     *
     * The async variant is {@see ProjectsClient::setCloudArmorTierAsync()} .
     *
     * @example samples/V1/ProjectsClient/set_cloud_armor_tier.php
     *
     * @param SetCloudArmorTierProjectRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setCloudArmorTier(
        SetCloudArmorTierProjectRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('SetCloudArmorTier', $request, $callOptions)->wait();
    }

    /**
     * Sets metadata common to all instances within the specified project using the data included in the request.
     *
     * The async variant is {@see ProjectsClient::setCommonInstanceMetadataAsync()} .
     *
     * @example samples/V1/ProjectsClient/set_common_instance_metadata.php
     *
     * @param SetCommonInstanceMetadataProjectRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setCommonInstanceMetadata(
        SetCommonInstanceMetadataProjectRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('SetCommonInstanceMetadata', $request, $callOptions)->wait();
    }

    /**
     * Sets the default network tier of the project. The default network tier is used when an address/forwardingRule/instance is created without specifying the network tier field.
     *
     * The async variant is {@see ProjectsClient::setDefaultNetworkTierAsync()} .
     *
     * @example samples/V1/ProjectsClient/set_default_network_tier.php
     *
     * @param SetDefaultNetworkTierProjectRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setDefaultNetworkTier(
        SetDefaultNetworkTierProjectRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('SetDefaultNetworkTier', $request, $callOptions)->wait();
    }

    /**
     * Enables the usage export feature and sets the usage export bucket where reports are stored. If you provide an empty request body using this method, the usage export feature will be disabled.
     *
     * The async variant is {@see ProjectsClient::setUsageExportBucketAsync()} .
     *
     * @example samples/V1/ProjectsClient/set_usage_export_bucket.php
     *
     * @param SetUsageExportBucketProjectRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setUsageExportBucket(
        SetUsageExportBucketProjectRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('SetUsageExportBucket', $request, $callOptions)->wait();
    }
}
