<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/chronicle/v1/reference_list.proto

namespace Google\Cloud\Chronicle\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request to create a reference list.
 *
 * Generated from protobuf message <code>google.cloud.chronicle.v1.CreateReferenceListRequest</code>
 */
class CreateReferenceListRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource where this reference list will be created.
     * Format: `projects/{project}/locations/{location}/instances/{instance}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The reference list to create.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ReferenceList reference_list = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $reference_list = null;
    /**
     * Required. The ID to use for the reference list. This is also the display
     * name for the reference list. It must satisfy the following requirements:
     * - Starts with letter.
     * - Contains only letters, numbers and underscore.
     * - Has length less than 256.
     * - Must be unique.
     *
     * Generated from protobuf field <code>string reference_list_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $reference_list_id = '';

    /**
     * @param string                                   $parent          Required. The parent resource where this reference list will be created.
     *                                                                  Format: `projects/{project}/locations/{location}/instances/{instance}`
     *                                                                  Please see {@see ReferenceListServiceClient::instanceName()} for help formatting this field.
     * @param \Google\Cloud\Chronicle\V1\ReferenceList $referenceList   Required. The reference list to create.
     * @param string                                   $referenceListId Required. The ID to use for the reference list. This is also the display
     *                                                                  name for the reference list. It must satisfy the following requirements:
     *                                                                  - Starts with letter.
     *                                                                  - Contains only letters, numbers and underscore.
     *                                                                  - Has length less than 256.
     *                                                                  - Must be unique.
     *
     * @return \Google\Cloud\Chronicle\V1\CreateReferenceListRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Chronicle\V1\ReferenceList $referenceList, string $referenceListId): self
    {
        return (new self())
            ->setParent($parent)
            ->setReferenceList($referenceList)
            ->setReferenceListId($referenceListId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent resource where this reference list will be created.
     *           Format: `projects/{project}/locations/{location}/instances/{instance}`
     *     @type \Google\Cloud\Chronicle\V1\ReferenceList $reference_list
     *           Required. The reference list to create.
     *     @type string $reference_list_id
     *           Required. The ID to use for the reference list. This is also the display
     *           name for the reference list. It must satisfy the following requirements:
     *           - Starts with letter.
     *           - Contains only letters, numbers and underscore.
     *           - Has length less than 256.
     *           - Must be unique.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Chronicle\V1\ReferenceList::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent resource where this reference list will be created.
     * Format: `projects/{project}/locations/{location}/instances/{instance}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource where this reference list will be created.
     * Format: `projects/{project}/locations/{location}/instances/{instance}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The reference list to create.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ReferenceList reference_list = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Chronicle\V1\ReferenceList|null
     */
    public function getReferenceList()
    {
        return $this->reference_list;
    }

    public function hasReferenceList()
    {
        return isset($this->reference_list);
    }

    public function clearReferenceList()
    {
        unset($this->reference_list);
    }

    /**
     * Required. The reference list to create.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.ReferenceList reference_list = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Chronicle\V1\ReferenceList $var
     * @return $this
     */
    public function setReferenceList($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Chronicle\V1\ReferenceList::class);
        $this->reference_list = $var;

        return $this;
    }

    /**
     * Required. The ID to use for the reference list. This is also the display
     * name for the reference list. It must satisfy the following requirements:
     * - Starts with letter.
     * - Contains only letters, numbers and underscore.
     * - Has length less than 256.
     * - Must be unique.
     *
     * Generated from protobuf field <code>string reference_list_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getReferenceListId()
    {
        return $this->reference_list_id;
    }

    /**
     * Required. The ID to use for the reference list. This is also the display
     * name for the reference list. It must satisfy the following requirements:
     * - Starts with letter.
     * - Contains only letters, numbers and underscore.
     * - Has length less than 256.
     * - Must be unique.
     *
     * Generated from protobuf field <code>string reference_list_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setReferenceListId($var)
    {
        GPBUtil::checkString($var, True);
        $this->reference_list_id = $var;

        return $this;
    }

}

