<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/apps/card/v1/card.proto

namespace Google\Apps\Card\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A text, icon, or text and icon chip that users can click.
 * [Google Workspace add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 *
 * Generated from protobuf message <code>google.apps.card.v1.Chip</code>
 */
class Chip extends \Google\Protobuf\Internal\Message
{
    /**
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Icon icon = 1;</code>
     */
    protected $icon = null;
    /**
     * The text displayed inside the chip.
     *
     * Generated from protobuf field <code>string label = 2;</code>
     */
    protected $label = '';
    /**
     * Optional. The action to perform when a user clicks the chip, such as
     * opening a hyperlink or running a custom function.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.OnClick on_click = 3;</code>
     */
    protected $on_click = null;
    /**
     * Whether the chip is in an active state and responds to user actions.
     * Defaults to `true`.
     * Deprecated. Use `disabled` instead.
     *
     * Generated from protobuf field <code>bool enabled = 4 [deprecated = true];</code>
     * @deprecated
     */
    protected $enabled = false;
    /**
     * Whether the chip is in an inactive state and ignores user actions.
     * Defaults to `false`.
     *
     * Generated from protobuf field <code>bool disabled = 6;</code>
     */
    protected $disabled = false;
    /**
     * The alternative text that's used for accessibility.
     * Set descriptive text that lets users know what the chip does. For
     * example, if a chip opens a hyperlink, write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/workspace/chat".
     *
     * Generated from protobuf field <code>string alt_text = 5;</code>
     */
    protected $alt_text = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Apps\Card\V1\Icon $icon
     *           The icon image. If both `icon` and `text` are set, then the icon appears
     *           before the text.
     *     @type string $label
     *           The text displayed inside the chip.
     *     @type \Google\Apps\Card\V1\OnClick $on_click
     *           Optional. The action to perform when a user clicks the chip, such as
     *           opening a hyperlink or running a custom function.
     *     @type bool $enabled
     *           Whether the chip is in an active state and responds to user actions.
     *           Defaults to `true`.
     *           Deprecated. Use `disabled` instead.
     *     @type bool $disabled
     *           Whether the chip is in an inactive state and ignores user actions.
     *           Defaults to `false`.
     *     @type string $alt_text
     *           The alternative text that's used for accessibility.
     *           Set descriptive text that lets users know what the chip does. For
     *           example, if a chip opens a hyperlink, write: "Opens a new
     *           browser tab and navigates to the Google Chat developer documentation at
     *           https://developers.google.com/workspace/chat".
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Apps\Card\V1\Card::initOnce();
        parent::__construct($data);
    }

    /**
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Icon icon = 1;</code>
     * @return \Google\Apps\Card\V1\Icon|null
     */
    public function getIcon()
    {
        return $this->icon;
    }

    public function hasIcon()
    {
        return isset($this->icon);
    }

    public function clearIcon()
    {
        unset($this->icon);
    }

    /**
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Icon icon = 1;</code>
     * @param \Google\Apps\Card\V1\Icon $var
     * @return $this
     */
    public function setIcon($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Icon::class);
        $this->icon = $var;

        return $this;
    }

    /**
     * The text displayed inside the chip.
     *
     * Generated from protobuf field <code>string label = 2;</code>
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * The text displayed inside the chip.
     *
     * Generated from protobuf field <code>string label = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->label = $var;

        return $this;
    }

    /**
     * Optional. The action to perform when a user clicks the chip, such as
     * opening a hyperlink or running a custom function.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.OnClick on_click = 3;</code>
     * @return \Google\Apps\Card\V1\OnClick|null
     */
    public function getOnClick()
    {
        return $this->on_click;
    }

    public function hasOnClick()
    {
        return isset($this->on_click);
    }

    public function clearOnClick()
    {
        unset($this->on_click);
    }

    /**
     * Optional. The action to perform when a user clicks the chip, such as
     * opening a hyperlink or running a custom function.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.OnClick on_click = 3;</code>
     * @param \Google\Apps\Card\V1\OnClick $var
     * @return $this
     */
    public function setOnClick($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\OnClick::class);
        $this->on_click = $var;

        return $this;
    }

    /**
     * Whether the chip is in an active state and responds to user actions.
     * Defaults to `true`.
     * Deprecated. Use `disabled` instead.
     *
     * Generated from protobuf field <code>bool enabled = 4 [deprecated = true];</code>
     * @return bool
     * @deprecated
     */
    public function getEnabled()
    {
        if ($this->enabled !== false) {
            @trigger_error('enabled is deprecated.', E_USER_DEPRECATED);
        }
        return $this->enabled;
    }

    /**
     * Whether the chip is in an active state and responds to user actions.
     * Defaults to `true`.
     * Deprecated. Use `disabled` instead.
     *
     * Generated from protobuf field <code>bool enabled = 4 [deprecated = true];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setEnabled($var)
    {
        @trigger_error('enabled is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->enabled = $var;

        return $this;
    }

    /**
     * Whether the chip is in an inactive state and ignores user actions.
     * Defaults to `false`.
     *
     * Generated from protobuf field <code>bool disabled = 6;</code>
     * @return bool
     */
    public function getDisabled()
    {
        return $this->disabled;
    }

    /**
     * Whether the chip is in an inactive state and ignores user actions.
     * Defaults to `false`.
     *
     * Generated from protobuf field <code>bool disabled = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->disabled = $var;

        return $this;
    }

    /**
     * The alternative text that's used for accessibility.
     * Set descriptive text that lets users know what the chip does. For
     * example, if a chip opens a hyperlink, write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/workspace/chat".
     *
     * Generated from protobuf field <code>string alt_text = 5;</code>
     * @return string
     */
    public function getAltText()
    {
        return $this->alt_text;
    }

    /**
     * The alternative text that's used for accessibility.
     * Set descriptive text that lets users know what the chip does. For
     * example, if a chip opens a hyperlink, write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/workspace/chat".
     *
     * Generated from protobuf field <code>string alt_text = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setAltText($var)
    {
        GPBUtil::checkString($var, True);
        $this->alt_text = $var;

        return $this;
    }

}

