<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/chronicle/v1/data_access_control.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Chronicle\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Chronicle\V1\CreateDataAccessLabelRequest;
use Google\Cloud\Chronicle\V1\CreateDataAccessScopeRequest;
use Google\Cloud\Chronicle\V1\DataAccessLabel;
use Google\Cloud\Chronicle\V1\DataAccessScope;
use Google\Cloud\Chronicle\V1\DeleteDataAccessLabelRequest;
use Google\Cloud\Chronicle\V1\DeleteDataAccessScopeRequest;
use Google\Cloud\Chronicle\V1\GetDataAccessLabelRequest;
use Google\Cloud\Chronicle\V1\GetDataAccessScopeRequest;
use Google\Cloud\Chronicle\V1\ListDataAccessLabelsRequest;
use Google\Cloud\Chronicle\V1\ListDataAccessScopesRequest;
use Google\Cloud\Chronicle\V1\UpdateDataAccessLabelRequest;
use Google\Cloud\Chronicle\V1\UpdateDataAccessScopeRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: DataAccessControlService exposes resources and endpoints related to data
 * access control.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<DataAccessLabel> createDataAccessLabelAsync(CreateDataAccessLabelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataAccessScope> createDataAccessScopeAsync(CreateDataAccessScopeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteDataAccessLabelAsync(DeleteDataAccessLabelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteDataAccessScopeAsync(DeleteDataAccessScopeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataAccessLabel> getDataAccessLabelAsync(GetDataAccessLabelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataAccessScope> getDataAccessScopeAsync(GetDataAccessScopeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDataAccessLabelsAsync(ListDataAccessLabelsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDataAccessScopesAsync(ListDataAccessScopesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataAccessLabel> updateDataAccessLabelAsync(UpdateDataAccessLabelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DataAccessScope> updateDataAccessScopeAsync(UpdateDataAccessScopeRequest $request, array $optionalArgs = [])
 */
final class DataAccessControlServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.chronicle.v1.DataAccessControlService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'chronicle.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'chronicle.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/data_access_control_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/data_access_control_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/data_access_control_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ . '/../resources/data_access_control_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_access_label resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     * @param string $dataAccessLabel
     *
     * @return string The formatted data_access_label resource.
     */
    public static function dataAccessLabelName(
        string $project,
        string $location,
        string $instance,
        string $dataAccessLabel
    ): string {
        return self::getPathTemplate('dataAccessLabel')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
            'data_access_label' => $dataAccessLabel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_access_scope resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     * @param string $dataAccessScope
     *
     * @return string The formatted data_access_scope resource.
     */
    public static function dataAccessScopeName(
        string $project,
        string $location,
        string $instance,
        string $dataAccessScope
    ): string {
        return self::getPathTemplate('dataAccessScope')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
            'data_access_scope' => $dataAccessScope,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $location, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - dataAccessLabel: projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label}
     * - dataAccessScope: projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope}
     * - instance: projects/{project}/locations/{location}/instances/{instance}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'chronicle.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a data access label.
     * Data access labels are applied to incoming event data and selected in data
     * access scopes (another resource), and only users with scopes containing the
     * label can see data with that label. Currently, the data access label
     * resource only includes custom labels, which are labels that correspond
     * to UDM queries over event data.
     *
     * The async variant is
     * {@see DataAccessControlServiceClient::createDataAccessLabelAsync()} .
     *
     * @example samples/V1/DataAccessControlServiceClient/create_data_access_label.php
     *
     * @param CreateDataAccessLabelRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataAccessLabel
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDataAccessLabel(
        CreateDataAccessLabelRequest $request,
        array $callOptions = []
    ): DataAccessLabel {
        return $this->startApiCall('CreateDataAccessLabel', $request, $callOptions)->wait();
    }

    /**
     * Creates a data access scope.
     * Data access scope is a combination of allowed and denied labels attached
     * to a permission group. If a scope has allowed labels A and B and denied
     * labels C and D, then the group of people attached to the scope
     * will have permissions to see all events labeled with A or B (or both) and
     * not labeled with either C or D.
     *
     * The async variant is
     * {@see DataAccessControlServiceClient::createDataAccessScopeAsync()} .
     *
     * @example samples/V1/DataAccessControlServiceClient/create_data_access_scope.php
     *
     * @param CreateDataAccessScopeRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataAccessScope
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDataAccessScope(
        CreateDataAccessScopeRequest $request,
        array $callOptions = []
    ): DataAccessScope {
        return $this->startApiCall('CreateDataAccessScope', $request, $callOptions)->wait();
    }

    /**
     * Deletes a data access label. When a label is deleted, new
     * data that enters in the system will not receive the label, but the label
     * will not be removed from old data that still refers to it.
     *
     * The async variant is
     * {@see DataAccessControlServiceClient::deleteDataAccessLabelAsync()} .
     *
     * @example samples/V1/DataAccessControlServiceClient/delete_data_access_label.php
     *
     * @param DeleteDataAccessLabelRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDataAccessLabel(DeleteDataAccessLabelRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDataAccessLabel', $request, $callOptions)->wait();
    }

    /**
     * Deletes a data access scope.
     *
     * The async variant is
     * {@see DataAccessControlServiceClient::deleteDataAccessScopeAsync()} .
     *
     * @example samples/V1/DataAccessControlServiceClient/delete_data_access_scope.php
     *
     * @param DeleteDataAccessScopeRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDataAccessScope(DeleteDataAccessScopeRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDataAccessScope', $request, $callOptions)->wait();
    }

    /**
     * Gets a data access label.
     *
     * The async variant is
     * {@see DataAccessControlServiceClient::getDataAccessLabelAsync()} .
     *
     * @example samples/V1/DataAccessControlServiceClient/get_data_access_label.php
     *
     * @param GetDataAccessLabelRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataAccessLabel
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDataAccessLabel(GetDataAccessLabelRequest $request, array $callOptions = []): DataAccessLabel
    {
        return $this->startApiCall('GetDataAccessLabel', $request, $callOptions)->wait();
    }

    /**
     * Retrieves an existing data access scope.
     *
     * The async variant is
     * {@see DataAccessControlServiceClient::getDataAccessScopeAsync()} .
     *
     * @example samples/V1/DataAccessControlServiceClient/get_data_access_scope.php
     *
     * @param GetDataAccessScopeRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataAccessScope
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDataAccessScope(GetDataAccessScopeRequest $request, array $callOptions = []): DataAccessScope
    {
        return $this->startApiCall('GetDataAccessScope', $request, $callOptions)->wait();
    }

    /**
     * Lists all data access labels for the customer.
     *
     * The async variant is
     * {@see DataAccessControlServiceClient::listDataAccessLabelsAsync()} .
     *
     * @example samples/V1/DataAccessControlServiceClient/list_data_access_labels.php
     *
     * @param ListDataAccessLabelsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDataAccessLabels(
        ListDataAccessLabelsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDataAccessLabels', $request, $callOptions);
    }

    /**
     * Lists all existing data access scopes for the customer.
     *
     * The async variant is
     * {@see DataAccessControlServiceClient::listDataAccessScopesAsync()} .
     *
     * @example samples/V1/DataAccessControlServiceClient/list_data_access_scopes.php
     *
     * @param ListDataAccessScopesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDataAccessScopes(
        ListDataAccessScopesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDataAccessScopes', $request, $callOptions);
    }

    /**
     * Updates a data access label.
     *
     * The async variant is
     * {@see DataAccessControlServiceClient::updateDataAccessLabelAsync()} .
     *
     * @example samples/V1/DataAccessControlServiceClient/update_data_access_label.php
     *
     * @param UpdateDataAccessLabelRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataAccessLabel
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDataAccessLabel(
        UpdateDataAccessLabelRequest $request,
        array $callOptions = []
    ): DataAccessLabel {
        return $this->startApiCall('UpdateDataAccessLabel', $request, $callOptions)->wait();
    }

    /**
     * Updates a data access scope.
     *
     * The async variant is
     * {@see DataAccessControlServiceClient::updateDataAccessScopeAsync()} .
     *
     * @example samples/V1/DataAccessControlServiceClient/update_data_access_scope.php
     *
     * @param UpdateDataAccessScopeRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataAccessScope
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDataAccessScope(
        UpdateDataAccessScopeRequest $request,
        array $callOptions = []
    ): DataAccessScope {
        return $this->startApiCall('UpdateDataAccessScope', $request, $callOptions)->wait();
    }
}
