<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/v2/data.proto

namespace Google\Cloud\Bigtable\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A partial result set from the streaming query API.
 * Cloud Bigtable clients buffer partial results received in this message until
 * a `resume_token` is received.
 * The pseudocode below describes how to buffer and parse a stream of
 * `PartialResultSet` messages.
 * Having:
 * - queue of row results waiting to be returned `queue`
 * - extensible buffer of bytes `buffer`
 * - a place to keep track of the most recent `resume_token`
 * for each PartialResultSet `p` received {
 *   if p.reset {
 *     ensure `queue` is empty
 *     ensure `buffer` is empty
 *   }
 *   if p.estimated_batch_size != 0 {
 *     (optional) ensure `buffer` is sized to at least `p.estimated_batch_size`
 *   }
 *   if `p.proto_rows_batch` is set {
 *     append `p.proto_rows_batch.bytes` to `buffer`
 *   }
 *   if p.batch_checksum is set and `buffer` is not empty {
 *     validate the checksum matches the contents of `buffer`
 *     (see comments on `batch_checksum`)
 *     parse `buffer` as `ProtoRows` message, clearing `buffer`
 *     add parsed rows to end of `queue`
 *   }
 *   if p.resume_token is set {
 *     release results in `queue`
 *     save `p.resume_token` in `resume_token`
 *   }
 * }
 *
 * Generated from protobuf message <code>google.bigtable.v2.PartialResultSet</code>
 */
class PartialResultSet extends \Google\Protobuf\Internal\Message
{
    /**
     * CRC32C checksum of concatenated `partial_rows` data for the current batch.
     * When present, the buffered data from `partial_rows` forms a complete
     * parseable message of the appropriate type.
     * The client should mark the end of a parseable message and prepare to
     * receive a new one starting from the next `PartialResultSet` message.
     * Clients must verify the checksum of the serialized batch before yielding it
     * to the caller.
     * This does NOT mean the values can be yielded to the callers since a
     * `resume_token` is required to safely do so.
     * If `resume_token` is non-empty and any data has been received since the
     * last one, this field is guaranteed to be non-empty. In other words, clients
     * may assume that a batch will never cross a `resume_token` boundary.
     *
     * Generated from protobuf field <code>optional uint32 batch_checksum = 6;</code>
     */
    protected $batch_checksum = null;
    /**
     * An opaque token sent by the server to allow query resumption and signal
     * that the buffered values constructed from received `partial_rows` can be
     * yielded to the caller. Clients can provide this token in a subsequent
     * request to resume the result stream from the current point.
     * When `resume_token` is non-empty, the buffered values received from
     * `partial_rows` since the last non-empty `resume_token` can be yielded to
     * the callers, provided that the client keeps the value of `resume_token` and
     * uses it on subsequent retries.
     * A `resume_token` may be sent without information in `partial_rows` to
     * checkpoint the progress of a sparse query. Any previous `partial_rows` data
     * should still be yielded in this case, and the new `resume_token` should be
     * saved for future retries as normal.
     * A `resume_token` will only be sent on a boundary where there is either no
     * ongoing result batch, or `batch_checksum` is also populated.
     * The server will also send a sentinel `resume_token` when last batch of
     * `partial_rows` is sent. If the client retries the ExecuteQueryRequest with
     * the sentinel `resume_token`, the server will emit it again without any
     * data in `partial_rows`, then return OK.
     *
     * Generated from protobuf field <code>bytes resume_token = 5;</code>
     */
    protected $resume_token = '';
    /**
     * If `true`, any data buffered since the last non-empty `resume_token` must
     * be discarded before the other parts of this message, if any, are handled.
     *
     * Generated from protobuf field <code>bool reset = 7;</code>
     */
    protected $reset = false;
    /**
     * Estimated size of the buffer required to hold the next batch of results.
     * This value will be sent with the first `partial_rows` of a batch. That is,
     * on the first `partial_rows` received in a stream, on the first message
     * after a `batch_checksum` message, and any time `reset` is true.
     * The client can use this estimate to allocate a buffer for the next batch of
     * results. This helps minimize the number of allocations required, though the
     * buffer size may still need to be increased if the estimate is too low.
     *
     * Generated from protobuf field <code>int32 estimated_batch_size = 4;</code>
     */
    protected $estimated_batch_size = 0;
    protected $partial_rows;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Bigtable\V2\ProtoRowsBatch $proto_rows_batch
     *           Partial rows in serialized ProtoRows format.
     *     @type int $batch_checksum
     *           CRC32C checksum of concatenated `partial_rows` data for the current batch.
     *           When present, the buffered data from `partial_rows` forms a complete
     *           parseable message of the appropriate type.
     *           The client should mark the end of a parseable message and prepare to
     *           receive a new one starting from the next `PartialResultSet` message.
     *           Clients must verify the checksum of the serialized batch before yielding it
     *           to the caller.
     *           This does NOT mean the values can be yielded to the callers since a
     *           `resume_token` is required to safely do so.
     *           If `resume_token` is non-empty and any data has been received since the
     *           last one, this field is guaranteed to be non-empty. In other words, clients
     *           may assume that a batch will never cross a `resume_token` boundary.
     *     @type string $resume_token
     *           An opaque token sent by the server to allow query resumption and signal
     *           that the buffered values constructed from received `partial_rows` can be
     *           yielded to the caller. Clients can provide this token in a subsequent
     *           request to resume the result stream from the current point.
     *           When `resume_token` is non-empty, the buffered values received from
     *           `partial_rows` since the last non-empty `resume_token` can be yielded to
     *           the callers, provided that the client keeps the value of `resume_token` and
     *           uses it on subsequent retries.
     *           A `resume_token` may be sent without information in `partial_rows` to
     *           checkpoint the progress of a sparse query. Any previous `partial_rows` data
     *           should still be yielded in this case, and the new `resume_token` should be
     *           saved for future retries as normal.
     *           A `resume_token` will only be sent on a boundary where there is either no
     *           ongoing result batch, or `batch_checksum` is also populated.
     *           The server will also send a sentinel `resume_token` when last batch of
     *           `partial_rows` is sent. If the client retries the ExecuteQueryRequest with
     *           the sentinel `resume_token`, the server will emit it again without any
     *           data in `partial_rows`, then return OK.
     *     @type bool $reset
     *           If `true`, any data buffered since the last non-empty `resume_token` must
     *           be discarded before the other parts of this message, if any, are handled.
     *     @type int $estimated_batch_size
     *           Estimated size of the buffer required to hold the next batch of results.
     *           This value will be sent with the first `partial_rows` of a batch. That is,
     *           on the first `partial_rows` received in a stream, on the first message
     *           after a `batch_checksum` message, and any time `reset` is true.
     *           The client can use this estimate to allocate a buffer for the next batch of
     *           results. This helps minimize the number of allocations required, though the
     *           buffer size may still need to be increased if the estimate is too low.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\V2\Data::initOnce();
        parent::__construct($data);
    }

    /**
     * Partial rows in serialized ProtoRows format.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.ProtoRowsBatch proto_rows_batch = 3;</code>
     * @return \Google\Cloud\Bigtable\V2\ProtoRowsBatch|null
     */
    public function getProtoRowsBatch()
    {
        return $this->readOneof(3);
    }

    public function hasProtoRowsBatch()
    {
        return $this->hasOneof(3);
    }

    /**
     * Partial rows in serialized ProtoRows format.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.ProtoRowsBatch proto_rows_batch = 3;</code>
     * @param \Google\Cloud\Bigtable\V2\ProtoRowsBatch $var
     * @return $this
     */
    public function setProtoRowsBatch($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Bigtable\V2\ProtoRowsBatch::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * CRC32C checksum of concatenated `partial_rows` data for the current batch.
     * When present, the buffered data from `partial_rows` forms a complete
     * parseable message of the appropriate type.
     * The client should mark the end of a parseable message and prepare to
     * receive a new one starting from the next `PartialResultSet` message.
     * Clients must verify the checksum of the serialized batch before yielding it
     * to the caller.
     * This does NOT mean the values can be yielded to the callers since a
     * `resume_token` is required to safely do so.
     * If `resume_token` is non-empty and any data has been received since the
     * last one, this field is guaranteed to be non-empty. In other words, clients
     * may assume that a batch will never cross a `resume_token` boundary.
     *
     * Generated from protobuf field <code>optional uint32 batch_checksum = 6;</code>
     * @return int
     */
    public function getBatchChecksum()
    {
        return isset($this->batch_checksum) ? $this->batch_checksum : 0;
    }

    public function hasBatchChecksum()
    {
        return isset($this->batch_checksum);
    }

    public function clearBatchChecksum()
    {
        unset($this->batch_checksum);
    }

    /**
     * CRC32C checksum of concatenated `partial_rows` data for the current batch.
     * When present, the buffered data from `partial_rows` forms a complete
     * parseable message of the appropriate type.
     * The client should mark the end of a parseable message and prepare to
     * receive a new one starting from the next `PartialResultSet` message.
     * Clients must verify the checksum of the serialized batch before yielding it
     * to the caller.
     * This does NOT mean the values can be yielded to the callers since a
     * `resume_token` is required to safely do so.
     * If `resume_token` is non-empty and any data has been received since the
     * last one, this field is guaranteed to be non-empty. In other words, clients
     * may assume that a batch will never cross a `resume_token` boundary.
     *
     * Generated from protobuf field <code>optional uint32 batch_checksum = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setBatchChecksum($var)
    {
        GPBUtil::checkUint32($var);
        $this->batch_checksum = $var;

        return $this;
    }

    /**
     * An opaque token sent by the server to allow query resumption and signal
     * that the buffered values constructed from received `partial_rows` can be
     * yielded to the caller. Clients can provide this token in a subsequent
     * request to resume the result stream from the current point.
     * When `resume_token` is non-empty, the buffered values received from
     * `partial_rows` since the last non-empty `resume_token` can be yielded to
     * the callers, provided that the client keeps the value of `resume_token` and
     * uses it on subsequent retries.
     * A `resume_token` may be sent without information in `partial_rows` to
     * checkpoint the progress of a sparse query. Any previous `partial_rows` data
     * should still be yielded in this case, and the new `resume_token` should be
     * saved for future retries as normal.
     * A `resume_token` will only be sent on a boundary where there is either no
     * ongoing result batch, or `batch_checksum` is also populated.
     * The server will also send a sentinel `resume_token` when last batch of
     * `partial_rows` is sent. If the client retries the ExecuteQueryRequest with
     * the sentinel `resume_token`, the server will emit it again without any
     * data in `partial_rows`, then return OK.
     *
     * Generated from protobuf field <code>bytes resume_token = 5;</code>
     * @return string
     */
    public function getResumeToken()
    {
        return $this->resume_token;
    }

    /**
     * An opaque token sent by the server to allow query resumption and signal
     * that the buffered values constructed from received `partial_rows` can be
     * yielded to the caller. Clients can provide this token in a subsequent
     * request to resume the result stream from the current point.
     * When `resume_token` is non-empty, the buffered values received from
     * `partial_rows` since the last non-empty `resume_token` can be yielded to
     * the callers, provided that the client keeps the value of `resume_token` and
     * uses it on subsequent retries.
     * A `resume_token` may be sent without information in `partial_rows` to
     * checkpoint the progress of a sparse query. Any previous `partial_rows` data
     * should still be yielded in this case, and the new `resume_token` should be
     * saved for future retries as normal.
     * A `resume_token` will only be sent on a boundary where there is either no
     * ongoing result batch, or `batch_checksum` is also populated.
     * The server will also send a sentinel `resume_token` when last batch of
     * `partial_rows` is sent. If the client retries the ExecuteQueryRequest with
     * the sentinel `resume_token`, the server will emit it again without any
     * data in `partial_rows`, then return OK.
     *
     * Generated from protobuf field <code>bytes resume_token = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setResumeToken($var)
    {
        GPBUtil::checkString($var, False);
        $this->resume_token = $var;

        return $this;
    }

    /**
     * If `true`, any data buffered since the last non-empty `resume_token` must
     * be discarded before the other parts of this message, if any, are handled.
     *
     * Generated from protobuf field <code>bool reset = 7;</code>
     * @return bool
     */
    public function getReset()
    {
        return $this->reset;
    }

    /**
     * If `true`, any data buffered since the last non-empty `resume_token` must
     * be discarded before the other parts of this message, if any, are handled.
     *
     * Generated from protobuf field <code>bool reset = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setReset($var)
    {
        GPBUtil::checkBool($var);
        $this->reset = $var;

        return $this;
    }

    /**
     * Estimated size of the buffer required to hold the next batch of results.
     * This value will be sent with the first `partial_rows` of a batch. That is,
     * on the first `partial_rows` received in a stream, on the first message
     * after a `batch_checksum` message, and any time `reset` is true.
     * The client can use this estimate to allocate a buffer for the next batch of
     * results. This helps minimize the number of allocations required, though the
     * buffer size may still need to be increased if the estimate is too low.
     *
     * Generated from protobuf field <code>int32 estimated_batch_size = 4;</code>
     * @return int
     */
    public function getEstimatedBatchSize()
    {
        return $this->estimated_batch_size;
    }

    /**
     * Estimated size of the buffer required to hold the next batch of results.
     * This value will be sent with the first `partial_rows` of a batch. That is,
     * on the first `partial_rows` received in a stream, on the first message
     * after a `batch_checksum` message, and any time `reset` is true.
     * The client can use this estimate to allocate a buffer for the next batch of
     * results. This helps minimize the number of allocations required, though the
     * buffer size may still need to be increased if the estimate is too low.
     *
     * Generated from protobuf field <code>int32 estimated_batch_size = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setEstimatedBatchSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->estimated_batch_size = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getPartialRows()
    {
        return $this->whichOneof("partial_rows");
    }

}

