<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/asset/v1/asset_service.proto

namespace Google\Cloud\Asset\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Search all IAM policies request.
 *
 * Generated from protobuf message <code>google.cloud.asset.v1.SearchAllIamPoliciesRequest</code>
 */
class SearchAllIamPoliciesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. A scope can be a project, a folder or an organization. The search
     * is limited to the IAM policies within the `scope`.
     * The allowed values are:
     * * projects/{PROJECT_ID}
     * * projects/{PROJECT_NUMBER}
     * * folders/{FOLDER_NUMBER}
     * * organizations/{ORGANIZATION_NUMBER}
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $scope = '';
    /**
     * Optional. The query statement. An empty query can be specified to search
     * all the IAM policies within the given `scope`.
     * Examples:
     * * `policy : "amy&#64;gmail.com"` to find Cloud IAM policy bindings that
     *   specify user "amy&#64;gmail.com".
     * * `policy : "roles/compute.admin"` to find Cloud IAM policy bindings that
     *   specify the Compute Admin role.
     * * `policy.role.permissions : "storage.buckets.update"` to find Cloud IAM
     *   policy bindings that specify a role containing "storage.buckets.update"
     *   permission.
     * * `resource : "organizations/123"` to find Cloud IAM policy bindings that
     *   are set on "organizations/123".
     * * `(resource : ("organizations/123" OR "folders/1234") AND policy : "amy")`
     *   to find Cloud IAM policy bindings that are set on "organizations/123" or
     *   "folders/1234", and also specify user "amy".
     * See [how to construct a
     * query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
     * for more details.
     *
     * Generated from protobuf field <code>string query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $query = '';
    /**
     * Optional. The page size for search result pagination. Page size is capped
     * at 500 even if a larger value is given. If set to zero, server will pick an
     * appropriate default. Returned results may be fewer than requested. When
     * this happens, there could be more results as long as `next_page_token` is
     * returned.
     *
     * Generated from protobuf field <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $page_size = 0;
    /**
     * Optional. If present, retrieve the next batch of results from the preceding
     * call to this method. `page_token` must be the value of `next_page_token`
     * from the previous response. The values of all other method parameters must
     * be identical to those in the previous call.
     *
     * Generated from protobuf field <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $page_token = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $scope
     *           Required. A scope can be a project, a folder or an organization. The search
     *           is limited to the IAM policies within the `scope`.
     *           The allowed values are:
     *           * projects/{PROJECT_ID}
     *           * projects/{PROJECT_NUMBER}
     *           * folders/{FOLDER_NUMBER}
     *           * organizations/{ORGANIZATION_NUMBER}
     *     @type string $query
     *           Optional. The query statement. An empty query can be specified to search
     *           all the IAM policies within the given `scope`.
     *           Examples:
     *           * `policy : "amy&#64;gmail.com"` to find Cloud IAM policy bindings that
     *             specify user "amy&#64;gmail.com".
     *           * `policy : "roles/compute.admin"` to find Cloud IAM policy bindings that
     *             specify the Compute Admin role.
     *           * `policy.role.permissions : "storage.buckets.update"` to find Cloud IAM
     *             policy bindings that specify a role containing "storage.buckets.update"
     *             permission.
     *           * `resource : "organizations/123"` to find Cloud IAM policy bindings that
     *             are set on "organizations/123".
     *           * `(resource : ("organizations/123" OR "folders/1234") AND policy : "amy")`
     *             to find Cloud IAM policy bindings that are set on "organizations/123" or
     *             "folders/1234", and also specify user "amy".
     *           See [how to construct a
     *           query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
     *           for more details.
     *     @type int $page_size
     *           Optional. The page size for search result pagination. Page size is capped
     *           at 500 even if a larger value is given. If set to zero, server will pick an
     *           appropriate default. Returned results may be fewer than requested. When
     *           this happens, there could be more results as long as `next_page_token` is
     *           returned.
     *     @type string $page_token
     *           Optional. If present, retrieve the next batch of results from the preceding
     *           call to this method. `page_token` must be the value of `next_page_token`
     *           from the previous response. The values of all other method parameters must
     *           be identical to those in the previous call.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Asset\V1\AssetService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. A scope can be a project, a folder or an organization. The search
     * is limited to the IAM policies within the `scope`.
     * The allowed values are:
     * * projects/{PROJECT_ID}
     * * projects/{PROJECT_NUMBER}
     * * folders/{FOLDER_NUMBER}
     * * organizations/{ORGANIZATION_NUMBER}
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Required. A scope can be a project, a folder or an organization. The search
     * is limited to the IAM policies within the `scope`.
     * The allowed values are:
     * * projects/{PROJECT_ID}
     * * projects/{PROJECT_NUMBER}
     * * folders/{FOLDER_NUMBER}
     * * organizations/{ORGANIZATION_NUMBER}
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkString($var, True);
        $this->scope = $var;

        return $this;
    }

    /**
     * Optional. The query statement. An empty query can be specified to search
     * all the IAM policies within the given `scope`.
     * Examples:
     * * `policy : "amy&#64;gmail.com"` to find Cloud IAM policy bindings that
     *   specify user "amy&#64;gmail.com".
     * * `policy : "roles/compute.admin"` to find Cloud IAM policy bindings that
     *   specify the Compute Admin role.
     * * `policy.role.permissions : "storage.buckets.update"` to find Cloud IAM
     *   policy bindings that specify a role containing "storage.buckets.update"
     *   permission.
     * * `resource : "organizations/123"` to find Cloud IAM policy bindings that
     *   are set on "organizations/123".
     * * `(resource : ("organizations/123" OR "folders/1234") AND policy : "amy")`
     *   to find Cloud IAM policy bindings that are set on "organizations/123" or
     *   "folders/1234", and also specify user "amy".
     * See [how to construct a
     * query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
     * for more details.
     *
     * Generated from protobuf field <code>string query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Optional. The query statement. An empty query can be specified to search
     * all the IAM policies within the given `scope`.
     * Examples:
     * * `policy : "amy&#64;gmail.com"` to find Cloud IAM policy bindings that
     *   specify user "amy&#64;gmail.com".
     * * `policy : "roles/compute.admin"` to find Cloud IAM policy bindings that
     *   specify the Compute Admin role.
     * * `policy.role.permissions : "storage.buckets.update"` to find Cloud IAM
     *   policy bindings that specify a role containing "storage.buckets.update"
     *   permission.
     * * `resource : "organizations/123"` to find Cloud IAM policy bindings that
     *   are set on "organizations/123".
     * * `(resource : ("organizations/123" OR "folders/1234") AND policy : "amy")`
     *   to find Cloud IAM policy bindings that are set on "organizations/123" or
     *   "folders/1234", and also specify user "amy".
     * See [how to construct a
     * query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
     * for more details.
     *
     * Generated from protobuf field <code>string query = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * Optional. The page size for search result pagination. Page size is capped
     * at 500 even if a larger value is given. If set to zero, server will pick an
     * appropriate default. Returned results may be fewer than requested. When
     * this happens, there could be more results as long as `next_page_token` is
     * returned.
     *
     * Generated from protobuf field <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Optional. The page size for search result pagination. Page size is capped
     * at 500 even if a larger value is given. If set to zero, server will pick an
     * appropriate default. Returned results may be fewer than requested. When
     * this happens, there could be more results as long as `next_page_token` is
     * returned.
     *
     * Generated from protobuf field <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Optional. If present, retrieve the next batch of results from the preceding
     * call to this method. `page_token` must be the value of `next_page_token`
     * from the previous response. The values of all other method parameters must
     * be identical to those in the previous call.
     *
     * Generated from protobuf field <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * Optional. If present, retrieve the next batch of results from the preceding
     * call to this method. `page_token` must be the value of `next_page_token`
     * from the previous response. The values of all other method parameters must
     * be identical to those in the previous call.
     *
     * Generated from protobuf field <code>string page_token = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

}

