<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/talent/v4beta1/tenant.proto

namespace Google\Cloud\Talent\V4beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Tenant resource represents a tenant in the service. A tenant is a group or
 * entity that shares common access with specific privileges for resources like
 * profiles. Customer may create multiple tenants to provide data isolation for
 * different groups.
 *
 * Generated from protobuf message <code>google.cloud.talent.v4beta1.Tenant</code>
 */
class Tenant extends \Google\Protobuf\Internal\Message
{
    /**
     * Required during tenant update.
     * The resource name for a tenant. This is generated by the service when a
     * tenant is created.
     * The format is "projects/{project_id}/tenants/{tenant_id}", for example,
     * "projects/foo/tenants/bar".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Required. Client side tenant identifier, used to uniquely identify the tenant.
     * The maximum number of allowed characters is 255.
     *
     * Generated from protobuf field <code>string external_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $external_id = '';
    /**
     * Indicates whether data owned by this tenant may be used to provide product
     * improvements across other tenants.
     * Defaults behavior is [DataUsageType.ISOLATED][google.cloud.talent.v4beta1.Tenant.DataUsageType.ISOLATED] if it's unset.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.Tenant.DataUsageType usage_type = 3;</code>
     */
    private $usage_type = 0;
    /**
     * A list of keys of filterable [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes], whose
     * corresponding `string_values` are used in keyword searches. Profiles with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and must be surrounded by quotes.
     *
     * Generated from protobuf field <code>repeated string keyword_searchable_profile_custom_attributes = 4;</code>
     */
    private $keyword_searchable_profile_custom_attributes;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required during tenant update.
     *           The resource name for a tenant. This is generated by the service when a
     *           tenant is created.
     *           The format is "projects/{project_id}/tenants/{tenant_id}", for example,
     *           "projects/foo/tenants/bar".
     *     @type string $external_id
     *           Required. Client side tenant identifier, used to uniquely identify the tenant.
     *           The maximum number of allowed characters is 255.
     *     @type int $usage_type
     *           Indicates whether data owned by this tenant may be used to provide product
     *           improvements across other tenants.
     *           Defaults behavior is [DataUsageType.ISOLATED][google.cloud.talent.v4beta1.Tenant.DataUsageType.ISOLATED] if it's unset.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $keyword_searchable_profile_custom_attributes
     *           A list of keys of filterable [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes], whose
     *           corresponding `string_values` are used in keyword searches. Profiles with
     *           `string_values` under these specified field keys are returned if any
     *           of the values match the search keyword. Custom field values with
     *           parenthesis, brackets and special symbols are not searchable as-is,
     *           and must be surrounded by quotes.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Talent\V4Beta1\Tenant::initOnce();
        parent::__construct($data);
    }

    /**
     * Required during tenant update.
     * The resource name for a tenant. This is generated by the service when a
     * tenant is created.
     * The format is "projects/{project_id}/tenants/{tenant_id}", for example,
     * "projects/foo/tenants/bar".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required during tenant update.
     * The resource name for a tenant. This is generated by the service when a
     * tenant is created.
     * The format is "projects/{project_id}/tenants/{tenant_id}", for example,
     * "projects/foo/tenants/bar".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Client side tenant identifier, used to uniquely identify the tenant.
     * The maximum number of allowed characters is 255.
     *
     * Generated from protobuf field <code>string external_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getExternalId()
    {
        return $this->external_id;
    }

    /**
     * Required. Client side tenant identifier, used to uniquely identify the tenant.
     * The maximum number of allowed characters is 255.
     *
     * Generated from protobuf field <code>string external_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setExternalId($var)
    {
        GPBUtil::checkString($var, True);
        $this->external_id = $var;

        return $this;
    }

    /**
     * Indicates whether data owned by this tenant may be used to provide product
     * improvements across other tenants.
     * Defaults behavior is [DataUsageType.ISOLATED][google.cloud.talent.v4beta1.Tenant.DataUsageType.ISOLATED] if it's unset.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.Tenant.DataUsageType usage_type = 3;</code>
     * @return int
     */
    public function getUsageType()
    {
        return $this->usage_type;
    }

    /**
     * Indicates whether data owned by this tenant may be used to provide product
     * improvements across other tenants.
     * Defaults behavior is [DataUsageType.ISOLATED][google.cloud.talent.v4beta1.Tenant.DataUsageType.ISOLATED] if it's unset.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.Tenant.DataUsageType usage_type = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setUsageType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Talent\V4beta1\Tenant\DataUsageType::class);
        $this->usage_type = $var;

        return $this;
    }

    /**
     * A list of keys of filterable [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes], whose
     * corresponding `string_values` are used in keyword searches. Profiles with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and must be surrounded by quotes.
     *
     * Generated from protobuf field <code>repeated string keyword_searchable_profile_custom_attributes = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getKeywordSearchableProfileCustomAttributes()
    {
        return $this->keyword_searchable_profile_custom_attributes;
    }

    /**
     * A list of keys of filterable [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes], whose
     * corresponding `string_values` are used in keyword searches. Profiles with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and must be surrounded by quotes.
     *
     * Generated from protobuf field <code>repeated string keyword_searchable_profile_custom_attributes = 4;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setKeywordSearchableProfileCustomAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->keyword_searchable_profile_custom_attributes = $arr;

        return $this;
    }

}

