<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/batch_prediction_job.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A job that uses a [Model][google.cloud.aiplatform.v1.BatchPredictionJob.model] to produce predictions
 * on multiple [input instances][google.cloud.aiplatform.v1.BatchPredictionJob.input_config]. If
 * predictions for significant portion of the instances fail, the job may finish
 * without attempting predictions for all remaining instances.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.BatchPredictionJob</code>
 */
class BatchPredictionJob extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Resource name of the BatchPredictionJob.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Required. The user-defined name of this BatchPredictionJob.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $display_name = '';
    /**
     * The name of the Model resource that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * Exactly one of model and unmanaged_container_model must be set.
     * The model resource name may contain version id or version alias to specify
     * the version, if no version is specified, the default version will be used.
     *
     * Generated from protobuf field <code>string model = 3 [(.google.api.resource_reference) = {</code>
     */
    private $model = '';
    /**
     * Output only. The version ID of the Model that produces the predictions via this job.
     *
     * Generated from protobuf field <code>string model_version_id = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $model_version_id = '';
    /**
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.UnmanagedContainerModel unmanaged_container_model = 28;</code>
     */
    private $unmanaged_container_model = null;
    /**
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $input_config = null;
    /**
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri].
     *
     * Generated from protobuf field <code>.google.protobuf.Value model_parameters = 5;</code>
     */
    private $model_parameters = null;
    /**
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $output_config = null;
    /**
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchDedicatedResources dedicated_resources = 7;</code>
     */
    private $dedicated_resources = null;
    /**
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $manual_batch_tuning_parameters = null;
    /**
     * Generate explanation with the batch prediction results.
     * When set to `true`, the batch prediction output changes based on the
     * `predictions_format` field of the
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config] object:
     *  * `bigquery`: output includes a column named `explanation`. The value
     *    is a struct that conforms to the [Explanation][google.cloud.aiplatform.v1.Explanation] object.
     *  * `jsonl`: The JSON objects on each line include an additional entry
     *    keyed `explanation`. The value of the entry is a JSON object that
     *    conforms to the [Explanation][google.cloud.aiplatform.v1.Explanation] object.
     *  * `csv`: Generating explanations for CSV format is not supported.
     * If this field is set to true, either the [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] must be populated.
     *
     * Generated from protobuf field <code>bool generate_explanation = 23;</code>
     */
    private $generate_explanation = false;
    /**
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] object is inherited.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 25;</code>
     */
    private $explanation_spec = null;
    /**
     * Output only. Information further describing the output of this job.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $output_info = null;
    /**
     * Output only. The detailed state of the job.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $error = null;
    /**
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     *
     * Generated from protobuf field <code>repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $partial_failures;
    /**
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $resources_consumed = null;
    /**
     * Output only. Statistics on completed and failed prediction instances.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $completion_stats = null;
    /**
     * Output only. Time when the BatchPredictionJob was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $start_time = null;
    /**
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $end_time = null;
    /**
     * Output only. Time when the BatchPredictionJob was most recently updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 19;</code>
     */
    private $labels;
    /**
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     */
    private $encryption_spec = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Resource name of the BatchPredictionJob.
     *     @type string $display_name
     *           Required. The user-defined name of this BatchPredictionJob.
     *     @type string $model
     *           The name of the Model resource that produces the predictions via this job,
     *           must share the same ancestor Location.
     *           Starting this job has no impact on any existing deployments of the Model
     *           and their resources.
     *           Exactly one of model and unmanaged_container_model must be set.
     *           The model resource name may contain version id or version alias to specify
     *           the version, if no version is specified, the default version will be used.
     *     @type string $model_version_id
     *           Output only. The version ID of the Model that produces the predictions via this job.
     *     @type \Google\Cloud\AIPlatform\V1\UnmanagedContainerModel $unmanaged_container_model
     *           Contains model information necessary to perform batch prediction without
     *           requiring uploading to model registry.
     *           Exactly one of model and unmanaged_container_model must be set.
     *     @type \Google\Cloud\AIPlatform\V1\BatchPredictionJob\InputConfig $input_config
     *           Required. Input configuration of the instances on which predictions are performed.
     *           The schema of any single instance may be specified via
     *           the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     *           [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     *           [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     *     @type \Google\Protobuf\Value $model_parameters
     *           The parameters that govern the predictions. The schema of the parameters
     *           may be specified via the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     *           [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     *           [parameters_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri].
     *     @type \Google\Cloud\AIPlatform\V1\BatchPredictionJob\OutputConfig $output_config
     *           Required. The Configuration specifying where output predictions should
     *           be written.
     *           The schema of any single prediction may be specified as a concatenation
     *           of [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     *           [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     *           [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     *           and
     *           [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     *     @type \Google\Cloud\AIPlatform\V1\BatchDedicatedResources $dedicated_resources
     *           The config of resources used by the Model during the batch prediction. If
     *           the Model [supports][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types]
     *           DEDICATED_RESOURCES this config may be provided (and the job will use these
     *           resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     *           must be provided.
     *     @type \Google\Cloud\AIPlatform\V1\ManualBatchTuningParameters $manual_batch_tuning_parameters
     *           Immutable. Parameters configuring the batch behavior. Currently only applicable when
     *           [dedicated_resources][google.cloud.aiplatform.v1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     *           the tuning itself).
     *     @type bool $generate_explanation
     *           Generate explanation with the batch prediction results.
     *           When set to `true`, the batch prediction output changes based on the
     *           `predictions_format` field of the
     *           [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config] object:
     *            * `bigquery`: output includes a column named `explanation`. The value
     *              is a struct that conforms to the [Explanation][google.cloud.aiplatform.v1.Explanation] object.
     *            * `jsonl`: The JSON objects on each line include an additional entry
     *              keyed `explanation`. The value of the entry is a JSON object that
     *              conforms to the [Explanation][google.cloud.aiplatform.v1.Explanation] object.
     *            * `csv`: Generating explanations for CSV format is not supported.
     *           If this field is set to true, either the [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] or
     *           [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] must be populated.
     *     @type \Google\Cloud\AIPlatform\V1\ExplanationSpec $explanation_spec
     *           Explanation configuration for this BatchPredictionJob. Can be
     *           specified only if [generate_explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation] is set to `true`.
     *           This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     *           [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     *           [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     *           the [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] object is inherited.
     *     @type \Google\Cloud\AIPlatform\V1\BatchPredictionJob\OutputInfo $output_info
     *           Output only. Information further describing the output of this job.
     *     @type int $state
     *           Output only. The detailed state of the job.
     *     @type \Google\Rpc\Status $error
     *           Output only. Only populated when the job's state is JOB_STATE_FAILED or
     *           JOB_STATE_CANCELLED.
     *     @type array<\Google\Rpc\Status>|\Google\Protobuf\Internal\RepeatedField $partial_failures
     *           Output only. Partial failures encountered.
     *           For example, single files that can't be read.
     *           This field never exceeds 20 entries.
     *           Status details fields contain standard GCP error details.
     *     @type \Google\Cloud\AIPlatform\V1\ResourcesConsumed $resources_consumed
     *           Output only. Information about resources that had been consumed by this job.
     *           Provided in real time at best effort basis, as well as a final value
     *           once the job completes.
     *           Note: This field currently may be not populated for batch predictions that
     *           use AutoML Models.
     *     @type \Google\Cloud\AIPlatform\V1\CompletionStats $completion_stats
     *           Output only. Statistics on completed and failed prediction instances.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Time when the BatchPredictionJob was created.
     *     @type \Google\Protobuf\Timestamp $start_time
     *           Output only. Time when the BatchPredictionJob for the first time entered the
     *           `JOB_STATE_RUNNING` state.
     *     @type \Google\Protobuf\Timestamp $end_time
     *           Output only. Time when the BatchPredictionJob entered any of the following states:
     *           `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Time when the BatchPredictionJob was most recently updated.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The labels with user-defined metadata to organize BatchPredictionJobs.
     *           Label keys and values can be no longer than 64 characters
     *           (Unicode codepoints), can only contain lowercase letters, numeric
     *           characters, underscores and dashes. International characters are allowed.
     *           See https://goo.gl/xmQnxf for more information and examples of labels.
     *     @type \Google\Cloud\AIPlatform\V1\EncryptionSpec $encryption_spec
     *           Customer-managed encryption key options for a BatchPredictionJob. If this
     *           is set, then all resources created by the BatchPredictionJob will be
     *           encrypted with the provided encryption key.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\BatchPredictionJob::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Resource name of the BatchPredictionJob.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Resource name of the BatchPredictionJob.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The user-defined name of this BatchPredictionJob.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The user-defined name of this BatchPredictionJob.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The name of the Model resource that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * Exactly one of model and unmanaged_container_model must be set.
     * The model resource name may contain version id or version alias to specify
     * the version, if no version is specified, the default version will be used.
     *
     * Generated from protobuf field <code>string model = 3 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getModel()
    {
        return $this->model;
    }

    /**
     * The name of the Model resource that produces the predictions via this job,
     * must share the same ancestor Location.
     * Starting this job has no impact on any existing deployments of the Model
     * and their resources.
     * Exactly one of model and unmanaged_container_model must be set.
     * The model resource name may contain version id or version alias to specify
     * the version, if no version is specified, the default version will be used.
     *
     * Generated from protobuf field <code>string model = 3 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setModel($var)
    {
        GPBUtil::checkString($var, True);
        $this->model = $var;

        return $this;
    }

    /**
     * Output only. The version ID of the Model that produces the predictions via this job.
     *
     * Generated from protobuf field <code>string model_version_id = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getModelVersionId()
    {
        return $this->model_version_id;
    }

    /**
     * Output only. The version ID of the Model that produces the predictions via this job.
     *
     * Generated from protobuf field <code>string model_version_id = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setModelVersionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->model_version_id = $var;

        return $this;
    }

    /**
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.UnmanagedContainerModel unmanaged_container_model = 28;</code>
     * @return \Google\Cloud\AIPlatform\V1\UnmanagedContainerModel|null
     */
    public function getUnmanagedContainerModel()
    {
        return $this->unmanaged_container_model;
    }

    public function hasUnmanagedContainerModel()
    {
        return isset($this->unmanaged_container_model);
    }

    public function clearUnmanagedContainerModel()
    {
        unset($this->unmanaged_container_model);
    }

    /**
     * Contains model information necessary to perform batch prediction without
     * requiring uploading to model registry.
     * Exactly one of model and unmanaged_container_model must be set.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.UnmanagedContainerModel unmanaged_container_model = 28;</code>
     * @param \Google\Cloud\AIPlatform\V1\UnmanagedContainerModel $var
     * @return $this
     */
    public function setUnmanagedContainerModel($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\UnmanagedContainerModel::class);
        $this->unmanaged_container_model = $var;

        return $this;
    }

    /**
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\AIPlatform\V1\BatchPredictionJob\InputConfig|null
     */
    public function getInputConfig()
    {
        return $this->input_config;
    }

    public function hasInputConfig()
    {
        return isset($this->input_config);
    }

    public function clearInputConfig()
    {
        unset($this->input_config);
    }

    /**
     * Required. Input configuration of the instances on which predictions are performed.
     * The schema of any single instance may be specified via
     * the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig input_config = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\AIPlatform\V1\BatchPredictionJob\InputConfig $var
     * @return $this
     */
    public function setInputConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\BatchPredictionJob\InputConfig::class);
        $this->input_config = $var;

        return $this;
    }

    /**
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri].
     *
     * Generated from protobuf field <code>.google.protobuf.Value model_parameters = 5;</code>
     * @return \Google\Protobuf\Value|null
     */
    public function getModelParameters()
    {
        return $this->model_parameters;
    }

    public function hasModelParameters()
    {
        return isset($this->model_parameters);
    }

    public function clearModelParameters()
    {
        unset($this->model_parameters);
    }

    /**
     * The parameters that govern the predictions. The schema of the parameters
     * may be specified via the [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [parameters_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri].
     *
     * Generated from protobuf field <code>.google.protobuf.Value model_parameters = 5;</code>
     * @param \Google\Protobuf\Value $var
     * @return $this
     */
    public function setModelParameters($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Value::class);
        $this->model_parameters = $var;

        return $this;
    }

    /**
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\AIPlatform\V1\BatchPredictionJob\OutputConfig|null
     */
    public function getOutputConfig()
    {
        return $this->output_config;
    }

    public function hasOutputConfig()
    {
        return isset($this->output_config);
    }

    public function clearOutputConfig()
    {
        unset($this->output_config);
    }

    /**
     * Required. The Configuration specifying where output predictions should
     * be written.
     * The schema of any single prediction may be specified as a concatenation
     * of [Model's][google.cloud.aiplatform.v1.BatchPredictionJob.model]
     * [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
     * [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
     * and
     * [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig output_config = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\AIPlatform\V1\BatchPredictionJob\OutputConfig $var
     * @return $this
     */
    public function setOutputConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\BatchPredictionJob\OutputConfig::class);
        $this->output_config = $var;

        return $this;
    }

    /**
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchDedicatedResources dedicated_resources = 7;</code>
     * @return \Google\Cloud\AIPlatform\V1\BatchDedicatedResources|null
     */
    public function getDedicatedResources()
    {
        return $this->dedicated_resources;
    }

    public function hasDedicatedResources()
    {
        return isset($this->dedicated_resources);
    }

    public function clearDedicatedResources()
    {
        unset($this->dedicated_resources);
    }

    /**
     * The config of resources used by the Model during the batch prediction. If
     * the Model [supports][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types]
     * DEDICATED_RESOURCES this config may be provided (and the job will use these
     * resources), if the Model doesn't support AUTOMATIC_RESOURCES, this config
     * must be provided.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchDedicatedResources dedicated_resources = 7;</code>
     * @param \Google\Cloud\AIPlatform\V1\BatchDedicatedResources $var
     * @return $this
     */
    public function setDedicatedResources($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\BatchDedicatedResources::class);
        $this->dedicated_resources = $var;

        return $this;
    }

    /**
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Cloud\AIPlatform\V1\ManualBatchTuningParameters|null
     */
    public function getManualBatchTuningParameters()
    {
        return $this->manual_batch_tuning_parameters;
    }

    public function hasManualBatchTuningParameters()
    {
        return isset($this->manual_batch_tuning_parameters);
    }

    public function clearManualBatchTuningParameters()
    {
        unset($this->manual_batch_tuning_parameters);
    }

    /**
     * Immutable. Parameters configuring the batch behavior. Currently only applicable when
     * [dedicated_resources][google.cloud.aiplatform.v1.BatchPredictionJob.dedicated_resources] are used (in other cases Vertex AI does
     * the tuning itself).
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ManualBatchTuningParameters manual_batch_tuning_parameters = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Cloud\AIPlatform\V1\ManualBatchTuningParameters $var
     * @return $this
     */
    public function setManualBatchTuningParameters($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\ManualBatchTuningParameters::class);
        $this->manual_batch_tuning_parameters = $var;

        return $this;
    }

    /**
     * Generate explanation with the batch prediction results.
     * When set to `true`, the batch prediction output changes based on the
     * `predictions_format` field of the
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config] object:
     *  * `bigquery`: output includes a column named `explanation`. The value
     *    is a struct that conforms to the [Explanation][google.cloud.aiplatform.v1.Explanation] object.
     *  * `jsonl`: The JSON objects on each line include an additional entry
     *    keyed `explanation`. The value of the entry is a JSON object that
     *    conforms to the [Explanation][google.cloud.aiplatform.v1.Explanation] object.
     *  * `csv`: Generating explanations for CSV format is not supported.
     * If this field is set to true, either the [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] must be populated.
     *
     * Generated from protobuf field <code>bool generate_explanation = 23;</code>
     * @return bool
     */
    public function getGenerateExplanation()
    {
        return $this->generate_explanation;
    }

    /**
     * Generate explanation with the batch prediction results.
     * When set to `true`, the batch prediction output changes based on the
     * `predictions_format` field of the
     * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config] object:
     *  * `bigquery`: output includes a column named `explanation`. The value
     *    is a struct that conforms to the [Explanation][google.cloud.aiplatform.v1.Explanation] object.
     *  * `jsonl`: The JSON objects on each line include an additional entry
     *    keyed `explanation`. The value of the entry is a JSON object that
     *    conforms to the [Explanation][google.cloud.aiplatform.v1.Explanation] object.
     *  * `csv`: Generating explanations for CSV format is not supported.
     * If this field is set to true, either the [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] or
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] must be populated.
     *
     * Generated from protobuf field <code>bool generate_explanation = 23;</code>
     * @param bool $var
     * @return $this
     */
    public function setGenerateExplanation($var)
    {
        GPBUtil::checkBool($var);
        $this->generate_explanation = $var;

        return $this;
    }

    /**
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] object is inherited.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 25;</code>
     * @return \Google\Cloud\AIPlatform\V1\ExplanationSpec|null
     */
    public function getExplanationSpec()
    {
        return $this->explanation_spec;
    }

    public function hasExplanationSpec()
    {
        return isset($this->explanation_spec);
    }

    public function clearExplanationSpec()
    {
        unset($this->explanation_spec);
    }

    /**
     * Explanation configuration for this BatchPredictionJob. Can be
     * specified only if [generate_explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation] is set to `true`.
     * This value overrides the value of [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec]. All fields of
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] are optional in the request. If a field of the
     * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec] object is not populated, the corresponding field of
     * the [Model.explanation_spec][google.cloud.aiplatform.v1.Model.explanation_spec] object is inherited.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 25;</code>
     * @param \Google\Cloud\AIPlatform\V1\ExplanationSpec $var
     * @return $this
     */
    public function setExplanationSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\ExplanationSpec::class);
        $this->explanation_spec = $var;

        return $this;
    }

    /**
     * Output only. Information further describing the output of this job.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AIPlatform\V1\BatchPredictionJob\OutputInfo|null
     */
    public function getOutputInfo()
    {
        return $this->output_info;
    }

    public function hasOutputInfo()
    {
        return isset($this->output_info);
    }

    public function clearOutputInfo()
    {
        unset($this->output_info);
    }

    /**
     * Output only. Information further describing the output of this job.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BatchPredictionJob.OutputInfo output_info = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AIPlatform\V1\BatchPredictionJob\OutputInfo $var
     * @return $this
     */
    public function setOutputInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\BatchPredictionJob\OutputInfo::class);
        $this->output_info = $var;

        return $this;
    }

    /**
     * Output only. The detailed state of the job.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The detailed state of the job.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.JobState state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AIPlatform\V1\JobState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     */
    public function getError()
    {
        return $this->error;
    }

    public function hasError()
    {
        return isset($this->error);
    }

    public function clearError()
    {
        unset($this->error);
    }

    /**
     * Output only. Only populated when the job's state is JOB_STATE_FAILED or
     * JOB_STATE_CANCELLED.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->error = $var;

        return $this;
    }

    /**
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     *
     * Generated from protobuf field <code>repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPartialFailures()
    {
        return $this->partial_failures;
    }

    /**
     * Output only. Partial failures encountered.
     * For example, single files that can't be read.
     * This field never exceeds 20 entries.
     * Status details fields contain standard GCP error details.
     *
     * Generated from protobuf field <code>repeated .google.rpc.Status partial_failures = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Rpc\Status>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPartialFailures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Rpc\Status::class);
        $this->partial_failures = $arr;

        return $this;
    }

    /**
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AIPlatform\V1\ResourcesConsumed|null
     */
    public function getResourcesConsumed()
    {
        return $this->resources_consumed;
    }

    public function hasResourcesConsumed()
    {
        return isset($this->resources_consumed);
    }

    public function clearResourcesConsumed()
    {
        unset($this->resources_consumed);
    }

    /**
     * Output only. Information about resources that had been consumed by this job.
     * Provided in real time at best effort basis, as well as a final value
     * once the job completes.
     * Note: This field currently may be not populated for batch predictions that
     * use AutoML Models.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ResourcesConsumed resources_consumed = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AIPlatform\V1\ResourcesConsumed $var
     * @return $this
     */
    public function setResourcesConsumed($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\ResourcesConsumed::class);
        $this->resources_consumed = $var;

        return $this;
    }

    /**
     * Output only. Statistics on completed and failed prediction instances.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AIPlatform\V1\CompletionStats|null
     */
    public function getCompletionStats()
    {
        return $this->completion_stats;
    }

    public function hasCompletionStats()
    {
        return isset($this->completion_stats);
    }

    public function clearCompletionStats()
    {
        unset($this->completion_stats);
    }

    /**
     * Output only. Statistics on completed and failed prediction instances.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.CompletionStats completion_stats = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AIPlatform\V1\CompletionStats $var
     * @return $this
     */
    public function setCompletionStats($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\CompletionStats::class);
        $this->completion_stats = $var;

        return $this;
    }

    /**
     * Output only. Time when the BatchPredictionJob was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Time when the BatchPredictionJob was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * Output only. Time when the BatchPredictionJob for the first time entered the
     * `JOB_STATE_RUNNING` state.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    public function hasEndTime()
    {
        return isset($this->end_time);
    }

    public function clearEndTime()
    {
        unset($this->end_time);
    }

    /**
     * Output only. Time when the BatchPredictionJob entered any of the following states:
     * `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

    /**
     * Output only. Time when the BatchPredictionJob was most recently updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Time when the BatchPredictionJob was most recently updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 19;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The labels with user-defined metadata to organize BatchPredictionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 19;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     * @return \Google\Cloud\AIPlatform\V1\EncryptionSpec|null
     */
    public function getEncryptionSpec()
    {
        return $this->encryption_spec;
    }

    public function hasEncryptionSpec()
    {
        return isset($this->encryption_spec);
    }

    public function clearEncryptionSpec()
    {
        unset($this->encryption_spec);
    }

    /**
     * Customer-managed encryption key options for a BatchPredictionJob. If this
     * is set, then all resources created by the BatchPredictionJob will be
     * encrypted with the provided encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
     * @param \Google\Cloud\AIPlatform\V1\EncryptionSpec $var
     * @return $this
     */
    public function setEncryptionSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\EncryptionSpec::class);
        $this->encryption_spec = $var;

        return $this;
    }

}

